/*
 * jQuery JavaScript Library v1.3.2
 * http://jquery.com/
 *
 * Copyright (c) 2009 John Resig
 * Dual licensed under the MIT and GPL licenses.
 * http://docs.jquery.com/License
 *
 * Date: 2009-02-19 17:34:21 -0500 (Thu, 19 Feb 2009)
 * Revision: 6246
 */
(function(){var window=this,undefined,_jQuery=window.jQuery,_$=window.$,jQuery=window.jQuery=window.$=function(selector,context){return new jQuery.fn.init(selector,context)},quickExpr=/^[^<]*(<(.|\s)+>)[^>]*$|^#([\w-]+)$/,isSimple=/^.[^:#\[\.,]*$/;jQuery.fn=jQuery.prototype={init:function(selector,context){selector=selector||document;if(selector.nodeType){this[0]=selector;this.length=1;this.context=selector;return this}if(typeof selector==="string"){var match=quickExpr.exec(selector);if(match&&(match[1]||!context)){if(match[1]){selector=jQuery.clean([match[1]],context)}else{var elem=document.getElementById(match[3]);if(elem&&elem.id!=match[3]){return jQuery().find(selector)}var ret=jQuery(elem||[]);ret.context=document;ret.selector=selector;return ret}}else{return jQuery(context).find(selector)}}else{if(jQuery.isFunction(selector)){return jQuery(document).ready(selector)}}if(selector.selector&&selector.context){this.selector=selector.selector;this.context=selector.context}return this.setArray(jQuery.isArray(selector)?selector:jQuery.makeArray(selector))},selector:"",jquery:"1.3.2",size:function(){return this.length},get:function(num){return num===undefined?Array.prototype.slice.call(this):this[num]},pushStack:function(elems,name,selector){var ret=jQuery(elems);ret.prevObject=this;ret.context=this.context;if(name==="find"){ret.selector=this.selector+(this.selector?" ":"")+selector}else{if(name){ret.selector=this.selector+"."+name+"("+selector+")"}}return ret},setArray:function(elems){this.length=0;Array.prototype.push.apply(this,elems);return this},each:function(callback,args){return jQuery.each(this,callback,args)},index:function(elem){return jQuery.inArray(elem&&elem.jquery?elem[0]:elem,this)},attr:function(name,value,type){var options=name;if(typeof name==="string"){if(value===undefined){return this[0]&&jQuery[type||"attr"](this[0],name)}else{options={};options[name]=value}}return this.each(function(i){for(name in options){jQuery.attr(type?this.style:this,name,jQuery.prop(this,options[name],type,i,name))}})},css:function(key,value){if((key=="width"||key=="height")&&parseFloat(value)<0){value=undefined}return this.attr(key,value,"curCSS")},text:function(text){if(typeof text!=="object"&&text!=null){return this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(text))}var ret="";jQuery.each(text||this,function(){jQuery.each(this.childNodes,function(){if(this.nodeType!=8){ret+=this.nodeType!=1?this.nodeValue:jQuery.fn.text([this])}})});return ret},wrapAll:function(html){if(this[0]){var wrap=jQuery(html,this[0].ownerDocument).clone();if(this[0].parentNode){wrap.insertBefore(this[0])}wrap.map(function(){var elem=this;while(elem.firstChild){elem=elem.firstChild}return elem}).append(this)}return this},wrapInner:function(html){return this.each(function(){jQuery(this).contents().wrapAll(html)})},wrap:function(html){return this.each(function(){jQuery(this).wrapAll(html)})},append:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType==1){this.appendChild(elem)}})},prepend:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType==1){this.insertBefore(elem,this.firstChild)}})},before:function(){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this)})},after:function(){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this.nextSibling)})},end:function(){return this.prevObject||jQuery([])},push:[].push,sort:[].sort,splice:[].splice,find:function(selector){if(this.length===1){var ret=this.pushStack([],"find",selector);ret.length=0;jQuery.find(selector,this[0],ret);return ret}else{return this.pushStack(jQuery.unique(jQuery.map(this,function(elem){return jQuery.find(selector,elem)})),"find",selector)}},clone:function(events){var ret=this.map(function(){if(!jQuery.support.noCloneEvent&&!jQuery.isXMLDoc(this)){var html=this.outerHTML;if(!html){var div=this.ownerDocument.createElement("div");div.appendChild(this.cloneNode(true));html=div.innerHTML}return jQuery.clean([html.replace(/ jQuery\d+="(?:\d+|null)"/g,"").replace(/^\s*/,"")])[0]}else{return this.cloneNode(true)}});if(events===true){var orig=this.find("*").andSelf(),i=0;ret.find("*").andSelf().each(function(){if(this.nodeName!==orig[i].nodeName){return }var events=jQuery.data(orig[i],"events");for(var type in events){for(var handler in events[type]){jQuery.event.add(this,type,events[type][handler],events[type][handler].data)}}i++})}return ret},filter:function(selector){return this.pushStack(jQuery.isFunction(selector)&&jQuery.grep(this,function(elem,i){return selector.call(elem,i)})||jQuery.multiFilter(selector,jQuery.grep(this,function(elem){return elem.nodeType===1})),"filter",selector)},closest:function(selector){var pos=jQuery.expr.match.POS.test(selector)?jQuery(selector):null,closer=0;return this.map(function(){var cur=this;while(cur&&cur.ownerDocument){if(pos?pos.index(cur)>-1:jQuery(cur).is(selector)){jQuery.data(cur,"closest",closer);return cur}cur=cur.parentNode;closer++}})},not:function(selector){if(typeof selector==="string"){if(isSimple.test(selector)){return this.pushStack(jQuery.multiFilter(selector,this,true),"not",selector)}else{selector=jQuery.multiFilter(selector,this)}}var isArrayLike=selector.length&&selector[selector.length-1]!==undefined&&!selector.nodeType;return this.filter(function(){return isArrayLike?jQuery.inArray(this,selector)<0:this!=selector})},add:function(selector){return this.pushStack(jQuery.unique(jQuery.merge(this.get(),typeof selector==="string"?jQuery(selector):jQuery.makeArray(selector))))},is:function(selector){return !!selector&&jQuery.multiFilter(selector,this).length>0},hasClass:function(selector){return !!selector&&this.is("."+selector)},val:function(value){if(value===undefined){var elem=this[0];if(elem){if(jQuery.nodeName(elem,"option")){return(elem.attributes.value||{}).specified?elem.value:elem.text}if(jQuery.nodeName(elem,"select")){var index=elem.selectedIndex,values=[],options=elem.options,one=elem.type=="select-one";if(index<0){return null}for(var i=one?index:0,max=one?index+1:options.length;i<max;i++){var option=options[i];if(option.selected){value=jQuery(option).val();if(one){return value}values.push(value)}}return values}return(elem.value||"").replace(/\r/g,"")}return undefined}if(typeof value==="number"){value+=""}return this.each(function(){if(this.nodeType!=1){return }if(jQuery.isArray(value)&&/radio|checkbox/.test(this.type)){this.checked=(jQuery.inArray(this.value,value)>=0||jQuery.inArray(this.name,value)>=0)}else{if(jQuery.nodeName(this,"select")){var values=jQuery.makeArray(value);jQuery("option",this).each(function(){this.selected=(jQuery.inArray(this.value,values)>=0||jQuery.inArray(this.text,values)>=0)});if(!values.length){this.selectedIndex=-1}}else{this.value=value}}})},html:function(value){return value===undefined?(this[0]?this[0].innerHTML.replace(/ jQuery\d+="(?:\d+|null)"/g,""):null):this.empty().append(value)},replaceWith:function(value){return this.after(value).remove()},eq:function(i){return this.slice(i,+i+1)},slice:function(){return this.pushStack(Array.prototype.slice.apply(this,arguments),"slice",Array.prototype.slice.call(arguments).join(","))},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem)}))},andSelf:function(){return this.add(this.prevObject)},domManip:function(args,table,callback){if(this[0]){var fragment=(this[0].ownerDocument||this[0]).createDocumentFragment(),scripts=jQuery.clean(args,(this[0].ownerDocument||this[0]),fragment),first=fragment.firstChild;if(first){for(var i=0,l=this.length;i<l;i++){callback.call(root(this[i],first),this.length>1||i>0?fragment.cloneNode(true):fragment)}}if(scripts){jQuery.each(scripts,evalScript)}}return this;function root(elem,cur){return table&&jQuery.nodeName(elem,"table")&&jQuery.nodeName(cur,"tr")?(elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody"))):elem}}};jQuery.fn.init.prototype=jQuery.fn;function evalScript(i,elem){if(elem.src){jQuery.ajax({url:elem.src,async:false,dataType:"script"})}else{jQuery.globalEval(elem.text||elem.textContent||elem.innerHTML||"")}if(elem.parentNode){elem.parentNode.removeChild(elem)}}function now(){return +new Date}jQuery.extend=jQuery.fn.extend=function(){var target=arguments[0]||{},i=1,length=arguments.length,deep=false,options;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2}if(typeof target!=="object"&&!jQuery.isFunction(target)){target={}}if(length==i){target=this;--i}for(;i<length;i++){if((options=arguments[i])!=null){for(var name in options){var src=target[name],copy=options[name];if(target===copy){continue}if(deep&&copy&&typeof copy==="object"&&!copy.nodeType){target[name]=jQuery.extend(deep,src||(copy.length!=null?[]:{}),copy)}else{if(copy!==undefined){target[name]=copy}}}}}return target};var exclude=/z-?index|font-?weight|opacity|zoom|line-?height/i,defaultView=document.defaultView||{},toString=Object.prototype.toString;jQuery.extend({noConflict:function(deep){window.$=_$;if(deep){window.jQuery=_jQuery}return jQuery},isFunction:function(obj){return toString.call(obj)==="[object Function]"},isArray:function(obj){return toString.call(obj)==="[object Array]"},isXMLDoc:function(elem){return elem.nodeType===9&&elem.documentElement.nodeName!=="HTML"||!!elem.ownerDocument&&jQuery.isXMLDoc(elem.ownerDocument)},globalEval:function(data){if(data&&/\S/.test(data)){var head=document.getElementsByTagName("head")[0]||document.documentElement,script=document.createElement("script");script.type="text/javascript";if(jQuery.support.scriptEval){script.appendChild(document.createTextNode(data))}else{script.text=data}head.insertBefore(script,head.firstChild);head.removeChild(script)}},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()==name.toUpperCase()},each:function(object,callback,args){var name,i=0,length=object.length;if(args){if(length===undefined){for(name in object){if(callback.apply(object[name],args)===false){break}}}else{for(;i<length;){if(callback.apply(object[i++],args)===false){break}}}}else{if(length===undefined){for(name in object){if(callback.call(object[name],name,object[name])===false){break}}}else{for(var value=object[0];i<length&&callback.call(value,i,value)!==false;value=object[++i]){}}}return object},prop:function(elem,value,type,i,name){if(jQuery.isFunction(value)){value=value.call(elem,i)}return typeof value==="number"&&type=="curCSS"&&!exclude.test(name)?value+"px":value},className:{add:function(elem,classNames){jQuery.each((classNames||"").split(/\s+/),function(i,className){if(elem.nodeType==1&&!jQuery.className.has(elem.className,className)){elem.className+=(elem.className?" ":"")+className}})},remove:function(elem,classNames){if(elem.nodeType==1){elem.className=classNames!==undefined?jQuery.grep(elem.className.split(/\s+/),function(className){return !jQuery.className.has(classNames,className)}).join(" "):""}},has:function(elem,className){return elem&&jQuery.inArray(className,(elem.className||elem).toString().split(/\s+/))>-1}},swap:function(elem,options,callback){var old={};for(var name in options){old[name]=elem.style[name];elem.style[name]=options[name]}callback.call(elem);for(var name in options){elem.style[name]=old[name]}},css:function(elem,name,force,extra){if(name=="width"||name=="height"){var val,props={position:"absolute",visibility:"hidden",display:"block"},which=name=="width"?["Left","Right"]:["Top","Bottom"];function getWH(){val=name=="width"?elem.offsetWidth:elem.offsetHeight;if(extra==="border"){return }jQuery.each(which,function(){if(!extra){val-=parseFloat(jQuery.curCSS(elem,"padding"+this,true))||0}if(extra==="margin"){val+=parseFloat(jQuery.curCSS(elem,"margin"+this,true))||0}else{val-=parseFloat(jQuery.curCSS(elem,"border"+this+"Width",true))||0}})}if(elem.offsetWidth!==0){getWH()}else{jQuery.swap(elem,props,getWH)}return Math.max(0,Math.round(val))}return jQuery.curCSS(elem,name,force)},curCSS:function(elem,name,force){var ret,style=elem.style;if(name=="opacity"&&!jQuery.support.opacity){ret=jQuery.attr(style,"opacity");return ret==""?"1":ret}if(name.match(/float/i)){name=styleFloat}if(!force&&style&&style[name]){ret=style[name]}else{if(defaultView.getComputedStyle){if(name.match(/float/i)){name="float"}name=name.replace(/([A-Z])/g,"-$1").toLowerCase();var computedStyle=defaultView.getComputedStyle(elem,null);if(computedStyle){ret=computedStyle.getPropertyValue(name)}if(name=="opacity"&&ret==""){ret="1"}}else{if(elem.currentStyle){var camelCase=name.replace(/\-(\w)/g,function(all,letter){return letter.toUpperCase()});ret=elem.currentStyle[name]||elem.currentStyle[camelCase];if(!/^\d+(px)?$/i.test(ret)&&/^\d/.test(ret)){var left=style.left,rsLeft=elem.runtimeStyle.left;elem.runtimeStyle.left=elem.currentStyle.left;style.left=ret||0;ret=style.pixelLeft+"px";style.left=left;elem.runtimeStyle.left=rsLeft}}}}return ret},clean:function(elems,context,fragment){context=context||document;if(typeof context.createElement==="undefined"){context=context.ownerDocument||context[0]&&context[0].ownerDocument||document}if(!fragment&&elems.length===1&&typeof elems[0]==="string"){var match=/^<(\w+)\s*\/?>$/.exec(elems[0]);if(match){return[context.createElement(match[1])]}}var ret=[],scripts=[],div=context.createElement("div");jQuery.each(elems,function(i,elem){if(typeof elem==="number"){elem+=""}if(!elem){return }if(typeof elem==="string"){elem=elem.replace(/(<(\w+)[^>]*?)\/>/g,function(all,front,tag){return tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i)?all:front+"></"+tag+">"});var tags=elem.replace(/^\s+/,"").substring(0,10).toLowerCase();var wrap=!tags.indexOf("<opt")&&[1,"<select multiple='multiple'>","</select>"]||!tags.indexOf("<leg")&&[1,"<fieldset>","</fieldset>"]||tags.match(/^<(thead|tbody|tfoot|colg|cap)/)&&[1,"<table>","</table>"]||!tags.indexOf("<tr")&&[2,"<table><tbody>","</tbody></table>"]||(!tags.indexOf("<td")||!tags.indexOf("<th"))&&[3,"<table><tbody><tr>","</tr></tbody></table>"]||!tags.indexOf("<col")&&[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"]||!jQuery.support.htmlSerialize&&[1,"div<div>","</div>"]||[0,"",""];div.innerHTML=wrap[1]+elem+wrap[2];while(wrap[0]--){div=div.lastChild}if(!jQuery.support.tbody){var hasBody=/<tbody/i.test(elem),tbody=!tags.indexOf("<table")&&!hasBody?div.firstChild&&div.firstChild.childNodes:wrap[1]=="<table>"&&!hasBody?div.childNodes:[];for(var j=tbody.length-1;j>=0;--j){if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length){tbody[j].parentNode.removeChild(tbody[j])}}}if(!jQuery.support.leadingWhitespace&&/^\s/.test(elem)){div.insertBefore(context.createTextNode(elem.match(/^\s*/)[0]),div.firstChild)}elem=jQuery.makeArray(div.childNodes)}if(elem.nodeType){ret.push(elem)}else{ret=jQuery.merge(ret,elem)}});if(fragment){for(var i=0;ret[i];i++){if(jQuery.nodeName(ret[i],"script")&&(!ret[i].type||ret[i].type.toLowerCase()==="text/javascript")){scripts.push(ret[i].parentNode?ret[i].parentNode.removeChild(ret[i]):ret[i])}else{if(ret[i].nodeType===1){ret.splice.apply(ret,[i+1,0].concat(jQuery.makeArray(ret[i].getElementsByTagName("script"))))}fragment.appendChild(ret[i])}}return scripts}return ret},attr:function(elem,name,value){if(!elem||elem.nodeType==3||elem.nodeType==8){return undefined}var notxml=!jQuery.isXMLDoc(elem),set=value!==undefined;name=notxml&&jQuery.props[name]||name;if(elem.tagName){var special=/href|src|style/.test(name);if(name=="selected"&&elem.parentNode){elem.parentNode.selectedIndex}if(name in elem&&notxml&&!special){if(set){if(name=="type"&&jQuery.nodeName(elem,"input")&&elem.parentNode){throw"type property can't be changed"}elem[name]=value}if(jQuery.nodeName(elem,"form")&&elem.getAttributeNode(name)){return elem.getAttributeNode(name).nodeValue}if(name=="tabIndex"){var attributeNode=elem.getAttributeNode("tabIndex");return attributeNode&&attributeNode.specified?attributeNode.value:elem.nodeName.match(/(button|input|object|select|textarea)/i)?0:elem.nodeName.match(/^(a|area)$/i)&&elem.href?0:undefined}return elem[name]}if(!jQuery.support.style&&notxml&&name=="style"){return jQuery.attr(elem.style,"cssText",value)}if(set){elem.setAttribute(name,""+value)}var attr=!jQuery.support.hrefNormalized&&notxml&&special?elem.getAttribute(name,2):elem.getAttribute(name);return attr===null?undefined:attr}if(!jQuery.support.opacity&&name=="opacity"){if(set){elem.zoom=1;elem.filter=(elem.filter||"").replace(/alpha\([^)]*\)/,"")+(parseInt(value)+""=="NaN"?"":"alpha(opacity="+value*100+")")}return elem.filter&&elem.filter.indexOf("opacity=")>=0?(parseFloat(elem.filter.match(/opacity=([^)]*)/)[1])/100)+"":""}name=name.replace(/-([a-z])/ig,function(all,letter){return letter.toUpperCase()});if(set){elem[name]=value}return elem[name]},trim:function(text){return(text||"").replace(/^\s+|\s+$/g,"")},makeArray:function(array){var ret=[];if(array!=null){var i=array.length;if(i==null||typeof array==="string"||jQuery.isFunction(array)||array.setInterval){ret[0]=array}else{while(i){ret[--i]=array[i]}}}return ret},inArray:function(elem,array){for(var i=0,length=array.length;i<length;i++){if(array[i]===elem){return i}}return -1},merge:function(first,second){var i=0,elem,pos=first.length;if(!jQuery.support.getAll){while((elem=second[i++])!=null){if(elem.nodeType!=8){first[pos++]=elem}}}else{while((elem=second[i++])!=null){first[pos++]=elem}}return first},unique:function(array){var ret=[],done={};try{for(var i=0,length=array.length;i<length;i++){var id=jQuery.data(array[i]);if(!done[id]){done[id]=true;ret.push(array[i])}}}catch(e){ret=array}return ret},grep:function(elems,callback,inv){var ret=[];for(var i=0,length=elems.length;i<length;i++){if(!inv!=!callback(elems[i],i)){ret.push(elems[i])}}return ret},map:function(elems,callback){var ret=[];for(var i=0,length=elems.length;i<length;i++){var value=callback(elems[i],i);if(value!=null){ret[ret.length]=value}}return ret.concat.apply([],ret)}});var userAgent=navigator.userAgent.toLowerCase();jQuery.browser={version:(userAgent.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[0,"0"])[1],safari:/webkit/.test(userAgent),opera:/opera/.test(userAgent),msie:/msie/.test(userAgent)&&!/opera/.test(userAgent),mozilla:/mozilla/.test(userAgent)&&!/(compatible|webkit)/.test(userAgent)};jQuery.each({parent:function(elem){return elem.parentNode},parents:function(elem){return jQuery.dir(elem,"parentNode")},next:function(elem){return jQuery.nth(elem,2,"nextSibling")},prev:function(elem){return jQuery.nth(elem,2,"previousSibling")},nextAll:function(elem){return jQuery.dir(elem,"nextSibling")},prevAll:function(elem){return jQuery.dir(elem,"previousSibling")},siblings:function(elem){return jQuery.sibling(elem.parentNode.firstChild,elem)},children:function(elem){return jQuery.sibling(elem.firstChild)},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes)}},function(name,fn){jQuery.fn[name]=function(selector){var ret=jQuery.map(this,fn);if(selector&&typeof selector=="string"){ret=jQuery.multiFilter(selector,ret)}return this.pushStack(jQuery.unique(ret),name,selector)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var ret=[],insert=jQuery(selector);for(var i=0,l=insert.length;i<l;i++){var elems=(i>0?this.clone(true):this).get();jQuery.fn[original].apply(jQuery(insert[i]),elems);ret=ret.concat(elems)}return this.pushStack(ret,name,selector)}});jQuery.each({removeAttr:function(name){jQuery.attr(this,name,"");if(this.nodeType==1){this.removeAttribute(name)}},addClass:function(classNames){jQuery.className.add(this,classNames)},removeClass:function(classNames){jQuery.className.remove(this,classNames)},toggleClass:function(classNames,state){if(typeof state!=="boolean"){state=!jQuery.className.has(this,classNames)}jQuery.className[state?"add":"remove"](this,classNames)},remove:function(selector){if(!selector||jQuery.filter(selector,[this]).length){jQuery("*",this).add([this]).each(function(){jQuery.event.remove(this);jQuery.removeData(this)});if(this.parentNode){this.parentNode.removeChild(this)}}},empty:function(){jQuery(this).children().remove();while(this.firstChild){this.removeChild(this.firstChild)}}},function(name,fn){jQuery.fn[name]=function(){return this.each(fn,arguments)}});function num(elem,prop){return elem[0]&&parseInt(jQuery.curCSS(elem[0],prop,true),10)||0}var expando="jQuery"+now(),uuid=0,windowData={};jQuery.extend({cache:{},data:function(elem,name,data){elem=elem==window?windowData:elem;var id=elem[expando];if(!id){id=elem[expando]=++uuid}if(name&&!jQuery.cache[id]){jQuery.cache[id]={}}if(data!==undefined){jQuery.cache[id][name]=data}return name?jQuery.cache[id][name]:id},removeData:function(elem,name){elem=elem==window?windowData:elem;var id=elem[expando];if(name){if(jQuery.cache[id]){delete jQuery.cache[id][name];name="";for(name in jQuery.cache[id]){break}if(!name){jQuery.removeData(elem)}}}else{try{delete elem[expando]}catch(e){if(elem.removeAttribute){elem.removeAttribute(expando)}}delete jQuery.cache[id]}},queue:function(elem,type,data){if(elem){type=(type||"fx")+"queue";var q=jQuery.data(elem,type);if(!q||jQuery.isArray(data)){q=jQuery.data(elem,type,jQuery.makeArray(data))}else{if(data){q.push(data)}}}return q},dequeue:function(elem,type){var queue=jQuery.queue(elem,type),fn=queue.shift();if(!type||type==="fx"){fn=queue[0]}if(fn!==undefined){fn.call(elem)}}});jQuery.fn.extend({data:function(key,value){var parts=key.split(".");parts[1]=parts[1]?"."+parts[1]:"";if(value===undefined){var data=this.triggerHandler("getData"+parts[1]+"!",[parts[0]]);if(data===undefined&&this.length){data=jQuery.data(this[0],key)}return data===undefined&&parts[1]?this.data(parts[0]):data}else{return this.trigger("setData"+parts[1]+"!",[parts[0],value]).each(function(){jQuery.data(this,key,value)})}},removeData:function(key){return this.each(function(){jQuery.removeData(this,key)})},queue:function(type,data){if(typeof type!=="string"){data=type;type="fx"}if(data===undefined){return jQuery.queue(this[0],type)}return this.each(function(){var queue=jQuery.queue(this,type,data);if(type=="fx"&&queue.length==1){queue[0].call(this)}})},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type)})}});
/*
 * Sizzle CSS Selector Engine - v0.9.3
 *  Copyright 2009, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^[\]]*\]|['"][^'"]*['"]|[^[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?/g,done=0,toString=Object.prototype.toString;var Sizzle=function(selector,context,results,seed){results=results||[];context=context||document;if(context.nodeType!==1&&context.nodeType!==9){return[]}if(!selector||typeof selector!=="string"){return results}var parts=[],m,set,checkSet,check,mode,extra,prune=true;chunker.lastIndex=0;while((m=chunker.exec(selector))!==null){parts.push(m[1]);if(m[2]){extra=RegExp.rightContext;break}}if(parts.length>1&&origPOS.exec(selector)){if(parts.length===2&&Expr.relative[parts[0]]){set=posProcess(parts[0]+parts[1],context)}else{set=Expr.relative[parts[0]]?[context]:Sizzle(parts.shift(),context);while(parts.length){selector=parts.shift();if(Expr.relative[selector]){selector+=parts.shift()}set=posProcess(selector,set)}}}else{var ret=seed?{expr:parts.pop(),set:makeArray(seed)}:Sizzle.find(parts.pop(),parts.length===1&&context.parentNode?context.parentNode:context,isXML(context));set=Sizzle.filter(ret.expr,ret.set);if(parts.length>0){checkSet=makeArray(set)}else{prune=false}while(parts.length){var cur=parts.pop(),pop=cur;if(!Expr.relative[cur]){cur=""}else{pop=parts.pop()}if(pop==null){pop=context}Expr.relative[cur](checkSet,pop,isXML(context))}}if(!checkSet){checkSet=set}if(!checkSet){throw"Syntax error, unrecognized expression: "+(cur||selector)}if(toString.call(checkSet)==="[object Array]"){if(!prune){results.push.apply(results,checkSet)}else{if(context.nodeType===1){for(var i=0;checkSet[i]!=null;i++){if(checkSet[i]&&(checkSet[i]===true||checkSet[i].nodeType===1&&contains(context,checkSet[i]))){results.push(set[i])}}}else{for(var i=0;checkSet[i]!=null;i++){if(checkSet[i]&&checkSet[i].nodeType===1){results.push(set[i])}}}}}else{makeArray(checkSet,results)}if(extra){Sizzle(extra,context,results,seed);if(sortOrder){hasDuplicate=false;results.sort(sortOrder);if(hasDuplicate){for(var i=1;i<results.length;i++){if(results[i]===results[i-1]){results.splice(i--,1)}}}}}return results};Sizzle.matches=function(expr,set){return Sizzle(expr,null,null,set)};Sizzle.find=function(expr,context,isXML){var set,match;if(!expr){return[]}for(var i=0,l=Expr.order.length;i<l;i++){var type=Expr.order[i],match;if((match=Expr.match[type].exec(expr))){var left=RegExp.leftContext;if(left.substr(left.length-1)!=="\\"){match[1]=(match[1]||"").replace(/\\/g,"");set=Expr.find[type](match,context,isXML);if(set!=null){expr=expr.replace(Expr.match[type],"");break}}}}if(!set){set=context.getElementsByTagName("*")}return{set:set,expr:expr}};Sizzle.filter=function(expr,set,inplace,not){var old=expr,result=[],curLoop=set,match,anyFound,isXMLFilter=set&&set[0]&&isXML(set[0]);while(expr&&set.length){for(var type in Expr.filter){if((match=Expr.match[type].exec(expr))!=null){var filter=Expr.filter[type],found,item;anyFound=false;if(curLoop==result){result=[]}if(Expr.preFilter[type]){match=Expr.preFilter[type](match,curLoop,inplace,result,not,isXMLFilter);if(!match){anyFound=found=true}else{if(match===true){continue}}}if(match){for(var i=0;(item=curLoop[i])!=null;i++){if(item){found=filter(item,match,i,curLoop);var pass=not^!!found;if(inplace&&found!=null){if(pass){anyFound=true}else{curLoop[i]=false}}else{if(pass){result.push(item);anyFound=true}}}}}if(found!==undefined){if(!inplace){curLoop=result}expr=expr.replace(Expr.match[type],"");if(!anyFound){return[]}break}}}if(expr==old){if(anyFound==null){throw"Syntax error, unrecognized expression: "+expr}else{break}}old=expr}return curLoop};var Expr=Sizzle.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF_-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF_-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF_-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF_-]|\\.)+)\s*(?:(\S?=)\s*(['"]*)(.*?)\3|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*_-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\((even|odd|[\dn+-]*)\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF_-]|\\.)+)(?:\((['"]*)((?:\([^\)]+\)|[^\2\(\)]*)+)\2\))?/},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(elem){return elem.getAttribute("href")}},relative:{"+":function(checkSet,part,isXML){var isPartStr=typeof part==="string",isTag=isPartStr&&!/\W/.test(part),isPartStrNotTag=isPartStr&&!isTag;if(isTag&&!isXML){part=part.toUpperCase()}for(var i=0,l=checkSet.length,elem;i<l;i++){if((elem=checkSet[i])){while((elem=elem.previousSibling)&&elem.nodeType!==1){}checkSet[i]=isPartStrNotTag||elem&&elem.nodeName===part?elem||false:elem===part}}if(isPartStrNotTag){Sizzle.filter(part,checkSet,true)}},">":function(checkSet,part,isXML){var isPartStr=typeof part==="string";if(isPartStr&&!/\W/.test(part)){part=isXML?part:part.toUpperCase();for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var parent=elem.parentNode;checkSet[i]=parent.nodeName===part?parent:false}}}else{for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){checkSet[i]=isPartStr?elem.parentNode:elem.parentNode===part}}if(isPartStr){Sizzle.filter(part,checkSet,true)}}},"":function(checkSet,part,isXML){var doneName=done++,checkFn=dirCheck;if(!part.match(/\W/)){var nodeCheck=part=isXML?part:part.toUpperCase();checkFn=dirNodeCheck}checkFn("parentNode",part,doneName,checkSet,nodeCheck,isXML)},"~":function(checkSet,part,isXML){var doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!part.match(/\W/)){var nodeCheck=part=isXML?part:part.toUpperCase();checkFn=dirNodeCheck}checkFn("previousSibling",part,doneName,checkSet,nodeCheck,isXML)}},find:{ID:function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?[m]:[]}},NAME:function(match,context,isXML){if(typeof context.getElementsByName!=="undefined"){var ret=[],results=context.getElementsByName(match[1]);for(var i=0,l=results.length;i<l;i++){if(results[i].getAttribute("name")===match[1]){ret.push(results[i])}}return ret.length===0?null:ret}},TAG:function(match,context){return context.getElementsByTagName(match[1])}},preFilter:{CLASS:function(match,curLoop,inplace,result,not,isXML){match=" "+match[1].replace(/\\/g,"")+" ";if(isXML){return match}for(var i=0,elem;(elem=curLoop[i])!=null;i++){if(elem){if(not^(elem.className&&(" "+elem.className+" ").indexOf(match)>=0)){if(!inplace){result.push(elem)}}else{if(inplace){curLoop[i]=false}}}}return false},ID:function(match){return match[1].replace(/\\/g,"")},TAG:function(match,curLoop){for(var i=0;curLoop[i]===false;i++){}return curLoop[i]&&isXML(curLoop[i])?match[1]:match[1].toUpperCase()},CHILD:function(match){if(match[1]=="nth"){var test=/(-?)(\d*)n((?:\+|-)?\d*)/.exec(match[2]=="even"&&"2n"||match[2]=="odd"&&"2n+1"||!/\D/.test(match[2])&&"0n+"+match[2]||match[2]);match[2]=(test[1]+(test[2]||1))-0;match[3]=test[3]-0}match[0]=done++;return match},ATTR:function(match,curLoop,inplace,result,not,isXML){var name=match[1].replace(/\\/g,"");if(!isXML&&Expr.attrMap[name]){match[1]=Expr.attrMap[name]}if(match[2]==="~="){match[4]=" "+match[4]+" "}return match},PSEUDO:function(match,curLoop,inplace,result,not){if(match[1]==="not"){if(match[3].match(chunker).length>1||/^\w/.test(match[3])){match[3]=Sizzle(match[3],null,null,curLoop)}else{var ret=Sizzle.filter(match[3],curLoop,inplace,true^not);if(!inplace){result.push.apply(result,ret)}return false}}else{if(Expr.match.POS.test(match[0])||Expr.match.CHILD.test(match[0])){return true}}return match},POS:function(match){match.unshift(true);return match}},filters:{enabled:function(elem){return elem.disabled===false&&elem.type!=="hidden"},disabled:function(elem){return elem.disabled===true},checked:function(elem){return elem.checked===true},selected:function(elem){elem.parentNode.selectedIndex;return elem.selected===true},parent:function(elem){return !!elem.firstChild},empty:function(elem){return !elem.firstChild},has:function(elem,i,match){return !!Sizzle(match[3],elem).length},header:function(elem){return/h\d/i.test(elem.nodeName)},text:function(elem){return"text"===elem.type},radio:function(elem){return"radio"===elem.type},checkbox:function(elem){return"checkbox"===elem.type},file:function(elem){return"file"===elem.type},password:function(elem){return"password"===elem.type},submit:function(elem){return"submit"===elem.type},image:function(elem){return"image"===elem.type},reset:function(elem){return"reset"===elem.type},button:function(elem){return"button"===elem.type||elem.nodeName.toUpperCase()==="BUTTON"},input:function(elem){return/input|select|textarea|button/i.test(elem.nodeName)}},setFilters:{first:function(elem,i){return i===0},last:function(elem,i,match,array){return i===array.length-1},even:function(elem,i){return i%2===0},odd:function(elem,i){return i%2===1},lt:function(elem,i,match){return i<match[3]-0},gt:function(elem,i,match){return i>match[3]-0},nth:function(elem,i,match){return match[3]-0==i},eq:function(elem,i,match){return match[3]-0==i}},filter:{PSEUDO:function(elem,match,i,array){var name=match[1],filter=Expr.filters[name];if(filter){return filter(elem,i,match,array)}else{if(name==="contains"){return(elem.textContent||elem.innerText||"").indexOf(match[3])>=0}else{if(name==="not"){var not=match[3];for(var i=0,l=not.length;i<l;i++){if(not[i]===elem){return false}}return true}}}},CHILD:function(elem,match){var type=match[1],node=elem;switch(type){case"only":case"first":while(node=node.previousSibling){if(node.nodeType===1){return false}}if(type=="first"){return true}node=elem;case"last":while(node=node.nextSibling){if(node.nodeType===1){return false}}return true;case"nth":var first=match[2],last=match[3];if(first==1&&last==0){return true}var doneName=match[0],parent=elem.parentNode;if(parent&&(parent.sizcache!==doneName||!elem.nodeIndex)){var count=0;for(node=parent.firstChild;node;node=node.nextSibling){if(node.nodeType===1){node.nodeIndex=++count}}parent.sizcache=doneName}var diff=elem.nodeIndex-last;if(first==0){return diff==0}else{return(diff%first==0&&diff/first>=0)}}},ID:function(elem,match){return elem.nodeType===1&&elem.getAttribute("id")===match},TAG:function(elem,match){return(match==="*"&&elem.nodeType===1)||elem.nodeName===match},CLASS:function(elem,match){return(" "+(elem.className||elem.getAttribute("class"))+" ").indexOf(match)>-1},ATTR:function(elem,match){var name=match[1],result=Expr.attrHandle[name]?Expr.attrHandle[name](elem):elem[name]!=null?elem[name]:elem.getAttribute(name),value=result+"",type=match[2],check=match[4];return result==null?type==="!=":type==="="?value===check:type==="*="?value.indexOf(check)>=0:type==="~="?(" "+value+" ").indexOf(check)>=0:!check?value&&result!==false:type==="!="?value!=check:type==="^="?value.indexOf(check)===0:type==="$="?value.substr(value.length-check.length)===check:type==="|="?value===check||value.substr(0,check.length+1)===check+"-":false},POS:function(elem,match,i,array){var name=match[2],filter=Expr.setFilters[name];if(filter){return filter(elem,i,match,array)}}}};var origPOS=Expr.match.POS;for(var type in Expr.match){Expr.match[type]=RegExp(Expr.match[type].source+/(?![^\[]*\])(?![^\(]*\))/.source)}var makeArray=function(array,results){array=Array.prototype.slice.call(array);if(results){results.push.apply(results,array);return results}return array};try{Array.prototype.slice.call(document.documentElement.childNodes)}catch(e){makeArray=function(array,results){var ret=results||[];if(toString.call(array)==="[object Array]"){Array.prototype.push.apply(ret,array)}else{if(typeof array.length==="number"){for(var i=0,l=array.length;i<l;i++){ret.push(array[i])}}else{for(var i=0;array[i];i++){ret.push(array[i])}}}return ret}}var sortOrder;if(document.documentElement.compareDocumentPosition){sortOrder=function(a,b){var ret=a.compareDocumentPosition(b)&4?-1:a===b?0:1;if(ret===0){hasDuplicate=true}return ret}}else{if("sourceIndex" in document.documentElement){sortOrder=function(a,b){var ret=a.sourceIndex-b.sourceIndex;if(ret===0){hasDuplicate=true}return ret}}else{if(document.createRange){sortOrder=function(a,b){var aRange=a.ownerDocument.createRange(),bRange=b.ownerDocument.createRange();aRange.selectNode(a);aRange.collapse(true);bRange.selectNode(b);bRange.collapse(true);var ret=aRange.compareBoundaryPoints(Range.START_TO_END,bRange);if(ret===0){hasDuplicate=true}return ret}}}}(function(){var form=document.createElement("form"),id="script"+(new Date).getTime();form.innerHTML="<input name='"+id+"'/>";var root=document.documentElement;root.insertBefore(form,root.firstChild);if(!!document.getElementById(id)){Expr.find.ID=function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?m.id===match[1]||typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id").nodeValue===match[1]?[m]:undefined:[]}};Expr.filter.ID=function(elem,match){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return elem.nodeType===1&&node&&node.nodeValue===match}}root.removeChild(form)})();(function(){var div=document.createElement("div");div.appendChild(document.createComment(""));if(div.getElementsByTagName("*").length>0){Expr.find.TAG=function(match,context){var results=context.getElementsByTagName(match[1]);if(match[1]==="*"){var tmp=[];for(var i=0;results[i];i++){if(results[i].nodeType===1){tmp.push(results[i])}}results=tmp}return results}}div.innerHTML="<a href='#'></a>";if(div.firstChild&&typeof div.firstChild.getAttribute!=="undefined"&&div.firstChild.getAttribute("href")!=="#"){Expr.attrHandle.href=function(elem){return elem.getAttribute("href",2)}}})();if(document.querySelectorAll){(function(){var oldSizzle=Sizzle,div=document.createElement("div");div.innerHTML="<p class='TEST'></p>";if(div.querySelectorAll&&div.querySelectorAll(".TEST").length===0){return }Sizzle=function(query,context,extra,seed){context=context||document;if(!seed&&context.nodeType===9&&!isXML(context)){try{return makeArray(context.querySelectorAll(query),extra)}catch(e){}}return oldSizzle(query,context,extra,seed)};Sizzle.find=oldSizzle.find;Sizzle.filter=oldSizzle.filter;Sizzle.selectors=oldSizzle.selectors;Sizzle.matches=oldSizzle.matches})()}if(document.getElementsByClassName&&document.documentElement.getElementsByClassName){(function(){var div=document.createElement("div");div.innerHTML="<div class='test e'></div><div class='test'></div>";if(div.getElementsByClassName("e").length===0){return }div.lastChild.className="e";if(div.getElementsByClassName("e").length===1){return }Expr.order.splice(1,0,"CLASS");Expr.find.CLASS=function(match,context,isXML){if(typeof context.getElementsByClassName!=="undefined"&&!isXML){return context.getElementsByClassName(match[1])}}})()}function dirNodeCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){var sibDir=dir=="previousSibling"&&!isXML;for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){if(sibDir&&elem.nodeType===1){elem.sizcache=doneName;elem.sizset=i}elem=elem[dir];var match=false;while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1&&!isXML){elem.sizcache=doneName;elem.sizset=i}if(elem.nodeName===cur){match=elem;break}elem=elem[dir]}checkSet[i]=match}}}function dirCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){var sibDir=dir=="previousSibling"&&!isXML;for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){if(sibDir&&elem.nodeType===1){elem.sizcache=doneName;elem.sizset=i}elem=elem[dir];var match=false;while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1){if(!isXML){elem.sizcache=doneName;elem.sizset=i}if(typeof cur!=="string"){if(elem===cur){match=true;break}}else{if(Sizzle.filter(cur,[elem]).length>0){match=elem;break}}}elem=elem[dir]}checkSet[i]=match}}}var contains=document.compareDocumentPosition?function(a,b){return a.compareDocumentPosition(b)&16}:function(a,b){return a!==b&&(a.contains?a.contains(b):true)};var isXML=function(elem){return elem.nodeType===9&&elem.documentElement.nodeName!=="HTML"||!!elem.ownerDocument&&isXML(elem.ownerDocument)};var posProcess=function(selector,context){var tmpSet=[],later="",match,root=context.nodeType?[context]:context;while((match=Expr.match.PSEUDO.exec(selector))){later+=match[0];selector=selector.replace(Expr.match.PSEUDO,"")}selector=Expr.relative[selector]?selector+"*":selector;for(var i=0,l=root.length;i<l;i++){Sizzle(selector,root[i],tmpSet)}return Sizzle.filter(later,tmpSet)};jQuery.find=Sizzle;jQuery.filter=Sizzle.filter;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.filters;Sizzle.selectors.filters.hidden=function(elem){return elem.offsetWidth===0||elem.offsetHeight===0};Sizzle.selectors.filters.visible=function(elem){return elem.offsetWidth>0||elem.offsetHeight>0};Sizzle.selectors.filters.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem}).length};jQuery.multiFilter=function(expr,elems,not){if(not){expr=":not("+expr+")"}return Sizzle.matches(expr,elems)};jQuery.dir=function(elem,dir){var matched=[],cur=elem[dir];while(cur&&cur!=document){if(cur.nodeType==1){matched.push(cur)}cur=cur[dir]}return matched};jQuery.nth=function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir]){if(cur.nodeType==1&&++num==result){break}}return cur};jQuery.sibling=function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType==1&&n!=elem){r.push(n)}}return r};return ;window.Sizzle=Sizzle})();jQuery.event={add:function(elem,types,handler,data){if(elem.nodeType==3||elem.nodeType==8){return }if(elem.setInterval&&elem!=window){elem=window}if(!handler.guid){handler.guid=this.guid++}if(data!==undefined){var fn=handler;handler=this.proxy(fn);handler.data=data}var events=jQuery.data(elem,"events")||jQuery.data(elem,"events",{}),handle=jQuery.data(elem,"handle")||jQuery.data(elem,"handle",function(){return typeof jQuery!=="undefined"&&!jQuery.event.triggered?jQuery.event.handle.apply(arguments.callee.elem,arguments):undefined});handle.elem=elem;jQuery.each(types.split(/\s+/),function(index,type){var namespaces=type.split(".");type=namespaces.shift();handler.type=namespaces.slice().sort().join(".");var handlers=events[type];if(jQuery.event.specialAll[type]){jQuery.event.specialAll[type].setup.call(elem,data,namespaces)}if(!handlers){handlers=events[type]={};if(!jQuery.event.special[type]||jQuery.event.special[type].setup.call(elem,data,namespaces)===false){if(elem.addEventListener){elem.addEventListener(type,handle,false)}else{if(elem.attachEvent){elem.attachEvent("on"+type,handle)}}}}handlers[handler.guid]=handler;jQuery.event.global[type]=true});elem=null},guid:1,global:{},remove:function(elem,types,handler){if(elem.nodeType==3||elem.nodeType==8){return }var events=jQuery.data(elem,"events"),ret,index;if(events){if(types===undefined||(typeof types==="string"&&types.charAt(0)==".")){for(var type in events){this.remove(elem,type+(types||""))}}else{if(types.type){handler=types.handler;types=types.type}jQuery.each(types.split(/\s+/),function(index,type){var namespaces=type.split(".");type=namespaces.shift();var namespace=RegExp("(^|\\.)"+namespaces.slice().sort().join(".*\\.")+"(\\.|$)");if(events[type]){if(handler){delete events[type][handler.guid]}else{for(var handle in events[type]){if(namespace.test(events[type][handle].type)){delete events[type][handle]}}}if(jQuery.event.specialAll[type]){jQuery.event.specialAll[type].teardown.call(elem,namespaces)}for(ret in events[type]){break}if(!ret){if(!jQuery.event.special[type]||jQuery.event.special[type].teardown.call(elem,namespaces)===false){if(elem.removeEventListener){elem.removeEventListener(type,jQuery.data(elem,"handle"),false)}else{if(elem.detachEvent){elem.detachEvent("on"+type,jQuery.data(elem,"handle"))}}}ret=null;delete events[type]}}})}for(ret in events){break}if(!ret){var handle=jQuery.data(elem,"handle");if(handle){handle.elem=null}jQuery.removeData(elem,"events");jQuery.removeData(elem,"handle")}}},trigger:function(event,data,elem,bubbling){var type=event.type||event;if(!bubbling){event=typeof event==="object"?event[expando]?event:jQuery.extend(jQuery.Event(type),event):jQuery.Event(type);if(type.indexOf("!")>=0){event.type=type=type.slice(0,-1);event.exclusive=true}if(!elem){event.stopPropagation();if(this.global[type]){jQuery.each(jQuery.cache,function(){if(this.events&&this.events[type]){jQuery.event.trigger(event,data,this.handle.elem)}})}}if(!elem||elem.nodeType==3||elem.nodeType==8){return undefined}event.result=undefined;event.target=elem;data=jQuery.makeArray(data);data.unshift(event)}event.currentTarget=elem;var handle=jQuery.data(elem,"handle");if(handle){handle.apply(elem,data)}if((!elem[type]||(jQuery.nodeName(elem,"a")&&type=="click"))&&elem["on"+type]&&elem["on"+type].apply(elem,data)===false){event.result=false}if(!bubbling&&elem[type]&&!event.isDefaultPrevented()&&!(jQuery.nodeName(elem,"a")&&type=="click")){this.triggered=true;try{elem[type]()}catch(e){}}this.triggered=false;if(!event.isPropagationStopped()){var parent=elem.parentNode||elem.ownerDocument;if(parent){jQuery.event.trigger(event,data,parent,true)}}},handle:function(event){var all,handlers;event=arguments[0]=jQuery.event.fix(event||window.event);event.currentTarget=this;var namespaces=event.type.split(".");event.type=namespaces.shift();all=!namespaces.length&&!event.exclusive;var namespace=RegExp("(^|\\.)"+namespaces.slice().sort().join(".*\\.")+"(\\.|$)");handlers=(jQuery.data(this,"events")||{})[event.type];for(var j in handlers){var handler=handlers[j];if(all||namespace.test(handler.type)){event.handler=handler;event.data=handler.data;var ret=handler.apply(this,arguments);if(ret!==undefined){event.result=ret;if(ret===false){event.preventDefault();event.stopPropagation()}}if(event.isImmediatePropagationStopped()){break}}}},props:"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),fix:function(event){if(event[expando]){return event}var originalEvent=event;event=jQuery.Event(originalEvent);for(var i=this.props.length,prop;i;){prop=this.props[--i];event[prop]=originalEvent[prop]}if(!event.target){event.target=event.srcElement||document}if(event.target.nodeType==3){event.target=event.target.parentNode}if(!event.relatedTarget&&event.fromElement){event.relatedTarget=event.fromElement==event.target?event.toElement:event.fromElement}if(event.pageX==null&&event.clientX!=null){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc.clientLeft||0);event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc.clientTop||0)}if(!event.which&&((event.charCode||event.charCode===0)?event.charCode:event.keyCode)){event.which=event.charCode||event.keyCode}if(!event.metaKey&&event.ctrlKey){event.metaKey=event.ctrlKey}if(!event.which&&event.button){event.which=(event.button&1?1:(event.button&2?3:(event.button&4?2:0)))}return event},proxy:function(fn,proxy){proxy=proxy||function(){return fn.apply(this,arguments)};proxy.guid=fn.guid=fn.guid||proxy.guid||this.guid++;return proxy},special:{ready:{setup:bindReady,teardown:function(){}}},specialAll:{live:{setup:function(selector,namespaces){jQuery.event.add(this,namespaces[0],liveHandler)},teardown:function(namespaces){if(namespaces.length){var remove=0,name=RegExp("(^|\\.)"+namespaces[0]+"(\\.|$)");jQuery.each((jQuery.data(this,"events").live||{}),function(){if(name.test(this.type)){remove++}});if(remove<1){jQuery.event.remove(this,namespaces[0],liveHandler)}}}}}};jQuery.Event=function(src){if(!this.preventDefault){return new jQuery.Event(src)}if(src&&src.type){this.originalEvent=src;this.type=src.type}else{this.type=src}this.timeStamp=now();this[expando]=true};function returnFalse(){return false}function returnTrue(){return true}jQuery.Event.prototype={preventDefault:function(){this.isDefaultPrevented=returnTrue;var e=this.originalEvent;if(!e){return }if(e.preventDefault){e.preventDefault()}e.returnValue=false},stopPropagation:function(){this.isPropagationStopped=returnTrue;var e=this.originalEvent;if(!e){return }if(e.stopPropagation){e.stopPropagation()}e.cancelBubble=true},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue;this.stopPropagation()},isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse};var withinElement=function(event){var parent=event.relatedTarget;while(parent&&parent!=this){try{parent=parent.parentNode}catch(e){parent=this}}if(parent!=this){event.type=event.data;jQuery.event.handle.apply(this,arguments)}};jQuery.each({mouseover:"mouseenter",mouseout:"mouseleave"},function(orig,fix){jQuery.event.special[fix]={setup:function(){jQuery.event.add(this,orig,withinElement,fix)},teardown:function(){jQuery.event.remove(this,orig,withinElement)}}});jQuery.fn.extend({bind:function(type,data,fn){return type=="unload"?this.one(type,data,fn):this.each(function(){jQuery.event.add(this,type,fn||data,fn&&data)})},one:function(type,data,fn){var one=jQuery.event.proxy(fn||data,function(event){jQuery(this).unbind(event,one);return(fn||data).apply(this,arguments)});return this.each(function(){jQuery.event.add(this,type,one,fn&&data)})},unbind:function(type,fn){return this.each(function(){jQuery.event.remove(this,type,fn)})},trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this)})},triggerHandler:function(type,data){if(this[0]){var event=jQuery.Event(type);event.preventDefault();event.stopPropagation();jQuery.event.trigger(event,data,this[0]);return event.result}},toggle:function(fn){var args=arguments,i=1;while(i<args.length){jQuery.event.proxy(fn,args[i++])}return this.click(jQuery.event.proxy(fn,function(event){this.lastToggle=(this.lastToggle||0)%i;event.preventDefault();return args[this.lastToggle++].apply(this,arguments)||false}))},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut)},ready:function(fn){bindReady();if(jQuery.isReady){fn.call(document,jQuery)}else{jQuery.readyList.push(fn)}return this},live:function(type,fn){var proxy=jQuery.event.proxy(fn);proxy.guid+=this.selector+type;jQuery(document).bind(liveConvert(type,this.selector),this.selector,proxy);return this},die:function(type,fn){jQuery(document).unbind(liveConvert(type,this.selector),fn?{guid:fn.guid+this.selector+type}:null);return this}});function liveHandler(event){var check=RegExp("(^|\\.)"+event.type+"(\\.|$)"),stop=true,elems=[];jQuery.each(jQuery.data(this,"events").live||[],function(i,fn){if(check.test(fn.type)){var elem=jQuery(event.target).closest(fn.data)[0];if(elem){elems.push({elem:elem,fn:fn})}}});elems.sort(function(a,b){return jQuery.data(a.elem,"closest")-jQuery.data(b.elem,"closest")});jQuery.each(elems,function(){if(this.fn.call(this.elem,event,this.fn.data)===false){return(stop=false)}});return stop}function liveConvert(type,selector){return["live",type,selector.replace(/\./g,"`").replace(/ /g,"|")].join(".")}jQuery.extend({isReady:false,readyList:[],ready:function(){if(!jQuery.isReady){jQuery.isReady=true;if(jQuery.readyList){jQuery.each(jQuery.readyList,function(){this.call(document,jQuery)});jQuery.readyList=null}jQuery(document).triggerHandler("ready")}}});var readyBound=false;function bindReady(){if(readyBound){return }readyBound=true;if(document.addEventListener){document.addEventListener("DOMContentLoaded",function(){document.removeEventListener("DOMContentLoaded",arguments.callee,false);jQuery.ready()},false)}else{if(document.attachEvent){document.attachEvent("onreadystatechange",function(){if(document.readyState==="complete"){document.detachEvent("onreadystatechange",arguments.callee);jQuery.ready()}});if(document.documentElement.doScroll&&window==window.top){(function(){if(jQuery.isReady){return }try{document.documentElement.doScroll("left")}catch(error){setTimeout(arguments.callee,0);return }jQuery.ready()})()}}}jQuery.event.add(window,"load",jQuery.ready)}jQuery.each(("blur,focus,load,resize,scroll,unload,click,dblclick,mousedown,mouseup,mousemove,mouseover,mouseout,mouseenter,mouseleave,change,select,submit,keydown,keypress,keyup,error").split(","),function(i,name){jQuery.fn[name]=function(fn){return fn?this.bind(name,fn):this.trigger(name)}});jQuery(window).bind("unload",function(){for(var id in jQuery.cache){if(id!=1&&jQuery.cache[id].handle){jQuery.event.remove(jQuery.cache[id].handle.elem)}}});(function(){jQuery.support={};var root=document.documentElement,script=document.createElement("script"),div=document.createElement("div"),id="script"+(new Date).getTime();div.style.display="none";div.innerHTML='   <link/><table></table><a href="/a" style="color:red;float:left;opacity:.5;">a</a><select><option>text</option></select><object><param/></object>';var all=div.getElementsByTagName("*"),a=div.getElementsByTagName("a")[0];if(!all||!all.length||!a){return }jQuery.support={leadingWhitespace:div.firstChild.nodeType==3,tbody:!div.getElementsByTagName("tbody").length,objectAll:!!div.getElementsByTagName("object")[0].getElementsByTagName("*").length,htmlSerialize:!!div.getElementsByTagName("link").length,style:/red/.test(a.getAttribute("style")),hrefNormalized:a.getAttribute("href")==="/a",opacity:a.style.opacity==="0.5",cssFloat:!!a.style.cssFloat,scriptEval:false,noCloneEvent:true,boxModel:null};script.type="text/javascript";try{script.appendChild(document.createTextNode("window."+id+"=1;"))}catch(e){}root.insertBefore(script,root.firstChild);if(window[id]){jQuery.support.scriptEval=true;delete window[id]}root.removeChild(script);if(div.attachEvent&&div.fireEvent){div.attachEvent("onclick",function(){jQuery.support.noCloneEvent=false;div.detachEvent("onclick",arguments.callee)});div.cloneNode(true).fireEvent("onclick")}jQuery(function(){var div=document.createElement("div");div.style.width=div.style.paddingLeft="1px";document.body.appendChild(div);jQuery.boxModel=jQuery.support.boxModel=div.offsetWidth===2;document.body.removeChild(div).style.display="none"})})();var styleFloat=jQuery.support.cssFloat?"cssFloat":"styleFloat";jQuery.props={"for":"htmlFor","class":"className","float":styleFloat,cssFloat:styleFloat,styleFloat:styleFloat,readonly:"readOnly",maxlength:"maxLength",cellspacing:"cellSpacing",rowspan:"rowSpan",tabindex:"tabIndex"};jQuery.fn.extend({_load:jQuery.fn.load,load:function(url,params,callback){if(typeof url!=="string"){return this._load(url)}var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off)}var type="GET";if(params){if(jQuery.isFunction(params)){callback=params;params=null}else{if(typeof params==="object"){params=jQuery.param(params);type="POST"}}}var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(res,status){if(status=="success"||status=="notmodified"){self.html(selector?jQuery("<div/>").append(res.responseText.replace(/<script(.|\s)*?\/script>/g,"")).find(selector):res.responseText)}if(callback){self.each(callback,[res.responseText,status,res])}}});return this},serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?jQuery.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||/select|textarea/i.test(this.nodeName)||/text|hidden|password|search/i.test(this.type))}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:jQuery.isArray(val)?jQuery.map(val,function(val,i){return{name:elem.name,value:val}}):{name:elem.name,value:val}}).get()}});jQuery.each("ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend".split(","),function(i,o){jQuery.fn[o]=function(f){return this.bind(o,f)}});var jsc=now();jQuery.extend({get:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data=null}return jQuery.ajax({type:"GET",url:url,data:data,success:callback,dataType:type})},getScript:function(url,callback){return jQuery.get(url,null,callback,"script")},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},post:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data={}}return jQuery.ajax({type:"POST",url:url,data:data,success:callback,dataType:type})},ajaxSetup:function(settings){jQuery.extend(jQuery.ajaxSettings,settings)},ajaxSettings:{url:location.href,global:true,type:"GET",contentType:"application/x-www-form-urlencoded",processData:true,async:true,xhr:function(){return window.ActiveXObject?new ActiveXObject("Microsoft.XMLHTTP"):new XMLHttpRequest()},accepts:{xml:"application/xml, text/xml",html:"text/html",script:"text/javascript, application/javascript",json:"application/json, text/javascript",text:"text/plain",_default:"*/*"}},lastModified:{},ajax:function(s){s=jQuery.extend(true,s,jQuery.extend(true,{},jQuery.ajaxSettings,s));var jsonp,jsre=/=\?(&|$)/g,status,data,type=s.type.toUpperCase();if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data)}if(s.dataType=="jsonp"){if(type=="GET"){if(!s.url.match(jsre)){s.url+=(s.url.match(/\?/)?"&":"?")+(s.jsonp||"callback")+"=?"}}else{if(!s.data||!s.data.match(jsre)){s.data=(s.data?s.data+"&":"")+(s.jsonp||"callback")+"=?"}}s.dataType="json"}if(s.dataType=="json"&&(s.data&&s.data.match(jsre)||s.url.match(jsre))){jsonp="jsonp"+jsc++;if(s.data){s.data=(s.data+"").replace(jsre,"="+jsonp+"$1")}s.url=s.url.replace(jsre,"="+jsonp+"$1");s.dataType="script";window[jsonp]=function(tmp){data=tmp;success();complete();window[jsonp]=undefined;try{delete window[jsonp]}catch(e){}if(head){head.removeChild(script)}}}if(s.dataType=="script"&&s.cache==null){s.cache=false}if(s.cache===false&&type=="GET"){var ts=now();var ret=s.url.replace(/(\?|&)_=.*?(&|$)/,"$1_="+ts+"$2");s.url=ret+((ret==s.url)?(s.url.match(/\?/)?"&":"?")+"_="+ts:"")}if(s.data&&type=="GET"){s.url+=(s.url.match(/\?/)?"&":"?")+s.data;s.data=null}if(s.global&&!jQuery.active++){jQuery.event.trigger("ajaxStart")}var parts=/^(\w+:)?\/\/([^\/?#]+)/.exec(s.url);if(s.dataType=="script"&&type=="GET"&&parts&&(parts[1]&&parts[1]!=location.protocol||parts[2]!=location.host)){var head=document.getElementsByTagName("head")[0];var script=document.createElement("script");script.src=s.url;if(s.scriptCharset){script.charset=s.scriptCharset}if(!jsonp){var done=false;script.onload=script.onreadystatechange=function(){if(!done&&(!this.readyState||this.readyState=="loaded"||this.readyState=="complete")){done=true;success();complete();script.onload=script.onreadystatechange=null;head.removeChild(script)}}}head.appendChild(script);return undefined}var requestDone=false;var xhr=s.xhr();if(s.username){xhr.open(type,s.url,s.async,s.username,s.password)}else{xhr.open(type,s.url,s.async)}try{if(s.data){xhr.setRequestHeader("Content-Type",s.contentType)}if(s.ifModified){xhr.setRequestHeader("If-Modified-Since",jQuery.lastModified[s.url]||"Thu, 01 Jan 1970 00:00:00 GMT")}xhr.setRequestHeader("X-Requested-With","XMLHttpRequest");xhr.setRequestHeader("Accept",s.dataType&&s.accepts[s.dataType]?s.accepts[s.dataType]+", */*":s.accepts._default)}catch(e){}if(s.beforeSend&&s.beforeSend(xhr,s)===false){if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}xhr.abort();return false}if(s.global){jQuery.event.trigger("ajaxSend",[xhr,s])}var onreadystatechange=function(isTimeout){if(xhr.readyState==0){if(ival){clearInterval(ival);ival=null;if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}}}else{if(!requestDone&&xhr&&(xhr.readyState==4||isTimeout=="timeout")){requestDone=true;if(ival){clearInterval(ival);ival=null}status=isTimeout=="timeout"?"timeout":!jQuery.httpSuccess(xhr)?"error":s.ifModified&&jQuery.httpNotModified(xhr,s.url)?"notmodified":"success";if(status=="success"){try{data=jQuery.httpData(xhr,s.dataType,s)}catch(e){status="parsererror"}}if(status=="success"){var modRes;try{modRes=xhr.getResponseHeader("Last-Modified")}catch(e){}if(s.ifModified&&modRes){jQuery.lastModified[s.url]=modRes}if(!jsonp){success()}}else{jQuery.handleError(s,xhr,status)}complete();if(isTimeout){xhr.abort()}if(s.async){xhr=null}}}};if(s.async){var ival=setInterval(onreadystatechange,13);if(s.timeout>0){setTimeout(function(){if(xhr&&!requestDone){onreadystatechange("timeout")}},s.timeout)}}try{xhr.send(s.data)}catch(e){jQuery.handleError(s,xhr,null,e)}if(!s.async){onreadystatechange()}function success(){if(s.success){s.success(data,status)}if(s.global){jQuery.event.trigger("ajaxSuccess",[xhr,s])}}function complete(){if(s.complete){s.complete(xhr,status)}if(s.global){jQuery.event.trigger("ajaxComplete",[xhr,s])}if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}}return xhr},handleError:function(s,xhr,status,e){if(s.error){s.error(xhr,status,e)}if(s.global){jQuery.event.trigger("ajaxError",[xhr,s,e])}},active:0,httpSuccess:function(xhr){try{return !xhr.status&&location.protocol=="file:"||(xhr.status>=200&&xhr.status<300)||xhr.status==304||xhr.status==1223}catch(e){}return false},httpNotModified:function(xhr,url){try{var xhrRes=xhr.getResponseHeader("Last-Modified");return xhr.status==304||xhrRes==jQuery.lastModified[url]}catch(e){}return false},httpData:function(xhr,type,s){var ct=xhr.getResponseHeader("content-type"),xml=type=="xml"||!type&&ct&&ct.indexOf("xml")>=0,data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.tagName=="parsererror"){throw"parsererror"}if(s&&s.dataFilter){data=s.dataFilter(data,type)}if(typeof data==="string"){if(type=="script"){jQuery.globalEval(data)}if(type=="json"){data=window.eval("("+data+")")}}return data},param:function(a){var s=[];function add(key,value){s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value)}if(jQuery.isArray(a)||a.jquery){jQuery.each(a,function(){add(this.name,this.value)})}else{for(var j in a){if(jQuery.isArray(a[j])){jQuery.each(a[j],function(){add(j,this)})}else{add(j,jQuery.isFunction(a[j])?a[j]():a[j])}}}return s.join("&").replace(/%20/g,"+")}});var elemdisplay={},timerId,fxAttrs=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]];function genFx(type,num){var obj={};jQuery.each(fxAttrs.concat.apply([],fxAttrs.slice(0,num)),function(){obj[this]=type});return obj}jQuery.fn.extend({show:function(speed,callback){if(speed){return this.animate(genFx("show",3),speed,callback)}else{for(var i=0,l=this.length;i<l;i++){var old=jQuery.data(this[i],"olddisplay");this[i].style.display=old||"";if(jQuery.css(this[i],"display")==="none"){var tagName=this[i].tagName,display;if(elemdisplay[tagName]){display=elemdisplay[tagName]}else{var elem=jQuery("<"+tagName+" />").appendTo("body");display=elem.css("display");if(display==="none"){display="block"}elem.remove();elemdisplay[tagName]=display}jQuery.data(this[i],"olddisplay",display)}}for(var i=0,l=this.length;i<l;i++){this[i].style.display=jQuery.data(this[i],"olddisplay")||""}return this}},hide:function(speed,callback){if(speed){return this.animate(genFx("hide",3),speed,callback)}else{for(var i=0,l=this.length;i<l;i++){var old=jQuery.data(this[i],"olddisplay");if(!old&&old!=="none"){jQuery.data(this[i],"olddisplay",jQuery.css(this[i],"display"))}}for(var i=0,l=this.length;i<l;i++){this[i].style.display="none"}return this}},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2){var bool=typeof fn==="boolean";return jQuery.isFunction(fn)&&jQuery.isFunction(fn2)?this._toggle.apply(this,arguments):fn==null||bool?this.each(function(){var state=bool?fn:jQuery(this).is(":hidden");jQuery(this)[state?"show":"hide"]()}):this.animate(genFx("toggle",3),fn,fn2)},fadeTo:function(speed,to,callback){return this.animate({opacity:to},speed,callback)},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);return this[optall.queue===false?"each":"queue"](function(){var opt=jQuery.extend({},optall),p,hidden=this.nodeType==1&&jQuery(this).is(":hidden"),self=this;for(p in prop){if(prop[p]=="hide"&&hidden||prop[p]=="show"&&!hidden){return opt.complete.call(this)}if((p=="height"||p=="width")&&this.style){opt.display=jQuery.css(this,"display");opt.overflow=this.style.overflow}}if(opt.overflow!=null){this.style.overflow="hidden"}opt.curAnim=jQuery.extend({},prop);jQuery.each(prop,function(name,val){var e=new jQuery.fx(self,opt,name);if(/toggle|show|hide/.test(val)){e[val=="toggle"?hidden?"show":"hide":val](prop)}else{var parts=val.toString().match(/^([+-]=)?([\d+-.]+)(.*)$/),start=e.cur(true)||0;if(parts){var end=parseFloat(parts[2]),unit=parts[3]||"px";if(unit!="px"){self.style[name]=(end||1)+unit;start=((end||1)/e.cur(true))*start;self.style[name]=start+unit}if(parts[1]){end=((parts[1]=="-="?-1:1)*end)+start}e.custom(start,end,unit)}else{e.custom(start,val,"")}}});return true})},stop:function(clearQueue,gotoEnd){var timers=jQuery.timers;if(clearQueue){this.queue([])}this.each(function(){for(var i=timers.length-1;i>=0;i--){if(timers[i].elem==this){if(gotoEnd){timers[i](true)}timers.splice(i,1)}}});if(!gotoEnd){this.dequeue()}return this}});jQuery.each({slideDown:genFx("show",1),slideUp:genFx("hide",1),slideToggle:genFx("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"}},function(name,props){jQuery.fn[name]=function(speed,callback){return this.animate(props,speed,callback)}});jQuery.extend({speed:function(speed,easing,fn){var opt=typeof speed==="object"?speed:{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!jQuery.isFunction(easing)&&easing};opt.duration=jQuery.fx.off?0:typeof opt.duration==="number"?opt.duration:jQuery.fx.speeds[opt.duration]||jQuery.fx.speeds._default;opt.old=opt.complete;opt.complete=function(){if(opt.queue!==false){jQuery(this).dequeue()}if(jQuery.isFunction(opt.old)){opt.old.call(this)}};return opt},easing:{linear:function(p,n,firstNum,diff){return firstNum+diff*p},swing:function(p,n,firstNum,diff){return((-Math.cos(p*Math.PI)/2)+0.5)*diff+firstNum}},timers:[],fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;if(!options.orig){options.orig={}}}});jQuery.fx.prototype={update:function(){if(this.options.step){this.options.step.call(this.elem,this.now,this)}(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this);if((this.prop=="height"||this.prop=="width")&&this.elem.style){this.elem.style.display="block"}},cur:function(force){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null)){return this.elem[this.prop]}var r=parseFloat(jQuery.css(this.elem,this.prop,force));return r&&r>-10000?r:parseFloat(jQuery.curCSS(this.elem,this.prop))||0},custom:function(from,to,unit){this.startTime=now();this.start=from;this.end=to;this.unit=unit||this.unit||"px";this.now=this.start;this.pos=this.state=0;var self=this;function t(gotoEnd){return self.step(gotoEnd)}t.elem=this.elem;if(t()&&jQuery.timers.push(t)&&!timerId){timerId=setInterval(function(){var timers=jQuery.timers;for(var i=0;i<timers.length;i++){if(!timers[i]()){timers.splice(i--,1)}}if(!timers.length){clearInterval(timerId);timerId=undefined}},13)}},show:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.show=true;this.custom(this.prop=="width"||this.prop=="height"?1:0,this.cur());jQuery(this.elem).show()},hide:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.hide=true;this.custom(this.cur(),0)},step:function(gotoEnd){var t=now();if(gotoEnd||t>=this.options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();this.options.curAnim[this.prop]=true;var done=true;for(var i in this.options.curAnim){if(this.options.curAnim[i]!==true){done=false}}if(done){if(this.options.display!=null){this.elem.style.overflow=this.options.overflow;this.elem.style.display=this.options.display;if(jQuery.css(this.elem,"display")=="none"){this.elem.style.display="block"}}if(this.options.hide){jQuery(this.elem).hide()}if(this.options.hide||this.options.show){for(var p in this.options.curAnim){jQuery.attr(this.elem.style,p,this.options.orig[p])}}this.options.complete.call(this.elem)}return false}else{var n=t-this.startTime;this.state=n/this.options.duration;this.pos=jQuery.easing[this.options.easing||(jQuery.easing.swing?"swing":"linear")](this.state,n,0,1,this.options.duration);this.now=this.start+((this.end-this.start)*this.pos);this.update()}return true}};jQuery.extend(jQuery.fx,{speeds:{slow:600,fast:200,_default:400},step:{opacity:function(fx){jQuery.attr(fx.elem.style,"opacity",fx.now)},_default:function(fx){if(fx.elem.style&&fx.elem.style[fx.prop]!=null){fx.elem.style[fx.prop]=fx.now+fx.unit}else{fx.elem[fx.prop]=fx.now}}}});if(document.documentElement.getBoundingClientRect){jQuery.fn.offset=function(){if(!this[0]){return{top:0,left:0}}if(this[0]===this[0].ownerDocument.body){return jQuery.offset.bodyOffset(this[0])}var box=this[0].getBoundingClientRect(),doc=this[0].ownerDocument,body=doc.body,docElem=doc.documentElement,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,top=box.top+(self.pageYOffset||jQuery.boxModel&&docElem.scrollTop||body.scrollTop)-clientTop,left=box.left+(self.pageXOffset||jQuery.boxModel&&docElem.scrollLeft||body.scrollLeft)-clientLeft;return{top:top,left:left}}}else{jQuery.fn.offset=function(){if(!this[0]){return{top:0,left:0}}if(this[0]===this[0].ownerDocument.body){return jQuery.offset.bodyOffset(this[0])}jQuery.offset.initialized||jQuery.offset.initialize();var elem=this[0],offsetParent=elem.offsetParent,prevOffsetParent=elem,doc=elem.ownerDocument,computedStyle,docElem=doc.documentElement,body=doc.body,defaultView=doc.defaultView,prevComputedStyle=defaultView.getComputedStyle(elem,null),top=elem.offsetTop,left=elem.offsetLeft;while((elem=elem.parentNode)&&elem!==body&&elem!==docElem){computedStyle=defaultView.getComputedStyle(elem,null);top-=elem.scrollTop,left-=elem.scrollLeft;if(elem===offsetParent){top+=elem.offsetTop,left+=elem.offsetLeft;if(jQuery.offset.doesNotAddBorder&&!(jQuery.offset.doesAddBorderForTableAndCells&&/^t(able|d|h)$/i.test(elem.tagName))){top+=parseInt(computedStyle.borderTopWidth,10)||0,left+=parseInt(computedStyle.borderLeftWidth,10)||0}prevOffsetParent=offsetParent,offsetParent=elem.offsetParent}if(jQuery.offset.subtractsBorderForOverflowNotVisible&&computedStyle.overflow!=="visible"){top+=parseInt(computedStyle.borderTopWidth,10)||0,left+=parseInt(computedStyle.borderLeftWidth,10)||0}prevComputedStyle=computedStyle}if(prevComputedStyle.position==="relative"||prevComputedStyle.position==="static"){top+=body.offsetTop,left+=body.offsetLeft}if(prevComputedStyle.position==="fixed"){top+=Math.max(docElem.scrollTop,body.scrollTop),left+=Math.max(docElem.scrollLeft,body.scrollLeft)}return{top:top,left:left}}}jQuery.offset={initialize:function(){if(this.initialized){return }var body=document.body,container=document.createElement("div"),innerDiv,checkDiv,table,td,rules,prop,bodyMarginTop=body.style.marginTop,html='<div style="position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;"><div></div></div><table style="position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;" cellpadding="0" cellspacing="0"><tr><td></td></tr></table>';rules={position:"absolute",top:0,left:0,margin:0,border:0,width:"1px",height:"1px",visibility:"hidden"};for(prop in rules){container.style[prop]=rules[prop]}container.innerHTML=html;body.insertBefore(container,body.firstChild);innerDiv=container.firstChild,checkDiv=innerDiv.firstChild,td=innerDiv.nextSibling.firstChild.firstChild;this.doesNotAddBorder=(checkDiv.offsetTop!==5);this.doesAddBorderForTableAndCells=(td.offsetTop===5);innerDiv.style.overflow="hidden",innerDiv.style.position="relative";this.subtractsBorderForOverflowNotVisible=(checkDiv.offsetTop===-5);body.style.marginTop="1px";this.doesNotIncludeMarginInBodyOffset=(body.offsetTop===0);body.style.marginTop=bodyMarginTop;body.removeChild(container);this.initialized=true},bodyOffset:function(body){jQuery.offset.initialized||jQuery.offset.initialize();var top=body.offsetTop,left=body.offsetLeft;if(jQuery.offset.doesNotIncludeMarginInBodyOffset){top+=parseInt(jQuery.curCSS(body,"marginTop",true),10)||0,left+=parseInt(jQuery.curCSS(body,"marginLeft",true),10)||0}return{top:top,left:left}}};jQuery.fn.extend({position:function(){var left=0,top=0,results;if(this[0]){var offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=/^body|html$/i.test(offsetParent[0].tagName)?{top:0,left:0}:offsetParent.offset();offset.top-=num(this,"marginTop");offset.left-=num(this,"marginLeft");parentOffset.top+=num(offsetParent,"borderTopWidth");parentOffset.left+=num(offsetParent,"borderLeftWidth");results={top:offset.top-parentOffset.top,left:offset.left-parentOffset.left}}return results},offsetParent:function(){var offsetParent=this[0].offsetParent||document.body;while(offsetParent&&(!/^body|html$/i.test(offsetParent.tagName)&&jQuery.css(offsetParent,"position")=="static")){offsetParent=offsetParent.offsetParent}return jQuery(offsetParent)}});jQuery.each(["Left","Top"],function(i,name){var method="scroll"+name;jQuery.fn[method]=function(val){if(!this[0]){return null}return val!==undefined?this.each(function(){this==window||this==document?window.scrollTo(!i?val:jQuery(window).scrollLeft(),i?val:jQuery(window).scrollTop()):this[method]=val}):this[0]==window||this[0]==document?self[i?"pageYOffset":"pageXOffset"]||jQuery.boxModel&&document.documentElement[method]||document.body[method]:this[0][method]}});jQuery.each(["Height","Width"],function(i,name){var tl=i?"Left":"Top",br=i?"Right":"Bottom",lower=name.toLowerCase();jQuery.fn["inner"+name]=function(){return this[0]?jQuery.css(this[0],lower,false,"padding"):null};jQuery.fn["outer"+name]=function(margin){return this[0]?jQuery.css(this[0],lower,false,margin?"margin":"border"):null};var type=name.toLowerCase();jQuery.fn[type]=function(size){return this[0]==window?document.compatMode=="CSS1Compat"&&document.documentElement["client"+name]||document.body["client"+name]:this[0]==document?Math.max(document.documentElement["client"+name],document.body["scroll"+name],document.documentElement["scroll"+name],document.body["offset"+name],document.documentElement["offset"+name]):size===undefined?(this.length?jQuery.css(this[0],type):null):this.css(type,typeof size==="string"?size:size+"px")}})})();jQuery.ui||(function($){var _remove=$.fn.remove,isFF2=$.browser.mozilla&&(parseFloat($.browser.version)<1.9);$.ui={version:"1.7",plugin:{add:function(module,option,set){var proto=$.ui[module].prototype;for(var i in set){proto.plugins[i]=proto.plugins[i]||[];proto.plugins[i].push([option,set[i]])}},call:function(instance,name,args){var set=instance.plugins[name];if(!set||!instance.element[0].parentNode){return }for(var i=0;i<set.length;i++){if(instance.options[set[i][0]]){set[i][1].apply(instance.element,args)}}}},contains:function(a,b){return document.compareDocumentPosition?a.compareDocumentPosition(b)&16:a!==b&&a.contains(b)},hasScroll:function(el,a){if($(el).css("overflow")=="hidden"){return false}var scroll=(a&&a=="left")?"scrollLeft":"scrollTop",has=false;if(el[scroll]>0){return true}el[scroll]=1;has=(el[scroll]>0);el[scroll]=0;return has},isOverAxis:function(x,reference,size){return(x>reference)&&(x<(reference+size))},isOver:function(y,x,top,left,height,width){return $.ui.isOverAxis(y,top,height)&&$.ui.isOverAxis(x,left,width)},keyCode:{BACKSPACE:8,CAPS_LOCK:20,COMMA:188,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,INSERT:45,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SHIFT:16,SPACE:32,TAB:9,UP:38}};if(isFF2){var attr=$.attr,removeAttr=$.fn.removeAttr,ariaNS="http://www.w3.org/2005/07/aaa",ariaState=/^aria-/,ariaRole=/^wairole:/;$.attr=function(elem,name,value){var set=value!==undefined;return(name=="role"?(set?attr.call(this,elem,name,"wairole:"+value):(attr.apply(this,arguments)||"").replace(ariaRole,"")):(ariaState.test(name)?(set?elem.setAttributeNS(ariaNS,name.replace(ariaState,"aaa:"),value):attr.call(this,elem,name.replace(ariaState,"aaa:"))):attr.apply(this,arguments)))};$.fn.removeAttr=function(name){return(ariaState.test(name)?this.each(function(){this.removeAttributeNS(ariaNS,name.replace(ariaState,""))}):removeAttr.call(this,name))}}$.fn.extend({remove:function(){$("*",this).add(this).each(function(){$(this).triggerHandler("remove")});return _remove.apply(this,arguments)},enableSelection:function(){return this.attr("unselectable","off").css("MozUserSelect","").unbind("selectstart.ui")},disableSelection:function(){return this.attr("unselectable","on").css("MozUserSelect","none").bind("selectstart.ui",function(){return false})},scrollParent:function(){var scrollParent;if(($.browser.msie&&(/(static|relative)/).test(this.css("position")))||(/absolute/).test(this.css("position"))){scrollParent=this.parents().filter(function(){return(/(relative|absolute|fixed)/).test($.curCSS(this,"position",1))&&(/(auto|scroll)/).test($.curCSS(this,"overflow",1)+$.curCSS(this,"overflow-y",1)+$.curCSS(this,"overflow-x",1))}).eq(0)}else{scrollParent=this.parents().filter(function(){return(/(auto|scroll)/).test($.curCSS(this,"overflow",1)+$.curCSS(this,"overflow-y",1)+$.curCSS(this,"overflow-x",1))}).eq(0)}return(/fixed/).test(this.css("position"))||!scrollParent.length?$(document):scrollParent}});$.extend($.expr[":"],{data:function(elem,i,match){return !!$.data(elem,match[3])},focusable:function(element){var nodeName=element.nodeName.toLowerCase(),tabIndex=$.attr(element,"tabindex");return(/input|select|textarea|button|object/.test(nodeName)?!element.disabled:"a"==nodeName||"area"==nodeName?element.href||!isNaN(tabIndex):!isNaN(tabIndex))&&!$(element)["area"==nodeName?"parents":"closest"](":hidden").length},tabbable:function(element){var tabIndex=$.attr(element,"tabindex");return(isNaN(tabIndex)||tabIndex>=0)&&$(element).is(":focusable")}});function getter(namespace,plugin,method,args){function getMethods(type){var methods=$[namespace][plugin][type]||[];return(typeof methods=="string"?methods.split(/,?\s+/):methods)}var methods=getMethods("getter");if(args.length==1&&typeof args[0]=="string"){methods=methods.concat(getMethods("getterSetter"))}return($.inArray(method,methods)!=-1)}$.widget=function(name,prototype){var namespace=name.split(".")[0];name=name.split(".")[1];$.fn[name]=function(options){var isMethodCall=(typeof options=="string"),args=Array.prototype.slice.call(arguments,1);if(isMethodCall&&options.substring(0,1)=="_"){return this}if(isMethodCall&&getter(namespace,name,options,args)){var instance=$.data(this[0],name);return(instance?instance[options].apply(instance,args):undefined)}return this.each(function(){var instance=$.data(this,name);(!instance&&!isMethodCall&&$.data(this,name,new $[namespace][name](this,options))._init());(instance&&isMethodCall&&$.isFunction(instance[options])&&instance[options].apply(instance,args))})};$[namespace]=$[namespace]||{};$[namespace][name]=function(element,options){var self=this;this.namespace=namespace;this.widgetName=name;this.widgetEventPrefix=$[namespace][name].eventPrefix||name;this.widgetBaseClass=namespace+"-"+name;this.options=$.extend({},$.widget.defaults,$[namespace][name].defaults,$.metadata&&$.metadata.get(element)[name],options);this.element=$(element).bind("setData."+name,function(event,key,value){if(event.target==element){return self._setData(key,value)}}).bind("getData."+name,function(event,key){if(event.target==element){return self._getData(key)}}).bind("remove",function(){return self.destroy()})};$[namespace][name].prototype=$.extend({},$.widget.prototype,prototype);$[namespace][name].getterSetter="option"};$.widget.prototype={_init:function(){},destroy:function(){this.element.removeData(this.widgetName).removeClass(this.widgetBaseClass+"-disabled "+this.namespace+"-state-disabled").removeAttr("aria-disabled")},option:function(key,value){var options=key,self=this;if(typeof key=="string"){if(value===undefined){return this._getData(key)}options={};options[key]=value}$.each(options,function(key,value){self._setData(key,value)})},_getData:function(key){return this.options[key]},_setData:function(key,value){this.options[key]=value;if(key=="disabled"){this.element[value?"addClass":"removeClass"](this.widgetBaseClass+"-disabled "+this.namespace+"-state-disabled").attr("aria-disabled",value)}},enable:function(){this._setData("disabled",false)},disable:function(){this._setData("disabled",true)},_trigger:function(type,event,data){var callback=this.options[type],eventName=(type==this.widgetEventPrefix?type:this.widgetEventPrefix+type);event=$.Event(event);event.type=eventName;if(event.originalEvent){for(var i=$.event.props.length,prop;i;){prop=$.event.props[--i];event[prop]=event.originalEvent[prop]}}this.element.trigger(event,data);return !($.isFunction(callback)&&callback.call(this.element[0],event,data)===false||event.isDefaultPrevented())}};$.widget.defaults={disabled:false};$.ui.mouse={_mouseInit:function(){var self=this;this.element.bind("mousedown."+this.widgetName,function(event){return self._mouseDown(event)}).bind("click."+this.widgetName,function(event){if(self._preventClickEvent){self._preventClickEvent=false;event.stopImmediatePropagation();return false}});if($.browser.msie){this._mouseUnselectable=this.element.attr("unselectable");this.element.attr("unselectable","on")}this.started=false},_mouseDestroy:function(){this.element.unbind("."+this.widgetName);($.browser.msie&&this.element.attr("unselectable",this._mouseUnselectable))},_mouseDown:function(event){event.originalEvent=event.originalEvent||{};if(event.originalEvent.mouseHandled){return }(this._mouseStarted&&this._mouseUp(event));this._mouseDownEvent=event;var self=this,btnIsLeft=(event.which==1),elIsCancel=(typeof this.options.cancel=="string"?$(event.target).parents().add(event.target).filter(this.options.cancel).length:false);if(!btnIsLeft||elIsCancel||!this._mouseCapture(event)){return true}this.mouseDelayMet=!this.options.delay;if(!this.mouseDelayMet){this._mouseDelayTimer=setTimeout(function(){self.mouseDelayMet=true},this.options.delay)}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(event)!==false);if(!this._mouseStarted){event.preventDefault();return true}}this._mouseMoveDelegate=function(event){return self._mouseMove(event)};this._mouseUpDelegate=function(event){return self._mouseUp(event)};$(document).bind("mousemove."+this.widgetName,this._mouseMoveDelegate).bind("mouseup."+this.widgetName,this._mouseUpDelegate);($.browser.safari||event.preventDefault());event.originalEvent.mouseHandled=true;return true},_mouseMove:function(event){if($.browser.msie&&!event.button){return this._mouseUp(event)}if(this._mouseStarted){this._mouseDrag(event);return event.preventDefault()}if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(this._mouseDownEvent,event)!==false);(this._mouseStarted?this._mouseDrag(event):this._mouseUp(event))}return !this._mouseStarted},_mouseUp:function(event){$(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate);if(this._mouseStarted){this._mouseStarted=false;this._preventClickEvent=(event.target==this._mouseDownEvent.target);this._mouseStop(event)}return false},_mouseDistanceMet:function(event){return(Math.max(Math.abs(this._mouseDownEvent.pageX-event.pageX),Math.abs(this._mouseDownEvent.pageY-event.pageY))>=this.options.distance)},_mouseDelayMet:function(event){return this.mouseDelayMet},_mouseStart:function(event){},_mouseDrag:function(event){},_mouseStop:function(event){},_mouseCapture:function(event){return true}};$.ui.mouse.defaults={cancel:null,distance:1,delay:0}})(jQuery);(function($){$.fn.bgIframe=$.fn.bgiframe=function(s){if($.browser.msie&&parseInt($.browser.version)<=6){s=$.extend({top:"auto",left:"auto",width:"auto",height:"auto",opacity:true,src:"javascript:false;"},s||{});var prop=function(n){return n&&n.constructor==Number?n+"px":n},html='<iframe class="bgiframe"frameborder="0"tabindex="-1"src="'+s.src+'"style="display:block;position:absolute;z-index:-1;'+(s.opacity!==false?"filter:Alpha(Opacity='0');":"")+"top:"+(s.top=="auto"?"expression(((parseInt(this.parentNode.currentStyle.borderTopWidth)||0)*-1)+'px')":prop(s.top))+";left:"+(s.left=="auto"?"expression(((parseInt(this.parentNode.currentStyle.borderLeftWidth)||0)*-1)+'px')":prop(s.left))+";width:"+(s.width=="auto"?"expression(this.parentNode.offsetWidth+'px')":prop(s.width))+";height:"+(s.height=="auto"?"expression(this.parentNode.offsetHeight+'px')":prop(s.height))+';"/>';return this.each(function(){if($("> iframe.bgiframe",this).length==0){this.insertBefore(document.createElement(html),this.firstChild)}})}return this};if(!$.browser.version){$.browser.version=navigator.userAgent.toLowerCase().match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)[1]}})(jQuery);(function($){var setDataSwitch={dragStart:"start.draggable",drag:"drag.draggable",dragStop:"stop.draggable",maxHeight:"maxHeight.resizable",minHeight:"minHeight.resizable",maxWidth:"maxWidth.resizable",minWidth:"minWidth.resizable",resizeStart:"start.resizable",resize:"drag.resizable",resizeStop:"stop.resizable"},uiDialogClasses="ui-dialog ui-widget ui-widget-content ui-corner-all ";$.widget("ui.dialog",{_init:function(){this.originalTitle=this.element.attr("title");var self=this,options=this.options,title=options.title||this.originalTitle||"&nbsp;",titleId=$.ui.dialog.getTitleId(this.element),uiDialog=(this.uiDialog=$("<div/>")).appendTo(document.body).hide().addClass(uiDialogClasses+options.dialogClass).css({position:"absolute",overflow:"hidden",zIndex:options.zIndex}).attr("tabIndex",-1).css("outline",0).keydown(function(event){(options.closeOnEscape&&event.keyCode&&event.keyCode==$.ui.keyCode.ESCAPE&&self.close(event))}).attr({role:"dialog","aria-labelledby":titleId}).mousedown(function(event){self.moveToTop(false,event)}),uiDialogContent=this.element.show().removeAttr("title").addClass("ui-dialog-content ui-widget-content").appendTo(uiDialog),uiDialogTitlebar=(this.uiDialogTitlebar=$("<div></div>")).addClass("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix").prependTo(uiDialog),uiDialogTitlebarClose=$('<a href="#"/>').addClass("ui-dialog-titlebar-close ui-corner-all").attr("role","button").hover(function(){uiDialogTitlebarClose.addClass("ui-state-hover")},function(){uiDialogTitlebarClose.removeClass("ui-state-hover")}).focus(function(){uiDialogTitlebarClose.addClass("ui-state-focus")}).blur(function(){uiDialogTitlebarClose.removeClass("ui-state-focus")}).mousedown(function(ev){ev.stopPropagation()}).click(function(event){self.close(event);return false}).appendTo(uiDialogTitlebar),uiDialogTitlebarCloseText=(this.uiDialogTitlebarCloseText=$("<span/>")).addClass("ui-icon ui-icon-closethick").text(options.closeText).appendTo(uiDialogTitlebarClose),uiDialogTitle=$("<span/>").addClass("ui-dialog-title").attr("id",titleId).html(title).prependTo(uiDialogTitlebar);uiDialogTitlebar.find("*").add(uiDialogTitlebar).disableSelection();(options.draggable&&$.fn.draggable&&this._makeDraggable());(options.resizable&&$.fn.resizable&&this._makeResizable());this._createButtons(options.buttons);this._isOpen=false;(options.bgiframe&&$.fn.bgiframe&&uiDialog.bgiframe());(options.autoOpen&&this.open())},destroy:function(){(this.overlay&&this.overlay.destroy());this.uiDialog.hide();this.element.unbind(".dialog").removeData("dialog").removeClass("ui-dialog-content ui-widget-content").hide().appendTo("body");this.uiDialog.remove();(this.originalTitle&&this.element.attr("title",this.originalTitle))},close:function(event){var self=this;if(false===self._trigger("beforeclose",event)){return }(self.overlay&&self.overlay.destroy());self.uiDialog.unbind("keypress.ui-dialog");(self.options.hide?self.uiDialog.hide(self.options.hide,function(){self._trigger("close",event)}):self.uiDialog.hide()&&self._trigger("close",event));$.ui.dialog.overlay.resize();self._isOpen=false},isOpen:function(){return this._isOpen},moveToTop:function(force,event){if((this.options.modal&&!force)||(!this.options.stack&&!this.options.modal)){return this._trigger("focus",event)}if(this.options.zIndex>$.ui.dialog.maxZ){$.ui.dialog.maxZ=this.options.zIndex}(this.overlay&&this.overlay.$el.css("z-index",$.ui.dialog.overlay.maxZ=++$.ui.dialog.maxZ));var saveScroll={scrollTop:this.element.attr("scrollTop"),scrollLeft:this.element.attr("scrollLeft")};this.uiDialog.css("z-index",++$.ui.dialog.maxZ);this.element.attr(saveScroll);this._trigger("focus",event)},open:function(){if(this._isOpen){return }var options=this.options,uiDialog=this.uiDialog;this.overlay=options.modal?new $.ui.dialog.overlay(this):null;(uiDialog.next().length&&uiDialog.appendTo("body"));this._size();this._position(options.position);uiDialog.show(options.show);this.moveToTop(true);(options.modal&&uiDialog.bind("keypress.ui-dialog",function(event){if(event.keyCode!=$.ui.keyCode.TAB){return }var tabbables=$(":tabbable",this),first=tabbables.filter(":first")[0],last=tabbables.filter(":last")[0];if(event.target==last&&!event.shiftKey){setTimeout(function(){first.focus()},1)}else{if(event.target==first&&event.shiftKey){setTimeout(function(){last.focus()},1)}}}));$([]).add(uiDialog.find(".ui-dialog-content :tabbable:first")).add(uiDialog.find(".ui-dialog-buttonpane :tabbable:first")).add(uiDialog).filter(":first").focus();this._trigger("open");this._isOpen=true},_createButtons:function(buttons){var self=this,hasButtons=false,uiDialogButtonPane=$("<div></div>").addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix");this.uiDialog.find(".ui-dialog-buttonpane").remove();(typeof buttons=="object"&&buttons!==null&&$.each(buttons,function(){return !(hasButtons=true)}));if(hasButtons){$.each(buttons,function(name,fn){$('<button type="button"></button>').addClass("ui-state-default ui-corner-all").text(name).click(function(){fn.apply(self.element[0],arguments)}).hover(function(){$(this).addClass("ui-state-hover")},function(){$(this).removeClass("ui-state-hover")}).focus(function(){$(this).addClass("ui-state-focus")}).blur(function(){$(this).removeClass("ui-state-focus")}).appendTo(uiDialogButtonPane)});uiDialogButtonPane.appendTo(this.uiDialog)}},_makeDraggable:function(){var self=this,options=this.options,heightBeforeDrag;this.uiDialog.draggable({cancel:".ui-dialog-content",handle:".ui-dialog-titlebar",containment:"document",start:function(){heightBeforeDrag=options.height;$(this).height($(this).height()).addClass("ui-dialog-dragging");(options.dragStart&&options.dragStart.apply(self.element[0],arguments))},drag:function(){(options.drag&&options.drag.apply(self.element[0],arguments))},stop:function(){$(this).removeClass("ui-dialog-dragging").height(heightBeforeDrag);(options.dragStop&&options.dragStop.apply(self.element[0],arguments));$.ui.dialog.overlay.resize()}})},_makeResizable:function(handles){handles=(handles===undefined?this.options.resizable:handles);var self=this,options=this.options,resizeHandles=typeof handles=="string"?handles:"n,e,s,w,se,sw,ne,nw";this.uiDialog.resizable({cancel:".ui-dialog-content",alsoResize:this.element,maxWidth:options.maxWidth,maxHeight:options.maxHeight,minWidth:options.minWidth,minHeight:options.minHeight,start:function(){$(this).addClass("ui-dialog-resizing");(options.resizeStart&&options.resizeStart.apply(self.element[0],arguments))},resize:function(){(options.resize&&options.resize.apply(self.element[0],arguments))},handles:resizeHandles,stop:function(){$(this).removeClass("ui-dialog-resizing");options.height=$(this).height();options.width=$(this).width();(options.resizeStop&&options.resizeStop.apply(self.element[0],arguments));$.ui.dialog.overlay.resize()}}).find(".ui-resizable-se").addClass("ui-icon ui-icon-grip-diagonal-se")},_position:function(pos){var wnd=$(window),doc=$(document),pTop=doc.scrollTop(),pLeft=doc.scrollLeft(),minTop=pTop;if($.inArray(pos,["center","top","right","bottom","left"])>=0){pos=[pos=="right"||pos=="left"?pos:"center",pos=="top"||pos=="bottom"?pos:"middle"]}if(pos.constructor!=Array){pos=["center","middle"]}if(pos[0].constructor==Number){pLeft+=pos[0]}else{switch(pos[0]){case"left":pLeft+=0;break;case"right":pLeft+=wnd.width()-this.uiDialog.outerWidth();break;default:case"center":pLeft+=(wnd.width()-this.uiDialog.outerWidth())/2}}if(pos[1].constructor==Number){pTop+=pos[1]}else{switch(pos[1]){case"top":pTop+=0;break;case"bottom":pTop+=wnd.height()-this.uiDialog.outerHeight();break;default:case"middle":pTop+=(wnd.height()-this.uiDialog.outerHeight())/2}}pTop=Math.max(pTop,minTop);this.uiDialog.css({top:pTop,left:pLeft})},_setData:function(key,value){(setDataSwitch[key]&&this.uiDialog.data(setDataSwitch[key],value));switch(key){case"buttons":this._createButtons(value);break;case"closeText":this.uiDialogTitlebarCloseText.text(value);break;case"dialogClass":this.uiDialog.removeClass(this.options.dialogClass).addClass(uiDialogClasses+value);break;case"draggable":(value?this._makeDraggable():this.uiDialog.draggable("destroy"));break;case"height":this.uiDialog.height(value);break;case"position":this._position(value);break;case"resizable":var uiDialog=this.uiDialog,isResizable=this.uiDialog.is(":data(resizable)");(isResizable&&!value&&uiDialog.resizable("destroy"));(isResizable&&typeof value=="string"&&uiDialog.resizable("option","handles",value));(isResizable||this._makeResizable(value));break;case"title":$(".ui-dialog-title",this.uiDialogTitlebar).html(value||"&nbsp;");break;case"width":this.uiDialog.width(value);break}$.widget.prototype._setData.apply(this,arguments)},_size:function(){var options=this.options;this.element.css({height:0,minHeight:0,width:"auto"});var nonContentHeight=this.uiDialog.css({height:"auto",width:options.width}).height();this.element.css({minHeight:Math.max(options.minHeight-nonContentHeight,0),height:options.height=="auto"?"auto":Math.max(options.height-nonContentHeight,0)})}});$.extend($.ui.dialog,{version:"1.7",defaults:{autoOpen:true,bgiframe:false,buttons:{},closeOnEscape:true,closeText:"close",dialogClass:"",draggable:true,hide:null,height:"auto",maxHeight:false,maxWidth:false,minHeight:150,minWidth:150,modal:false,position:"center",resizable:true,show:null,stack:true,title:"",width:300,zIndex:1000},getter:"isOpen",uuid:0,maxZ:0,getTitleId:function($el){return"ui-dialog-title-"+($el.attr("id")||++this.uuid)},overlay:function(dialog){this.$el=$.ui.dialog.overlay.create(dialog)}});$.extend($.ui.dialog.overlay,{instances:[],maxZ:0,events:$.map("focus,mousedown,mouseup,keydown,keypress,click".split(","),function(event){return event+".dialog-overlay"}).join(" "),create:function(dialog){if(this.instances.length===0){setTimeout(function(){$(document).bind($.ui.dialog.overlay.events,function(event){var dialogZ=$(event.target).parents(".ui-dialog").css("zIndex")||0;return(dialogZ>$.ui.dialog.overlay.maxZ)})},1);$(document).bind("keydown.dialog-overlay",function(event){(dialog.options.closeOnEscape&&event.keyCode&&event.keyCode==$.ui.keyCode.ESCAPE&&dialog.close(event))});$(window).bind("resize.dialog-overlay",$.ui.dialog.overlay.resize)}var $el=$("<div></div>").appendTo(document.body).addClass("ui-widget-overlay").css({width:this.width(),height:this.height()});(dialog.options.bgiframe&&$.fn.bgiframe&&$el.bgiframe());this.instances.push($el);return $el},destroy:function($el){this.instances.splice($.inArray(this.instances,$el),1);if(this.instances.length===0){$([document,window]).unbind(".dialog-overlay")}$el.remove()},height:function(){if($.browser.msie&&$.browser.version<7){var scrollHeight=Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);var offsetHeight=Math.max(document.documentElement.offsetHeight,document.body.offsetHeight);if(scrollHeight<offsetHeight){return $(window).height()+"px"}else{return scrollHeight+"px"}}else{return $(document).height()+"px"}},width:function(){if($.browser.msie&&$.browser.version<7){var scrollWidth=Math.max(document.documentElement.scrollWidth,document.body.scrollWidth);var offsetWidth=Math.max(document.documentElement.offsetWidth,document.body.offsetWidth);if(scrollWidth<offsetWidth){return $(window).width()+"px"}else{return scrollWidth+"px"}}else{return $(document).width()+"px"}},resize:function(){var $overlays=$([]);$.each($.ui.dialog.overlay.instances,function(){$overlays=$overlays.add(this)});$overlays.css({width:0,height:0}).css({width:$.ui.dialog.overlay.width(),height:$.ui.dialog.overlay.height()})}});$.extend($.ui.dialog.overlay.prototype,{destroy:function(){$.ui.dialog.overlay.destroy(this.$el)}})})(jQuery);(function($){$.widget("ui.draggable",$.extend({},$.ui.mouse,{_init:function(){if(this.options.helper=="original"&&!(/^(?:r|a|f)/).test(this.element.css("position"))){this.element[0].style.position="relative"}(this.options.addClasses&&this.element.addClass("ui-draggable"));(this.options.disabled&&this.element.addClass("ui-draggable-disabled"));this._mouseInit()},destroy:function(){if(!this.element.data("draggable")){return }this.element.removeData("draggable").unbind(".draggable").removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled");this._mouseDestroy()},_mouseCapture:function(event){var o=this.options;if(this.helper||o.disabled||$(event.target).is(".ui-resizable-handle")){return false}this.handle=this._getHandle(event);if(!this.handle){return false}return true},_mouseStart:function(event){var o=this.options;this.helper=this._createHelper(event);this._cacheHelperProportions();if($.ui.ddmanager){$.ui.ddmanager.current=this}this._cacheMargins();this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent();this.offset=this.element.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};$.extend(this.offset,{click:{left:event.pageX-this.offset.left,top:event.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.originalPosition=this._generatePosition(event);this.originalPageX=event.pageX;this.originalPageY=event.pageY;if(o.cursorAt){this._adjustOffsetFromHelper(o.cursorAt)}if(o.containment){this._setContainment()}this._trigger("start",event);this._cacheHelperProportions();if($.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(this,event)}this.helper.addClass("ui-draggable-dragging");this._mouseDrag(event,true);return true},_mouseDrag:function(event,noPropagation){this.position=this._generatePosition(event);this.positionAbs=this._convertPositionTo("absolute");if(!noPropagation){var ui=this._uiHash();this._trigger("drag",event,ui);this.position=ui.position}if(!this.options.axis||this.options.axis!="y"){this.helper[0].style.left=this.position.left+"px"}if(!this.options.axis||this.options.axis!="x"){this.helper[0].style.top=this.position.top+"px"}if($.ui.ddmanager){$.ui.ddmanager.drag(this,event)}return false},_mouseStop:function(event){var dropped=false;if($.ui.ddmanager&&!this.options.dropBehaviour){dropped=$.ui.ddmanager.drop(this,event)}if(this.dropped){dropped=this.dropped;this.dropped=false}if((this.options.revert=="invalid"&&!dropped)||(this.options.revert=="valid"&&dropped)||this.options.revert===true||($.isFunction(this.options.revert)&&this.options.revert.call(this.element,dropped))){var self=this;$(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){self._trigger("stop",event);self._clear()})}else{this._trigger("stop",event);this._clear()}return false},_getHandle:function(event){var handle=!this.options.handle||!$(this.options.handle,this.element).length?true:false;$(this.options.handle,this.element).find("*").andSelf().each(function(){if(this==event.target){handle=true}});return handle},_createHelper:function(event){var o=this.options;var helper=$.isFunction(o.helper)?$(o.helper.apply(this.element[0],[event])):(o.helper=="clone"?this.element.clone():this.element);if(!helper.parents("body").length){helper.appendTo((o.appendTo=="parent"?this.element[0].parentNode:o.appendTo))}if(helper[0]!=this.element[0]&&!(/(fixed|absolute)/).test(helper.css("position"))){helper.css("position","absolute")}return helper},_adjustOffsetFromHelper:function(obj){if(obj.left!=undefined){this.offset.click.left=obj.left+this.margins.left}if(obj.right!=undefined){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left}if(obj.top!=undefined){this.offset.click.top=obj.top+this.margins.top}if(obj.bottom!=undefined){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();if(this.cssPosition=="absolute"&&this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop()}if((this.offsetParent[0]==document.body)||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()=="html"&&$.browser.msie)){po={top:0,left:0}}return{top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition=="relative"){var p=this.element.position();return{top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}else{return{top:0,left:0}}},_cacheMargins:function(){this.margins={left:(parseInt(this.element.css("marginLeft"),10)||0),top:(parseInt(this.element.css("marginTop"),10)||0)}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var o=this.options;if(o.containment=="parent"){o.containment=this.helper[0].parentNode}if(o.containment=="document"||o.containment=="window"){this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,$(o.containment=="document"?document:window).width()-this.helperProportions.width-this.margins.left,($(o.containment=="document"?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]}if(!(/^(document|window|parent)$/).test(o.containment)&&o.containment.constructor!=Array){var ce=$(o.containment)[0];if(!ce){return }var co=$(o.containment).offset();var over=($(ce).css("overflow")!="hidden");this.containment=[co.left+(parseInt($(ce).css("borderLeftWidth"),10)||0)+(parseInt($(ce).css("paddingLeft"),10)||0)-this.margins.left,co.top+(parseInt($(ce).css("borderTopWidth"),10)||0)+(parseInt($(ce).css("paddingTop"),10)||0)-this.margins.top,co.left+(over?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-(parseInt($(ce).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,co.top+(over?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-(parseInt($(ce).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top]}else{if(o.containment.constructor==Array){this.containment=o.containment}}},_convertPositionTo:function(d,pos){if(!pos){pos=this.position}var mod=d=="absolute"?1:-1;var o=this.options,scroll=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);return{top:(pos.top+this.offset.relative.top*mod+this.offset.parent.top*mod-($.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop()))*mod)),left:(pos.left+this.offset.relative.left*mod+this.offset.parent.left*mod-($.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())*mod))}},_generatePosition:function(event){var o=this.options,scroll=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&$.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);if(this.cssPosition=="relative"&&!(this.scrollParent[0]!=document&&this.scrollParent[0]!=this.offsetParent[0])){this.offset.relative=this._getRelativeOffset()}var pageX=event.pageX;var pageY=event.pageY;if(this.originalPosition){if(this.containment){if(event.pageX-this.offset.click.left<this.containment[0]){pageX=this.containment[0]+this.offset.click.left}if(event.pageY-this.offset.click.top<this.containment[1]){pageY=this.containment[1]+this.offset.click.top}if(event.pageX-this.offset.click.left>this.containment[2]){pageX=this.containment[2]+this.offset.click.left}if(event.pageY-this.offset.click.top>this.containment[3]){pageY=this.containment[3]+this.offset.click.top}}if(o.grid){var top=this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1];pageY=this.containment?(!(top-this.offset.click.top<this.containment[1]||top-this.offset.click.top>this.containment[3])?top:(!(top-this.offset.click.top<this.containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0];pageX=this.containment?(!(left-this.offset.click.left<this.containment[0]||left-this.offset.click.left>this.containment[2])?left:(!(left-this.offset.click.left<this.containment[0])?left-o.grid[0]:left+o.grid[0])):left}}return{top:(pageY-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+($.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop())))),left:(pageX-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+($.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())))}},_clear:function(){this.helper.removeClass("ui-draggable-dragging");if(this.helper[0]!=this.element[0]&&!this.cancelHelperRemoval){this.helper.remove()}this.helper=null;this.cancelHelperRemoval=false},_trigger:function(type,event,ui){ui=ui||this._uiHash();$.ui.plugin.call(this,type,[event,ui]);if(type=="drag"){this.positionAbs=this._convertPositionTo("absolute")}return $.widget.prototype._trigger.call(this,type,event,ui)},plugins:{},_uiHash:function(event){return{helper:this.helper,position:this.position,absolutePosition:this.positionAbs,offset:this.positionAbs}}}));$.extend($.ui.draggable,{version:"1.7",eventPrefix:"drag",defaults:{addClasses:true,appendTo:"parent",axis:false,cancel:":input,option",connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,delay:0,distance:1,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false}});$.ui.plugin.add("draggable","connectToSortable",{start:function(event,ui){var inst=$(this).data("draggable"),o=inst.options,uiSortable=$.extend({},ui,{item:inst.element});inst.sortables=[];$(o.connectToSortable).each(function(){var sortable=$.data(this,"sortable");if(sortable&&!sortable.options.disabled){inst.sortables.push({instance:sortable,shouldRevert:sortable.options.revert});sortable._refreshItems();sortable._trigger("activate",event,uiSortable)}})},stop:function(event,ui){var inst=$(this).data("draggable"),uiSortable=$.extend({},ui,{item:inst.element});$.each(inst.sortables,function(){if(this.instance.isOver){this.instance.isOver=0;inst.cancelHelperRemoval=true;this.instance.cancelHelperRemoval=false;if(this.shouldRevert){this.instance.options.revert=true}this.instance._mouseStop(event);this.instance.options.helper=this.instance.options._helper;if(inst.options.helper=="original"){this.instance.currentItem.css({top:"auto",left:"auto"})}}else{this.instance.cancelHelperRemoval=false;this.instance._trigger("deactivate",event,uiSortable)}})},drag:function(event,ui){var inst=$(this).data("draggable"),self=this;var checkPos=function(o){var dyClick=this.offset.click.top,dxClick=this.offset.click.left;var helperTop=this.positionAbs.top,helperLeft=this.positionAbs.left;var itemHeight=o.height,itemWidth=o.width;var itemTop=o.top,itemLeft=o.left;return $.ui.isOver(helperTop+dyClick,helperLeft+dxClick,itemTop,itemLeft,itemHeight,itemWidth)};$.each(inst.sortables,function(i){this.instance.positionAbs=inst.positionAbs;this.instance.helperProportions=inst.helperProportions;this.instance.offset.click=inst.offset.click;if(this.instance._intersectsWith(this.instance.containerCache)){if(!this.instance.isOver){this.instance.isOver=1;this.instance.currentItem=$(self).clone().appendTo(this.instance.element).data("sortable-item",true);this.instance.options._helper=this.instance.options.helper;this.instance.options.helper=function(){return ui.helper[0]};event.target=this.instance.currentItem[0];this.instance._mouseCapture(event,true);this.instance._mouseStart(event,true,true);this.instance.offset.click.top=inst.offset.click.top;this.instance.offset.click.left=inst.offset.click.left;this.instance.offset.parent.left-=inst.offset.parent.left-this.instance.offset.parent.left;this.instance.offset.parent.top-=inst.offset.parent.top-this.instance.offset.parent.top;inst._trigger("toSortable",event);inst.dropped=this.instance.element;inst.currentItem=inst.element;this.instance.fromOutside=inst}if(this.instance.currentItem){this.instance._mouseDrag(event)}}else{if(this.instance.isOver){this.instance.isOver=0;this.instance.cancelHelperRemoval=true;this.instance.options.revert=false;this.instance._trigger("out",event,this.instance._uiHash(this.instance));this.instance._mouseStop(event,true);this.instance.options.helper=this.instance.options._helper;this.instance.currentItem.remove();if(this.instance.placeholder){this.instance.placeholder.remove()}inst._trigger("fromSortable",event);inst.dropped=false}}})}});$.ui.plugin.add("draggable","cursor",{start:function(event,ui){var t=$("body"),o=$(this).data("draggable").options;if(t.css("cursor")){o._cursor=t.css("cursor")}t.css("cursor",o.cursor)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._cursor){$("body").css("cursor",o._cursor)}}});$.ui.plugin.add("draggable","iframeFix",{start:function(event,ui){var o=$(this).data("draggable").options;$(o.iframeFix===true?"iframe":o.iframeFix).each(function(){$('<div class="ui-draggable-iframeFix" style="background: #fff;"></div>').css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1000}).css($(this).offset()).appendTo("body")})},stop:function(event,ui){$("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this)})}});$.ui.plugin.add("draggable","opacity",{start:function(event,ui){var t=$(ui.helper),o=$(this).data("draggable").options;if(t.css("opacity")){o._opacity=t.css("opacity")}t.css("opacity",o.opacity)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._opacity){$(ui.helper).css("opacity",o._opacity)}}});$.ui.plugin.add("draggable","scroll",{start:function(event,ui){var i=$(this).data("draggable");if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!="HTML"){i.overflowOffset=i.scrollParent.offset()}},drag:function(event,ui){var i=$(this).data("draggable"),o=i.options,scrolled=false;if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!="HTML"){if(!o.axis||o.axis!="x"){if((i.overflowOffset.top+i.scrollParent[0].offsetHeight)-event.pageY<o.scrollSensitivity){i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop+o.scrollSpeed}else{if(event.pageY-i.overflowOffset.top<o.scrollSensitivity){i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop-o.scrollSpeed}}}if(!o.axis||o.axis!="y"){if((i.overflowOffset.left+i.scrollParent[0].offsetWidth)-event.pageX<o.scrollSensitivity){i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft+o.scrollSpeed}else{if(event.pageX-i.overflowOffset.left<o.scrollSensitivity){i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft-o.scrollSpeed}}}}else{if(!o.axis||o.axis!="x"){if(event.pageY-$(document).scrollTop()<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()-o.scrollSpeed)}else{if($(window).height()-(event.pageY-$(document).scrollTop())<o.scrollSensitivity){scrolled=$(document).scrollTop($(document).scrollTop()+o.scrollSpeed)}}}if(!o.axis||o.axis!="y"){if(event.pageX-$(document).scrollLeft()<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed)}else{if($(window).width()-(event.pageX-$(document).scrollLeft())<o.scrollSensitivity){scrolled=$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed)}}}}if(scrolled!==false&&$.ui.ddmanager&&!o.dropBehaviour){$.ui.ddmanager.prepareOffsets(i,event)}}});$.ui.plugin.add("draggable","snap",{start:function(event,ui){var i=$(this).data("draggable"),o=i.options;i.snapElements=[];$(o.snap.constructor!=String?(o.snap.items||":data(draggable)"):o.snap).each(function(){var $t=$(this);var $o=$t.offset();if(this!=i.element[0]){i.snapElements.push({item:this,width:$t.outerWidth(),height:$t.outerHeight(),top:$o.top,left:$o.left})}})},drag:function(event,ui){var inst=$(this).data("draggable"),o=inst.options;var d=o.snapTolerance;var x1=ui.offset.left,x2=x1+inst.helperProportions.width,y1=ui.offset.top,y2=y1+inst.helperProportions.height;for(var i=inst.snapElements.length-1;i>=0;i--){var l=inst.snapElements[i].left,r=l+inst.snapElements[i].width,t=inst.snapElements[i].top,b=t+inst.snapElements[i].height;if(!((l-d<x1&&x1<r+d&&t-d<y1&&y1<b+d)||(l-d<x1&&x1<r+d&&t-d<y2&&y2<b+d)||(l-d<x2&&x2<r+d&&t-d<y1&&y1<b+d)||(l-d<x2&&x2<r+d&&t-d<y2&&y2<b+d))){if(inst.snapElements[i].snapping){(inst.options.snap.release&&inst.options.snap.release.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})))}inst.snapElements[i].snapping=false;continue}if(o.snapMode!="inner"){var ts=Math.abs(t-y2)<=d;var bs=Math.abs(b-y1)<=d;var ls=Math.abs(l-x2)<=d;var rs=Math.abs(r-x1)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t-inst.helperProportions.height,left:0}).top-inst.margins.top}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b,left:0}).top-inst.margins.top}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l-inst.helperProportions.width}).left-inst.margins.left}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r}).left-inst.margins.left}}var first=(ts||bs||ls||rs);if(o.snapMode!="outer"){var ts=Math.abs(t-y1)<=d;var bs=Math.abs(b-y2)<=d;var ls=Math.abs(l-x1)<=d;var rs=Math.abs(r-x2)<=d;if(ts){ui.position.top=inst._convertPositionTo("relative",{top:t,left:0}).top-inst.margins.top}if(bs){ui.position.top=inst._convertPositionTo("relative",{top:b-inst.helperProportions.height,left:0}).top-inst.margins.top}if(ls){ui.position.left=inst._convertPositionTo("relative",{top:0,left:l}).left-inst.margins.left}if(rs){ui.position.left=inst._convertPositionTo("relative",{top:0,left:r-inst.helperProportions.width}).left-inst.margins.left}}if(!inst.snapElements[i].snapping&&(ts||bs||ls||rs||first)){(inst.options.snap.snap&&inst.options.snap.snap.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})))}inst.snapElements[i].snapping=(ts||bs||ls||rs||first)}}});$.ui.plugin.add("draggable","stack",{start:function(event,ui){var o=$(this).data("draggable").options;var group=$.makeArray($(o.stack.group)).sort(function(a,b){return(parseInt($(a).css("zIndex"),10)||o.stack.min)-(parseInt($(b).css("zIndex"),10)||o.stack.min)});$(group).each(function(i){this.style.zIndex=o.stack.min+i});this[0].style.zIndex=o.stack.min+group.length}});$.ui.plugin.add("draggable","zIndex",{start:function(event,ui){var t=$(ui.helper),o=$(this).data("draggable").options;if(t.css("zIndex")){o._zIndex=t.css("zIndex")}t.css("zIndex",o.zIndex)},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._zIndex){$(ui.helper).css("zIndex",o._zIndex)}}})})(jQuery);(function($){$.widget("ui.accordion",{_init:function(){var o=this.options,self=this;this.running=0;if(o.collapsible==$.ui.accordion.defaults.collapsible&&o.alwaysOpen!=$.ui.accordion.defaults.alwaysOpen){o.collapsible=!o.alwaysOpen}if(o.navigation){var current=this.element.find("a").filter(o.navigationFilter);if(current.length){if(current.filter(o.header).length){this.active=current}else{this.active=current.parent().parent().prev();current.addClass("ui-accordion-content-active")}}}this.element.addClass("ui-accordion ui-widget ui-helper-reset");if(this.element[0].nodeName=="UL"){this.element.children("li").addClass("ui-accordion-li-fix")}this.headers=this.element.find(o.header).addClass("ui-accordion-header ui-helper-reset ui-state-default ui-corner-all").bind("mouseenter.accordion",function(){$(this).addClass("ui-state-hover")}).bind("mouseleave.accordion",function(){$(this).removeClass("ui-state-hover")}).bind("focus.accordion",function(){$(this).addClass("ui-state-focus")}).bind("blur.accordion",function(){$(this).removeClass("ui-state-focus")});this.headers.next().addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom");this.active=this._findActive(this.active||o.active).toggleClass("ui-state-default").toggleClass("ui-state-active").toggleClass("ui-corner-all").toggleClass("ui-corner-top");this.active.next().addClass("ui-accordion-content-active");$("<span/>").addClass("ui-icon "+o.icons.header).prependTo(this.headers);this.active.find(".ui-icon").toggleClass(o.icons.header).toggleClass(o.icons.headerSelected);if($.browser.msie){this.element.find("a").css("zoom","1")}this.resize();this.element.attr("role","tablist");this.headers.attr("role","tab").bind("keydown",function(event){return self._keydown(event)}).next().attr("role","tabpanel");this.headers.not(this.active||"").attr("aria-expanded","false").attr("tabIndex","-1").next().hide();if(!this.active.length){this.headers.eq(0).attr("tabIndex","0")}else{this.active.attr("aria-expanded","true").attr("tabIndex","0")}if(!$.browser.safari){this.headers.find("a").attr("tabIndex","-1")}if(o.event){this.headers.bind((o.event)+".accordion",function(event){return self._clickHandler.call(self,event,this)})}},destroy:function(){var o=this.options;this.element.removeClass("ui-accordion ui-widget ui-helper-reset").removeAttr("role").unbind(".accordion").removeData("accordion");this.headers.unbind(".accordion").removeClass("ui-accordion-header ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-corner-top").removeAttr("role").removeAttr("aria-expanded").removeAttr("tabindex");this.headers.find("a").removeAttr("tabindex");this.headers.children(".ui-icon").remove();var contents=this.headers.next().css("display","").removeAttr("role").removeClass("ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active");if(o.autoHeight||o.fillHeight){contents.css("height","")}},_setData:function(key,value){if(key=="alwaysOpen"){key="collapsible";value=!value}$.widget.prototype._setData.apply(this,arguments)},_keydown:function(event){var o=this.options,keyCode=$.ui.keyCode;if(o.disabled||event.altKey||event.ctrlKey){return }var length=this.headers.length;var currentIndex=this.headers.index(event.target);var toFocus=false;switch(event.keyCode){case keyCode.RIGHT:case keyCode.DOWN:toFocus=this.headers[(currentIndex+1)%length];break;case keyCode.LEFT:case keyCode.UP:toFocus=this.headers[(currentIndex-1+length)%length];break;case keyCode.SPACE:case keyCode.ENTER:return this._clickHandler({target:event.target},event.target)}if(toFocus){$(event.target).attr("tabIndex","-1");$(toFocus).attr("tabIndex","0");toFocus.focus();return false}return true},resize:function(){var o=this.options,maxHeight;if(o.fillSpace){if($.browser.msie){var defOverflow=this.element.parent().css("overflow");this.element.parent().css("overflow","hidden")}maxHeight=this.element.parent().height();if($.browser.msie){this.element.parent().css("overflow",defOverflow)}this.headers.each(function(){maxHeight-=$(this).outerHeight()});var maxPadding=0;this.headers.next().each(function(){maxPadding=Math.max(maxPadding,$(this).innerHeight()-$(this).height())}).height(Math.max(0,maxHeight-maxPadding)).css("overflow","auto")}else{if(o.autoHeight){maxHeight=0;this.headers.next().each(function(){maxHeight=Math.max(maxHeight,$(this).outerHeight())}).height(maxHeight)}}},activate:function(index){var active=this._findActive(index)[0];this._clickHandler({target:active},active)},_findActive:function(selector){return selector?typeof selector=="number"?this.headers.filter(":eq("+selector+")"):this.headers.not(this.headers.not(selector)):selector===false?$([]):this.headers.filter(":eq(0)")},_clickHandler:function(event,target){var o=this.options;if(o.disabled){return false}if(!event.target&&o.collapsible){this.active.removeClass("ui-state-active ui-corner-top").addClass("ui-state-default ui-corner-all").find(".ui-icon").removeClass(o.icons.headerSelected).addClass(o.icons.header);this.active.next().addClass("ui-accordion-content-active");var toHide=this.active.next(),data={options:o,newHeader:$([]),oldHeader:o.active,newContent:$([]),oldContent:toHide},toShow=(this.active=$([]));this._toggle(toShow,toHide,data);return false}var clicked=$(event.currentTarget||target);var clickedIsActive=clicked[0]==this.active[0];if(this.running||(!o.collapsible&&clickedIsActive)){return false}this.active.removeClass("ui-state-active ui-corner-top").addClass("ui-state-default ui-corner-all").find(".ui-icon").removeClass(o.icons.headerSelected).addClass(o.icons.header);this.active.next().addClass("ui-accordion-content-active");if(!clickedIsActive){clicked.removeClass("ui-state-default ui-corner-all").addClass("ui-state-active ui-corner-top").find(".ui-icon").removeClass(o.icons.header).addClass(o.icons.headerSelected);clicked.next().addClass("ui-accordion-content-active")}var toShow=clicked.next(),toHide=this.active.next(),data={options:o,newHeader:clickedIsActive&&o.collapsible?$([]):clicked,oldHeader:this.active,newContent:clickedIsActive&&o.collapsible?$([]):toShow.find("> *"),oldContent:toHide.find("> *")},down=this.headers.index(this.active[0])>this.headers.index(clicked[0]);this.active=clickedIsActive?$([]):clicked;this._toggle(toShow,toHide,data,clickedIsActive,down);return false},_toggle:function(toShow,toHide,data,clickedIsActive,down){var o=this.options,self=this;this.toShow=toShow;this.toHide=toHide;this.data=data;var complete=function(){if(!self){return }return self._completed.apply(self,arguments)};this._trigger("changestart",null,this.data);this.running=toHide.size()===0?toShow.size():toHide.size();if(o.animated){var animOptions={};if(o.collapsible&&clickedIsActive){animOptions={toShow:$([]),toHide:toHide,complete:complete,down:down,autoHeight:o.autoHeight||o.fillSpace}}else{animOptions={toShow:toShow,toHide:toHide,complete:complete,down:down,autoHeight:o.autoHeight||o.fillSpace}}if(!o.proxied){o.proxied=o.animated}if(!o.proxiedDuration){o.proxiedDuration=o.duration}o.animated=$.isFunction(o.proxied)?o.proxied(animOptions):o.proxied;o.duration=$.isFunction(o.proxiedDuration)?o.proxiedDuration(animOptions):o.proxiedDuration;var animations=$.ui.accordion.animations,duration=o.duration,easing=o.animated;if(!animations[easing]){animations[easing]=function(options){this.slide(options,{easing:easing,duration:duration||700})}}animations[easing](animOptions)}else{if(o.collapsible&&clickedIsActive){toShow.toggle()}else{toHide.hide();toShow.show()}complete(true)}toHide.prev().attr("aria-expanded","false").attr("tabIndex","-1").blur();toShow.prev().attr("aria-expanded","true").attr("tabIndex","0").focus()},_completed:function(cancel){var o=this.options;this.running=cancel?0:--this.running;if(this.running){return }if(o.clearStyle){this.toShow.add(this.toHide).css({height:"",overflow:""})}this._trigger("change",null,this.data)}});$.extend($.ui.accordion,{version:"1.7",defaults:{active:null,alwaysOpen:true,animated:"slide",autoHeight:true,clearStyle:false,collapsible:false,event:"click",fillSpace:false,header:"> li > :first-child,> :not(li):even",icons:{header:"ui-icon-triangle-1-e",headerSelected:"ui-icon-triangle-1-s"},navigation:false,navigationFilter:function(){return this.href.toLowerCase()==location.href.toLowerCase()}},animations:{slide:function(options,additions){options=$.extend({easing:"swing",duration:300},options,additions);if(!options.toHide.size()){options.toShow.animate({height:"show"},options);return }if(!options.toShow.size()){options.toHide.animate({height:"hide"},options);return }var overflow=options.toShow.css("overflow"),percentDone,showProps={},hideProps={},fxAttrs=["height","paddingTop","paddingBottom"],originalWidth;var s=options.toShow;originalWidth=s[0].style.width;s.width(parseInt(s.parent().width(),10)-parseInt(s.css("paddingLeft"),10)-parseInt(s.css("paddingRight"),10)-parseInt(s.css("borderLeftWidth"),10)-parseInt(s.css("borderRightWidth"),10));$.each(fxAttrs,function(i,prop){hideProps[prop]="hide";var parts=(""+$.css(options.toShow[0],prop)).match(/^([\d+-.]+)(.*)$/);showProps[prop]={value:parts[1],unit:parts[2]||"px"}});options.toShow.css({height:0,overflow:"hidden"}).show();options.toHide.filter(":hidden").each(options.complete).end().filter(":visible").animate(hideProps,{step:function(now,settings){if(settings.prop=="height"){percentDone=(settings.now-settings.start)/(settings.end-settings.start)}options.toShow[0].style[settings.prop]=(percentDone*showProps[settings.prop].value)+showProps[settings.prop].unit},duration:options.duration,easing:options.easing,complete:function(){if(!options.autoHeight){options.toShow.css("height","")}options.toShow.css("width",originalWidth);options.toShow.css({overflow:overflow});options.complete()}})},bounceslide:function(options){this.slide(options,{easing:options.down?"easeOutBounce":"swing",duration:options.down?1000:200})},easeslide:function(options){this.slide(options,{easing:"easeinout",duration:700})}}})})(jQuery);(function($){$.widget("ui.slider",$.extend({},$.ui.mouse,{_init:function(){var self=this,o=this.options;this._keySliding=false;this._handleIndex=null;this._detectOrientation();this._mouseInit();this.element.addClass("ui-slider ui-slider-"+this.orientation+" ui-widget ui-widget-content ui-corner-all");this.range=$([]);if(o.range){if(o.range===true){this.range=$("<div></div>");if(!o.values){o.values=[this._valueMin(),this._valueMin()]}if(o.values.length&&o.values.length!=2){o.values=[o.values[0],o.values[0]]}}else{this.range=$("<div></div>")}this.range.appendTo(this.element).addClass("ui-slider-range");if(o.range=="min"||o.range=="max"){this.range.addClass("ui-slider-range-"+o.range)}this.range.addClass("ui-widget-header")}if($(".ui-slider-handle",this.element).length==0){$('<a href="#"></a>').appendTo(this.element).addClass("ui-slider-handle")}if(o.values&&o.values.length){while($(".ui-slider-handle",this.element).length<o.values.length){$('<a href="#"></a>').appendTo(this.element).addClass("ui-slider-handle")}}this.handles=$(".ui-slider-handle",this.element).addClass("ui-state-default ui-corner-all");this.handle=this.handles.eq(0);this.handles.add(this.range).filter("a").click(function(event){event.preventDefault()}).hover(function(){$(this).addClass("ui-state-hover")},function(){$(this).removeClass("ui-state-hover")}).focus(function(){$(".ui-slider .ui-state-focus").removeClass("ui-state-focus");$(this).addClass("ui-state-focus")}).blur(function(){$(this).removeClass("ui-state-focus")});this.handles.each(function(i){$(this).data("index.ui-slider-handle",i)});this.handles.keydown(function(event){var ret=true;var index=$(this).data("index.ui-slider-handle");if(self.options.disabled){return }switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:ret=false;if(!self._keySliding){self._keySliding=true;$(this).addClass("ui-state-active");self._start(event,index)}break}var curVal,newVal,step=self._step();if(self.options.values&&self.options.values.length){curVal=newVal=self.values(index)}else{curVal=newVal=self.value()}switch(event.keyCode){case $.ui.keyCode.HOME:newVal=self._valueMin();break;case $.ui.keyCode.END:newVal=self._valueMax();break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal==self._valueMax()){return }newVal=curVal+step;break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal==self._valueMin()){return }newVal=curVal-step;break}self._slide(event,index,newVal);return ret}).keyup(function(event){var index=$(this).data("index.ui-slider-handle");if(self._keySliding){self._stop(event,index);self._change(event,index);self._keySliding=false;$(this).removeClass("ui-state-active")}});this._refreshValue()},destroy:function(){this.handles.remove();this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-slider-disabled ui-widget ui-widget-content ui-corner-all").removeData("slider").unbind(".slider");this._mouseDestroy()},_mouseCapture:function(event){var o=this.options;if(o.disabled){return false}this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();var position={x:event.pageX,y:event.pageY};var normValue=this._normValueFromMouse(position);var distance=this._valueMax()+1,closestHandle;var self=this,index;this.handles.each(function(i){var thisDistance=Math.abs(normValue-self.values(i));if(distance>thisDistance){distance=thisDistance;closestHandle=$(this);index=i}});if(o.range==true&&this.values(1)==o.min){closestHandle=$(this.handles[++index])}this._start(event,index);self._handleIndex=index;closestHandle.addClass("ui-state-active").focus();var offset=closestHandle.offset();var mouseOverHandle=!$(event.target).parents().andSelf().is(".ui-slider-handle");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-(closestHandle.width()/2),top:event.pageY-offset.top-(closestHandle.height()/2)-(parseInt(closestHandle.css("borderTopWidth"),10)||0)-(parseInt(closestHandle.css("borderBottomWidth"),10)||0)+(parseInt(closestHandle.css("marginTop"),10)||0)};normValue=this._normValueFromMouse(position);this._slide(event,index,normValue);return true},_mouseStart:function(event){return true},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY};var normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false},_mouseStop:function(event){this.handles.removeClass("ui-state-active");this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;return false},_detectOrientation:function(){this.orientation=this.options.orientation=="vertical"?"vertical":"horizontal"},_normValueFromMouse:function(position){var pixelTotal,pixelMouse;if("horizontal"==this.orientation){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)}else{pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)}var percentMouse=(pixelMouse/pixelTotal);if(percentMouse>1){percentMouse=1}if(percentMouse<0){percentMouse=0}if("vertical"==this.orientation){percentMouse=1-percentMouse}var valueTotal=this._valueMax()-this._valueMin(),valueMouse=percentMouse*valueTotal,valueMouseModStep=valueMouse%this.options.step,normValue=this._valueMin()+valueMouse-valueMouseModStep;if(valueMouseModStep>(this.options.step/2)){normValue+=this.options.step}return parseFloat(normValue.toFixed(5))},_start:function(event,index){this._trigger("start",event,this._uiHash(index))},_slide:function(event,index,newVal){var handle=this.handles[index];if(this.options.values&&this.options.values.length){var otherVal=this.values(index?0:1);if((index==0&&newVal>=otherVal)||(index==1&&newVal<=otherVal)){newVal=otherVal}if(newVal!=this.values(index)){var newValues=this.values();newValues[index]=newVal;var allowed=this._trigger("slide",event,this._uiHash(index,newVal,newValues));var otherVal=this.values(index?0:1);if(allowed!==false){this.values(index,newVal,(event.type=="mousedown"&&this.options.animate),true)}}}else{if(newVal!=this.value()){var allowed=this._trigger("slide",event,this._uiHash(index,newVal));if(allowed!==false){this._setData("value",newVal,(event.type=="mousedown"&&this.options.animate))}}}},_stop:function(event,index){this._trigger("stop",event,this._uiHash(index))},_change:function(event,index){this._trigger("change",event,this._uiHash(index))},value:function(newValue){if(arguments.length){this._setData("value",newValue);this._change(null,0)}return this._value()},values:function(index,newValue,animated,noPropagation){if(arguments.length>1){this.options.values[index]=newValue;this._refreshValue(animated);if(!noPropagation){this._change(null,index)}}if(arguments.length){if(this.options.values&&this.options.values.length){return this._values(index)}else{return this.value()}}else{return this._values()}},_setData:function(key,value,animated){$.widget.prototype._setData.apply(this,arguments);switch(key){case"orientation":this._detectOrientation();this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+this.orientation);this._refreshValue(animated);break;case"value":this._refreshValue(animated);break}},_step:function(){var step=this.options.step;return step},_value:function(){var val=this.options.value;if(val<this._valueMin()){val=this._valueMin()}if(val>this._valueMax()){val=this._valueMax()}return val},_values:function(index){if(arguments.length){var val=this.options.values[index];if(val<this._valueMin()){val=this._valueMin()}if(val>this._valueMax()){val=this._valueMax()}return val}else{return this.options.values}},_valueMin:function(){var valueMin=this.options.min;return valueMin},_valueMax:function(){var valueMax=this.options.max;return valueMax},_refreshValue:function(animate){var oRange=this.options.range,o=this.options,self=this;if(this.options.values&&this.options.values.length){var vp0,vp1;this.handles.each(function(i,j){var valPercent=(self.values(i)-self._valueMin())/(self._valueMax()-self._valueMin())*100;var _set={};_set[self.orientation=="horizontal"?"left":"bottom"]=valPercent+"%";$(this).stop(1,1)[animate?"animate":"css"](_set,o.animate);if(self.options.range===true){if(self.orientation=="horizontal"){(i==0)&&self.range.stop(1,1)[animate?"animate":"css"]({left:valPercent+"%"},o.animate);(i==1)&&self.range[animate?"animate":"css"]({width:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate})}else{(i==0)&&self.range.stop(1,1)[animate?"animate":"css"]({bottom:(valPercent)+"%"},o.animate);(i==1)&&self.range[animate?"animate":"css"]({height:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate})}}lastValPercent=valPercent})}else{var value=this.value(),valueMin=this._valueMin(),valueMax=this._valueMax(),valPercent=valueMax!=valueMin?(value-valueMin)/(valueMax-valueMin)*100:0;var _set={};_set[self.orientation=="horizontal"?"left":"bottom"]=valPercent+"%";this.handle.stop(1,1)[animate?"animate":"css"](_set,o.animate);(oRange=="min")&&(this.orientation=="horizontal")&&this.range.stop(1,1)[animate?"animate":"css"]({width:valPercent+"%"},o.animate);(oRange=="max")&&(this.orientation=="horizontal")&&this.range[animate?"animate":"css"]({width:(100-valPercent)+"%"},{queue:false,duration:o.animate});(oRange=="min")&&(this.orientation=="vertical")&&this.range.stop(1,1)[animate?"animate":"css"]({height:valPercent+"%"},o.animate);(oRange=="max")&&(this.orientation=="vertical")&&this.range[animate?"animate":"css"]({height:(100-valPercent)+"%"},{queue:false,duration:o.animate})}},_uiHash:function(index,value,values){var multiple=this.options.values&&this.options.values.length;return{handle:this.handles[index],value:value||(multiple?this.values(index):this.value()),values:values||(multiple&&this.values())}}}));$.extend($.ui.slider,{getter:"value values",version:"1.7",eventPrefix:"slide",defaults:{animate:false,delay:0,distance:0,max:100,min:0,orientation:"horizontal",range:false,step:1,value:0,values:null}})})(jQuery);(function($){$.each({focus:"focusin",blur:"focusout"},function(original,fix){$.event.special[fix]={setup:function(){if($.browser.msie){return false}this.addEventListener(original,$.event.special[fix].handler,true)},teardown:function(){if($.browser.msie){return false}this.removeEventListener(original,$.event.special[fix].handler,true)},handler:function(e){arguments[0]=$.event.fix(e);arguments[0].type=fix;return $.event.handle.apply(this,arguments)}}});$.extend($.fn,{delegate:function(type,delegate,handler){return this.bind(type,function(event){var target=$(event.target);if(target.is(delegate)){return handler.apply(target,arguments)}})},triggerEvent:function(type,target){return this.triggerHandler(type,[jQuery.event.fix({type:type,target:target})])}})})(jQuery);var fluid_1_1=fluid_1_1||{};var fluid=fluid||fluid_1_1;(function($,fluid){fluid.version="Infusion 1.1.2";fluid.fail=function(message){fluid.setLogging(true);fluid.log(message.message?message.message:message);throw new Error(message)};fluid.wrap=function(obj){return((!obj||obj.jquery)?obj:$(obj))};fluid.unwrap=function(obj){return obj&&obj.jquery&&obj.length===1?obj[0]:obj};fluid.keyForValue=function(obj,value){for(var key in obj){if(obj[key]===value){return key}}return null};fluid.findKeyInObject=fluid.keyForValue;fluid.clear=function(target){if(target instanceof Array){target.length=0}else{for(var i in target){delete target[i]}}};fluid.container=function(containerSpec){var container=containerSpec;if(typeof containerSpec==="string"||containerSpec.nodeType&&(containerSpec.nodeType===1||containerSpec.nodeType===9)){container=$(containerSpec)}if(!container||!container.jquery||container.length!==1){if(typeof (containerSpec)!=="string"){containerSpec=container.selector}fluid.fail({name:"NotOne",message:"A single container element was not found for selector "+containerSpec})}return container};var defaultsStore={};var globalDefaultsStore={};fluid.defaults=function(){var offset=0;var store=defaultsStore;if(typeof arguments[0]==="boolean"){store=globalDefaultsStore;offset=1}var componentName=arguments[offset];var defaultsObject=arguments[offset+1];if(defaultsObject!==undefined){store[componentName]=defaultsObject;return defaultsObject}return store[componentName]};fluid.createDomBinder=function(container,selectors){var cache={},that={};function cacheKey(name,thisContainer){return $.data(fluid.unwrap(thisContainer))+"-"+name}function record(name,thisContainer,result){cache[cacheKey(name,thisContainer)]=result}that.locate=function(name,localContainer){var selector,thisContainer,togo;selector=selectors[name];thisContainer=localContainer?localContainer:container;if(!thisContainer){fluid.fail("DOM binder invoked for selector "+name+" without container")}if(!selector){return thisContainer}if(typeof (selector)==="function"){togo=$(selector.call(null,fluid.unwrap(thisContainer)))}else{togo=$(selector,thisContainer)}if(togo.get(0)===document){togo=[]}if(!togo.selector){togo.selector=selector;togo.context=thisContainer}togo.selectorName=name;record(name,thisContainer,togo);return togo};that.fastLocate=function(name,localContainer){var thisContainer=localContainer?localContainer:container;var key=cacheKey(name,thisContainer);var togo=cache[key];return togo?togo:that.locate(name,localContainer)};that.clear=function(){cache={}};that.refresh=function(names,localContainer){var thisContainer=localContainer?localContainer:container;if(typeof names==="string"){names=[names]}if(thisContainer.length===undefined){thisContainer=[thisContainer]}for(var i=0;i<names.length;++i){for(var j=0;j<thisContainer.length;++j){that.locate(names[i],thisContainer[j])}}};return that};fluid.mergeListeners=function(events,listeners){if(listeners){for(var key in listeners){var value=listeners[key];var keydot=key.indexOf(".");var namespace;if(keydot!==-1){namespace=key.substring(keydot+1);key=key.substring(0,keydot)}if(!events[key]){events[key]=fluid.event.getEventFirer()}var firer=events[key];if(typeof (value)==="function"){firer.addListener(value,namespace)}else{if(value&&typeof value.length==="number"){for(var i=0;i<value.length;++i){firer.addListener(value[i],namespace)}}}}}};fluid.instantiateFirers=function(that,options){that.events={};if(options.events){for(var event in options.events){var eventType=options.events[event];that.events[event]=fluid.event.getEventFirer(eventType==="unicast",eventType==="preventable")}}fluid.mergeListeners(that.events,options.listeners)};fluid.mergeComponentOptions=function(that,componentName,userOptions){var defaults=fluid.defaults(componentName);that.options=fluid.merge(defaults?defaults.mergePolicy:null,{},defaults,userOptions)};fluid.expectFilledSelector=function(result,message){if(result&&result.length===0&&result.jquery){fluid.fail(message+': selector "'+result.selector+'" with name '+result.selectorName+" returned no results in context "+fluid.dumpEl(result.context))}};fluid.initView=function(componentName,container,userOptions){var that={};fluid.expectFilledSelector(container,'Error instantiating component with name "'+componentName);fluid.mergeComponentOptions(that,componentName,userOptions);if(container){that.container=fluid.container(container);fluid.initDomBinder(that)}fluid.instantiateFirers(that,that.options);return that};fluid.COMPONENT_OPTIONS={};fluid.VALUE={};fluid.emptySubcomponent=function(options){var that={};options=$.makeArray(options);for(var i=0;i<options.length;++i){that[options[i]]=function(){}}return that};fluid.initLittleComponent=function(name,options){var that={};fluid.mergeComponentOptions(that,name,options);return that};fluid.initSubcomponent=function(that,className,args){return fluid.initSubcomponents(that,className,args)[0]};fluid.initSubcomponents=function(that,className,args){var entry=that.options[className];if(!entry){return }var entries=$.makeArray(entry);var optindex=-1;var togo=[];args=$.makeArray(args);for(var i=0;i<args.length;++i){if(args[i]===fluid.COMPONENT_OPTIONS){optindex=i}}for(i=0;i<entries.length;++i){entry=entries[i];if(optindex!==-1&&entry.options){args[optindex]=entry.options}if(typeof (entry)!=="function"){var entryType=typeof (entry)==="string"?entry:entry.type;var globDef=fluid.defaults(true,entryType);fluid.merge("reverse",that.options,globDef);togo[i]=entryType==="fluid.emptySubcomponent"?fluid.emptySubcomponent(entry.options):fluid.invokeGlobalFunction(entryType,args,{fluid:fluid})}else{togo[i]=entry.apply(null,args)}var returnedOptions=togo[i]?togo[i].returnedOptions:null;if(returnedOptions){fluid.merge(that.options.mergePolicy,that.options,returnedOptions);if(returnedOptions.listeners){fluid.mergeListeners(that.events,returnedOptions.listeners)}}}return togo};fluid.initDomBinder=function(that){that.dom=fluid.createDomBinder(that.container,that.options.selectors);that.locate=that.dom.locate};fluid.isPrimitive=function(value){var valueType=typeof (value);return !value||valueType==="string"||valueType==="boolean"||valueType==="number"};function mergeImpl(policy,basePath,target,source){var thisPolicy=policy&&typeof (policy)!=="string"?policy[basePath]:policy;if(typeof (thisPolicy)==="function"){thisPolicy.apply(null,target,source);return target}if(thisPolicy==="replace"){fluid.clear(target)}for(var name in source){var path=(basePath?basePath+".":"")+name;var thisTarget=target[name];var thisSource=source[name];var primitiveTarget=fluid.isPrimitive(thisTarget);if(thisSource!==undefined){if(thisSource!==null&&typeof thisSource==="object"&&!thisSource.nodeType&&!thisSource.jquery&&thisSource!==fluid.VALUE){if(primitiveTarget){target[name]=thisTarget=thisSource instanceof Array?[]:{}}mergeImpl(policy,path,thisTarget,thisSource)}else{if(thisTarget===null||thisTarget===undefined||thisPolicy!=="reverse"){target[name]=thisSource}}}}return target}fluid.merge=function(policy,target){var path="";for(var i=2;i<arguments.length;++i){var source=arguments[i];if(source!==null&&source!==undefined){mergeImpl(policy,path,target,source)}}if(policy&&typeof (policy)!=="string"){for(var key in policy){var elrh=policy[key];if(typeof (elrh)==="string"&&elrh!=="replace"){var oldValue=fluid.model.getBeanValue(target,key);if(oldValue===null||oldValue===undefined){var value=fluid.model.getBeanValue(target,elrh);fluid.model.setBeanValue(target,key,value)}}}}return target};fluid.copy=function(tocopy){if(fluid.isPrimitive(tocopy)){return tocopy}return $.extend(true,typeof (tocopy.length)==="number"?[]:{},tocopy)};fluid.invokeGlobalFunction=function(functionPath,args,environment){var func=fluid.model.getBeanValue(window,functionPath,environment);if(!func){fluid.fail("Error invoking global function: "+functionPath+" could not be located")}else{return func.apply(null,args)}};fluid.event={};var fluid_guid=1;fluid.event.getEventFirer=function(unicast,preventable){var log=fluid.log;var listeners={};return{addListener:function(listener,namespace,predicate){if(!listener){return }if(unicast){namespace="unicast"}if(!namespace){if(!listener.$$guid){listener.$$guid=fluid_guid++}namespace=listener.$$guid}listeners[namespace]={listener:listener,predicate:predicate}},removeListener:function(listener){if(typeof (listener)==="string"){delete listeners[listener]}else{if(typeof (listener)==="object"&&listener.$$guid){delete listeners[listener.$$guid]}}},fire:function(){for(var i in listeners){var lisrec=listeners[i];var listener=lisrec.listener;if(lisrec.predicate&&!lisrec.predicate(listener,arguments)){continue}try{var ret=listener.apply(null,arguments);if(preventable&&ret===false){return false}}catch(e){log("FireEvent received exception "+e.message+" e "+e+" firing to listener "+i);throw (e)}}}}};fluid.model={};fluid.model.copyModel=function(target,source){fluid.clear(target);$.extend(true,target,source)};fluid.model.parseEL=function(EL){return String(EL).split(".")};fluid.model.composePath=function(prefix,suffix){return prefix===""?suffix:prefix+"."+suffix};fluid.model.setBeanValue=function(root,EL,newValue){var segs=fluid.model.parseEL(EL);for(var i=0;i<segs.length-1;i+=1){if(!root[segs[i]]){root[segs[i]]={}}root=root[segs[i]]}root[segs[segs.length-1]]=newValue};fluid.model.getBeanValue=function(root,EL,environment){if(EL===""||EL===null||EL===undefined){return root}var segs=fluid.model.parseEL(EL);for(var i=0;i<segs.length;++i){if(!root){return root}var segment=segs[i];if(environment&&environment[segment]){root=environment[segment];environment=null}else{root=root[segment]}}return root};var logging;fluid.setLogging=function(enabled){if(typeof enabled==="boolean"){logging=enabled}else{logging=false}};fluid.log=function(str){if(logging){str=new Date().toTimeString()+":  "+str;if(typeof (console)!=="undefined"){if(console.debug){console.debug(str)}else{console.log(str)}}else{if(typeof (YAHOO)!=="undefined"){YAHOO.log(str)}else{if(typeof (opera)!=="undefined"){opera.postError(str)}}}}};fluid.dumpEl=function(element){var togo;if(!element){return"null"}if(element.nodeType===3||element.nodeType===8){return"[data: "+element.data+"]"}if(element.nodeType===9){return"[document: location "+element.location+"]"}if(!element.nodeType&&typeof element.length==="number"){togo="[";for(var i=0;i<element.length;++i){togo+=fluid.dumpEl(element[i]);if(i<element.length-1){togo+=", "}}return togo+"]"}element=$(element);togo=element.get(0).tagName;if(element.attr("id")){togo+="#"+element.attr("id")}if(element.attr("class")){togo+="."+element.attr("class")}return togo};fluid.findAncestor=function(element,test){element=fluid.unwrap(element);while(element){if(test(element)){return element}element=element.parentNode}};fluid.jById=function(id,dokkument){dokkument=dokkument&&dokkument.nodeType===9?dokkument:document;var element=fluid.byId(id,dokkument);var togo=element?$(element):[];togo.selector="#"+id;togo.context=dokkument;return togo};fluid.byId=function(id,dokkument){dokkument=dokkument&&dokkument.nodeType===9?dokkument:document;var el=dokkument.getElementById(id);if(el){if(el.getAttribute("id")!==id){fluid.fail("Problem in document structure - picked up element "+fluid.dumpEl(el)+" for id "+id+" without this id - most likely the element has a name which conflicts with this id")}return el}else{return null}};fluid.getId=function(element){return fluid.unwrap(element).getAttribute("id")};fluid.allocateSimpleId=function(element){element=fluid.unwrap(element);if(!element.id){element.id="fluid-id-"+(fluid_guid++)}return element.id};fluid.transform=function(list){var togo=[];for(var i=0;i<list.length;++i){var transit=list[i];for(var j=0;j<arguments.length-1;++j){transit=arguments[j+1](transit,i)}togo[togo.length]=transit}return togo};fluid.find=function(list,fn,deflt){for(var i=0;i<list.length;++i){var transit=fn(list[i],i);if(transit!==null&&transit!==undefined){return transit}}return deflt};fluid.accumulate=function(list,fn,arg){for(var i=0;i<list.length;++i){arg=fn(list[i],arg,i)}return arg};fluid.remove_if=function(list,fn){for(var i=0;i<list.length;++i){if(fn(list[i],i)){list.splice(i,1);--i}}return list};fluid.formatMessage=function(messageString,args){if(!args){return messageString}if(typeof (args)==="string"){args=[args]}for(var i=0;i<args.length;++i){messageString=messageString.replace("{"+i+"}",args[i])}return messageString};fluid.messageLocator=function(messageBase){return function(messagecodes,args){if(typeof (messagecodes)==="string"){messagecodes=[messagecodes]}for(var i=0;i<messagecodes.length;++i){var code=messagecodes[i];var message=messageBase[code];if(message===undefined){continue}return fluid.formatMessage(message,args)}return"[Message string for key "+messagecodes[0]+" not found]"}};fluid.stringTemplate=function(template,values){var newString=template;for(var key in values){if(values.hasOwnProperty(key)){var searchStr="%"+key;newString=newString.replace(searchStr,values[key])}}return newString}})(jQuery,fluid_1_1);var fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.dom=fluid.dom||{};var getNextNode=function(iterator){if(iterator.node.firstChild){iterator.node=iterator.node.firstChild;iterator.depth+=1;return iterator}while(iterator.node){if(iterator.node.nextSibling){iterator.node=iterator.node.nextSibling;return iterator}iterator.node=iterator.node.parentNode;iterator.depth-=1}return iterator};fluid.dom.iterateDom=function(node,acceptor,allNodes){var currentNode={node:node,depth:0};var prevNode=node;var condition;while(currentNode.node!==null&&currentNode.depth>=0&&currentNode.depth<fluid.dom.iterateDom.DOM_BAIL_DEPTH){condition=null;if(currentNode.node.nodeType===1||allNodes){condition=acceptor(currentNode.node,currentNode.depth)}if(condition){if(condition==="delete"){currentNode.node.parentNode.removeChild(currentNode.node);currentNode.node=prevNode}else{if(condition==="stop"){return currentNode.node}}}prevNode=currentNode.node;currentNode=getNextNode(currentNode)}};fluid.dom.iterateDom.DOM_BAIL_DEPTH=256;fluid.dom.computeAbsolutePosition=function(element){var curleft=0,curtop=0;if(element.offsetParent){do{curleft+=element.offsetLeft;curtop+=element.offsetTop;element=element.offsetParent}while(element);return[curleft,curtop]}};fluid.dom.isContainer=function(container,containee){for(;containee;containee=containee.parentNode){if(container===containee){return true}}return false};fluid.dom.insertAfter=function(newChild,refChild){var nextSib=refChild.nextSibling;if(!nextSib){refChild.parentNode.appendChild(newChild)}else{refChild.parentNode.insertBefore(newChild,nextSib)}};fluid.dom.isWhitespaceNode=function(node){return !(/[^\t\n\r ]/.test(node.data))};fluid.dom.isIgnorableNode=function(node){return(node.nodeType===8)||((node.nodeType===3)&&fluid.dom.isWhitespaceNode(node))};fluid.dom.getElementText=function(element){var nodes=element.childNodes;var text="";for(var i=0;i<nodes.length;++i){var child=nodes[i];if(child.nodeType==3){text=text+child.nodeValue}}return text};fluid.dom.cleanseScripts=function(element){var cleansed=$.data(element,fluid.dom.cleanseScripts.MARKER);if(!cleansed){fluid.dom.iterateDom(element,function(node){return node.tagName.toLowerCase()==="script"?"delete":null});$.data(element,fluid.dom.cleanseScripts.MARKER,true)}};fluid.dom.cleanseScripts.MARKER="fluid-scripts-cleansed"})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.VALUE={};fluid.BINDING_ROOT_KEY="fluid-binding-root";fluid.findData=function(elem,name){while(elem){var data=$.data(elem,name);if(data){return data}elem=elem.parentNode}};fluid.bindFossils=function(node,data,fossils){$.data(node,fluid.BINDING_ROOT_KEY,{data:data,fossils:fossils})};fluid.findForm=function(node){return fluid.findAncestor(node,function(element){return element.nodeName.toLowerCase()==="form"})};fluid.value=function(nodeIn,newValue){var node=fluid.unwrap(nodeIn);var multiple=false;if(node.nodeType===undefined&&node.length>1){node=node[0];multiple=true}var jNode=$(node);if("input"!==node.nodeName.toLowerCase()||!/radio|checkbox/.test(node.type)){return $(node).val(newValue)}var name=node.name;if(name===undefined){fluid.fail("Cannot acquire value from node "+fluid.dumpEl(node)+" which does not have name attribute set")}var elements;if(multiple){elements=nodeIn}else{var elements=document.getElementsByName(name);var scope=fluid.findForm(node);elements=$.grep(elements,function(element){if(element.name!==name){return false}return !scope||fluid.dom.isContainer(scope,element)})}if(newValue!==undefined){if(typeof (newValue)==="boolean"){newValue=(newValue?"true":"false")}$.each(elements,function(){this.checked=(newValue instanceof Array?$.inArray(this.value,newValue)!==-1:newValue===this.value)})}else{var checked=$.map(elements,function(element){return element.checked?element.value:null});return node.type==="radio"?checked[0]:checked}};fluid.applyChange=function(node,newValue,applier){node=fluid.unwrap(node);if(newValue===undefined){newValue=fluid.value(node)}if(node.nodeType===undefined&&node.length>0){node=node[0]}var root=fluid.findData(node,fluid.BINDING_ROOT_KEY);if(!root){fluid.fail("Bound data could not be discovered in any node above "+fluid.dumpEl(node))}var name=node.name;var fossil=root.fossils[name];if(!fossil){fluid.fail("No fossil discovered for name "+name+" in fossil record above "+fluid.dumpEl(node))}if(typeof (fossil.oldvalue)==="boolean"){newValue=newValue[0]?true:false}var EL=root.fossils[name].EL;if(applier){applier.fireChangeRequest({path:EL,value:newValue,source:node.id})}else{fluid.model.setBeanValue(root.data,EL,newValue)}};fluid.pathUtil={};var getPathSegmentImpl=function(accept,path,i){var segment=null;if(accept){segment=""}var escaped=false;var limit=path.length;for(;i<limit;++i){var c=path.charAt(i);if(!escaped){if(c==="."){break}else{if(c==="\\"){escaped=true}else{if(segment!==null){segment+=c}}}}else{escaped=false;if(segment!==null){accept+=c}}}if(segment!==null){accept[0]=segment}return i};var globalAccept=[];fluid.pathUtil.getPathSegment=function(path,i){getPathSegmentImpl(globalAccept,path,i);return globalAccept[0]};fluid.pathUtil.getHeadPath=function(path){return fluid.pathUtil.getPathSegment(path,0)};fluid.pathUtil.getFromHeadPath=function(path){var firstdot=getPathSegmentImpl(null,path,0);return firstdot===path.length?null:path.substring(firstdot+1)};function lastDotIndex(path){return path.lastIndexOf(".")}fluid.pathUtil.getToTailPath=function(path){var lastdot=lastDotIndex(path);return lastdot==-1?null:path.substring(0,lastdot)};fluid.pathUtil.getTailPath=function(path){var lastdot=lastDotIndex(path);return fluid.pathUtil.getPathSegment(path,lastdot+1)};var composeSegment=function(prefix,toappend){for(var i=0;i<toappend.length;++i){var c=toappend.charAt(i);if(c==="."||c==="\\"||c==="}"){prefix+="\\"}prefix+=c}return prefix};fluid.pathUtil.composePath=function(prefix,suffix){if(prefix.length!==0){prefix+="."}return composeSegment(prefix,suffix)};fluid.pathUtil.matchPath=function(spec,path){var togo="";while(true){if(!spec){break}if(!path){return null}var spechead=fluid.pathUtil.getHeadPath(spec);var pathhead=fluid.pathUtil.getHeadPath(path);if(spechead!=="*"&&spechead!==pathhead){return null}togo=fluid.pathUtil.composePath(togo,pathhead);spec=fluid.pathUtil.getFromHeadPath(spec);path=fluid.pathUtil.getFromHeadPath(path)}return togo};fluid.model.applyChangeRequest=function(model,request){if(request.type==="ADD"){fluid.model.setBeanValue(model,request.path,request.value)}else{if(request.type==="DELETE"){var totail=fluid.pathUtil.getToTailPath(request.path);var tail=fluid.pathUtil.getTailPath(request.path);var penult=fluid.model.getBeanValue(model,penult);delete penult[tail]}}};fluid.makeChangeApplier=function(model){var baseEvents={guards:fluid.event.getEventFirer(false,true),modelChanged:fluid.event.getEventFirer(false,false)};var that={model:model};function makePredicate(listenerMember,requestIndex){return function(listener,args){var changeRequest=args[requestIndex];return fluid.pathUtil.matchPath(listener[listenerMember],changeRequest.path)}}function adaptListener(that,name,listenerMember,requestIndex){var predicate=makePredicate(listenerMember,requestIndex);that[name]={addListener:function(pathSpec,listener,namespace){listener[listenerMember]=pathSpec;baseEvents[name].addListener(listener,namespace,predicate)},removeListener:function(listener){baseEvents[name].removeListener(listener)}}}adaptListener(that,"guards","guardedPathSpec",1);adaptListener(that,"modelChanged","triggerPathSpec",2);that.fireChangeRequest=function(changeRequest){if(!changeRequest.type){changeRequest.type="ADD"}var prevent=baseEvents.guards.fire(model,changeRequest);if(prevent===false){return }var oldModel={};fluid.model.copyModel(oldModel,model);fluid.model.applyChangeRequest(model,changeRequest);baseEvents.modelChanged.fire(model,oldModel,changeRequest)};that.requestChange=function(path,value,type){var changeRequest={path:path,value:value,type:type};that.fireChangeRequest(changeRequest)};return that};fluid.makeSuperApplier=function(){var subAppliers=[];var that={};that.addSubApplier=function(path,subApplier){subAppliers.push({path:path,subApplier:subApplier})};that.fireChangeRequest=function(request){for(var i=0;i<subAppliers.length;++i){var path=subAppliers[i].path;if(request.path.indexOf(path)===0){var subpath=request.path.substring(path.length+1);var subRequest=fluid.copy(request);subRequest.path=subpath;subAppliers[i].subApplier.fireChangeRequest(subRequest)}}};return that};fluid.attachModel=function(baseModel,path,model){var segs=fluid.model.parseEL(path);for(var i=0;i<segs.length-1;++i){var seg=segs[i];var subModel=baseModel[seg];if(!subModel){baseModel[seg]=subModel={}}baseModel=subModel}baseModel[segs[segs.length-1]]=model};fluid.assembleModel=function(modelSpec){var model={};var superApplier=fluid.makeSuperApplier();var togo={model:model,applier:superApplier};for(path in modelSpec){var rec=modelSpec[path];fluid.attachModel(model,path,rec.model);if(rec.applier){superApplier.addSubApplier(path,rec.applier)}}return togo}})(jQuery,fluid_1_1);var fluid_1_1=fluid_1_1||{};var fluid=fluid||fluid_1_1;(function($,fluid){fluid.thatistBridge=function(name,peer){var togo=function(funcname){var segs=funcname.split(".");var move=peer;for(var i=0;i<segs.length;++i){move=move[segs[i]]}var args=[this];if(arguments.length===2){args=args.concat($.makeArray(arguments[1]))}var ret=move.apply(null,args);this.that=function(){return ret};var type=typeof (ret);return !ret||type==="string"||type==="number"||type==="boolean"||ret&&ret.length!==undefined?ret:this};$.fn[name]=togo;return togo};fluid.thatistBridge("fluid",fluid);fluid.thatistBridge("fluid_1_1",fluid_1_1);var NAMESPACE_KEY="fluid-keyboard-a11y";var getData=function(target,key){var data=$(target).data(NAMESPACE_KEY);return data?data[key]:undefined};var setData=function(target,key,value){$(target).each(function(){var data=$.data(this,NAMESPACE_KEY)||{};data[key]=value;$.data(this,NAMESPACE_KEY,data)})};var lastFocusedElement="disabled";if($.event.special.focusin){lastFocusedElement=null;$(document).bind("focusin",function(event){lastFocusedElement=event.target})}fluid.getLastFocusedElement=function(){if(lastFocusedElement==="disabled"){fluid.fail("Focus manager not enabled - please include jquery.delegate.js or equivalent for support of 'focusin' event")}return lastFocusedElement};var normalizeTabindexName=function(){return $.browser.msie?"tabIndex":"tabindex"};var canHaveDefaultTabindex=function(elements){if(elements.length<=0){return false}return $(elements[0]).is("a, input, button, select, area, textarea, object")};var getValue=function(elements){if(elements.length<=0){return undefined}if(!fluid.tabindex.hasAttr(elements)){return canHaveDefaultTabindex(elements)?Number(0):undefined}var value=elements.attr(normalizeTabindexName());return Number(value)};var setValue=function(elements,toIndex){return elements.each(function(i,item){$(item).attr(normalizeTabindexName(),toIndex)})};fluid.tabindex=function(target,toIndex){target=$(target);if(toIndex!==null&&toIndex!==undefined){return setValue(target,toIndex)}else{return getValue(target)}};fluid.tabindex.remove=function(target){target=$(target);return target.each(function(i,item){$(item).removeAttr(normalizeTabindexName())})};fluid.tabindex.hasAttr=function(target){target=$(target);if(target.length<=0){return false}var togo=target.map(function(){var attributeNode=this.getAttributeNode(normalizeTabindexName());return attributeNode?attributeNode.specified:false});return togo.length===1?togo[0]:togo};fluid.tabindex.has=function(target){target=$(target);return fluid.tabindex.hasAttr(target)||canHaveDefaultTabindex(target)};var ENABLEMENT_KEY="enablement";fluid.enabled=function(target,state){target=$(target);if(state===undefined){return getData(target,ENABLEMENT_KEY)!==false}else{$("*",target).each(function(){if(getData(this,ENABLEMENT_KEY)!==undefined){setData(this,ENABLEMENT_KEY,state)}else{if(/select|textarea|input/i.test(this.nodeName)){$(this).attr("disabled",!state)}}});setData(target,ENABLEMENT_KEY,state)}};fluid.a11y=$.a11y||{};fluid.a11y.orientation={HORIZONTAL:0,VERTICAL:1,BOTH:2};var UP_DOWN_KEYMAP={next:$.ui.keyCode.DOWN,previous:$.ui.keyCode.UP};var LEFT_RIGHT_KEYMAP={next:$.ui.keyCode.RIGHT,previous:$.ui.keyCode.LEFT};var unwrap=function(element){return element.jquery?element[0]:element};var makeElementsTabFocussable=function(elements){elements.each(function(idx,item){item=$(item);if(!item.fluid("tabindex.has")||item.fluid("tabindex")<0){item.fluid("tabindex",0)}})};fluid.tabbable=function(target){target=$(target);makeElementsTabFocussable(target)};var CONTEXT_KEY="selectionContext";var NO_SELECTION=-32768;var cleanUpWhenLeavingContainer=function(selectionContext){if(selectionContext.options.onLeaveContainer){selectionContext.options.onLeaveContainer(selectionContext.selectables[selectionContext.activeItemIndex])}else{if(selectionContext.options.onUnselect){selectionContext.options.onUnselect(selectionContext.selectables[selectionContext.activeItemIndex])}}if(!selectionContext.options.rememberSelectionState){selectionContext.activeItemIndex=NO_SELECTION}};var drawSelection=function(elementToSelect,handler){if(handler){handler(elementToSelect)}};var eraseSelection=function(selectedElement,handler){if(handler&&selectedElement){handler(selectedElement)}};var unselectElement=function(selectedElement,selectionContext){eraseSelection(selectedElement,selectionContext.options.onUnselect)};var selectElement=function(elementToSelect,selectionContext){unselectElement(selectionContext.selectedElement(),selectionContext);elementToSelect=unwrap(elementToSelect);var newIndex=selectionContext.selectables.index(elementToSelect);if(newIndex===-1){return }selectionContext.activeItemIndex=newIndex;drawSelection(elementToSelect,selectionContext.options.onSelect)};var selectableFocusHandler=function(selectionContext){return function(evt){selectElement(evt.target,selectionContext);return evt.stopPropagation()}};var selectableBlurHandler=function(selectionContext){return function(evt){unselectElement(evt.target,selectionContext);return evt.stopPropagation()}};var reifyIndex=function(sc_that){var elements=sc_that.selectables;if(sc_that.activeItemIndex>=elements.length){sc_that.activeItemIndex=0}if(sc_that.activeItemIndex<0&&sc_that.activeItemIndex!==NO_SELECTION){sc_that.activeItemIndex=elements.length-1}if(sc_that.activeItemIndex>=0){$(elements[sc_that.activeItemIndex]).focus()}};var prepareShift=function(selectionContext){unselectElement(selectionContext.selectedElement(),selectionContext);if(selectionContext.activeItemIndex===NO_SELECTION){selectionContext.activeItemIndex=-1}};var focusNextElement=function(selectionContext){prepareShift(selectionContext);++selectionContext.activeItemIndex;reifyIndex(selectionContext)};var focusPreviousElement=function(selectionContext){prepareShift(selectionContext);--selectionContext.activeItemIndex;reifyIndex(selectionContext)};var arrowKeyHandler=function(selectionContext,keyMap,userHandlers){return function(evt){if(evt.which===keyMap.next){focusNextElement(selectionContext);evt.preventDefault()}else{if(evt.which===keyMap.previous){focusPreviousElement(selectionContext);evt.preventDefault()}}}};var getKeyMapForDirection=function(direction){var keyMap;if(direction===fluid.a11y.orientation.HORIZONTAL){keyMap=LEFT_RIGHT_KEYMAP}else{if(direction===fluid.a11y.orientation.VERTICAL){keyMap=UP_DOWN_KEYMAP}}return keyMap};var tabKeyHandler=function(selectionContext){return function(evt){if(evt.which!==$.ui.keyCode.TAB){return }cleanUpWhenLeavingContainer(selectionContext);if(evt.shiftKey){selectionContext.focusIsLeavingContainer=true}}};var containerFocusHandler=function(selectionContext){return function(evt){var shouldOrig=selectionContext.options.autoSelectFirstItem;var shouldSelect=typeof (shouldOrig)==="function"?shouldOrig():shouldOrig;if(selectionContext.focusIsLeavingContainer){shouldSelect=false}if(shouldSelect&&evt.target===selectionContext.container.get(0)){if(selectionContext.activeItemIndex===NO_SELECTION){selectionContext.activeItemIndex=0}$(selectionContext.selectables[selectionContext.activeItemIndex]).focus()}return evt.stopPropagation()}};var containerBlurHandler=function(selectionContext){return function(evt){selectionContext.focusIsLeavingContainer=false;return evt.stopPropagation()}};var makeElementsSelectable=function(container,defaults,userOptions){var options=$.extend(true,{},defaults,userOptions);var keyMap=getKeyMapForDirection(options.direction);var selectableElements=options.selectableElements?options.selectableElements:container.find(options.selectableSelector);var that={container:container,activeItemIndex:NO_SELECTION,selectables:selectableElements,focusIsLeavingContainer:false,options:options};that.selectablesUpdated=function(focusedItem){if(typeof (that.options.selectablesTabindex)==="number"){that.selectables.fluid("tabindex",that.options.selectablesTabindex)}that.selectables.unbind("focus."+NAMESPACE_KEY);that.selectables.unbind("blur."+NAMESPACE_KEY);that.selectables.bind("focus."+NAMESPACE_KEY,selectableFocusHandler(that));that.selectables.bind("blur."+NAMESPACE_KEY,selectableBlurHandler(that));if(focusedItem){selectElement(focusedItem,that)}else{reifyIndex(that)}};that.refresh=function(){if(!that.options.selectableSelector){throw ("Cannot refresh selectable context which was not initialised by a selector")}that.selectables=container.find(options.selectableSelector);that.selectablesUpdated()};that.selectedElement=function(){return that.activeItemIndex<0?null:that.selectables[that.activeItemIndex]};if(keyMap){container.keydown(arrowKeyHandler(that,keyMap))}container.keydown(tabKeyHandler(that));container.focus(containerFocusHandler(that));container.blur(containerBlurHandler(that));that.selectablesUpdated();return that};fluid.selectable=function(target,options){target=$(target);var that=makeElementsSelectable(target,fluid.selectable.defaults,options);setData(target,CONTEXT_KEY,that);return that};fluid.selectable.select=function(target,toSelect){$(toSelect).focus()};fluid.selectable.selectNext=function(target){target=$(target);focusNextElement(getData(target,CONTEXT_KEY))};fluid.selectable.selectPrevious=function(target){target=$(target);focusPreviousElement(getData(target,CONTEXT_KEY))};fluid.selectable.currentSelection=function(target){target=$(target);var that=getData(target,CONTEXT_KEY);return $(that.selectedElement())};fluid.selectable.defaults={direction:fluid.a11y.orientation.VERTICAL,selectablesTabindex:-1,autoSelectFirstItem:true,rememberSelectionState:true,selectableSelector:".selectable",selectableElements:null,onSelect:null,onUnselect:null,onLeaveContainer:null};var checkForModifier=function(binding,evt){if(!binding.modifier){return true}var modifierKey=binding.modifier;var isCtrlKeyPresent=modifierKey&&evt.ctrlKey;var isAltKeyPresent=modifierKey&&evt.altKey;var isShiftKeyPresent=modifierKey&&evt.shiftKey;return isCtrlKeyPresent||isAltKeyPresent||isShiftKeyPresent};var makeActivationHandler=function(binding){return function(evt){var target=evt.target;if(!fluid.enabled(evt.target)){return }var code=evt.which?evt.which:evt.keyCode;if(code===binding.key&&binding.activateHandler&&checkForModifier(binding,evt)){var event=$.Event("fluid-activate");$(evt.target).trigger(event,[binding.activateHandler]);if(event.isDefaultPrevented()){evt.preventDefault()}}}};var makeElementsActivatable=function(elements,onActivateHandler,defaultKeys,options){var bindings=[];$(defaultKeys).each(function(index,key){bindings.push({modifier:null,key:key,activateHandler:onActivateHandler})});if(options&&options.additionalBindings){bindings=bindings.concat(options.additionalBindings)}setData(elements,ENABLEMENT_KEY,true);for(var i=0;i<bindings.length;++i){var binding=bindings[i];elements.keydown(makeActivationHandler(binding))}elements.bind("fluid-activate",function(evt,handler){handler=handler||onActivateHandler;return handler?handler(evt):null})};fluid.activatable=function(target,fn,options){target=$(target);makeElementsActivatable(target,fn,fluid.activatable.defaults.keys,options)};fluid.activate=function(target){$(target).trigger("fluid-activate")};fluid.activatable.defaults={keys:[$.ui.keyCode.ENTER,$.ui.keyCode.SPACE]}})(jQuery,fluid_1_1);if(!this.JSON){JSON=function(){function f(n){return n<10?"0"+n:n}Date.prototype.toJSON=function(){return this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z"};var m={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};function stringify(value,whitelist){var a,i,k,l,r=/["\\\x00-\x1f\x7f-\x9f]/g,v;switch(typeof value){case"string":return r.test(value)?'"'+value.replace(r,function(a){var c=m[a];if(c){return c}c=a.charCodeAt();return"\\u00"+Math.floor(c/16).toString(16)+(c%16).toString(16)})+'"':'"'+value+'"';case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}if(typeof value.toJSON==="function"){return stringify(value.toJSON())}a=[];if(typeof value.length==="number"&&!(value.propertyIsEnumerable("length"))){l=value.length;for(i=0;i<l;i+=1){a.push(stringify(value[i],whitelist)||"null")}return"["+a.join(",")+"]"}if(whitelist){l=whitelist.length;for(i=0;i<l;i+=1){k=whitelist[i];if(typeof k==="string"){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+":"+v)}}}}else{for(k in value){if(typeof k==="string"){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+":"+v)}}}}return"{"+a.join(",")+"}"}}return{stringify:stringify,parse:function(text,filter){var j;function walk(k,v){var i,n;if(v&&typeof v==="object"){for(i in v){if(Object.prototype.hasOwnProperty.apply(v,[i])){n=walk(i,v[i]);if(n!==undefined){v[i]=n}}}}return filter(k,v)}if(/^[\],:{}\s]*$/.test(text.replace(/\\./g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(:?[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof filter==="function"?walk("",j):j}throw new SyntaxError("parseJSON")}}}()}var fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.orientation={HORIZONTAL:4,VERTICAL:1};fluid.rectSides={4:["left","right"],1:["top","bottom"],8:"top",12:"bottom",2:"left",3:"right"};fluid.position={BEFORE:-1,AFTER:1,INSIDE:2,REPLACE:3};fluid.direction={NEXT:1,PREVIOUS:-1,UP:8,DOWN:12,LEFT:2,RIGHT:3};fluid.directionSign=function(direction){return direction===fluid.direction.UP||direction===fluid.direction.LEFT?fluid.direction.PREVIOUS:fluid.direction.NEXT};fluid.directionAxis=function(direction){return direction===fluid.direction.LEFT||direction===fluid.direction.RIGHT?0:1};fluid.directionOrientation=function(direction){return fluid.directionAxis(direction)?fluid.orientation.VERTICAL:fluid.orientation.HORIZONTAL};fluid.keycodeDirection={up:fluid.direction.UP,down:fluid.direction.DOWN,left:fluid.direction.LEFT,right:fluid.direction.RIGHT};fluid.moveDom=function(source,target,position){source=fluid.unwrap(source);target=fluid.unwrap(target);var scan;if(position===fluid.position.INSIDE){target.appendChild(source)}else{if(position===fluid.position.BEFORE){for(scan=target.previousSibling;;scan=scan.previousSibling){if(!scan||!fluid.dom.isIgnorableNode(scan)){if(scan!==source){fluid.dom.cleanseScripts(source);target.parentNode.insertBefore(source,target)}break}}}else{if(position===fluid.position.AFTER){for(scan=target.nextSibling;;scan=scan.nextSibling){if(!scan||!fluid.dom.isIgnorableNode(scan)){if(scan!==source){fluid.dom.cleanseScripts(source);fluid.dom.insertAfter(source,target)}break}}}else{fluid.fail("Unrecognised position supplied to fluid.moveDom: "+position)}}}};fluid.normalisePosition=function(position,samespan,targeti,sourcei){if(position===fluid.position.REPLACE){position=samespan&&targeti>=sourcei?fluid.position.AFTER:fluid.position.BEFORE}return position};fluid.permuteDom=function(element,target,position,sourceelements,targetelements){element=fluid.unwrap(element);target=fluid.unwrap(target);var sourcei=$.inArray(element,sourceelements);if(sourcei===-1){fluid.fail("Error in permuteDom: source element "+fluid.dumpEl(element)+" not found in source list "+fluid.dumpEl(sourceelements))}var targeti=$.inArray(target,targetelements);if(targeti===-1){fluid.fail("Error in permuteDom: target element "+fluid.dumpEl(target)+" not found in source list "+fluid.dumpEl(targetelements))}var samespan=sourceelements===targetelements;position=fluid.normalisePosition(position,samespan,targeti,sourcei);var oldn={};oldn[fluid.position.AFTER]=element.nextSibling;oldn[fluid.position.BEFORE]=element.previousSibling;fluid.moveDom(sourceelements[sourcei],targetelements[targeti],position);var frontlimit=samespan?targeti-1:sourceelements.length-2;var i;if(position===fluid.position.BEFORE&&samespan){frontlimit--}if(!samespan||targeti>sourcei){for(i=frontlimit;i>sourcei;--i){fluid.moveDom(sourceelements[i+1],sourceelements[i],fluid.position.AFTER)}if(sourcei+1<sourceelements.length){fluid.moveDom(sourceelements[sourcei+1],oldn[fluid.position.AFTER],fluid.position.BEFORE)}}var backlimit=samespan?sourcei-1:targetelements.length-1;if(position===fluid.position.AFTER){targeti++}if(!samespan||targeti<sourcei){for(i=targeti;i<backlimit;++i){fluid.moveDom(targetelements[i],targetelements[i+1],fluid.position.BEFORE)}if(backlimit>=0&&backlimit<targetelements.length-1){fluid.moveDom(targetelements[backlimit],oldn[fluid.position.BEFORE],fluid.position.AFTER)}}};var curCss=function(a,name){return window.getComputedStyle?window.getComputedStyle(a,null).getPropertyValue(name):a.currentStyle[name]};var isAttached=function(node){while(node&&node.nodeName){if(node.nodeName==="BODY"){return true}node=node.parentNode}return false};var generalHidden=function(a){return"hidden"===a.type||curCss(a,"display")==="none"||curCss(a,"visibility")==="hidden"||!isAttached(a)};var computeGeometry=function(element,orientation,disposition){var elem={};elem.element=element;elem.orientation=orientation;if(disposition===fluid.position.INSIDE){elem.position=disposition}if(generalHidden(element)){elem.clazz="hidden"}var pos=fluid.dom.computeAbsolutePosition(element)||[0,0];var width=element.offsetWidth;var height=element.offsetHeight;elem.rect={left:pos[0],top:pos[1]};elem.rect.right=pos[0]+width;elem.rect.bottom=pos[1]+height;return elem};var SENTINEL_DIMENSION=10000;function dumprect(rect){return"Rect top: "+rect.top+" left: "+rect.left+" bottom: "+rect.bottom+" right: "+rect.right}function dumpelem(cacheelem){if(!cacheelem||!cacheelem.rect){return"null"}else{return dumprect(cacheelem.rect)+" position: "+cacheelem.position+" for "+fluid.dumpEl(cacheelem.element)}}fluid.dropManager=function(){var targets=[];var cache={};var that={};var lastClosest;function cacheKey(element){return $(element).data("")}function sentinelizeElement(targets,sides,cacheelem,fc,disposition,clazz){var elemCopy=$.extend(true,{},cacheelem);elemCopy.rect[sides[fc]]=elemCopy.rect[sides[1-fc]]+(fc?1:-1);elemCopy.rect[sides[1-fc]]=(fc?-1:1)*SENTINEL_DIMENSION;elemCopy.position=disposition===fluid.position.INSIDE?disposition:(fc?fluid.position.BEFORE:fluid.position.AFTER);elemCopy.clazz=clazz;targets[targets.length]=elemCopy}function splitElement(targets,sides,cacheelem,disposition,clazz1,clazz2){var elem1=$.extend(true,{},cacheelem);var elem2=$.extend(true,{},cacheelem);var midpoint=(elem1.rect[sides[0]]+elem1.rect[sides[1]])/2;elem1.rect[sides[1]]=midpoint;elem1.position=fluid.position.BEFORE;elem2.rect[sides[0]]=midpoint;elem2.position=fluid.position.AFTER;elem1.clazz=clazz1;elem2.clazz=clazz2;targets[targets.length]=elem1;targets[targets.length]=elem2}function getRelativeClass(thisElements,index,relative,thisclazz,mapper){index+=relative;if(index<0&&thisclazz==="locked"){return"locked"}if(index>=thisElements.length||mapper===null){return null}else{relative=thisElements[index];return mapper(relative)==="locked"&&thisclazz==="locked"?"locked":null}}var lastGeometry;var displacementX,displacementY;that.updateGeometry=function(geometricInfo){lastGeometry=geometricInfo;targets=[];cache={};var mapper=geometricInfo.elementMapper;for(var i=0;i<geometricInfo.extents.length;++i){var thisInfo=geometricInfo.extents[i];var orientation=thisInfo.orientation;var sides=fluid.rectSides[orientation];var processElement=function(element,sentB,sentF,disposition,j){var cacheelem=computeGeometry(element,orientation,disposition);cacheelem.owner=thisInfo;if(cacheelem.clazz!=="hidden"&&mapper){cacheelem.clazz=mapper(element)}cache[$.data(element)]=cacheelem;var backClass=getRelativeClass(thisInfo.elements,j,fluid.position.BEFORE,cacheelem.clazz,mapper);var frontClass=getRelativeClass(thisInfo.elements,j,fluid.position.AFTER,cacheelem.clazz,mapper);if(disposition===fluid.position.INSIDE){targets[targets.length]=cacheelem}else{splitElement(targets,sides,cacheelem,disposition,backClass,frontClass)}if(sentB&&geometricInfo.sentinelize){sentinelizeElement(targets,sides,cacheelem,1,disposition,backClass)}if(sentF&&geometricInfo.sentinelize){sentinelizeElement(targets,sides,cacheelem,0,disposition,frontClass)}return cacheelem};var allHidden=true;for(var j=0;j<thisInfo.elements.length;++j){var element=thisInfo.elements[j];var cacheelem=processElement(element,j===0,j===thisInfo.elements.length-1,fluid.position.INTERLEAVED,j);if(cacheelem.clazz!=="hidden"){allHidden=false}}if(allHidden&&thisInfo.parentElement){processElement(thisInfo.parentElement,true,true,fluid.position.INSIDE)}}};that.startDrag=function(event,handlePos,handleWidth,handleHeight){var handleMidX=handlePos[0]+handleWidth/2;var handleMidY=handlePos[1]+handleHeight/2;var dX=handleMidX-event.pageX;var dY=handleMidY-event.pageY;that.updateGeometry(lastGeometry);lastClosest=null;displacementX=dX;displacementY=dY;$("").bind("mousemove.fluid-dropManager",that.mouseMove)};that.lastPosition=function(){return lastClosest};that.endDrag=function(){$("").unbind("mousemove.fluid-dropManager")};that.mouseMove=function(evt){var x=evt.pageX+displacementX;var y=evt.pageY+displacementY;var closestTarget=that.closestTarget(x,y,lastClosest);if(closestTarget&&closestTarget!==fluid.dropManager.NO_CHANGE){lastClosest=closestTarget;that.dropChangeFirer.fire(closestTarget)}};that.dropChangeFirer=fluid.event.getEventFirer();var blankHolder={element:null};that.closestTarget=function(x,y,lastClosest){var mindistance=Number.MAX_VALUE;var minelem=blankHolder;var minlockeddistance=Number.MAX_VALUE;var minlockedelem=blankHolder;for(var i=0;i<targets.length;++i){var cacheelem=targets[i];if(cacheelem.clazz==="hidden"){continue}var distance=fluid.geom.minPointRectangle(x,y,cacheelem.rect);if(cacheelem.clazz==="locked"){if(distance<minlockeddistance){minlockeddistance=distance;minlockedelem=cacheelem}}else{if(distance<mindistance){mindistance=distance;minelem=cacheelem}if(distance===0){break}}}if(!minelem){return minelem}if(minlockeddistance>=mindistance){minlockedelem=blankHolder}if(lastClosest&&lastClosest.position===minelem.position&&fluid.unwrap(lastClosest.element)===fluid.unwrap(minelem.element)&&fluid.unwrap(lastClosest.lockedelem)===fluid.unwrap(minlockedelem.element)){return fluid.dropManager.NO_CHANGE}return{position:minelem.position,element:minelem.element,lockedelem:minlockedelem.element}};that.shuffleProjectFrom=function(element,direction,includeLocked){var togo=that.projectFrom(element,direction,includeLocked);togo.position=fluid.position.REPLACE;return togo};that.projectFrom=function(element,direction,includeLocked){that.updateGeometry(lastGeometry);var cacheelem=cache[cacheKey(element)];var projected=fluid.geom.projectFrom(cacheelem.rect,direction,targets,includeLocked);if(!projected.cacheelem){return null}var retpos=projected.cacheelem.position;return{element:projected.cacheelem.element,position:retpos?retpos:fluid.position.BEFORE}};function getRelativeElement(element,direction,elements){var folded=fluid.directionSign(direction);var index=$(elements).index(element)+folded;if(index<0){index+=elements.length}index%=elements.length;return elements[index]}that.logicalFrom=function(element,direction,includeLocked){var orderables=that.getOwningSpan(element,fluid.position.INTERLEAVED,includeLocked);return{element:getRelativeElement(element,direction,orderables),position:fluid.position.REPLACE}};that.lockedWrapFrom=function(element,direction,includeLocked){var base=that.logicalFrom(element,direction,includeLocked);var selectables=that.getOwningSpan(element,fluid.position.INTERLEAVED,includeLocked);var allElements=cache[cacheKey(element)].owner.elements;if(includeLocked||selectables[0]===allElements[0]){return base}var directElement=getRelativeElement(element,direction,allElements);if(lastGeometry.elementMapper(directElement)==="locked"){base.element=null;base.clazz="locked"}return base};that.getOwningSpan=function(element,position,includeLocked){var owner=cache[cacheKey(element)].owner;var elements=position===fluid.position.INSIDE?[owner.parentElement]:owner.elements;if(!includeLocked&&lastGeometry.elementMapper){elements=$.makeArray(elements);fluid.remove_if(elements,function(element){return lastGeometry.elementMapper(element)==="locked"})}return elements};that.geometricMove=function(element,target,position){var sourceElements=that.getOwningSpan(element,null,true);var targetElements=that.getOwningSpan(target,position,true);fluid.permuteDom(element,target,position,sourceElements,targetElements)};return that};fluid.dropManager.NO_CHANGE="no change";fluid.geom=fluid.geom||{};fluid.geom.minPointRectangle=function(x,y,rectangle){var dx=x<rectangle.left?(rectangle.left-x):(x>rectangle.right?(x-rectangle.right):0);var dy=y<rectangle.top?(rectangle.top-y):(y>rectangle.bottom?(y-rectangle.bottom):0);return dx*dx+dy*dy};fluid.geom.minRectRect=function(rect1,rect2){var dx=rect1.right<rect2.left?rect2.left-rect1.right:rect2.right<rect1.left?rect1.left-rect2.right:0;var dy=rect1.bottom<rect2.top?rect2.top-rect1.bottom:rect2.bottom<rect1.top?rect1.top-rect2.bottom:0;return dx*dx+dy*dy};var makePenCollect=function(){return{mindist:Number.MAX_VALUE,minrdist:Number.MAX_VALUE}};fluid.geom.projectFrom=function(baserect,direction,targets,forSelection){var axis=fluid.directionAxis(direction);var frontSide=fluid.rectSides[direction];var backSide=fluid.rectSides[axis*15+5-direction];var dirSign=fluid.directionSign(direction);var penrect={left:(7*baserect.left+1*baserect.right)/8,right:(5*baserect.left+3*baserect.right)/8,top:(7*baserect.top+1*baserect.bottom)/8,bottom:(5*baserect.top+3*baserect.bottom)/8};penrect[frontSide]=dirSign*SENTINEL_DIMENSION;penrect[backSide]=-penrect[frontSide];function accPen(collect,cacheelem,backSign){var thisrect=cacheelem.rect;var pdist=fluid.geom.minRectRect(penrect,thisrect);var rdist=-dirSign*backSign*(baserect[backSign===1?frontSide:backSide]-thisrect[backSign===1?backSide:frontSide]);if(pdist<=collect.mindist&&rdist>=0){if(pdist===collect.mindist&&rdist*backSign>collect.minrdist){return }collect.minrdist=rdist*backSign;collect.mindist=pdist;collect.minelem=cacheelem}}var collect=makePenCollect();var backcollect=makePenCollect();var lockedcollect=makePenCollect();for(var i=0;i<targets.length;++i){var elem=targets[i];var isPure=elem.owner&&elem.element===elem.owner.parentElement;if(elem.clazz==="hidden"||forSelection&&isPure){continue}else{if(!forSelection&&elem.clazz==="locked"){accPen(lockedcollect,elem,1)}else{accPen(collect,elem,1);accPen(backcollect,elem,-1)}}}var wrap=!collect.minelem||backcollect.mindist<collect.mindist;var mincollect=wrap?backcollect:collect;var togo={wrapped:wrap,cacheelem:mincollect.minelem};if(lockedcollect.mindist<mincollect.mindist){togo.lockedelem=lockedcollect.minelem}return togo}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var defaultAvatarCreator=function(item,cssClass,dropWarning){var avatar=$(item).clone();fluid.dom.iterateDom(avatar.get(0),function(node){if(node.tagName.toLowerCase()==="script"){return"delete"}node.removeAttribute("id");if(node.tagName.toLowerCase()==="input"){node.setAttribute("disabled","disabled")}});avatar.removeAttr("id");avatar.removeClass("ui-droppable");avatar.addClass(cssClass);if(dropWarning){var avatarContainer=$(document.createElement("div"));avatarContainer.append(avatar);avatarContainer.append(dropWarning);avatar=avatarContainer}$("body").append(avatar);if(!$.browser.safari){avatar.css("display","block").width(item.offsetWidth).height(item.offsetHeight)}if($.browser.opera){avatar.hide()}return avatar};function firstSelectable(that){var selectables=that.dom.fastLocate("selectables");if(selectables.length<=0){return null}return selectables[0]}function bindHandlersToContainer(container,keyDownHandler,keyUpHandler,mouseMoveHandler){var actualKeyDown=keyDownHandler;var advancedPrevention=false;if($.browser.opera){container.keypress(function(evt){if(advancedPrevention){advancedPrevention=false;evt.preventDefault();return false}});actualKeyDown=function(evt){var oldret=keyDownHandler(evt);if(oldret===false){advancedPrevention=true}}}container.keydown(actualKeyDown);container.keyup(keyUpHandler)}function addRolesToContainer(that){var first=that.dom.fastLocate("selectables")[0];that.container.attr("role",that.options.containerRole.container);that.container.attr("aria-multiselectable","false");that.container.attr("aria-readonly","false");that.container.attr("aria-disabled","false")}function createAvatarId(parentId){return parentId+"_avatar"}var adaptKeysets=function(options){if(options.keysets&&!(options.keysets instanceof Array)){options.keysets=[options.keysets]}};fluid.reorderer=function(container,options){if(!container){fluid.fail("Reorderer initialised with no container")}var thatReorderer=fluid.initView("fluid.reorderer",container,options);options=thatReorderer.options;var dropManager=fluid.dropManager();thatReorderer.layoutHandler=fluid.initSubcomponent(thatReorderer,"layoutHandler",[thatReorderer.container,options,dropManager,thatReorderer.dom]);thatReorderer.activeItem=undefined;adaptKeysets(options);var kbDropWarning=thatReorderer.locate("dropWarning");var mouseDropWarning;if(kbDropWarning){mouseDropWarning=kbDropWarning.clone()}var isMove=function(evt){var keysets=options.keysets;for(var i=0;i<keysets.length;i++){if(keysets[i].modifier(evt)){return true}}return false};var isActiveItemMovable=function(){return $.inArray(thatReorderer.activeItem,thatReorderer.dom.fastLocate("movables"))>=0};var setDropEffects=function(value){thatReorderer.dom.fastLocate("dropTargets").attr("aria-dropeffect",value)};var styles=options.styles;var noModifier=function(evt){return(!evt.ctrlKey&&!evt.altKey&&!evt.shiftKey&&!evt.metaKey)};var handleDirectionKeyDown=function(evt){var item=thatReorderer.activeItem;if(!item){return true}var keysets=options.keysets;for(var i=0;i<keysets.length;i++){var keyset=keysets[i];var didProcessKey=false;var keydir=fluid.keyForValue(keyset,evt.keyCode);if(!keydir){continue}var isMovement=keyset.modifier(evt);var dirnum=fluid.keycodeDirection[keydir];var relativeItem=thatReorderer.layoutHandler.getRelativePosition(item,dirnum,!isMovement);if(!relativeItem){continue}if(isMovement){var prevent=thatReorderer.events.onBeginMove.fire(item);if(prevent===false){return false}if(kbDropWarning.length>0){if(relativeItem.clazz==="locked"){thatReorderer.events.onShowKeyboardDropWarning.fire(item,kbDropWarning);kbDropWarning.show()}else{kbDropWarning.hide()}}if(relativeItem.element){thatReorderer.requestMovement(relativeItem,item)}}else{if(noModifier(evt)){$(relativeItem.element).focus()}}return false}return true};thatReorderer.handleKeyDown=function(evt){if(!thatReorderer.activeItem||thatReorderer.activeItem!==evt.target){return true}var jActiveItem=$(thatReorderer.activeItem);if(!jActiveItem.hasClass(styles.dragging)&&isMove(evt)){if(isActiveItemMovable()){jActiveItem.removeClass(styles.selected);jActiveItem.addClass(styles.dragging);jActiveItem.attr("aria-grabbed","true");setDropEffects("move")}return false}return handleDirectionKeyDown(evt)};thatReorderer.handleKeyUp=function(evt){if(!thatReorderer.activeItem||thatReorderer.activeItem!==evt.target){return true}var jActiveItem=$(thatReorderer.activeItem);if(jActiveItem.hasClass(styles.dragging)&&!isMove(evt)){if(kbDropWarning){kbDropWarning.hide()}jActiveItem.removeClass(styles.dragging);jActiveItem.addClass(styles.selected);jActiveItem.attr("aria-grabbed","false");setDropEffects("none");return false}return false};var dropMarker;var createDropMarker=function(tagName){var dropMarker=$(document.createElement(tagName));dropMarker.addClass(options.styles.dropMarker);dropMarker.hide();return dropMarker};fluid.logEnabled=true;thatReorderer.requestMovement=function(requestedPosition,item){if(!requestedPosition||fluid.unwrap(requestedPosition.element)===fluid.unwrap(item)){return }thatReorderer.events.onMove.fire(item,requestedPosition);dropManager.geometricMove(item,requestedPosition.element,requestedPosition.position);$(thatReorderer.activeItem).focus();thatReorderer.refresh();dropManager.updateGeometry(thatReorderer.layoutHandler.getGeometricInfo());thatReorderer.events.afterMove.fire(item,requestedPosition,thatReorderer.dom.fastLocate("movables"))};var hoverStyleHandler=function(item,state){thatReorderer.dom.fastLocate("grabHandle",item)[state?"addClass":"removeClass"](styles.hover)};function initMovable(item){var styles=options.styles;item.attr("aria-grabbed","false");item.mouseover(function(){thatReorderer.events.onHover.fire(item,true)});item.mouseout(function(){thatReorderer.events.onHover.fire(item,false)});var avatar;thatReorderer.dom.fastLocate("grabHandle",item).draggable({refreshPositions:false,scroll:true,helper:function(){var dropWarningEl;if(mouseDropWarning){dropWarningEl=mouseDropWarning[0]}avatar=$(options.avatarCreator(item[0],styles.avatar,dropWarningEl));avatar.attr("id",createAvatarId(thatReorderer.container.id));return avatar},start:function(e,ui){var prevent=thatReorderer.events.onBeginMove.fire(item);if(prevent===false){return false}var handle=thatReorderer.dom.fastLocate("grabHandle",item)[0];var handlePos=fluid.dom.computeAbsolutePosition(handle);var handleWidth=handle.offsetWidth;var handleHeight=handle.offsetHeight;item.focus();item.removeClass(options.styles.selected);item.addClass(options.styles.mouseDrag);item.attr("aria-grabbed","true");setDropEffects("move");dropManager.startDrag(e,handlePos,handleWidth,handleHeight);avatar.show()},stop:function(e,ui){item.removeClass(options.styles.mouseDrag);item.addClass(options.styles.selected);$(thatReorderer.activeItem).attr("aria-grabbed","false");var markerNode=fluid.unwrap(dropMarker);if(markerNode.parentNode){markerNode.parentNode.removeChild(markerNode)}avatar.hide();ui.helper=null;setDropEffects("none");dropManager.endDrag();thatReorderer.requestMovement(dropManager.lastPosition(),item);thatReorderer.activeItem.focus()},handle:thatReorderer.dom.fastLocate("grabHandle",item)})}function changeSelectedToDefault(jItem,styles){jItem.removeClass(styles.selected);jItem.removeClass(styles.dragging);jItem.addClass(styles.defaultStyle);jItem.attr("aria-selected","false")}var selectItem=function(anItem){thatReorderer.events.onSelect.fire(anItem);var styles=options.styles;if(thatReorderer.activeItem&&thatReorderer.activeItem!==anItem){changeSelectedToDefault($(thatReorderer.activeItem),styles)}thatReorderer.activeItem=anItem;var jItem=$(anItem);jItem.removeClass(styles.defaultStyle);jItem.addClass(styles.selected);jItem.attr("aria-selected","true")};var initSelectables=function(){var handleBlur=function(evt){changeSelectedToDefault($(this),options.styles);return evt.stopPropagation()};var handleFocus=function(evt){selectItem(this);return evt.stopPropagation()};var selectables=thatReorderer.dom.fastLocate("selectables");for(var i=0;i<selectables.length;++i){var selectable=$(selectables[i]);if(!$.data(selectable[0],"fluid.reorderer.selectable-initialised")){selectable.addClass(styles.defaultStyle);selectables.blur(handleBlur);selectables.focus(handleFocus);selectables.click(function(evt){var handle=fluid.unwrap(thatReorderer.dom.fastLocate("grabHandle",this));if(fluid.dom.isContainer(handle,evt.target)){$(this).focus()}});selectables.attr("role",options.containerRole.item);selectables.attr("aria-selected","false");selectables.attr("aria-disabled","false");$.data(selectable[0],"fluid.reorderer.selectable-initialised",true)}}if(!thatReorderer.selectableContext){thatReorderer.selectableContext=fluid.selectable(thatReorderer.container,{selectableElements:selectables,selectablesTabindex:thatReorderer.options.selectablesTabindex,direction:null})}};var dropChangeListener=function(dropTarget){fluid.moveDom(dropMarker,dropTarget.element,dropTarget.position);dropMarker.css("display","");if(mouseDropWarning){if(dropTarget.lockedelem){mouseDropWarning.show()}else{mouseDropWarning.hide()}}};var initItems=function(){var movables=thatReorderer.dom.fastLocate("movables");var dropTargets=thatReorderer.dom.fastLocate("dropTargets");initSelectables();for(var i=0;i<movables.length;i++){var item=movables[i];if(!$.data(item,"fluid.reorderer.movable-initialised")){initMovable($(item));$.data(item,"fluid.reorderer.movable-initialised",true)}}if(movables.length>0&&!dropMarker){dropMarker=createDropMarker(movables[0].tagName)}dropManager.updateGeometry(thatReorderer.layoutHandler.getGeometricInfo());dropManager.dropChangeFirer.addListener(dropChangeListener,"fluid.Reorderer");dropTargets.attr("aria-dropeffect","none")};if(thatReorderer.container){bindHandlersToContainer(thatReorderer.container,thatReorderer.handleKeyDown,thatReorderer.handleKeyUp);addRolesToContainer(thatReorderer);fluid.tabbable(thatReorderer.container);initItems()}if(options.afterMoveCallbackUrl){thatReorderer.events.afterMove.addListener(function(){var layoutHandler=thatReorderer.layoutHandler;var model=layoutHandler.getModel?layoutHandler.getModel():options.acquireModel(thatReorderer);$.post(options.afterMoveCallbackUrl,JSON.stringify(model))},"postModel")}thatReorderer.events.onHover.addListener(hoverStyleHandler,"style");thatReorderer.refresh=function(){thatReorderer.dom.refresh("movables");thatReorderer.dom.refresh("selectables");thatReorderer.dom.refresh("grabHandle",thatReorderer.dom.fastLocate("movables"));thatReorderer.dom.refresh("stylisticOffset",thatReorderer.dom.fastLocate("movables"));thatReorderer.dom.refresh("dropTargets");thatReorderer.events.onRefresh.fire();initItems();thatReorderer.selectableContext.selectables=thatReorderer.dom.fastLocate("selectables");thatReorderer.selectableContext.selectablesUpdated(thatReorderer.activeItem)};thatReorderer.refresh();return thatReorderer};fluid.reorderer.keys={TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,META:19,SPACE:32,LEFT:37,UP:38,RIGHT:39,DOWN:40,i:73,j:74,k:75,m:77};fluid.reorderer.defaultKeysets=[{modifier:function(evt){return evt.ctrlKey},up:fluid.reorderer.keys.UP,down:fluid.reorderer.keys.DOWN,right:fluid.reorderer.keys.RIGHT,left:fluid.reorderer.keys.LEFT},{modifier:function(evt){return evt.ctrlKey},up:fluid.reorderer.keys.i,down:fluid.reorderer.keys.m,right:fluid.reorderer.keys.k,left:fluid.reorderer.keys.j}];fluid.reorderer.roles={GRID:{container:"grid",item:"gridcell"},LIST:{container:"list",item:"listitem"},REGIONS:{container:"main",item:"article"}};var simpleInit=function(container,layoutHandler,options){options=options||{};options.layoutHandler=layoutHandler;return fluid.reorderer(container,options)};fluid.reorderList=function(container,options){return simpleInit(container,"fluid.listLayoutHandler",options)};fluid.reorderGrid=function(container,options){return simpleInit(container,"fluid.gridLayoutHandler",options)};fluid.reorderer.SHUFFLE_GEOMETRIC_STRATEGY="shuffleProjectFrom";fluid.reorderer.GEOMETRIC_STRATEGY="projectFrom";fluid.reorderer.LOGICAL_STRATEGY="logicalFrom";fluid.reorderer.WRAP_LOCKED_STRATEGY="lockedWrapFrom";fluid.reorderer.NO_STRATEGY=null;fluid.reorderer.relativeInfoGetter=function(orientation,coStrategy,contraStrategy,dropManager,dom){return function(item,direction,forSelection){var dirorient=fluid.directionOrientation(direction);var strategy=dirorient===orientation?coStrategy:contraStrategy;return strategy!==null?dropManager[strategy](item,direction,forSelection):null}};fluid.defaults("fluid.reorderer",{styles:{defaultStyle:"fl-reorderer-movable-default",selected:"fl-reorderer-movable-selected",dragging:"fl-reorderer-movable-dragging",mouseDrag:"fl-reorderer-movable-dragging",hover:"fl-reorderer-movable-hover",dropMarker:"fl-reorderer-dropMarker",avatar:"fl-reorderer-avatar"},selectors:{dropWarning:".flc-reorderer-dropWarning",movables:".flc-reorderer-movable",grabHandle:"",stylisticOffset:""},avatarCreator:defaultAvatarCreator,keysets:fluid.reorderer.defaultKeysets,layoutHandler:{type:"fluid.listLayoutHandler"},events:{onShowKeyboardDropWarning:null,onSelect:null,onBeginMove:"preventable",onMove:null,afterMove:null,onHover:null,onRefresh:null},mergePolicy:{keysets:"replace","selectors.selectables":"selectors.movables","selectors.dropTargets":"selectors.movables"}});function geometricInfoGetter(orientation,sentinelize,dom){return function(){return{sentinelize:sentinelize,extents:[{orientation:orientation,elements:dom.fastLocate("dropTargets")}],elementMapper:function(element){return $.inArray(element,dom.fastLocate("movables"))===-1?"locked":null}}}}fluid.defaults(true,"fluid.listLayoutHandler",{orientation:fluid.orientation.VERTICAL,containerRole:fluid.reorderer.roles.LIST,selectablesTabindex:-1,sentinelize:true});fluid.listLayoutHandler=function(container,options,dropManager,dom){var that={};that.getRelativePosition=fluid.reorderer.relativeInfoGetter(options.orientation,fluid.reorderer.LOGICAL_STRATEGY,null,dropManager,dom);that.getGeometricInfo=geometricInfoGetter(options.orientation,options.sentinelize,dom);return that};fluid.defaults(true,"fluid.gridLayoutHandler",{orientation:fluid.orientation.HORIZONTAL,containerRole:fluid.reorderer.roles.GRID,selectablesTabindex:-1,sentinelize:false});fluid.gridLayoutHandler=function(container,options,dropManager,dom){var that={};that.getRelativePosition=fluid.reorderer.relativeInfoGetter(options.orientation,fluid.reorderer.LOGICAL_STRATEGY,fluid.reorderer.SHUFFLE_GEOMETRIC_STRATEGY,dropManager,dom);that.getGeometricInfo=geometricInfoGetter(options.orientation,options.sentinelize,dom);return that}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var deriveLightboxCellBase=function(namebase,index){return namebase+"lightbox-cell:"+index+":"};var addThumbnailActivateHandler=function(container){var enterKeyHandler=function(evt){if(evt.which===fluid.reorderer.keys.ENTER){var thumbnailAnchors=$("a",evt.target);document.location=thumbnailAnchors.attr("href")}};container.keypress(enterKeyHandler)};var seekNodesById=function(rootnode,tagname,idmatch){var inputs=rootnode.getElementsByTagName(tagname);var togo=[];for(var i=0;i<inputs.length;i+=1){var input=inputs[i];var id=input.id;if(id&&id.match(idmatch)){togo.push(input)}}return togo};var createImageCellFinder=function(parentNode,containerId){parentNode=fluid.unwrap(parentNode);var lightboxCellNamePattern="^"+deriveLightboxCellBase(containerId,"[0-9]+")+"$";return function(){return seekNodesById(parentNode,"div",lightboxCellNamePattern)}};var seekForm=function(container){return fluid.findAncestor(container,function(element){return $(element).is("form")})};var seekInputs=function(container,reorderform){return seekNodesById(reorderform,"input","^"+deriveLightboxCellBase(container.attr("id"),"[^:]*")+"reorder-index$")};var mapIdsToNames=function(container,reorderform){var inputs=seekInputs(container,reorderform);for(var i=0;i<inputs.length;i++){var input=inputs[i];var name=input.name;input.name=name||input.id}};var createIDAfterMoveListener=function(container){var reorderform=seekForm(container);mapIdsToNames(container,reorderform);return function(){var inputs,i;inputs=seekInputs(container,reorderform);for(i=0;i<inputs.length;i+=1){inputs[i].value=i}if(reorderform&&reorderform.action){var order=$(reorderform).serialize();$.post(reorderform.action,order,function(type,data,evt){})}}};var setDefaultValue=function(target,path,value){var previousValue=fluid.model.getBeanValue(target,path);var valueToSet=previousValue||value;fluid.model.setBeanValue(target,path,valueToSet)};fluid.reorderImages=function(container,options){var that=fluid.initView("fluid.reorderImages",container,options);setDefaultValue(that,"options.listeners.afterMove",that.options.afterMoveCallback||createIDAfterMoveListener(that.container));setDefaultValue(that,"options.selectors.movables",createImageCellFinder(that.container,that.container.attr("id")));var reorderer=fluid.reorderer(that.container,that.options);fluid.transform(reorderer.locate("movables"),function(cell){fluid.reorderImages.addAriaRoles(that.options.selectors.imageTitle,cell)});fluid.tabindex($("a",that.container),-1);addThumbnailActivateHandler(that.container);return reorderer};fluid.reorderImages.addAriaRoles=function(imageTitle,cell){cell=$(cell);cell.attr("role","img");var title=$(imageTitle,cell);if(title[0]===cell[0]||title[0]===document){fluid.fail("Could not locate cell title using selector "+imageTitle+" in context "+fluid.dumpEl(cell))}var titleId=fluid.allocateSimpleId(title);cell.attr("aria-labelledby",titleId);var image=$("img",cell);image.attr("role","presentation");image.attr("alt","")};fluid.lightbox=fluid.reorderImages;fluid.defaults("fluid.reorderImages",{layoutHandler:"fluid.gridLayoutHandler",selectors:{imageTitle:".flc-reorderer-imageTitle"}})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.moduleLayout=fluid.moduleLayout||{};var findColumnAndItemIndices=function(item,layout){return fluid.find(layout.columns,function(column,colIndex){var index=$.inArray(item,column.elements);return index===-1?null:{columnIndex:colIndex,itemIndex:index}},{columnIndex:-1,itemIndex:-1})};var findColIndex=function(item,layout){return fluid.find(layout.columns,function(column,colIndex){return item===column.container?colIndex:null},-1)};fluid.moduleLayout.updateLayout=function(item,target,position,layout){item=fluid.unwrap(item);target=fluid.unwrap(target);var itemIndices=findColumnAndItemIndices(item,layout);layout.columns[itemIndices.columnIndex].elements.splice(itemIndices.itemIndex,1);var targetCol;if(position===fluid.position.INSIDE){targetCol=layout.columns[findColIndex(target,layout)].elements;targetCol.splice(targetCol.length,0,item)}else{var relativeItemIndices=findColumnAndItemIndices(target,layout);targetCol=layout.columns[relativeItemIndices.columnIndex].elements;position=fluid.normalisePosition(position,itemIndices.columnIndex===relativeItemIndices.columnIndex,relativeItemIndices.itemIndex,itemIndices.itemIndex);var relative=position===fluid.position.BEFORE?0:1;targetCol.splice(relativeItemIndices.itemIndex+relative,0,item)}};fluid.moduleLayout.layoutFromFlat=function(container,columns,portlets){var layout={};layout.container=container;layout.columns=fluid.transform(columns,function(column){return{container:column,elements:$.makeArray(portlets.filter(function(){return fluid.dom.isContainer(column,this)}))}});return layout};fluid.moduleLayout.layoutFromIds=function(idLayout){return{container:fluid.byId(idLayout.id),columns:fluid.transform(idLayout.columns,function(column){return{container:fluid.byId(column.id),elements:fluid.transform(column.children,fluid.byId)}})}};fluid.moduleLayout.layoutToIds=function(idLayout){return{id:fluid.getId(idLayout.container),columns:fluid.transform(idLayout.columns,function(column){return{id:fluid.getId(column.container),children:fluid.transform(column.elements,fluid.getId)}})}};var defaultOnShowKeyboardDropWarning=function(item,dropWarning){if(dropWarning){var offset=$(item).offset();dropWarning=$(dropWarning);dropWarning.css("position","absolute");dropWarning.css("top",offset.top);dropWarning.css("left",offset.left)}};fluid.defaults(true,"fluid.moduleLayoutHandler",{orientation:fluid.orientation.VERTICAL,containerRole:fluid.reorderer.roles.REGIONS,selectablesTabindex:0,sentinelize:true});fluid.moduleLayoutHandler=function(container,options,dropManager,dom){var that={};function computeLayout(){var togo;if(options.selectors.modules){togo=fluid.moduleLayout.layoutFromFlat(container,dom.locate("columns"),dom.locate("modules"))}if(!togo){var idLayout=fluid.model.getBeanValue(options,"moduleLayout.layout");fluid.moduleLayout.layoutFromIds(idLayout)}return togo}var layout=computeLayout();that.layout=layout;function isLocked(item){var lockedModules=options.selectors.lockedModules?dom.fastLocate("lockedModules"):[];return $.inArray(item,lockedModules)!==-1}that.getRelativePosition=fluid.reorderer.relativeInfoGetter(options.orientation,fluid.reorderer.WRAP_LOCKED_STRATEGY,fluid.reorderer.GEOMETRIC_STRATEGY,dropManager,dom);that.getGeometricInfo=function(){var extents=[];var togo={extents:extents,sentinelize:options.sentinelize};togo.elementMapper=function(element){return isLocked(element)?"locked":null};for(var col=0;col<layout.columns.length;col++){var column=layout.columns[col];var thisEls={orientation:options.orientation,elements:$.makeArray(column.elements),parentElement:column.container};extents.push(thisEls)}return togo};function computeModules(all){return function(){var modules=fluid.accumulate(layout.columns,function(column,list){return list.concat(column.elements)},[]);if(!all){fluid.remove_if(modules,isLocked)}return modules}}that.returnedOptions={selectors:{movables:computeModules(false),dropTargets:computeModules(false),selectables:computeModules(true)},listeners:{onMove:function(item,requestedPosition){fluid.moduleLayout.updateLayout(item,requestedPosition.element,requestedPosition.position,layout)},onRefresh:function(){layout=computeLayout();that.layout=layout},"onShowKeyboardDropWarning.setPosition":defaultOnShowKeyboardDropWarning}};that.getModel=function(){return fluid.moduleLayout.layoutToIds(layout)};return that}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.reorderLayout=function(container,userOptions){var assembleOptions={layoutHandler:"fluid.moduleLayoutHandler",selectors:{columns:".flc-reorderer-column",modules:".flc-reorderer-module"}};var options=$.extend(true,assembleOptions,userOptions);return fluid.reorderer(container,options)}})(jQuery,fluid_1_1);
/* SWFObject v2.1 <http://code.google.com/p/swfobject/>
	Copyright (c) 2007-2008 Geoff Stearns, Michael Williams, and Bobby van der Sluis
	This software is released under the MIT License <http://www.opensource.org/licenses/mit-license.php>
*/
var swfobject=function(){var UNDEF="undefined",OBJECT="object",SHOCKWAVE_FLASH="Shockwave Flash",SHOCKWAVE_FLASH_AX="ShockwaveFlash.ShockwaveFlash",FLASH_MIME_TYPE="application/x-shockwave-flash",EXPRESS_INSTALL_ID="SWFObjectExprInst",win=window,doc=document,nav=navigator,domLoadFnArr=[],regObjArr=[],objIdArr=[],listenersArr=[],script,timer=null,storedAltContent=null,storedAltContentId=null,isDomLoaded=false,isExpressInstallActive=false;var ua=function(){var w3cdom=typeof doc.getElementById!=UNDEF&&typeof doc.getElementsByTagName!=UNDEF&&typeof doc.createElement!=UNDEF,playerVersion=[0,0,0],d=null;if(typeof nav.plugins!=UNDEF&&typeof nav.plugins[SHOCKWAVE_FLASH]==OBJECT){d=nav.plugins[SHOCKWAVE_FLASH].description;if(d&&!(typeof nav.mimeTypes!=UNDEF&&nav.mimeTypes[FLASH_MIME_TYPE]&&!nav.mimeTypes[FLASH_MIME_TYPE].enabledPlugin)){d=d.replace(/^.*\s+(\S+\s+\S+$)/,"$1");playerVersion[0]=parseInt(d.replace(/^(.*)\..*$/,"$1"),10);playerVersion[1]=parseInt(d.replace(/^.*\.(.*)\s.*$/,"$1"),10);playerVersion[2]=/r/.test(d)?parseInt(d.replace(/^.*r(.*)$/,"$1"),10):0}}else{if(typeof win.ActiveXObject!=UNDEF){var a=null,fp6Crash=false;try{a=new ActiveXObject(SHOCKWAVE_FLASH_AX+".7")}catch(e){try{a=new ActiveXObject(SHOCKWAVE_FLASH_AX+".6");playerVersion=[6,0,21];a.AllowScriptAccess="always"}catch(e){if(playerVersion[0]==6){fp6Crash=true}}if(!fp6Crash){try{a=new ActiveXObject(SHOCKWAVE_FLASH_AX)}catch(e){}}}if(!fp6Crash&&a){try{d=a.GetVariable("$version");if(d){d=d.split(" ")[1].split(",");playerVersion=[parseInt(d[0],10),parseInt(d[1],10),parseInt(d[2],10)]}}catch(e){}}}}var u=nav.userAgent.toLowerCase(),p=nav.platform.toLowerCase(),webkit=/webkit/.test(u)?parseFloat(u.replace(/^.*webkit\/(\d+(\.\d+)?).*$/,"$1")):false,ie=false,windows=p?/win/.test(p):/win/.test(u),mac=p?/mac/.test(p):/mac/.test(u);
/*@cc_on
			ie = true;
			@if (@_win32)
				windows = true;
			@elif (@_mac)
				mac = true;
			@end
		@*/
return{w3cdom:w3cdom,pv:playerVersion,webkit:webkit,ie:ie,win:windows,mac:mac}}();var onDomLoad=function(){if(!ua.w3cdom){return }addDomLoadEvent(main);if(ua.ie&&ua.win){try{doc.write("<script id=__ie_ondomload defer=true src=//:><\/script>");script=getElementById("__ie_ondomload");if(script){addListener(script,"onreadystatechange",checkReadyState)}}catch(e){}}if(ua.webkit&&typeof doc.readyState!=UNDEF){timer=setInterval(function(){if(/loaded|complete/.test(doc.readyState)){callDomLoadFunctions()}},10)}if(typeof doc.addEventListener!=UNDEF){doc.addEventListener("DOMContentLoaded",callDomLoadFunctions,null)}addLoadEvent(callDomLoadFunctions)}();function checkReadyState(){if(script.readyState=="complete"){script.parentNode.removeChild(script);callDomLoadFunctions()}}function callDomLoadFunctions(){if(isDomLoaded){return }if(ua.ie&&ua.win){var s=createElement("span");try{var t=doc.getElementsByTagName("body")[0].appendChild(s);t.parentNode.removeChild(t)}catch(e){return }}isDomLoaded=true;if(timer){clearInterval(timer);timer=null}var dl=domLoadFnArr.length;for(var i=0;i<dl;i++){domLoadFnArr[i]()}}function addDomLoadEvent(fn){if(isDomLoaded){fn()}else{domLoadFnArr[domLoadFnArr.length]=fn}}function addLoadEvent(fn){if(typeof win.addEventListener!=UNDEF){win.addEventListener("load",fn,false)}else{if(typeof doc.addEventListener!=UNDEF){doc.addEventListener("load",fn,false)}else{if(typeof win.attachEvent!=UNDEF){addListener(win,"onload",fn)}else{if(typeof win.onload=="function"){var fnOld=win.onload;win.onload=function(){fnOld();fn()}}else{win.onload=fn}}}}}function main(){var rl=regObjArr.length;for(var i=0;i<rl;i++){var id=regObjArr[i].id;if(ua.pv[0]>0){var obj=getElementById(id);if(obj){regObjArr[i].width=obj.getAttribute("width")?obj.getAttribute("width"):"0";regObjArr[i].height=obj.getAttribute("height")?obj.getAttribute("height"):"0";if(hasPlayerVersion(regObjArr[i].swfVersion)){if(ua.webkit&&ua.webkit<312){fixParams(obj)}setVisibility(id,true)}else{if(regObjArr[i].expressInstall&&!isExpressInstallActive&&hasPlayerVersion("6.0.65")&&(ua.win||ua.mac)){showExpressInstall(regObjArr[i])}else{displayAltContent(obj)}}}}else{setVisibility(id,true)}}}function fixParams(obj){var nestedObj=obj.getElementsByTagName(OBJECT)[0];if(nestedObj){var e=createElement("embed"),a=nestedObj.attributes;if(a){var al=a.length;for(var i=0;i<al;i++){if(a[i].nodeName=="DATA"){e.setAttribute("src",a[i].nodeValue)}else{e.setAttribute(a[i].nodeName,a[i].nodeValue)}}}var c=nestedObj.childNodes;if(c){var cl=c.length;for(var j=0;j<cl;j++){if(c[j].nodeType==1&&c[j].nodeName=="PARAM"){e.setAttribute(c[j].getAttribute("name"),c[j].getAttribute("value"))}}}obj.parentNode.replaceChild(e,obj)}}function showExpressInstall(regObj){isExpressInstallActive=true;var obj=getElementById(regObj.id);if(obj){if(regObj.altContentId){var ac=getElementById(regObj.altContentId);if(ac){storedAltContent=ac;storedAltContentId=regObj.altContentId}}else{storedAltContent=abstractAltContent(obj)}if(!(/%$/.test(regObj.width))&&parseInt(regObj.width,10)<310){regObj.width="310"}if(!(/%$/.test(regObj.height))&&parseInt(regObj.height,10)<137){regObj.height="137"}doc.title=doc.title.slice(0,47)+" - Flash Player Installation";var pt=ua.ie&&ua.win?"ActiveX":"PlugIn",dt=doc.title,fv="MMredirectURL="+win.location+"&MMplayerType="+pt+"&MMdoctitle="+dt,replaceId=regObj.id;if(ua.ie&&ua.win&&obj.readyState!=4){var newObj=createElement("div");replaceId+="SWFObjectNew";newObj.setAttribute("id",replaceId);obj.parentNode.insertBefore(newObj,obj);obj.style.display="none";var fn=function(){obj.parentNode.removeChild(obj)};addListener(win,"onload",fn)}createSWF({data:regObj.expressInstall,id:EXPRESS_INSTALL_ID,width:regObj.width,height:regObj.height},{flashvars:fv},replaceId)}}function displayAltContent(obj){if(ua.ie&&ua.win&&obj.readyState!=4){var el=createElement("div");obj.parentNode.insertBefore(el,obj);el.parentNode.replaceChild(abstractAltContent(obj),el);obj.style.display="none";var fn=function(){obj.parentNode.removeChild(obj)};addListener(win,"onload",fn)}else{obj.parentNode.replaceChild(abstractAltContent(obj),obj)}}function abstractAltContent(obj){var ac=createElement("div");if(ua.win&&ua.ie){ac.innerHTML=obj.innerHTML}else{var nestedObj=obj.getElementsByTagName(OBJECT)[0];if(nestedObj){var c=nestedObj.childNodes;if(c){var cl=c.length;for(var i=0;i<cl;i++){if(!(c[i].nodeType==1&&c[i].nodeName=="PARAM")&&!(c[i].nodeType==8)){ac.appendChild(c[i].cloneNode(true))}}}}}return ac}function createSWF(attObj,parObj,id){var r,el=getElementById(id);if(el){if(typeof attObj.id==UNDEF){attObj.id=id}if(ua.ie&&ua.win){var att="";for(var i in attObj){if(attObj[i]!=Object.prototype[i]){if(i.toLowerCase()=="data"){parObj.movie=attObj[i]}else{if(i.toLowerCase()=="styleclass"){att+=' class="'+attObj[i]+'"'}else{if(i.toLowerCase()!="classid"){att+=" "+i+'="'+attObj[i]+'"'}}}}}var par="";for(var j in parObj){if(parObj[j]!=Object.prototype[j]){par+='<param name="'+j+'" value="'+parObj[j]+'" />'}}el.outerHTML='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'+att+">"+par+"</object>";objIdArr[objIdArr.length]=attObj.id;r=getElementById(attObj.id)}else{if(ua.webkit&&ua.webkit<312){var e=createElement("embed");e.setAttribute("type",FLASH_MIME_TYPE);for(var k in attObj){if(attObj[k]!=Object.prototype[k]){if(k.toLowerCase()=="data"){e.setAttribute("src",attObj[k])}else{if(k.toLowerCase()=="styleclass"){e.setAttribute("class",attObj[k])}else{if(k.toLowerCase()!="classid"){e.setAttribute(k,attObj[k])}}}}}for(var l in parObj){if(parObj[l]!=Object.prototype[l]){if(l.toLowerCase()!="movie"){e.setAttribute(l,parObj[l])}}}el.parentNode.replaceChild(e,el);r=e}else{var o=createElement(OBJECT);o.setAttribute("type",FLASH_MIME_TYPE);for(var m in attObj){if(attObj[m]!=Object.prototype[m]){if(m.toLowerCase()=="styleclass"){o.setAttribute("class",attObj[m])}else{if(m.toLowerCase()!="classid"){o.setAttribute(m,attObj[m])}}}}for(var n in parObj){if(parObj[n]!=Object.prototype[n]&&n.toLowerCase()!="movie"){createObjParam(o,n,parObj[n])}}el.parentNode.replaceChild(o,el);r=o}}}return r}function createObjParam(el,pName,pValue){var p=createElement("param");p.setAttribute("name",pName);p.setAttribute("value",pValue);el.appendChild(p)}function removeSWF(id){var obj=getElementById(id);if(obj&&(obj.nodeName=="OBJECT"||obj.nodeName=="EMBED")){if(ua.ie&&ua.win){if(obj.readyState==4){removeObjectInIE(id)}else{win.attachEvent("onload",function(){removeObjectInIE(id)})}}else{obj.parentNode.removeChild(obj)}}}function removeObjectInIE(id){var obj=getElementById(id);if(obj){for(var i in obj){if(typeof obj[i]=="function"){obj[i]=null}}obj.parentNode.removeChild(obj)}}function getElementById(id){var el=null;try{el=doc.getElementById(id)}catch(e){}return el}function createElement(el){return doc.createElement(el)}function addListener(target,eventType,fn){target.attachEvent(eventType,fn);listenersArr[listenersArr.length]=[target,eventType,fn]}function hasPlayerVersion(rv){var pv=ua.pv,v=rv.split(".");v[0]=parseInt(v[0],10);v[1]=parseInt(v[1],10)||0;v[2]=parseInt(v[2],10)||0;return(pv[0]>v[0]||(pv[0]==v[0]&&pv[1]>v[1])||(pv[0]==v[0]&&pv[1]==v[1]&&pv[2]>=v[2]))?true:false}function createCSS(sel,decl){if(ua.ie&&ua.mac){return }var h=doc.getElementsByTagName("head")[0],s=createElement("style");s.setAttribute("type","text/css");s.setAttribute("media","screen");if(!(ua.ie&&ua.win)&&typeof doc.createTextNode!=UNDEF){s.appendChild(doc.createTextNode(sel+" {"+decl+"}"))}h.appendChild(s);if(ua.ie&&ua.win&&typeof doc.styleSheets!=UNDEF&&doc.styleSheets.length>0){var ls=doc.styleSheets[doc.styleSheets.length-1];if(typeof ls.addRule==OBJECT){ls.addRule(sel,decl)}}}function setVisibility(id,isVisible){var v=isVisible?"visible":"hidden";if(isDomLoaded&&getElementById(id)){getElementById(id).style.visibility=v}else{createCSS("#"+id,"visibility:"+v)}}function urlEncodeIfNecessary(s){var regex=/[\\\"<>\.;]/;var hasBadChars=regex.exec(s)!=null;return hasBadChars?encodeURIComponent(s):s}var cleanup=function(){if(ua.ie&&ua.win){window.attachEvent("onunload",function(){var ll=listenersArr.length;for(var i=0;i<ll;i++){listenersArr[i][0].detachEvent(listenersArr[i][1],listenersArr[i][2])}var il=objIdArr.length;for(var j=0;j<il;j++){removeSWF(objIdArr[j])}for(var k in ua){ua[k]=null}ua=null;for(var l in swfobject){swfobject[l]=null}swfobject=null})}}();return{registerObject:function(objectIdStr,swfVersionStr,xiSwfUrlStr){if(!ua.w3cdom||!objectIdStr||!swfVersionStr){return }var regObj={};regObj.id=objectIdStr;regObj.swfVersion=swfVersionStr;regObj.expressInstall=xiSwfUrlStr?xiSwfUrlStr:false;regObjArr[regObjArr.length]=regObj;setVisibility(objectIdStr,false)},getObjectById:function(objectIdStr){var r=null;if(ua.w3cdom){var o=getElementById(objectIdStr);if(o){var n=o.getElementsByTagName(OBJECT)[0];if(!n||(n&&typeof o.SetVariable!=UNDEF)){r=o}else{if(typeof n.SetVariable!=UNDEF){r=n}}}}return r},embedSWF:function(swfUrlStr,replaceElemIdStr,widthStr,heightStr,swfVersionStr,xiSwfUrlStr,flashvarsObj,parObj,attObj){if(!ua.w3cdom||!swfUrlStr||!replaceElemIdStr||!widthStr||!heightStr||!swfVersionStr){return }widthStr+="";heightStr+="";if(hasPlayerVersion(swfVersionStr)){setVisibility(replaceElemIdStr,false);var att={};if(attObj&&typeof attObj===OBJECT){for(var i in attObj){if(attObj[i]!=Object.prototype[i]){att[i]=attObj[i]}}}att.data=swfUrlStr;att.width=widthStr;att.height=heightStr;var par={};if(parObj&&typeof parObj===OBJECT){for(var j in parObj){if(parObj[j]!=Object.prototype[j]){par[j]=parObj[j]}}}if(flashvarsObj&&typeof flashvarsObj===OBJECT){for(var k in flashvarsObj){if(flashvarsObj[k]!=Object.prototype[k]){if(typeof par.flashvars!=UNDEF){par.flashvars+="&"+k+"="+flashvarsObj[k]}else{par.flashvars=k+"="+flashvarsObj[k]}}}}addDomLoadEvent(function(){createSWF(att,par,replaceElemIdStr);if(att.id==replaceElemIdStr){setVisibility(replaceElemIdStr,true)}})}else{if(xiSwfUrlStr&&!isExpressInstallActive&&hasPlayerVersion("6.0.65")&&(ua.win||ua.mac)){isExpressInstallActive=true;setVisibility(replaceElemIdStr,false);addDomLoadEvent(function(){var regObj={};regObj.id=regObj.altContentId=replaceElemIdStr;regObj.width=widthStr;regObj.height=heightStr;regObj.expressInstall=xiSwfUrlStr;showExpressInstall(regObj)})}}},getFlashPlayerVersion:function(){return{major:ua.pv[0],minor:ua.pv[1],release:ua.pv[2]}},hasFlashPlayerVersion:hasPlayerVersion,createSWF:function(attObj,parObj,replaceElemIdStr){if(ua.w3cdom){return createSWF(attObj,parObj,replaceElemIdStr)}else{return undefined}},removeSWF:function(objElemIdStr){if(ua.w3cdom){removeSWF(objElemIdStr)}},createCSS:function(sel,decl){if(ua.w3cdom){createCSS(sel,decl)}},addDomLoadEvent:addDomLoadEvent,addLoadEvent:addLoadEvent,getQueryParamValue:function(param){var q=doc.location.search||doc.location.hash;if(param==null){return urlEncodeIfNecessary(q)}if(q){var pairs=q.substring(1).split("&");for(var i=0;i<pairs.length;i++){if(pairs[i].substring(0,pairs[i].indexOf("="))==param){return urlEncodeIfNecessary(pairs[i].substring((pairs[i].indexOf("=")+1)))}}}return""},expressInstallCallback:function(){if(isExpressInstallActive&&storedAltContent){var obj=getElementById(EXPRESS_INSTALL_ID);if(obj){obj.parentNode.replaceChild(storedAltContent,obj);if(storedAltContentId){setVisibility(storedAltContentId,true);if(ua.ie&&ua.win){storedAltContent.style.display="block"}}storedAltContent=null;storedAltContentId=null;isExpressInstallActive=false}}}}}();var SWFUpload;if(SWFUpload==undefined){SWFUpload=function(settings){this.initSWFUpload(settings)}}SWFUpload.prototype.initSWFUpload=function(settings){try{this.customSettings={};this.settings=settings;this.eventQueue=[];this.movieName="SWFUpload_"+SWFUpload.movieCount++;this.movieElement=null;SWFUpload.instances[this.movieName]=this;this.initSettings();this.loadFlash();this.displayDebugInfo()}catch(ex){delete SWFUpload.instances[this.movieName];throw ex}};SWFUpload.instances={};SWFUpload.movieCount=0;SWFUpload.version="2.2.0 2009-03-25";SWFUpload.QUEUE_ERROR={QUEUE_LIMIT_EXCEEDED:-100,FILE_EXCEEDS_SIZE_LIMIT:-110,ZERO_BYTE_FILE:-120,INVALID_FILETYPE:-130};SWFUpload.UPLOAD_ERROR={HTTP_ERROR:-200,MISSING_UPLOAD_URL:-210,IO_ERROR:-220,SECURITY_ERROR:-230,UPLOAD_LIMIT_EXCEEDED:-240,UPLOAD_FAILED:-250,SPECIFIED_FILE_ID_NOT_FOUND:-260,FILE_VALIDATION_FAILED:-270,FILE_CANCELLED:-280,UPLOAD_STOPPED:-290};SWFUpload.FILE_STATUS={QUEUED:-1,IN_PROGRESS:-2,ERROR:-3,COMPLETE:-4,CANCELLED:-5};SWFUpload.BUTTON_ACTION={SELECT_FILE:-100,SELECT_FILES:-110,START_UPLOAD:-120};SWFUpload.CURSOR={ARROW:-1,HAND:-2};SWFUpload.WINDOW_MODE={WINDOW:"window",TRANSPARENT:"transparent",OPAQUE:"opaque"};SWFUpload.completeURL=function(url){if(typeof (url)!=="string"||url.match(/^https?:\/\//i)||url.match(/^\//)){return url}var currentURL=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"");var indexSlash=window.location.pathname.lastIndexOf("/");if(indexSlash<=0){path="/"}else{path=window.location.pathname.substr(0,indexSlash)+"/"}return path+url};SWFUpload.prototype.initSettings=function(){this.ensureDefault=function(settingName,defaultValue){this.settings[settingName]=(this.settings[settingName]==undefined)?defaultValue:this.settings[settingName]};this.ensureDefault("upload_url","");this.ensureDefault("preserve_relative_urls",false);this.ensureDefault("file_post_name","Filedata");this.ensureDefault("post_params",{});this.ensureDefault("use_query_string",false);this.ensureDefault("requeue_on_error",false);this.ensureDefault("http_success",[]);this.ensureDefault("assume_success_timeout",0);this.ensureDefault("file_types","*.*");this.ensureDefault("file_types_description","All Files");this.ensureDefault("file_size_limit",0);this.ensureDefault("file_upload_limit",0);this.ensureDefault("file_queue_limit",0);this.ensureDefault("flash_url","swfupload.swf");this.ensureDefault("prevent_swf_caching",true);this.ensureDefault("button_image_url","");this.ensureDefault("button_width",1);this.ensureDefault("button_height",1);this.ensureDefault("button_text","");this.ensureDefault("button_text_style","color: #000000; font-size: 16pt;");this.ensureDefault("button_text_top_padding",0);this.ensureDefault("button_text_left_padding",0);this.ensureDefault("button_action",SWFUpload.BUTTON_ACTION.SELECT_FILES);this.ensureDefault("button_disabled",false);this.ensureDefault("button_placeholder_id","");this.ensureDefault("button_placeholder",null);this.ensureDefault("button_cursor",SWFUpload.CURSOR.ARROW);this.ensureDefault("button_window_mode",SWFUpload.WINDOW_MODE.WINDOW);this.ensureDefault("debug",false);this.settings.debug_enabled=this.settings.debug;this.settings.return_upload_start_handler=this.returnUploadStart;this.ensureDefault("swfupload_loaded_handler",null);this.ensureDefault("file_dialog_start_handler",null);this.ensureDefault("file_queued_handler",null);this.ensureDefault("file_queue_error_handler",null);this.ensureDefault("file_dialog_complete_handler",null);this.ensureDefault("upload_start_handler",null);this.ensureDefault("upload_progress_handler",null);this.ensureDefault("upload_error_handler",null);this.ensureDefault("upload_success_handler",null);this.ensureDefault("upload_complete_handler",null);this.ensureDefault("debug_handler",this.debugMessage);this.ensureDefault("custom_settings",{});this.customSettings=this.settings.custom_settings;if(!!this.settings.prevent_swf_caching){this.settings.flash_url=this.settings.flash_url+(this.settings.flash_url.indexOf("?")<0?"?":"&")+"preventswfcaching="+new Date().getTime()}if(!this.settings.preserve_relative_urls){this.settings.upload_url=SWFUpload.completeURL(this.settings.upload_url);this.settings.button_image_url=SWFUpload.completeURL(this.settings.button_image_url)}delete this.ensureDefault};SWFUpload.prototype.loadFlash=function(){var targetElement,tempParent;if(document.getElementById(this.movieName)!==null){throw"ID "+this.movieName+" is already in use. The Flash Object could not be added"}targetElement=document.getElementById(this.settings.button_placeholder_id)||this.settings.button_placeholder;if(targetElement==undefined){throw"Could not find the placeholder element: "+this.settings.button_placeholder_id}tempParent=document.createElement("div");tempParent.innerHTML=this.getFlashHTML();targetElement.parentNode.replaceChild(tempParent.firstChild,targetElement);if(window[this.movieName]==undefined){window[this.movieName]=this.getMovieElement()}};SWFUpload.prototype.getFlashHTML=function(){return['<object id="',this.movieName,'" type="application/x-shockwave-flash" data="',this.settings.flash_url,'" width="',this.settings.button_width,'" height="',this.settings.button_height,'" class="swfupload">','<param name="wmode" value="',this.settings.button_window_mode,'" />','<param name="movie" value="',this.settings.flash_url,'" />','<param name="quality" value="high" />','<param name="menu" value="false" />','<param name="allowScriptAccess" value="always" />','<param name="flashvars" value="'+this.getFlashVars()+'" />',"</object>"].join("")};SWFUpload.prototype.getFlashVars=function(){var paramString=this.buildParamString();var httpSuccessString=this.settings.http_success.join(",");return["movieName=",encodeURIComponent(this.movieName),"&amp;uploadURL=",encodeURIComponent(this.settings.upload_url),"&amp;useQueryString=",encodeURIComponent(this.settings.use_query_string),"&amp;requeueOnError=",encodeURIComponent(this.settings.requeue_on_error),"&amp;httpSuccess=",encodeURIComponent(httpSuccessString),"&amp;assumeSuccessTimeout=",encodeURIComponent(this.settings.assume_success_timeout),"&amp;params=",encodeURIComponent(paramString),"&amp;filePostName=",encodeURIComponent(this.settings.file_post_name),"&amp;fileTypes=",encodeURIComponent(this.settings.file_types),"&amp;fileTypesDescription=",encodeURIComponent(this.settings.file_types_description),"&amp;fileSizeLimit=",encodeURIComponent(this.settings.file_size_limit),"&amp;fileUploadLimit=",encodeURIComponent(this.settings.file_upload_limit),"&amp;fileQueueLimit=",encodeURIComponent(this.settings.file_queue_limit),"&amp;debugEnabled=",encodeURIComponent(this.settings.debug_enabled),"&amp;buttonImageURL=",encodeURIComponent(this.settings.button_image_url),"&amp;buttonWidth=",encodeURIComponent(this.settings.button_width),"&amp;buttonHeight=",encodeURIComponent(this.settings.button_height),"&amp;buttonText=",encodeURIComponent(this.settings.button_text),"&amp;buttonTextTopPadding=",encodeURIComponent(this.settings.button_text_top_padding),"&amp;buttonTextLeftPadding=",encodeURIComponent(this.settings.button_text_left_padding),"&amp;buttonTextStyle=",encodeURIComponent(this.settings.button_text_style),"&amp;buttonAction=",encodeURIComponent(this.settings.button_action),"&amp;buttonDisabled=",encodeURIComponent(this.settings.button_disabled),"&amp;buttonCursor=",encodeURIComponent(this.settings.button_cursor)].join("")};SWFUpload.prototype.getMovieElement=function(){if(this.movieElement==undefined){this.movieElement=document.getElementById(this.movieName)}if(this.movieElement===null){throw"Could not find Flash element"}return this.movieElement};SWFUpload.prototype.buildParamString=function(){var postParams=this.settings.post_params;var paramStringPairs=[];if(typeof (postParams)==="object"){for(var name in postParams){if(postParams.hasOwnProperty(name)){paramStringPairs.push(encodeURIComponent(name.toString())+"="+encodeURIComponent(postParams[name].toString()))}}}return paramStringPairs.join("&amp;")};SWFUpload.prototype.destroy=function(){try{this.cancelUpload(null,false);var movieElement=null;movieElement=this.getMovieElement();if(movieElement&&typeof (movieElement.CallFunction)==="unknown"){for(var i in movieElement){try{if(typeof (movieElement[i])==="function"){movieElement[i]=null}}catch(ex1){}}try{movieElement.parentNode.removeChild(movieElement)}catch(ex){}}window[this.movieName]=null;SWFUpload.instances[this.movieName]=null;delete SWFUpload.instances[this.movieName];this.movieElement=null;this.settings=null;this.customSettings=null;this.eventQueue=null;this.movieName=null;return true}catch(ex2){return false}};SWFUpload.prototype.displayDebugInfo=function(){this.debug(["---SWFUpload Instance Info---\n","Version: ",SWFUpload.version,"\n","Movie Name: ",this.movieName,"\n","Settings:\n","\t","upload_url:               ",this.settings.upload_url,"\n","\t","flash_url:                ",this.settings.flash_url,"\n","\t","use_query_string:         ",this.settings.use_query_string.toString(),"\n","\t","requeue_on_error:         ",this.settings.requeue_on_error.toString(),"\n","\t","http_success:             ",this.settings.http_success.join(", "),"\n","\t","assume_success_timeout:   ",this.settings.assume_success_timeout,"\n","\t","file_post_name:           ",this.settings.file_post_name,"\n","\t","post_params:              ",this.settings.post_params.toString(),"\n","\t","file_types:               ",this.settings.file_types,"\n","\t","file_types_description:   ",this.settings.file_types_description,"\n","\t","file_size_limit:          ",this.settings.file_size_limit,"\n","\t","file_upload_limit:        ",this.settings.file_upload_limit,"\n","\t","file_queue_limit:         ",this.settings.file_queue_limit,"\n","\t","debug:                    ",this.settings.debug.toString(),"\n","\t","prevent_swf_caching:      ",this.settings.prevent_swf_caching.toString(),"\n","\t","button_placeholder_id:    ",this.settings.button_placeholder_id.toString(),"\n","\t","button_placeholder:       ",(this.settings.button_placeholder?"Set":"Not Set"),"\n","\t","button_image_url:         ",this.settings.button_image_url.toString(),"\n","\t","button_width:             ",this.settings.button_width.toString(),"\n","\t","button_height:            ",this.settings.button_height.toString(),"\n","\t","button_text:              ",this.settings.button_text.toString(),"\n","\t","button_text_style:        ",this.settings.button_text_style.toString(),"\n","\t","button_text_top_padding:  ",this.settings.button_text_top_padding.toString(),"\n","\t","button_text_left_padding: ",this.settings.button_text_left_padding.toString(),"\n","\t","button_action:            ",this.settings.button_action.toString(),"\n","\t","button_disabled:          ",this.settings.button_disabled.toString(),"\n","\t","custom_settings:          ",this.settings.custom_settings.toString(),"\n","Event Handlers:\n","\t","swfupload_loaded_handler assigned:  ",(typeof this.settings.swfupload_loaded_handler==="function").toString(),"\n","\t","file_dialog_start_handler assigned: ",(typeof this.settings.file_dialog_start_handler==="function").toString(),"\n","\t","file_queued_handler assigned:       ",(typeof this.settings.file_queued_handler==="function").toString(),"\n","\t","file_queue_error_handler assigned:  ",(typeof this.settings.file_queue_error_handler==="function").toString(),"\n","\t","upload_start_handler assigned:      ",(typeof this.settings.upload_start_handler==="function").toString(),"\n","\t","upload_progress_handler assigned:   ",(typeof this.settings.upload_progress_handler==="function").toString(),"\n","\t","upload_error_handler assigned:      ",(typeof this.settings.upload_error_handler==="function").toString(),"\n","\t","upload_success_handler assigned:    ",(typeof this.settings.upload_success_handler==="function").toString(),"\n","\t","upload_complete_handler assigned:   ",(typeof this.settings.upload_complete_handler==="function").toString(),"\n","\t","debug_handler assigned:             ",(typeof this.settings.debug_handler==="function").toString(),"\n"].join(""))};SWFUpload.prototype.addSetting=function(name,value,default_value){if(value==undefined){return(this.settings[name]=default_value)}else{return(this.settings[name]=value)}};SWFUpload.prototype.getSetting=function(name){if(this.settings[name]!=undefined){return this.settings[name]}return""};SWFUpload.prototype.callFlash=function(functionName,argumentArray){argumentArray=argumentArray||[];var movieElement=this.getMovieElement();var returnValue,returnString;try{returnString=movieElement.CallFunction('<invoke name="'+functionName+'" returntype="javascript">'+__flash__argumentsToXML(argumentArray,0)+"</invoke>");returnValue=eval(returnString)}catch(ex){throw"Call to "+functionName+" failed"}if(returnValue!=undefined&&typeof returnValue.post==="object"){returnValue=this.unescapeFilePostParams(returnValue)}return returnValue};SWFUpload.prototype.selectFile=function(){this.callFlash("SelectFile")};SWFUpload.prototype.selectFiles=function(){this.callFlash("SelectFiles")};SWFUpload.prototype.startUpload=function(fileID){this.callFlash("StartUpload",[fileID])};SWFUpload.prototype.cancelUpload=function(fileID,triggerErrorEvent){if(triggerErrorEvent!==false){triggerErrorEvent=true}this.callFlash("CancelUpload",[fileID,triggerErrorEvent])};SWFUpload.prototype.stopUpload=function(){this.callFlash("StopUpload")};SWFUpload.prototype.getStats=function(){return this.callFlash("GetStats")};SWFUpload.prototype.setStats=function(statsObject){this.callFlash("SetStats",[statsObject])};SWFUpload.prototype.getFile=function(fileID){if(typeof (fileID)==="number"){return this.callFlash("GetFileByIndex",[fileID])}else{return this.callFlash("GetFile",[fileID])}};SWFUpload.prototype.addFileParam=function(fileID,name,value){return this.callFlash("AddFileParam",[fileID,name,value])};SWFUpload.prototype.removeFileParam=function(fileID,name){this.callFlash("RemoveFileParam",[fileID,name])};SWFUpload.prototype.setUploadURL=function(url){this.settings.upload_url=url.toString();this.callFlash("SetUploadURL",[url])};SWFUpload.prototype.setPostParams=function(paramsObject){this.settings.post_params=paramsObject;this.callFlash("SetPostParams",[paramsObject])};SWFUpload.prototype.addPostParam=function(name,value){this.settings.post_params[name]=value;this.callFlash("SetPostParams",[this.settings.post_params])};SWFUpload.prototype.removePostParam=function(name){delete this.settings.post_params[name];this.callFlash("SetPostParams",[this.settings.post_params])};SWFUpload.prototype.setFileTypes=function(types,description){this.settings.file_types=types;this.settings.file_types_description=description;this.callFlash("SetFileTypes",[types,description])};SWFUpload.prototype.setFileSizeLimit=function(fileSizeLimit){this.settings.file_size_limit=fileSizeLimit;this.callFlash("SetFileSizeLimit",[fileSizeLimit])};SWFUpload.prototype.setFileUploadLimit=function(fileUploadLimit){this.settings.file_upload_limit=fileUploadLimit;this.callFlash("SetFileUploadLimit",[fileUploadLimit])};SWFUpload.prototype.setFileQueueLimit=function(fileQueueLimit){this.settings.file_queue_limit=fileQueueLimit;this.callFlash("SetFileQueueLimit",[fileQueueLimit])};SWFUpload.prototype.setFilePostName=function(filePostName){this.settings.file_post_name=filePostName;this.callFlash("SetFilePostName",[filePostName])};SWFUpload.prototype.setUseQueryString=function(useQueryString){this.settings.use_query_string=useQueryString;this.callFlash("SetUseQueryString",[useQueryString])};SWFUpload.prototype.setRequeueOnError=function(requeueOnError){this.settings.requeue_on_error=requeueOnError;this.callFlash("SetRequeueOnError",[requeueOnError])};SWFUpload.prototype.setHTTPSuccess=function(http_status_codes){if(typeof http_status_codes==="string"){http_status_codes=http_status_codes.replace(" ","").split(",")}this.settings.http_success=http_status_codes;this.callFlash("SetHTTPSuccess",[http_status_codes])};SWFUpload.prototype.setAssumeSuccessTimeout=function(timeout_seconds){this.settings.assume_success_timeout=timeout_seconds;this.callFlash("SetAssumeSuccessTimeout",[timeout_seconds])};SWFUpload.prototype.setDebugEnabled=function(debugEnabled){this.settings.debug_enabled=debugEnabled;this.callFlash("SetDebugEnabled",[debugEnabled])};SWFUpload.prototype.setButtonImageURL=function(buttonImageURL){if(buttonImageURL==undefined){buttonImageURL=""}this.settings.button_image_url=buttonImageURL;this.callFlash("SetButtonImageURL",[buttonImageURL])};SWFUpload.prototype.setButtonDimensions=function(width,height){this.settings.button_width=width;this.settings.button_height=height;var movie=this.getMovieElement();if(movie!=undefined){movie.style.width=width+"px";movie.style.height=height+"px"}this.callFlash("SetButtonDimensions",[width,height])};SWFUpload.prototype.setButtonText=function(html){this.settings.button_text=html;this.callFlash("SetButtonText",[html])};SWFUpload.prototype.setButtonTextPadding=function(left,top){this.settings.button_text_top_padding=top;this.settings.button_text_left_padding=left;this.callFlash("SetButtonTextPadding",[left,top])};SWFUpload.prototype.setButtonTextStyle=function(css){this.settings.button_text_style=css;this.callFlash("SetButtonTextStyle",[css])};SWFUpload.prototype.setButtonDisabled=function(isDisabled){this.settings.button_disabled=isDisabled;this.callFlash("SetButtonDisabled",[isDisabled])};SWFUpload.prototype.setButtonAction=function(buttonAction){this.settings.button_action=buttonAction;this.callFlash("SetButtonAction",[buttonAction])};SWFUpload.prototype.setButtonCursor=function(cursor){this.settings.button_cursor=cursor;this.callFlash("SetButtonCursor",[cursor])};SWFUpload.prototype.queueEvent=function(handlerName,argumentArray){if(argumentArray==undefined){argumentArray=[]}else{if(!(argumentArray instanceof Array)){argumentArray=[argumentArray]}}var self=this;if(typeof this.settings[handlerName]==="function"){this.eventQueue.push(function(){this.settings[handlerName].apply(this,argumentArray)});setTimeout(function(){self.executeNextEvent()},0)}else{if(this.settings[handlerName]!==null){throw"Event handler "+handlerName+" is unknown or is not a function"}}};SWFUpload.prototype.executeNextEvent=function(){var f=this.eventQueue?this.eventQueue.shift():null;if(typeof (f)==="function"){f.apply(this)}};SWFUpload.prototype.unescapeFilePostParams=function(file){var reg=/[$]([0-9a-f]{4})/i;var unescapedPost={};var uk;if(file!=undefined){for(var k in file.post){if(file.post.hasOwnProperty(k)){uk=k;var match;while((match=reg.exec(uk))!==null){uk=uk.replace(match[0],String.fromCharCode(parseInt("0x"+match[1],16)))}unescapedPost[uk]=file.post[k]}}file.post=unescapedPost}return file};SWFUpload.prototype.testExternalInterface=function(){try{return this.callFlash("TestExternalInterface")}catch(ex){return false}};SWFUpload.prototype.flashReady=function(){var movieElement=this.getMovieElement();if(!movieElement){this.debug("Flash called back ready but the flash movie can't be found.");return }this.cleanUp(movieElement);this.queueEvent("swfupload_loaded_handler")};SWFUpload.prototype.cleanUp=function(movieElement){try{if(this.movieElement&&typeof (movieElement.CallFunction)==="unknown"){this.debug("Removing Flash functions hooks (this should only run in IE and should prevent memory leaks)");for(var key in movieElement){try{if(typeof (movieElement[key])==="function"){movieElement[key]=null}}catch(ex){}}}}catch(ex1){}window.__flash__removeCallback=function(instance,name){try{if(instance){instance[name]=null}}catch(flashEx){}}};SWFUpload.prototype.fileDialogStart=function(){this.queueEvent("file_dialog_start_handler")};SWFUpload.prototype.fileQueued=function(file){file=this.unescapeFilePostParams(file);this.queueEvent("file_queued_handler",file)};SWFUpload.prototype.fileQueueError=function(file,errorCode,message){file=this.unescapeFilePostParams(file);this.queueEvent("file_queue_error_handler",[file,errorCode,message])};SWFUpload.prototype.fileDialogComplete=function(numFilesSelected,numFilesQueued,numFilesInQueue){this.queueEvent("file_dialog_complete_handler",[numFilesSelected,numFilesQueued,numFilesInQueue])};SWFUpload.prototype.uploadStart=function(file){file=this.unescapeFilePostParams(file);this.queueEvent("return_upload_start_handler",file)};SWFUpload.prototype.returnUploadStart=function(file){var returnValue;if(typeof this.settings.upload_start_handler==="function"){file=this.unescapeFilePostParams(file);returnValue=this.settings.upload_start_handler.call(this,file)}else{if(this.settings.upload_start_handler!=undefined){throw"upload_start_handler must be a function"}}if(returnValue===undefined){returnValue=true}returnValue=!!returnValue;this.callFlash("ReturnUploadStart",[returnValue])};SWFUpload.prototype.uploadProgress=function(file,bytesComplete,bytesTotal){file=this.unescapeFilePostParams(file);this.queueEvent("upload_progress_handler",[file,bytesComplete,bytesTotal])};SWFUpload.prototype.uploadError=function(file,errorCode,message){file=this.unescapeFilePostParams(file);this.queueEvent("upload_error_handler",[file,errorCode,message])};SWFUpload.prototype.uploadSuccess=function(file,serverData,responseReceived){file=this.unescapeFilePostParams(file);this.queueEvent("upload_success_handler",[file,serverData,responseReceived])};SWFUpload.prototype.uploadComplete=function(file){file=this.unescapeFilePostParams(file);this.queueEvent("upload_complete_handler",file)};SWFUpload.prototype.debug=function(message){this.queueEvent("debug_handler",message)};SWFUpload.prototype.debugMessage=function(message){if(this.settings.debug){var exceptionMessage,exceptionValues=[];if(typeof message==="object"&&typeof message.name==="string"&&typeof message.message==="string"){for(var key in message){if(message.hasOwnProperty(key)){exceptionValues.push(key+": "+message[key])}}exceptionMessage=exceptionValues.join("\n")||"";exceptionValues=exceptionMessage.split("\n");exceptionMessage="EXCEPTION: "+exceptionValues.join("\nEXCEPTION: ");SWFUpload.Console.writeLine(exceptionMessage)}else{SWFUpload.Console.writeLine(message)}}};SWFUpload.Console={};SWFUpload.Console.writeLine=function(message){var console,documentForm;try{console=document.getElementById("SWFUpload_Console");if(!console){documentForm=document.createElement("form");document.getElementsByTagName("body")[0].appendChild(documentForm);console=document.createElement("textarea");console.id="SWFUpload_Console";console.style.fontFamily="monospace";console.setAttribute("wrap","off");console.wrap="off";console.style.overflow="auto";console.style.width="700px";console.style.height="350px";console.style.margin="5px";documentForm.appendChild(console)}console.value+=message+"\n";console.scrollTop=console.scrollHeight-console.clientHeight}catch(ex){alert("Exception: "+ex.name+" Message: "+ex.message)}};fluid_1_1=fluid_1_1||{};(function($,fluid){var animateDisplay=function(elm,animation,defaultAnimation){animation=(animation)?animation:defaultAnimation;elm.animate(animation.params,animation.duration,animation.callback)};var animateProgress=function(elm,width,speed){elm.queue("fx",[]);elm.animate({width:width,queue:false},speed)};var showProgress=function(that,animation){if(animation===false){that.displayElement.show()}else{animateDisplay(that.displayElement,animation,that.options.showAnimation)}};var hideProgress=function(that,delay,animation){delay=(delay===null||isNaN(delay))?that.options.delay:delay;if(delay){var timeOut=setTimeout(function(){hideProgress(that,0,animation)},delay)}else{if(animation===false){that.displayElement.hide()}else{animateDisplay(that.displayElement,animation,that.options.hideAnimation)}}};var updateWidth=function(that,newWidth,dontAnimate){dontAnimate=dontAnimate||false;var currWidth=that.indicator.width();var direction=that.options.animate;if((newWidth>currWidth)&&(direction==="both"||direction==="forward")&&!dontAnimate){animateProgress(that.indicator,newWidth,that.options.speed)}else{if((newWidth<currWidth)&&(direction==="both"||direction==="backward")&&!dontAnimate){animateProgress(that.indicator,newWidth,that.options.speed)}else{that.indicator.width(newWidth)}}};var percentToPixels=function(that,percent){return Math.round((Math.min(percent,100)*that.progressBar.width())/100)};var refreshRelativeWidth=function(that){var pixels=Math.max(percentToPixels(that,parseFloat(that.storedPercent)),that.options.minWidth);updateWidth(that,pixels,true)};var initARIA=function(ariaElement){ariaElement.attr("role","progressbar");ariaElement.attr("aria-valuemin","0");ariaElement.attr("aria-valuemax","100");ariaElement.attr("aria-valuenow","0");ariaElement.attr("aria-valuetext","");ariaElement.attr("aria-busy","false")};var updateARIA=function(that,percent){var busy=percent<100&&percent>0;that.ariaElement.attr("aria-busy",busy);that.ariaElement.attr("aria-valuenow",percent);if(busy){var busyString=fluid.stringTemplate(that.options.ariaBusyText,{percentComplete:percent});that.ariaElement.attr("aria-valuetext",busyString)}else{if(percent===100){that.ariaElement.attr("aria-valuetext",that.options.ariaDoneText)}}};var updateText=function(label,value){label.html(value)};var repositionIndicator=function(that){that.indicator.css("top",that.progressBar.position().top).css("left",0).height(that.progressBar.height());refreshRelativeWidth(that)};var updateProgress=function(that,percent,labelText,animationForShow){showProgress(that,animationForShow);if(percent!==null){that.storedPercent=percent;var pixels=Math.max(percentToPixels(that,parseFloat(percent)),that.options.minWidth);updateWidth(that,pixels)}if(labelText!==null){updateText(that.label,labelText)}if(that.ariaElement){updateARIA(that,percent)}};var setupProgress=function(that){that.displayElement=that.locate("displayElement");if(that.options.initiallyHidden){that.displayElement.hide()}that.progressBar=that.locate("progressBar");that.label=that.locate("label");that.indicator=that.locate("indicator");that.ariaElement=that.locate("ariaElement");that.indicator.width(that.options.minWidth);that.storedPercent=0;if(that.ariaElement){initARIA(that.ariaElement)}};fluid.progress=function(container,options){var that=fluid.initView("fluid.progress",container,options);setupProgress(that);that.show=function(animation){showProgress(that,animation)};that.hide=function(delay,animation){hideProgress(that,delay,animation)};that.update=function(percentage,labelValue,animationForShow){updateProgress(that,percentage,labelValue,animationForShow)};that.refreshView=function(){repositionIndicator(that)};return that};fluid.defaults("fluid.progress",{selectors:{displayElement:".flc-progress",progressBar:".flc-progress-bar",indicator:".flc-progress-indicator",label:".flc-progress-label",ariaElement:".flc-progress-bar"},showAnimation:{params:{opacity:"show"},duration:"slow",callback:null},hideAnimation:{params:{opacity:"hide"},duration:"slow",callback:null},minWidth:5,delay:0,speed:200,animate:"forward",initiallyHidden:true,updatePosition:false,ariaBusyText:"Progress is %percentComplete percent complete",ariaDoneText:"Progress is complete."})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var updateProgress=function(file,events,demoState,isUploading){if(!isUploading){return }var chunk=Math.min(demoState.chunkSize,file.size);demoState.bytesUploaded=Math.min(demoState.bytesUploaded+chunk,file.size);events.onFileProgress.fire(file,demoState.bytesUploaded,file.size)};var fireAfterFileComplete=function(that,file){if(that.swfUploadSettings){that.swfUploadSettings.upload_complete_handler(file)}else{that.events.afterFileComplete.fire(file)}};var finishAndContinueOrCleanup=function(that,file){that.queueManager.finishFile(file);if(that.queueManager.shouldUploadNextFile()){startUploading(that)}else{that.queueManager.complete()}};var finishUploading=function(that){if(!that.queue.isUploading){return }var file=that.demoState.currentFile;file.filestatus=fluid.uploader.fileStatusConstants.COMPLETE;that.events.onFileSuccess.fire(file);that.demoState.fileIdx++;finishAndContinueOrCleanup(that,file)};var simulateUpload=function(that){if(!that.queue.isUploading){return }var file=that.demoState.currentFile;if(that.demoState.bytesUploaded<file.size){that.invokeAfterRandomDelay(function(){updateProgress(file,that.events,that.demoState,that.queue.isUploading);simulateUpload(that)})}else{finishUploading(that)}};var startUploading=function(that){that.demoState.currentFile=that.queue.files[that.demoState.fileIdx];that.demoState.chunksForCurrentFile=Math.ceil(that.demoState.currentFile/that.demoState.chunkSize);that.demoState.bytesUploaded=0;that.queue.isUploading=true;that.events.onFileStart.fire(that.demoState.currentFile);that.demoState.currentFile.filestatus=fluid.uploader.fileStatusConstants.IN_PROGRESS;simulateUpload(that)};var stopDemo=function(that){var file=that.demoState.currentFile;file.filestatus=fluid.uploader.fileStatusConstants.CANCELLED;that.queue.shouldStop=true;that.events.onFileError.fire(file,fluid.uploader.errorConstants.UPLOAD_STOPPED,"The demo upload was paused by the user.");finishAndContinueOrCleanup(that,file);that.events.onUploadStop.fire()};var setupDemoUploadManager=function(that){if(that.options.simulateDelay===undefined||that.options.simulateDelay===null){that.options.simulateDelay=true}that.demoState={fileIdx:0,chunkSize:200000};return that};fluid.demoUploadManager=function(uploadManager){var that=uploadManager;that.start=function(){that.queueManager.start();startUploading(that)};that.stop=function(){stopDemo(that)};that.invokeAfterRandomDelay=function(fn){var delay;if(that.options.simulateDelay){delay=Math.floor(Math.random()*1000+100);setTimeout(fn,delay)}else{fn()}};setupDemoUploadManager(that);return that}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var filterFiles=function(files,filterFn){var filteredFiles=[];for(var i=0;i<files.length;i++){var file=files[i];if(filterFn(file)===true){filteredFiles.push(file)}}return filteredFiles};var getUploadedFiles=function(that){return filterFiles(that.files,function(file){return(file.filestatus===fluid.uploader.fileStatusConstants.COMPLETE)})};var getReadyFiles=function(that){return filterFiles(that.files,function(file){return(file.filestatus===fluid.uploader.fileStatusConstants.QUEUED||file.filestatus===fluid.uploader.fileStatusConstants.CANCELLED)})};var getErroredFiles=function(that){return filterFiles(that.files,function(file){return(file.filestatus===fluid.uploader.fileStatusConstants.ERROR)})};var removeFile=function(that,file){var idx=$.inArray(file,that.files);that.files.splice(idx,1)};var clearCurrentBatch=function(that){that.currentBatch={fileIdx:-1,files:[],totalBytes:0,numFilesCompleted:0,numFilesErrored:0,bytesUploadedForFile:0,previousBytesUploadedForFile:0,totalBytesUploaded:0}};var updateCurrentBatch=function(that){var readyFiles=that.getReadyFiles();that.currentBatch.files=readyFiles;that.currentBatch.totalBytes=fluid.fileQueue.sizeOfFiles(readyFiles)};var setupCurrentBatch=function(that){clearCurrentBatch(that);updateCurrentBatch(that)};fluid.fileQueue=function(){var that={};that.files=[];that.isUploading=false;that.addFile=function(file){that.files.push(file)};that.removeFile=function(file){removeFile(that,file)};that.totalBytes=function(){return fluid.fileQueue.sizeOfFiles(that.files)};that.getReadyFiles=function(){return getReadyFiles(that)};that.getErroredFiles=function(){return getErroredFiles(that)};that.sizeOfReadyFiles=function(){return fluid.fileQueue.sizeOfFiles(that.getReadyFiles())};that.getUploadedFiles=function(){return getUploadedFiles(that)};that.sizeOfUploadedFiles=function(){return fluid.fileQueue.sizeOfFiles(that.getUploadedFiles())};that.setupCurrentBatch=function(){setupCurrentBatch(that)};that.clearCurrentBatch=function(){clearCurrentBatch(that)};that.updateCurrentBatch=function(){updateCurrentBatch(that)};return that};fluid.fileQueue.sizeOfFiles=function(files){var totalBytes=0;for(var i=0;i<files.length;i++){var file=files[i];totalBytes+=file.size}return totalBytes};fluid.fileQueue.manager=function(queue,events){var that={};that.queue=queue;that.events=events;that.start=function(){that.queue.setupCurrentBatch();that.queue.isUploading=true;that.queue.shouldStop=false;that.events.onUploadStart.fire(that.queue.currentBatch.files)};that.startFile=function(){that.queue.currentBatch.fileIdx++;that.queue.currentBatch.bytesUploadedForFile=0;that.queue.currentBatch.previousBytesUploadedForFile=0};that.finishFile=function(file){var batch=that.queue.currentBatch;batch.numFilesCompleted++;that.events.afterFileComplete.fire(file)};that.shouldUploadNextFile=function(){return !that.queue.shouldStop&&that.queue.isUploading&&that.queue.currentBatch.numFilesCompleted<that.queue.currentBatch.files.length};that.complete=function(){that.events.afterUploadComplete.fire(that.queue.currentBatch.files);that.queue.clearCurrentBatch()};return that}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var refreshView=function(that){var maxHeight=that.options.maxHeight;var isOverMaxHeight=(that.scrollingElm.children().eq(0).height()>maxHeight);var setHeight=(isOverMaxHeight)?maxHeight:"";that.scrollingElm.height(setHeight)};var scrollBottom=function(that){that.scrollingElm[0].scrollTop=that.scrollingElm[0].scrollHeight};var scrollTo=function(that,element){if(!element||element.length<1){return }var padTop=0;var padBottom=0;var elmPosTop=element[0].offsetTop;var elmHeight=element.height();var containerScrollTop=that.scrollingElm[0].scrollTop;var containerHeight=that.scrollingElm.height();if(that.options.padScroll){var prevElmHeight=element.prev().height();padTop=(prevElmHeight+elmHeight<=containerHeight)?prevElmHeight:0;var nextElmHeight=element.next().height();padBottom=(nextElmHeight+elmHeight<=containerHeight)?nextElmHeight:0}if((elmPosTop-padTop)<containerScrollTop){that.scrollingElm[0].scrollTop=elmPosTop-padTop}if(((elmPosTop+elmHeight)+padBottom)>(containerScrollTop+containerHeight)){elmHeight=(elmHeight<containerHeight)?elmHeight:containerHeight;that.scrollingElm[0].scrollTop=(elmPosTop-containerHeight+elmHeight+padBottom)}};var setupScroller=function(that){that.scrollingElm=that.container.parents(that.options.selectors.wrapper);if(!that.scrollingElm.length){fluid.fail({name:"Missing Scroller",message:"The scroller wrapper element was not found."})}if(!$.browser.msie||$.browser.version>6){that.scrollingElm.css("max-height",that.options.maxHeight)}};fluid.scroller=function(container,options){var that=fluid.initView("fluid.scroller",container,options);setupScroller(that);that.scrollTo=function(element){scrollTo(that,element)};that.scrollBottom=function(){scrollBottom(that)};that.refreshView=function(){if($.browser.msie&&$.browser.version<7){refreshView(that)}};that.refreshView();return that};fluid.defaults("fluid.scroller",{selectors:{wrapper:".flc-scroller"},maxHeight:180,padScroll:true})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var unbindSelectFiles=function(){var emptyFunction=function(){};SWFUpload.prototype.selectFile=emptyFunction;SWFUpload.prototype.selectFiles=emptyFunction};var prepareUpstreamOptions=function(that,uploader){that.returnedOptions={uploadManager:{type:uploader.options.uploadManager.type||uploader.options.uploadManager}}};var createFlash9MovieContainer=function(that){var container=$("<div><span></span></div>");container.addClass(that.options.styles.flash9Container);$("body").append(container);return container};var setupForFlash9=function(that){var flashContainer=createFlash9MovieContainer(that);that.returnedOptions.uploadManager.options={flashURL:that.options.flash9URL||undefined,flashButtonPeerId:fluid.allocateSimpleId(flashContainer.children().eq(0))}};var createFlash10MovieContainer=function(that,uploaderContainer){uploaderContainer.wrap("<div class='"+that.options.styles.uploaderWrapperFlash10+"'></div>");var flashContainer=$("<div><span></span></div>");flashContainer.addClass(that.options.styles.browseButtonOverlay);uploaderContainer.after(flashContainer);unbindSelectFiles();return flashContainer};var setupForFlash10=function(that,uploader){var o=that.options,flashContainer=createFlash10MovieContainer(that,uploader.container),browseButton=uploader.locate("browseButton");fluid.tabindex(browseButton,-1);that.isTransparent=o.flashButtonAlwaysVisible?false:(!$.browser.msie||o.transparentEvenInIE);that.returnedOptions.uploadManager.options={flashURL:o.flash10URL||undefined,flashButtonImageURL:that.isTransparent?undefined:o.flashButtonImageURL,flashButtonPeerId:fluid.allocateSimpleId(flashContainer.children().eq(0)),flashButtonHeight:o.flashButtonHeight||browseButton.outerHeight(),flashButtonWidth:o.flashButtonWidth||browseButton.outerWidth(),flashButtonWindowMode:that.isTransparent?SWFUpload.WINDOW_MODE.TRANSPARENT:SWFUpload.WINDOW_MODE.OPAQUE,flashButtonCursorEffect:SWFUpload.CURSOR.HAND,listeners:{onUploadStart:function(){uploader.uploadManager.swfUploader.setButtonDisabled(true)},afterUploadComplete:function(){uploader.uploadManager.swfUploader.setButtonDisabled(false)}}}};fluid.swfUploadSetupDecorator=function(uploader,options){var that={};fluid.mergeComponentOptions(that,"fluid.swfUploadSetupDecorator",options);that.flashVersion=swfobject.getFlashPlayerVersion().major;prepareUpstreamOptions(that,uploader);if(that.flashVersion===9){setupForFlash9(that,uploader)}else{setupForFlash10(that,uploader)}return that};fluid.defaults("fluid.swfUploadSetupDecorator",{flashButtonAlwaysVisible:false,transparentEvenInIE:true,flashButtonImageURL:"../images/browse.png",styles:{browseButtonOverlay:"fl-uploader-browse-overlay",flash9Container:"fl-uploader-flash9-container",uploaderWrapperFlash10:"fl-uploader-flash10-wrapper"}});var swfUploadOptionsMap={uploadURL:"upload_url",flashURL:"flash_url",postParams:"post_params",fileSizeLimit:"file_size_limit",fileTypes:"file_types",fileTypesDescription:"file_types_description",fileUploadLimit:"file_upload_limit",fileQueueLimit:"file_queue_limit",flashButtonPeerId:"button_placeholder_id",flashButtonImageURL:"button_image_url",flashButtonHeight:"button_height",flashButtonWidth:"button_width",flashButtonWindowMode:"button_window_mode",flashButtonCursorEffect:"button_cursor",debug:"debug"};var swfUploadEventMap={afterReady:"swfupload_loaded_handler",onFileDialog:"file_dialog_start_handler",afterFileQueued:"file_queued_handler",onQueueError:"file_queue_error_handler",afterFileDialog:"file_dialog_complete_handler",onFileStart:"upload_start_handler",onFileProgress:"upload_progress_handler",onFileError:"upload_error_handler",onFileSuccess:"upload_success_handler"};var mapNames=function(nameMap,source,target){var result=target||{};for(var key in source){var mappedKey=nameMap[key];if(mappedKey){result[mappedKey]=source[key]}}return result};var mapEvents=function(that,nameMap,target){var result=target||{};for(var eventType in that.events){var fireFn=that.events[eventType].fire;var mappedName=nameMap[eventType];if(mappedName){result[mappedName]=fireFn}}result.upload_complete_handler=function(file){that.queueManager.finishFile(file);if(that.queueManager.shouldUploadNextFile()){that.swfUploader.startUpload()}else{if(that.queueManager.queue.shouldStop){that.swfUploader.stopUpload()}that.queueManager.complete()}};return result};var browse=function(that){if(that.queue.isUploading){return }if(that.options.fileQueueLimit===1){that.swfUploader.selectFile()}else{that.swfUploader.selectFiles()}};var stopUpload=function(that){that.queue.shouldStop=true;that.events.onUploadStop.fire()};var bindEvents=function(that){var fileStatusUpdater=function(file){fluid.find(that.queue.files,function(potentialMatch){if(potentialMatch.id===file.id){potentialMatch.filestatus=file.filestatus;return true}})};that.events.afterFileQueued.addListener(function(file){that.queue.addFile(file)});that.events.onFileStart.addListener(function(file){that.queueManager.startFile();fileStatusUpdater(file)});that.events.onFileProgress.addListener(function(file,currentBytes,totalBytes){var currentBatch=that.queue.currentBatch;var byteIncrement=currentBytes-currentBatch.previousBytesUploadedForFile;currentBatch.totalBytesUploaded+=byteIncrement;currentBatch.bytesUploadedForFile+=byteIncrement;currentBatch.previousBytesUploadedForFile=currentBytes;fileStatusUpdater(file)});that.events.onFileError.addListener(function(file,error){if(error===fluid.uploader.errorConstants.UPLOAD_STOPPED){that.queue.isUploading=false}else{if(that.queue.isUploading){that.queue.currentBatch.totalBytesUploaded+=file.size;that.queue.currentBatch.numFilesErrored++}}fileStatusUpdater(file)});that.events.onFileSuccess.addListener(function(file){if(that.queue.currentBatch.bytesUploadedForFile===0){that.queue.currentBatch.totalBytesUploaded+=file.size}fileStatusUpdater(file)});that.events.afterUploadComplete.addListener(function(){that.queue.isUploading=false})};var removeFile=function(that,file){that.queue.removeFile(file);that.swfUploader.cancelUpload(file.id);that.events.afterFileRemoved.fire(file)};var setupSwfUploadManager=function(that,events){that.events=events;that.queue=fluid.fileQueue();that.queueManager=fluid.fileQueue.manager(that.queue,that.events);that.swfUploadSettings=mapNames(swfUploadOptionsMap,that.options);mapEvents(that,swfUploadEventMap,that.swfUploadSettings);that.swfUploader=new SWFUpload(that.swfUploadSettings);bindEvents(that)};fluid.swfUploadManager=function(events,options){var that={};fluid.mergeComponentOptions(that,"fluid.swfUploadManager",options);fluid.mergeListeners(events,that.options.listeners);that.browseForFiles=function(){browse(that)};that.removeFile=function(file){removeFile(that,file)};that.start=function(){that.queueManager.start();that.swfUploader.startUpload()};that.stop=function(){stopUpload(that)};setupSwfUploadManager(that,events);return that};fluid.defaults("fluid.swfUploadManager",{uploadURL:"",flashURL:"../../../lib/swfupload/flash/swfupload.swf",flashButtonPeerId:"",postParams:{},fileSizeLimit:"20480",fileTypes:"*",fileTypesDescription:null,fileUploadLimit:0,fileQueueLimit:0,debug:false})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var rowForFile=function(that,file){return that.locate("fileQueue").find("#"+file.id)};var errorRowForFile=function(that,file){return $("#"+file.id+"_error",that.container)};var fileForRow=function(that,row){var files=that.uploadManager.queue.files;for(var i=0;i<files.length;i++){var file=files[i];if(file.id.toString()===row.attr("id")){return file}}return null};var progressorForFile=function(that,file){var progressId=file.id+"_progress";return that.fileProgressors[progressId]};var startFileProgress=function(that,file){var fileRowElm=rowForFile(that,file);that.scroller.scrollTo(fileRowElm);var fileProgressor=progressorForFile(that,file);fileProgressor.refreshView();fileProgressor.show()};var updateFileProgress=function(that,file,fileBytesComplete,fileTotalBytes){var filePercent=fluid.uploader.derivePercent(fileBytesComplete,fileTotalBytes);var filePercentStr=filePercent+"%";progressorForFile(that,file).update(filePercent,filePercentStr)};var hideFileProgress=function(that,file){var fileRowElm=rowForFile(that,file);progressorForFile(that,file).hide();if(file.filestatus===fluid.uploader.fileStatusConstants.COMPLETE){that.locate("fileIconBtn",fileRowElm).removeClass(that.options.styles.dim)}};var removeFileProgress=function(that,file){var fileProgressor=progressorForFile(that,file);if(!fileProgressor){return }var rowProgressor=fileProgressor.displayElement;rowProgressor.remove()};var animateRowRemoval=function(that,row){row.fadeOut("fast",function(){row.remove();that.refreshView()})};var removeFileErrorRow=function(that,file){if(file.filestatus===fluid.uploader.fileStatusConstants.ERROR){animateRowRemoval(that,errorRowForFile(that,file))}};var removeFileAndRow=function(that,file,row){removeFileProgress(that,file);removeFileErrorRow(that,file);that.uploadManager.removeFile(file);animateRowRemoval(that,row)};var removeFileForRow=function(that,row){var file=fileForRow(that,row);if(!file||file.filestatus===fluid.uploader.fileStatusConstants.COMPLETE){return }removeFileAndRow(that,file,row)};var removeRowForFile=function(that,file){var row=rowForFile(that,file);removeFileAndRow(that,file,row)};var bindHover=function(row,styles){var over=function(){if(row.hasClass(styles.ready)&&!row.hasClass(styles.uploading)){row.addClass(styles.hover)}};var out=function(){if(row.hasClass(styles.ready)&&!row.hasClass(styles.uploading)){row.removeClass(styles.hover)}};row.hover(over,out)};var bindDeleteKey=function(that,row){var deleteHandler=function(){removeFileForRow(that,row)};fluid.activatable(row,null,{additionalBindings:[{key:$.ui.keyCode.DELETE,activateHandler:deleteHandler}]})};var bindRowHandlers=function(that,row){if($.browser.msie&&$.browser.version<7){bindHover(row,that.options.styles)}that.locate("fileIconBtn",row).click(function(){removeFileForRow(that,row)});bindDeleteKey(that,row)};var renderRowFromTemplate=function(that,file){var row=that.rowTemplate.clone();row.removeClass(that.options.styles.hiddenTemplate);that.locate("fileName",row).text(file.name);that.locate("fileSize",row).text(fluid.uploader.formatFileSize(file.size));that.locate("fileIconBtn",row).addClass(that.options.styles.remove);row.attr("id",file.id);row.addClass(that.options.styles.ready);bindRowHandlers(that,row);return row};var createProgressorFromTemplate=function(that,row){var rowProgressor=that.rowProgressorTemplate.clone();var rowId=row.attr("id");var progressId=rowId+"_progress";rowProgressor.attr("id",progressId);rowProgressor.css("top",row.position().top);rowProgressor.height(row.height()).width(5);that.container.after(rowProgressor);that.fileProgressors[progressId]=fluid.progress(that.uploadContainer,{selectors:{progressBar:"#"+rowId,displayElement:"#"+progressId,label:"#"+progressId+" .fl-uploader-file-progress-text",indicator:"#"+progressId}})};var addFile=function(that,file){var row=renderRowFromTemplate(that,file);if(!($.browser.msie&&($.browser.version>=8))){row.hide()}that.container.append(row);row.fadeIn("slow");that.scroller.scrollBottom();createProgressorFromTemplate(that,row);that.refreshView()};var prepareForUpload=function(that){var rowButtons=that.locate("fileIconBtn",that.locate("fileRows"));rowButtons.attr("disabled","disabled");rowButtons.addClass(that.options.styles.dim)};var refreshAfterUpload=function(that){var rowButtons=that.locate("fileIconBtn",that.locate("fileRows"));rowButtons.removeAttr("disabled");rowButtons.removeClass(that.options.styles.dim)};var changeRowState=function(that,row,newState){row.removeClass(that.options.styles.ready).removeClass(that.options.styles.error).addClass(newState)};var markRowAsComplete=function(that,file){var row=rowForFile(that,file);changeRowState(that,row,that.options.styles.uploaded);row.attr("title",that.options.strings.status.success);fluid.enabled(row,false);var removeRowBtn=that.locate("fileIconBtn",row);removeRowBtn.unbind("click");removeRowBtn.removeClass(that.options.styles.remove);removeRowBtn.attr("title",that.options.strings.status.success)};var renderErrorInfoRowFromTemplate=function(that,fileRow,error){var errorRow=that.errorInfoRowTemplate.clone();errorRow.attr("id",fileRow.attr("id")+"_error");var errorType=fluid.keyForValue(fluid.uploader.errorConstants,error);var errorMsg=that.options.strings.errors[errorType];that.locate("errorText",errorRow).text(errorMsg);fileRow.after(errorRow);that.scroller.scrollTo(errorRow)};var showErrorForFile=function(that,file,error){hideFileProgress(that,file);if(file.filestatus===fluid.uploader.fileStatusConstants.ERROR){var fileRowElm=rowForFile(that,file);changeRowState(that,fileRowElm,that.options.styles.error);renderErrorInfoRowFromTemplate(that,fileRowElm,error)}};var bindModelEvents=function(that){that.returnedOptions={listeners:{afterFileQueued:that.addFile,onUploadStart:that.prepareForUpload,onFileStart:that.showFileProgress,onFileProgress:that.updateFileProgress,onFileSuccess:that.markFileComplete,onFileError:that.showErrorForFile,afterFileComplete:that.hideFileProgress,afterUploadComplete:that.refreshAfterUpload}}};var addKeyboardNavigation=function(that){fluid.tabbable(that.container);that.selectableContext=fluid.selectable(that.container,{selectableSelector:that.options.selectors.fileRows,onSelect:function(itemToSelect){$(itemToSelect).addClass(that.options.styles.selected)},onUnselect:function(selectedItem){$(selectedItem).removeClass(that.options.styles.selected)}})};var prepareTemplateElements=function(that){that.rowTemplate=that.locate("rowTemplate").remove();that.errorInfoRowTemplate=that.locate("errorInfoRowTemplate").remove();that.errorInfoRowTemplate.removeClass(that.options.styles.hiddenTemplate);that.rowProgressorTemplate=that.locate("rowProgressorTemplate",that.uploadContainer).remove()};var setupFileQueue=function(that,uploadManager){that.uploadManager=uploadManager;that.scroller=fluid.scroller(that.container);prepareTemplateElements(that);addKeyboardNavigation(that);bindModelEvents(that)};fluid.fileQueueView=function(container,parentContainer,uploadManager,options){var that=fluid.initView("fluid.fileQueueView",container,options);that.uploadContainer=parentContainer;that.fileProgressors={};that.addFile=function(file){addFile(that,file)};that.removeFile=function(file){removeRowForFile(that,file)};that.prepareForUpload=function(){prepareForUpload(that)};that.refreshAfterUpload=function(){refreshAfterUpload(that)};that.showFileProgress=function(file){startFileProgress(that,file)};that.updateFileProgress=function(file,fileBytesComplete,fileTotalBytes){updateFileProgress(that,file,fileBytesComplete,fileTotalBytes)};that.markFileComplete=function(file){progressorForFile(that,file).update(100,"100%");markRowAsComplete(that,file)};that.showErrorForFile=function(file,error){showErrorForFile(that,file,error)};that.hideFileProgress=function(file){hideFileProgress(that,file)};that.refreshView=function(){that.scroller.refreshView();that.selectableContext.refresh()};setupFileQueue(that,uploadManager);return that};fluid.defaults("fluid.fileQueueView",{selectors:{fileRows:".flc-uploader-file",fileName:".flc-uploader-file-name",fileSize:".flc-uploader-file-size",fileIconBtn:".flc-uploader-file-action",errorText:".flc-uploader-file-error",rowTemplate:".flc-uploader-file-tmplt",errorInfoRowTemplate:".flc-uploader-file-error-tmplt",rowProgressorTemplate:".flc-uploader-file-progressor-tmplt"},styles:{hover:"fl-uploader-file-hover",selected:"fl-uploader-file-focus",ready:"fl-uploader-file-state-ready",uploading:"fl-uploader-file-state-uploading",uploaded:"fl-uploader-file-state-uploaded",error:"fl-uploader-file-state-error",remove:"fl-uploader-file-action-remove",dim:"fl-uploader-dim",hiddenTemplate:"fl-uploader-hidden-templates"},strings:{progress:{toUploadLabel:"To upload: %fileCount %fileLabel (%totalBytes)",singleFile:"file",pluralFiles:"files"},status:{success:"File Uploaded",error:"File Upload Error"},errors:{HTTP_ERROR:"File upload error: a network error occured or the file was rejected (reason unknown).",IO_ERROR:"File upload error: a network error occured.",UPLOAD_LIMIT_EXCEEDED:"File upload error: you have uploaded as many files as you are allowed during this session",UPLOAD_FAILED:"File upload error: the upload failed for an unknown reason.",QUEUE_LIMIT_EXCEEDED:"You have as many files in the queue as can be added at one time. Removing files from the queue may allow you to add different files.",FILE_EXCEEDS_SIZE_LIMIT:"One or more of the files that you attempted to add to the queue exceeded the limit of %fileSizeLimit.",ZERO_BYTE_FILE:"One or more of the files that you attempted to add contained no data.",INVALID_FILETYPE:"One or more files were not added to the queue because they were of the wrong type."}}})})(jQuery,fluid_1_1);(function($,fluid){var fileOrFiles=function(that,numFiles){return(numFiles===1)?that.options.strings.progress.singleFile:that.options.strings.progress.pluralFiles};var enableElement=function(that,elm){elm.removeAttr("disabled");elm.removeClass(that.options.styles.dim)};var disableElement=function(that,elm){elm.attr("disabled","disabled");elm.addClass(that.options.styles.dim)};var showElement=function(that,elm){elm.removeClass(that.options.styles.hidden)};var hideElement=function(that,elm){elm.addClass(that.options.styles.hidden)};var setTotalProgressStyle=function(that,didError){didError=didError||false;var indicator=that.totalProgress.indicator;indicator.toggleClass(that.options.styles.totalProgress,!didError);indicator.toggleClass(that.options.styles.totalProgressError,didError)};var setStateEmpty=function(that){disableElement(that,that.locate("uploadButton"));if(that.uploadManager.queue.files.length===0){that.locate("browseButton").text(that.options.strings.buttons.browse);showElement(that,that.locate("instructions"))}};var setStateDone=function(that){disableElement(that,that.locate("uploadButton"));enableElement(that,that.locate("browseButton"));hideElement(that,that.locate("pauseButton"));showElement(that,that.locate("uploadButton"))};var setStateLoaded=function(that){that.locate("browseButton").text(that.options.strings.buttons.addMore);hideElement(that,that.locate("pauseButton"));showElement(that,that.locate("uploadButton"));enableElement(that,that.locate("uploadButton"));enableElement(that,that.locate("browseButton"));hideElement(that,that.locate("instructions"));that.totalProgress.hide()};var setStateUploading=function(that){that.totalProgress.hide(false,false);setTotalProgressStyle(that);hideElement(that,that.locate("uploadButton"));disableElement(that,that.locate("browseButton"));enableElement(that,that.locate("pauseButton"));showElement(that,that.locate("pauseButton"));that.locate(that.options.focusWithEvent.afterUploadStart).focus()};var renderUploadTotalMessage=function(that){var numReadyFiles=that.uploadManager.queue.getReadyFiles().length;var bytesReadyFiles=that.uploadManager.queue.sizeOfReadyFiles();var fileLabelStr=fileOrFiles(that,numReadyFiles);var totalStateStr=fluid.stringTemplate(that.options.strings.progress.toUploadLabel,{fileCount:numReadyFiles,fileLabel:fileLabelStr,totalBytes:fluid.uploader.formatFileSize(bytesReadyFiles)});that.locate("totalFileStatusText").html(totalStateStr)};var updateTotalProgress=function(that){var batch=that.uploadManager.queue.currentBatch;var totalPercent=fluid.uploader.derivePercent(batch.totalBytesUploaded,batch.totalBytes);var numFilesInBatch=batch.files.length;var fileLabelStr=fileOrFiles(that,numFilesInBatch);var totalProgressStr=fluid.stringTemplate(that.options.strings.progress.totalProgressLabel,{curFileN:batch.fileIdx+1,totalFilesN:numFilesInBatch,fileLabel:fileLabelStr,currBytes:fluid.uploader.formatFileSize(batch.totalBytesUploaded),totalBytes:fluid.uploader.formatFileSize(batch.totalBytes)});that.totalProgress.update(totalPercent,totalProgressStr)};var updateTotalAtCompletion=function(that){var numErroredFiles=that.uploadManager.queue.getErroredFiles().length;var numTotalFiles=that.uploadManager.queue.files.length;var fileLabelStr=fileOrFiles(that,numTotalFiles);var errorStr="";if(numErroredFiles>0){var errorLabelString=(numErroredFiles===1)?that.options.strings.progress.singleError:that.options.strings.progress.pluralErrors;setTotalProgressStyle(that,true);errorStr=fluid.stringTemplate(that.options.strings.progress.numberOfErrors,{errorsN:numErroredFiles,errorLabel:errorLabelString})}var totalProgressStr=fluid.stringTemplate(that.options.strings.progress.completedLabel,{curFileN:that.uploadManager.queue.getUploadedFiles().length,totalFilesN:numTotalFiles,errorString:errorStr,fileLabel:fileLabelStr,totalCurrBytes:fluid.uploader.formatFileSize(that.uploadManager.queue.sizeOfUploadedFiles())});that.totalProgress.update(100,totalProgressStr)};var bindDOMEvents=function(that){that.locate("browseButton").click(function(evnt){that.uploadManager.browseForFiles();evnt.preventDefault()});that.locate("uploadButton").click(function(){that.uploadManager.start()});that.locate("pauseButton").click(function(){that.uploadManager.stop()})};var updateStateAfterFileDialog=function(that){if(that.uploadManager.queue.getReadyFiles().length>0){setStateLoaded(that);renderUploadTotalMessage(that);that.locate(that.options.focusWithEvent.afterFileDialog).focus()}};var updateStateAfterFileRemoval=function(that){if(that.uploadManager.queue.getReadyFiles().length===0){setStateEmpty(that)}renderUploadTotalMessage(that)};var updateStateAfterPause=function(that){};var updateStateAfterCompletion=function(that){var userPaused=that.uploadManager.queue.shouldStop;if(that.uploadManager.queue.getReadyFiles().length===0){setStateDone(that)}else{setStateLoaded(that)}updateTotalAtCompletion(that)};var bindModelEvents=function(that){that.events.afterFileDialog.addListener(function(){updateStateAfterFileDialog(that)});that.events.afterFileRemoved.addListener(function(){updateStateAfterFileRemoval(that)});that.events.onUploadStart.addListener(function(){setStateUploading(that)});that.events.onUploadStop.addListener(function(){that.locate(that.options.focusWithEvent.afterUploadStop).focus()});that.events.onFileProgress.addListener(function(){updateTotalProgress(that)});that.events.onFileSuccess.addListener(function(){updateTotalProgress(that)});that.events.onFileError.addListener(function(file,error,message){if(error===fluid.uploader.errorConstants.UPLOAD_STOPPED){updateStateAfterPause(that)}});that.events.afterUploadComplete.addListener(function(){updateStateAfterCompletion(that)})};var initUploadManager=function(that){var manager=fluid.initSubcomponent(that,"uploadManager",[that.events,fluid.COMPONENT_OPTIONS]);return that.options.demo?fluid.demoUploadManager(manager):manager};var setupUploader=function(that){that.decorators=fluid.initSubcomponents(that,"decorators",[that,fluid.COMPONENT_OPTIONS]);that.uploadManager=initUploadManager(that);that.fileQueueView=fluid.initSubcomponent(that,"fileQueueView",[that.locate("fileQueue"),that.container,that.uploadManager,fluid.COMPONENT_OPTIONS]);that.totalProgress=fluid.initSubcomponent(that,"totalProgressBar",[that.container,fluid.COMPONENT_OPTIONS]);disableElement(that,that.locate("uploadButton"));bindDOMEvents(that);bindModelEvents(that)};fluid.uploader=function(container,options){var that=fluid.initView("fluid.uploader",container,options);setupUploader(that);return that};fluid.progressiveEnhanceableUploader=function(container,enhanceable,options){enhanceable=fluid.container(enhanceable);container=fluid.container(container);if(swfobject.getFlashPlayerVersion().major<9){enhanceable.show()}else{container.show();return fluid.uploader(container,options)}};fluid.uploader.formatFileSize=function(bytes){if(typeof bytes==="number"){if(bytes===0){return"0.0 KB"}else{if(bytes>0){if(bytes<1048576){return(Math.ceil(bytes/1024*10)/10).toFixed(1)+" KB"}else{return(Math.ceil(bytes/1048576*10)/10).toFixed(1)+" MB"}}}}return""};fluid.uploader.derivePercent=function(num,total){return Math.round((num*100)/total)};fluid.defaults("fluid.uploader",{demo:false,decorators:[{type:"fluid.swfUploadSetupDecorator"},{type:"fluid.manuallyDegrade",options:{selectors:{enhanceable:".fl-uploader.fl-progEnhance-basic"}}}],uploadManager:{type:"fluid.swfUploadManager"},fileQueueView:{type:"fluid.fileQueueView"},totalProgressBar:{type:"fluid.progress",options:{selectors:{progressBar:".flc-uploader-queue-footer",displayElement:".flc-uploader-total-progress",label:".flc-uploader-total-progress-text",indicator:".flc-uploader-total-progress",ariaElement:".flc-uploader-total-progress"}}},selectors:{fileQueue:".flc-uploader-queue",browseButton:".flc-uploader-button-browse",uploadButton:".flc-uploader-button-upload",pauseButton:".flc-uploader-button-pause",totalFileStatusText:".flc-uploader-total-progress-text",instructions:".flc-uploader-browse-instructions"},focusWithEvent:{afterFileDialog:"uploadButton",afterUploadStart:"pauseButton",afterUploadStop:"uploadButton"},styles:{disabled:"fl-uploader-disabled",hidden:"fl-uploader-hidden",dim:"fl-uploader-dim",totalProgress:"fl-uploader-total-progress-okay",totalProgressError:"fl-uploader-total-progress-errored"},events:{afterReady:null,onFileDialog:null,afterFileQueued:null,afterFileRemoved:null,onQueueError:null,afterFileDialog:null,onUploadStart:null,onUploadStop:null,onFileStart:null,onFileProgress:null,onFileError:null,onFileSuccess:null,afterFileComplete:null,afterUploadComplete:null},strings:{progress:{toUploadLabel:"To upload: %fileCount %fileLabel (%totalBytes)",totalProgressLabel:"Uploading: %curFileN of %totalFilesN %fileLabel (%currBytes of %totalBytes)",completedLabel:"Uploaded: %curFileN of %totalFilesN %fileLabel (%totalCurrBytes)%errorString",numberOfErrors:", %errorsN %errorLabel",singleFile:"file",pluralFiles:"files",singleError:"error",pluralErrors:"errors"},buttons:{browse:"Browse Files",addMore:"Add More",stopUpload:"Stop Upload",cancelRemaning:"Cancel remaining Uploads",resumeUpload:"Resume Upload"}}});fluid.uploader.errorConstants={HTTP_ERROR:-200,MISSING_UPLOAD_URL:-210,IO_ERROR:-220,SECURITY_ERROR:-230,UPLOAD_LIMIT_EXCEEDED:-240,UPLOAD_FAILED:-250,SPECIFIED_FILE_ID_NOT_FOUND:-260,FILE_VALIDATION_FAILED:-270,FILE_CANCELLED:-280,UPLOAD_STOPPED:-290};fluid.uploader.fileStatusConstants={QUEUED:-1,IN_PROGRESS:-2,ERROR:-3,COMPLETE:-4,CANCELLED:-5};var renderLink=function(renderLocation,text,classes,appendBeside){var link=$("<a href='#'>"+text+"</a>");link.addClass(classes);if(renderLocation==="before"){appendBeside.before(link)}else{appendBeside.after(link)}return link};var toggleVisibility=function(toShow,toHide){if(window.opera){toShow.show().removeClass("hideUploaderForOpera");toHide.show().addClass("hideUploaderForOpera")}else{toShow.show();toHide.hide()}};var defaultControlRenderer=function(that){var degradeLink=renderLink(that.options.defaultRenderLocation,that.options.strings.degradeLinkText,that.options.styles.degradeLinkClass,that.enhancedContainer);degradeLink.addClass("flc-manuallyDegrade-degrade");var enhanceLink=renderLink(that.options.defaultRenderLocation,that.options.strings.enhanceLinkText,that.options.styles.enhanceLinkClass,that.degradedContainer);enhanceLink.addClass("flc-manuallyDegrade-enhance")};var fetchControls=function(that){that.degradeControl=that.locate("degradeControl");that.enhanceControl=that.locate("enhanceControl")};var setupManuallyDegrade=function(that){if(!that.degradedContainer.length){return }fetchControls(that);if(!that.degradeControl.length&&!that.enhanceControl.length){that.options.controlRenderer(that);fetchControls(that)}that.degradeControl.click(that.degrade);that.enhanceControl.click(that.enhance);that.enhanceControl.hide()};var determineContainer=function(options){var defaults=fluid.defaults("fluid.manuallyDegrade");return(options&&options.container)?options.container:defaults.container};fluid.manuallyDegrade=function(component,options){var container=determineContainer(options);var that=fluid.initView("fluid.manuallyDegrade",container,options);var isDegraded=false;that.enhancedContainer=component.container;that.degradedContainer=that.locate("enhanceable");that.degrade=function(){toggleVisibility(that.enhanceControl,that.degradeControl);toggleVisibility(that.degradedContainer,that.enhancedContainer);isDegraded=true};that.enhance=function(){toggleVisibility(that.degradeControl,that.enhanceControl);toggleVisibility(that.enhancedContainer,that.degradedContainer);isDegraded=false};that.isDegraded=function(){return isDegraded};setupManuallyDegrade(that);return that};fluid.defaults("fluid.manuallyDegrade",{container:"body",controlRenderer:defaultControlRenderer,defaultRenderLocation:"before",strings:{degradeLinkText:"Switch to the standard single-file Uploader",enhanceLinkText:"Switch to the Flash-based multi-file Uploader"},selectors:{enhanceable:".fl-ProgEnhance-basic",degradeControl:".flc-manuallyDegrade-degrade",enhanceControl:".flc-manuallyDegrade-enhance"},styles:{degradeLinkClass:"fl-uploader-manually-degrade",enhanceLinkClass:"fl-uploader-manually-enhance"}})})(jQuery,fluid_1_1);var whitespace="\n\r\t ";var closedTags={abbr:true,br:true,col:true,img:true,input:true,link:true,meta:true,param:true,hr:true,area:true,embed:true};XMLP=function(strXML){this.m_xml=strXML;this.m_iP=0;this.m_iState=XMLP._STATE_PROLOG;this.m_stack=[];this.m_attributes={};this.m_emitSynthetic=false};XMLP._NONE=0;XMLP._ELM_B=1;XMLP._ELM_E=2;XMLP._ELM_EMP=3;XMLP._ATT=4;XMLP._TEXT=5;XMLP._ENTITY=6;XMLP._PI=7;XMLP._CDATA=8;XMLP._COMMENT=9;XMLP._DTD=10;XMLP._ERROR=11;XMLP._CONT_XML=0;XMLP._CONT_ALT=1;XMLP._ATT_NAME=0;XMLP._ATT_VAL=1;XMLP._STATE_PROLOG=1;XMLP._STATE_DOCUMENT=2;XMLP._STATE_MISC=3;XMLP._errs=[];XMLP._errs[XMLP.ERR_CLOSE_PI=0]="PI: missing closing sequence";XMLP._errs[XMLP.ERR_CLOSE_DTD=1]="DTD: missing closing sequence";XMLP._errs[XMLP.ERR_CLOSE_COMMENT=2]="Comment: missing closing sequence";XMLP._errs[XMLP.ERR_CLOSE_CDATA=3]="CDATA: missing closing sequence";XMLP._errs[XMLP.ERR_CLOSE_ELM=4]="Element: missing closing sequence";XMLP._errs[XMLP.ERR_CLOSE_ENTITY=5]="Entity: missing closing sequence";XMLP._errs[XMLP.ERR_PI_TARGET=6]="PI: target is required";XMLP._errs[XMLP.ERR_ELM_EMPTY=7]="Element: cannot be both empty and closing";XMLP._errs[XMLP.ERR_ELM_NAME=8]='Element: name must immediatly follow "<"';XMLP._errs[XMLP.ERR_ELM_LT_NAME=9]='Element: "<" not allowed in element names';XMLP._errs[XMLP.ERR_ATT_VALUES=10]="Attribute: values are required and must be in quotes";XMLP._errs[XMLP.ERR_ATT_LT_NAME=11]='Element: "<" not allowed in attribute names';XMLP._errs[XMLP.ERR_ATT_LT_VALUE=12]='Attribute: "<" not allowed in attribute values';XMLP._errs[XMLP.ERR_ATT_DUP=13]="Attribute: duplicate attributes not allowed";XMLP._errs[XMLP.ERR_ENTITY_UNKNOWN=14]="Entity: unknown entity";XMLP._errs[XMLP.ERR_INFINITELOOP=15]="Infinite loop";XMLP._errs[XMLP.ERR_DOC_STRUCTURE=16]="Document: only comments, processing instructions, or whitespace allowed outside of document element";XMLP._errs[XMLP.ERR_ELM_NESTING=17]="Element: must be nested correctly";XMLP.prototype._checkStructure=function(iEvent){var stack=this.m_stack;if(XMLP._STATE_PROLOG==this.m_iState){this.m_iState=XMLP._STATE_DOCUMENT}if(XMLP._STATE_DOCUMENT===this.m_iState){if((XMLP._ELM_B==iEvent)||(XMLP._ELM_EMP==iEvent)){this.m_stack[stack.length]=this.getName()}if((XMLP._ELM_E==iEvent)||(XMLP._ELM_EMP==iEvent)){if(stack.length===0){return XMLP._NONE}var strTop=stack[stack.length-1];this.m_stack.length--;if(strTop===null||strTop!==this.getName()){return this._setErr(XMLP.ERR_ELM_NESTING)}}}return iEvent};XMLP.prototype.getColumnNumber=function(){return SAXStrings.getColumnNumber(this.m_xml,this.m_iP)};XMLP.prototype.getContent=function(){return(this.m_cSrc==XMLP._CONT_XML)?this.m_xml:this.m_cAlt};XMLP.prototype.getContentBegin=function(){return this.m_cB};XMLP.prototype.getContentEnd=function(){return this.m_cE};XMLP.prototype.getLineNumber=function(){return SAXStrings.getLineNumber(this.m_xml,this.m_iP)};XMLP.prototype.getName=function(){return this.m_name};XMLP.prototype.next=function(){return this._checkStructure(this._parse())};XMLP.prototype._parse=function(){var iP=this.m_iP;var xml=this.m_xml;if(iP===xml.length){return XMLP._NONE}var c=xml.charAt(iP);if(c==="<"){var c2=xml.charAt(iP+1);if(c2==="?"){return this._parsePI(iP+2)}else{if(c2==="!"){if(iP===xml.indexOf("<!DOCTYPE",iP)){return this._parseDTD(iP+9)}else{if(iP===xml.indexOf("<!--",iP)){return this._parseComment(iP+4)}else{if(iP===xml.indexOf("<![CDATA[",iP)){return this._parseCDATA(iP+9)}}}}else{return this._parseElement(iP+1)}}}else{return this._parseText(iP)}};var nameRegex=/([^\s\/>]+)/g;var attrStartRegex=/\s*([\w:]+)/gm;var attrValRegex=/\"([^\"]*)\"\s*/gm;var attrValIERegex=/([^\>\s]+)\s*/gm;var closeRegex=/\s*<\//g;XMLP.prototype._parseElement=function(iB){var iE,iDE,iRet;var iType,strN,iLast;iDE=iE=this.m_xml.indexOf(">",iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_ELM)}if(this.m_xml.charAt(iB)=="/"){iType=XMLP._ELM_E;iB++}else{iType=XMLP._ELM_B}if(this.m_xml.charAt(iE-1)=="/"){if(iType==XMLP._ELM_E){return this._setErr(XMLP.ERR_ELM_EMPTY)}iType=XMLP._ELM_EMP;iDE--}nameRegex.lastIndex=iB;var nameMatch=nameRegex.exec(this.m_xml);if(!nameMatch){return this._setErr(XMLP.ERR_ELM_NAME)}strN=nameMatch[1].toLowerCase();if("li"===strN&&iType!==XMLP._ELM_E&&this.m_stack.length>0&&this.m_stack[this.m_stack.length-1]==="li"&&!this.m_emitSynthetic){this.m_name="li";this.m_emitSynthetic=true;return XMLP._ELM_E}this.m_attributes={};this.m_cAlt="";if(nameRegex.lastIndex<iDE){this.m_iP=nameRegex.lastIndex;while(this.m_iP<iDE){attrStartRegex.lastIndex=this.m_iP;var attrMatch=attrStartRegex.exec(this.m_xml);if(!attrMatch){return this._setErr(XMLP.ERR_ATT_VALUES)}var attrname=attrMatch[1].toLowerCase();var attrval;if(this.m_xml.charCodeAt(attrStartRegex.lastIndex)===61){var valRegex=this.m_xml.charCodeAt(attrStartRegex.lastIndex+1)===34?attrValRegex:attrValIERegex;valRegex.lastIndex=attrStartRegex.lastIndex+1;attrMatch=valRegex.exec(this.m_xml);if(!attrMatch){return this._setErr(XMLP.ERR_ATT_VALUES)}attrval=attrMatch[1]}else{attrval=attrname;valRegex=attrStartRegex}if(!this.m_attributes[attrname]){this.m_attributes[attrname]=attrval}else{return this._setErr(XMLP.ERR_ATT_DUP)}this.m_iP=valRegex.lastIndex}}if(strN.indexOf("<")!=-1){return this._setErr(XMLP.ERR_ELM_LT_NAME)}this.m_name=strN;this.m_iP=iE+1;if(closedTags[strN]){closeRegex.lastIndex=iE+1;var closeMatch=closeRegex.exec;if(closeMatch){var matchclose=this.m_xml.indexOf(strN,closeMatch.lastIndex);if(matchclose===closeMatch.lastIndex){return iType}else{return XMLP._ELM_EMP}}}this.m_emitSynthetic=false;return iType};XMLP.prototype._parseCDATA=function(iB){var iE=this.m_xml.indexOf("]]>",iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_CDATA)}this._setContent(XMLP._CONT_XML,iB,iE);this.m_iP=iE+3;return XMLP._CDATA};XMLP.prototype._parseComment=function(iB){var iE=this.m_xml.indexOf("-->",iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_COMMENT)}this._setContent(XMLP._CONT_XML,iB-4,iE+3);this.m_iP=iE+3;return XMLP._COMMENT};XMLP.prototype._parseDTD=function(iB){var iE,strClose,iInt,iLast;iE=this.m_xml.indexOf(">",iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_DTD)}iInt=this.m_xml.indexOf("[",iB);strClose=((iInt!=-1)&&(iInt<iE))?"]>":">";while(true){if(iE==iLast){return this._setErr(XMLP.ERR_INFINITELOOP)}iLast=iE;iE=this.m_xml.indexOf(strClose,iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_DTD)}if(this.m_xml.substring(iE-1,iE+2)!="]]>"){break}}this.m_iP=iE+strClose.length;return XMLP._DTD};XMLP.prototype._parsePI=function(iB){var iE,iTB,iTE,iCB,iCE;iE=this.m_xml.indexOf("?>",iB);if(iE==-1){return this._setErr(XMLP.ERR_CLOSE_PI)}iTB=SAXStrings.indexOfNonWhitespace(this.m_xml,iB,iE);if(iTB==-1){return this._setErr(XMLP.ERR_PI_TARGET)}iTE=SAXStrings.indexOfWhitespace(this.m_xml,iTB,iE);if(iTE==-1){iTE=iE}iCB=SAXStrings.indexOfNonWhitespace(this.m_xml,iTE,iE);if(iCB==-1){iCB=iE}iCE=SAXStrings.lastIndexOfNonWhitespace(this.m_xml,iCB,iE);if(iCE==-1){iCE=iE-1}this.m_name=this.m_xml.substring(iTB,iTE);this._setContent(XMLP._CONT_XML,iCB,iCE+1);this.m_iP=iE+2;return XMLP._PI};XMLP.prototype._parseText=function(iB){var iE=this.m_xml.indexOf("<",iB);if(iE==-1){iE=this.m_xml.length}this._setContent(XMLP._CONT_XML,iB,iE);this.m_iP=iE;return XMLP._TEXT};XMLP.prototype._setContent=function(iSrc){var args=arguments;if(XMLP._CONT_XML==iSrc){this.m_cAlt=null;this.m_cB=args[1];this.m_cE=args[2]}else{this.m_cAlt=args[1];this.m_cB=0;this.m_cE=args[1].length}this.m_cSrc=iSrc};XMLP.prototype._setErr=function(iErr){var strErr=XMLP._errs[iErr];this.m_cAlt=strErr;this.m_cB=0;this.m_cE=strErr.length;this.m_cSrc=XMLP._CONT_ALT;return XMLP._ERROR};SAXStrings={};SAXStrings.WHITESPACE=" \t\n\r";SAXStrings.QUOTES="\"'";SAXStrings.getColumnNumber=function(strD,iP){if(!strD){return -1}iP=iP||strD.length;var arrD=strD.substring(0,iP).split("\n");arrD.length--;var iLinePos=arrD.join("\n").length;return iP-iLinePos};SAXStrings.getLineNumber=function(strD,iP){if(!strD){return -1}iP=iP||strD.length;return strD.substring(0,iP).split("\n").length};SAXStrings.indexOfNonWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iB;i<iE;++i){var c=strD.charAt(i);if(c!==" "&&c!=="\t"&&c!=="\n"&&c!=="\r"){return i}}return -1};SAXStrings.indexOfWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iB;i<iE;i++){if(SAXStrings.WHITESPACE.indexOf(strD.charAt(i))!=-1){return i}}return -1};SAXStrings.lastIndexOfNonWhitespace=function(strD,iB,iE){if(!strD){return -1}iB=iB||0;iE=iE||strD.length;for(var i=iE-1;i>=iB;i--){if(SAXStrings.WHITESPACE.indexOf(strD.charAt(i))==-1){return i}}return -1};SAXStrings.replace=function(strD,iB,iE,strF,strR){if(!strD){return""}iB=iB||0;iE=iE||strD.length;return strD.substring(iB,iE).split(strF).join(strR)};function __unescapeString(str){return str.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&").replace(/&quot;/g,'"').replace(/&apos;/g,"'")}function __escapeString(str){var escAmpRegEx=/&/g;var escLtRegEx=/</g;var escGtRegEx=/>/g;var quotRegEx=/"/g;var aposRegEx=/'/g;str=str.replace(escAmpRegEx,"&amp;");str=str.replace(escLtRegEx,"&lt;");str=str.replace(escGtRegEx,"&gt;");str=str.replace(quotRegEx,"&quot;");str=str.replace(aposRegEx,"&apos;");return str}fluid_1_1=fluid_1_1||{};(function($,fluid){fluid.parseTemplate=function(template,baseURL,scanStart,cutpoints_in,opts){opts=opts||{};var t;var parser;var tagstack;var lumpindex=0;var nestingdepth=0;var justended=false;var defstart=-1;var defend=-1;var parseOptions=opts;var baseURL;var debugMode=false;var cutpoints=[];var cutstatus=[];XMLLump=function(lumpindex,nestingdepth){return{nestingdepth:nestingdepth,lumpindex:lumpindex,parent:t}};function init(baseURLin,debugModeIn,cutpointsIn){t.rootlump=XMLLump(0,-1);tagstack=[t.rootlump];lumpindex=0;nestingdepth=0;justended=false;defstart=-1;defend=-1;baseURL=baseURLin;debugMode=debugModeIn;cutpoints=cutpointsIn;if(cutpoints){for(var i=0;i<cutpoints.length;++i){cutstatus[i]=[];cutpoints[i].tree=fluid.parseSelector(cutpoints[i].selector)}}}function findTopContainer(){for(var i=tagstack.length-1;i>=0;--i){var lump=tagstack[i];if(lump.rsfID!==undefined){return lump}}return t.rootlump}function newLump(){var togo=XMLLump(lumpindex,nestingdepth);if(debugMode){togo.line=parser.getLineNumber();togo.column=parser.getColumnNumber()}t.lumps[lumpindex]=togo;++lumpindex;return togo}function addLump(mmap,ID,lump){var list=mmap[ID];if(!list){list=[];mmap[ID]=list}list[list.length]=lump}function checkContribute(ID,lump){if(ID.indexOf("scr=contribute-")!==-1){var scr=ID.substring("scr=contribute-".length);addLump(t.collectmap,scr,lump)}}function rewriteUrl(url){url=fluid.rewriteUrlPrefix(parseOptions,url);if(!parseOptions.rebaseURLs){return url}var po=fluid.parseUri(url);if(po.protocol||url.charAt(0)==="/"){return url}else{return baseURL+url}}function debugLump(lump){return"<"+lump.tagname+">"}function hasCssClass(clazz,totest){if(!totest){return false}return(" "+totest+" ").indexOf(" "+clazz+" ")!==-1}function matchNode(term,headlump){if(term.predList){for(var i=0;i<term.predList.length;++i){var pred=term.predList[i];if(pred.id&&headlump.attributemap.id!==pred.id){return false}if(pred.clazz&&!hasCssClass(pred.clazz,headlump.attributemap["class"])){return false}if(pred.tag&&headlump.tagname!==pred.tag){return false}}return true}}function tagStartCut(headlump){var togo=undefined;if(cutpoints){for(var i=0;i<cutpoints.length;++i){var cut=cutpoints[i];var cutstat=cutstatus[i];var nextterm=cutstat.length;if(nextterm<cut.tree.length){var term=cut.tree[nextterm];if(nextterm>0){if(cut.tree[nextterm-1].child&&cutstat[nextterm-1]!==headlump.nestingdepth-1){continue}}var isMatch=matchNode(term,headlump);if(isMatch){cutstat[cutstat.length]=headlump.nestingdepth;if(cutstat.length===cut.tree.length){if(togo!==undefined){fluid.fail("Cutpoint specification error - node "+debugLump(headlump)+" has already matched with rsf:id of "+togo)}if(cut.id===undefined||cut.id===null){fluid.fail("Error in cutpoints list - entry at position "+i+" does not have an id set")}togo=cut.id}}}}}return togo}function tagEndCut(){if(cutpoints){for(var i=0;i<cutpoints.length;++i){var cutstat=cutstatus[i];if(cutstat.length>0&&cutstat[cutstat.length-1]===nestingdepth){cutstat.length--}}}}function processTagStart(isempty,text){++nestingdepth;if(justended){justended=false;var backlump=newLump();backlump.nestingdepth--}if(t.firstdocumentindex===-1){t.firstdocumentindex=lumpindex}var headlump=newLump();var stacktop=tagstack[tagstack.length-1];headlump.uplump=stacktop;var tagname=parser.getName();headlump.tagname=tagname;var attrs=headlump.attributemap=parser.m_attributes;var ID=attrs[fluid.ID_ATTRIBUTE];if(ID===undefined){ID=tagStartCut(headlump)}for(var attrname in attrs){var attrval=attrs[attrname];if(/href|src|codebase|action/.test(attrname)){attrval=rewriteUrl(attrval);attrs[attrname]=attrval}else{if(ID===undefined&&/for|headers/.test(attrname)){ID=attrs[fluid.ID_ATTRIBUTE]="scr=null"}}}if(ID){if(ID.charCodeAt(0)===126){ID=ID.substring(1);headlump.elide=true}checkContribute(ID,headlump);headlump.rsfID=ID;var downreg=findTopContainer();if(!downreg.downmap){downreg.downmap={}}addLump(downreg.downmap,ID,headlump);addLump(t.globalmap,ID,headlump);var colpos=ID.indexOf(":");if(colpos!==-1){var prefix=ID.substring(0,colpos);if(!stacktop.finallump){stacktop.finallump={}}stacktop.finallump[prefix]=headlump}}headlump.text="<"+tagname+fluid.dumpAttributes(attrs)+">";tagstack[tagstack.length]=headlump;if(isempty){processTagEnd()}}function processTagEnd(){tagEndCut();var endlump=newLump();--nestingdepth;endlump.text="</"+parser.getName()+">";var oldtop=tagstack[tagstack.length-1];oldtop.close_tag=t.lumps[lumpindex-1];tagstack.length--;justended=true}function processDefaultTag(){if(defstart!==-1){if(t.firstdocumentindex===-1){t.firstdocumentindex=lumpindex}var text=parser.getContent().substr(defstart,defend-defstart);justended=false;var newlump=newLump();newlump.text=text;defstart=-1}}t=fluid.XMLViewTemplate();init(baseURL,opts.debugMode,cutpoints_in);var idpos=template.indexOf(fluid.ID_ATTRIBUTE);if(scanStart){var brackpos=template.indexOf(">",idpos);parser=new XMLP(template.substring(brackpos+1))}else{parser=new XMLP(template)}parseloop:while(true){var iEvent=parser.next();switch(iEvent){case XMLP._ELM_B:processDefaultTag();processTagStart(false,"");break;case XMLP._ELM_E:processDefaultTag();processTagEnd();break;case XMLP._ELM_EMP:processDefaultTag();processTagStart(true,"");break;case XMLP._PI:case XMLP._DTD:defstart=-1;continue;case XMLP._TEXT:case XMLP._ENTITY:case XMLP._CDATA:case XMLP._COMMENT:if(defstart===-1){defstart=parser.m_cB}defend=parser.m_cE;break;case XMLP._ERROR:fluid.setLogging(true);var message="Error parsing template: "+parser.m_cAlt+" at line "+parser.getLineNumber();fluid.log(message);fluid.log("Just read: "+parser.m_xml.substring(parser.m_iP-30,parser.m_iP));fluid.log("Still to read: "+parser.m_xml.substring(parser.m_iP,parser.m_iP+30));fluid.fail(message);break parseloop;case XMLP._NONE:break parseloop}}processDefaultTag();return t};fluid.debugLump=function(lump){var togo=lump.text;togo+=" at ";togo+="lump line "+lump.line+" column "+lump.column+" index "+lump.lumpindex;togo+=lump.parent.href===null?"":" in file "+lump.parent.href;return togo};fluid.rewriteUrlPrefix=function(options,URL){var pre=options.rewriteUrlPrefixes;if(pre){for(var i=0;i<pre.length;++i){if(URL.indexOf(pre[i].source)===0){return pre[i].target+URL.substring(pre[i].source.length)}}}return URL};fluid.parseUri=function(source){var o=fluid.parseUri.options,value=o.parser[o.strictMode?"strict":"loose"].exec(source);for(var i=0,uri={};i<14;i++){uri[o.key[i]]=value[i]||""}uri[o.q.name]={};uri[o.key[12]].replace(o.q.parser,function($0,$1,$2){if($1){uri[o.q.name][$1]=$2}});return uri};fluid.parseUri.options={strictMode:false,key:["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],q:{name:"queryKey",parser:/(?:^|&)([^&=]*)=?([^&]*)/g},parser:{strict:/^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,loose:/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/}};fluid.ID_ATTRIBUTE="rsf:id";fluid.getPrefix=function(id){var colpos=id.indexOf(":");return colpos===-1?id:id.substring(0,colpos)};fluid.SplitID=function(id){var that={};var colpos=id.indexOf(":");if(colpos===-1){that.prefix=id}else{that.prefix=id.substring(0,colpos);that.suffix=id.substring(colpos+1)}return that};fluid.XMLViewTemplate=function(){return{globalmap:{},collectmap:{},lumps:[],firstdocumentindex:-1}};fluid.fetchResources=function(resourceSpecs,callback){var resourceCallback=function(thisSpec){return{success:function(response){thisSpec.resourceText=response;thisSpec.resourceKey=thisSpec.href;thisSpec.queued=false;fluid.fetchResources(resourceSpecs,callback)},error:function(response,textStatus,errorThrown){thisSpec.fetchError={status:response.status,textStatus:response.textStatus,errorThrown:errorThrown};thisSpec.queued=false;fluid.fetchResources(resourceSpecs,callback)}}};var complete=true;for(var key in resourceSpecs){var resourceSpec=resourceSpecs[key];if(resourceSpec.href&&!(resourceSpec.resourceKey||resourceSpec.fetchError)){if(!resourceSpec.queued){var thisCallback=resourceCallback(resourceSpec);var options={url:resourceSpec.href,success:thisCallback.success,error:thisCallback.error};$.extend(true,options,resourceSpec.options);resourceSpec.queued=true;$.ajax(options)}if(resourceSpec.queued){complete=false}}else{if(resourceSpec.nodeId&&!resourceSpec.resourceText){var node=document.getElementById(resourceSpec.nodeId);resourceSpec.resourceText=fluid.dom.getElementText(node);resourceSpec.resourceKey=resourceSpec.nodeId}}}if(complete){if($.browser.mozilla){setTimeout(function(){callback(resourceSpecs)},1)}else{callback(resourceSpecs)}}};fluid.XMLEncode=function(text){return text.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")};fluid.dumpAttributes=function(attrcopy){var togo="";for(var attrname in attrcopy){var attrvalue=attrcopy[attrname];if(attrvalue!==null&&attrvalue!==undefined){togo+=" "+attrname+'="'+attrvalue+'"'}}return togo};fluid.aggregateMMap=function(target,source){for(var key in source){var targhas=target[key];if(!targhas){target[key]=[]}target[key]=target[key].concat(source[key])}};var unUnicode=/(\\u[\dabcdef]{4}|\\x[\dabcdef]{2})/g;fluid.unescapeProperties=function(string){string=string.replace(unUnicode,function(match){var code=match.substring(2);var parsed=parseInt(code,16);return String.fromCharCode(parsed)});var pos=0;while(true){var backpos=string.indexOf("\\",pos);if(backpos===-1){break}if(backpos===string.length-1){return[string.substring(0,string.length-1),true]}var replace=string.charAt(backpos+1);if(replace==="n"){replace="\n"}if(replace==="r"){replace="\r"}if(replace==="t"){replace="\t"}string=string.substring(0,backpos)+replace+string.substring(backpos+2);pos=backpos+1}return[string,false]};var breakPos=/[^\\][\s:=]/;fluid.parseJavaProperties=function(text){var togo={};text=text.replace(/\r\n/g,"\n");text=text.replace(/\r/g,"\n");lines=text.split("\n");var contin,key,valueComp,valueRaw,valueEsc;for(var i=0;i<lines.length;++i){var line=$.trim(lines[i]);if(!line||line.charAt(0)==="#"||line.charAt(0)==="!"){continue}if(!contin){valueComp="";var breakpos=line.search(breakPos);if(breakpos===-1){key=line;valueRaw=""}else{key=$.trim(line.substring(0,breakpos+1));valueRaw=$.trim(line.substring(breakpos+2));if(valueRaw.charAt(0)===":"||valueRaw.charAt(0)==="="){valueRaw=$.trim(valueRaw.substring(1))}}key=fluid.unescapeProperties(key)[0];valueEsc=fluid.unescapeProperties(valueRaw)}else{valueEsc=fluid.unescapeProperties(line)}contin=valueEsc[1];if(!valueEsc[1]){togo[key]=valueComp+valueEsc[0]}else{valueComp+=valueEsc[0]}}return togo};fluid.parseTemplates=function(resourceSpec,templateList,opts){var togo=[];togo.globalmap={};for(var i=0;i<templateList.length;++i){var resource=resourceSpec[templateList[i]];var lastslash=resource.href.lastIndexOf("/");var baseURL=lastslash===-1?"":resource.href.substring(0,lastslash+1);var template=fluid.parseTemplate(resource.resourceText,baseURL,opts.scanStart&&i===0,resource.cutpoints,opts);if(i===0){fluid.aggregateMMap(togo.globalmap,template.globalmap)}template.href=resource.href;template.baseURL=baseURL;template.resourceKey=resource.resourceKey;togo[i]=template;fluid.aggregateMMap(togo.globalmap,template.rootlump.downmap)}return togo};var chars="(?:[\\w\u0128-\uFFFF*_-]|\\\\.)";var quickChild=new RegExp("^>\\s*("+chars+"+)");var quickID=new RegExp("^("+chars+"+)(#)("+chars+"+)");var selSeg=new RegExp("^s*([#.]?)("+chars+"*)");var quickClass=new RegExp("([#.]?)("+chars+"+)","g");var childSeg=new RegExp("\\s*(>)?\\s*","g");var whiteSpace=new RegExp("^\\w*$");fluid.parseSelector=function(selstring){var togo=[];selstring=$.trim(selstring);quickClass.lastIndex=0;var lastIndex=0;while(true){var atNode=[];while(true){var segMatch=quickClass.exec(selstring);if(!segMatch||segMatch.index!==lastIndex){break}var thisNode={};var text=segMatch[2];if(segMatch[1]===""){thisNode.tag=text}else{if(segMatch[1]==="#"){thisNode.id=text}else{if(segMatch[1]==="."){thisNode.clazz=text}}}atNode[atNode.length]=thisNode;lastIndex=quickClass.lastIndex}childSeg.lastIndex=lastIndex;var fullAtNode={predList:atNode};var childMatch=childSeg.exec(selstring);if(!childMatch||childMatch.index!==lastIndex){var remainder=selstring.substring(lastIndex);fluid.fail("Error in selector string - can not match child selector expression at "+remainder)}if(childMatch[1]===">"){fullAtNode.child=true}togo[togo.length]=fullAtNode;if(childSeg.lastIndex>=selstring.length){break}lastIndex=childSeg.lastIndex;quickClass.lastIndex=childSeg.lastIndex}return togo}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){function debugPosition(component){return"as child of "+(component.parent.fullID?"component with full ID "+component.parent.fullID:"root")}function computeFullID(component){var togo="";var move=component;if(component.children===undefined){togo=component.ID+(component.localID!==undefined?component.localID:"");move=component.parent}while(move.parent){var parent=move.parent;if(move.fullID!==undefined){togo=move.fullID+togo;return togo}if(move.noID===undefined){var ID=move.ID;if(ID===undefined){fluid.fail("Error in component tree - component found with no ID "+debugPosition(parent)+": please check structure")}var colpos=ID.indexOf(":");var prefix=colpos===-1?ID:ID.substring(0,colpos);togo=prefix+":"+(move.localID===undefined?"":move.localID)+":"+togo}move=parent}return togo}function isBoundPrimitive(value){return fluid.isPrimitive(value)||value instanceof Array&&(value.length===0||typeof (value[0])==="string")}function processChild(value,key){if(isBoundPrimitive(value)){return{componentType:"UIBound",value:value,ID:key}}else{var unzip=unzipComponent(value);if(unzip.ID){return{ID:key,componentType:"UIContainer",children:[unzip]}}else{unzip.ID=key;return unzip}}}function fixChildren(children){if(!(children instanceof Array)){var togo=[];for(var key in children){var value=children[key];if(value instanceof Array){for(var i=0;i<value.length;++i){var processed=processChild(value[i],key);togo[togo.length]=processed}}else{togo[togo.length]=processChild(value,key)}}return togo}else{return children}}function fixupValue(uibound,model){if(uibound.value===undefined&&uibound.valuebinding!==undefined){if(!model){fluid.fail("Cannot perform value fixup for valuebinding "+uibound.valuebinding+" since no model was supplied to rendering")}uibound.value=fluid.model.getBeanValue(model,uibound.valuebinding)}}function upgradeBound(holder,property,model){if(holder[property]!==undefined){if(isBoundPrimitive(holder[property])){holder[property]={value:holder[property]}}}else{holder[property]={value:null}}fixupValue(holder[property],model)}var duckMap={children:"UIContainer",value:"UIBound",valuebinding:"UIBound",messagekey:"UIMessage",markup:"UIVerbatim",selection:"UISelect",target:"UILink",choiceindex:"UISelectChoice",functionname:"UIInitBlock"};function unzipComponent(component,model){if(component){for(var key in duckMap){if(component[key]!==undefined){component.componentType=duckMap[key];break}}if(component.componentType===undefined&&component.ID!==undefined){component.componentType="UIBound"}}if(!component||component.componentType===undefined){var decorators=component.decorators;if(decorators){delete component.decorators}component={componentType:"UIContainer",children:component};component.decorators=decorators}var cType=component.componentType;if(cType==="UIContainer"){component.children=fixChildren(component.children)}else{if(cType==="UISelect"){upgradeBound(component,"selection",model);upgradeBound(component,"optionlist",model);upgradeBound(component,"optionnames",model)}else{if(cType==="UILink"){upgradeBound(component,"target",model);upgradeBound(component,"linktext",model)}}}return component}function assignSubmittingName(component,defaultname){if(component.submittingname===undefined&&component.willinput!==false){component.submittingname=defaultname?defaultname:component.fullID}return component.submittingname}function fixupTree(tree,model){if(tree.componentType===undefined){tree=unzipComponent(tree,model)}if(tree.componentType!=="UIContainer"&&!tree.parent){tree={children:[tree]}}if(tree.children){tree.childmap={};for(var i=0;i<tree.children.length;++i){var child=tree.children[i];if(child.componentType===undefined){child=unzipComponent(child,model);tree.children[i]=child}child.parent=tree;if(child.ID===undefined){fluid.fail("Error in component tree: component found with no ID "+debugPosition(child))}tree.childmap[child.ID]=child;var colpos=child.ID.indexOf(":");if(colpos===-1){}else{var prefix=child.ID.substring(0,colpos);var childlist=tree.childmap[prefix];if(!childlist){childlist=[];tree.childmap[prefix]=childlist}if(child.localID===undefined&&childlist.length!==0){child.localID=childlist.length}childlist[childlist.length]=child}child.fullID=computeFullID(child);var componentType=child.componentType;if(componentType=="UISelect"){child.selection.fullID=child.fullID+"-selection"}else{if(componentType=="UIInitBlock"){var call=child.functionname+"(";for(var j=0;j<child.arguments.length;++j){if(child.arguments[j] instanceof fluid.ComponentReference){child.arguments[j]=child.parent.fullID+child.arguments[j].reference}call+='"'+child.arguments[j]+'"';if(j<child.arguments.length-1){call+=", "}}child.markup=call+")\n";child.componentType="UIVerbatim"}else{if(componentType=="UIBound"){fixupValue(child,model)}}}fixupTree(child,model)}}return tree}fluid.NULL_STRING="\u25a9null\u25a9";var LINK_ATTRIBUTES={a:"href",link:"href",img:"src",frame:"src",script:"src",style:"src",input:"src",embed:"src",form:"action",applet:"codebase",object:"codebase"};fluid.renderer=function(templates,tree,options,fossilsIn){options=options||{};tree=tree||{};debugMode=options.debugMode;if(!options.messageLocator&&options.messageSource){options.messageLocator=fluid.resolveMessageSource(options.messageSource)}options.document=options.document||document;var directFossils=fossilsIn||{};var globalmap={};var branchmap={};var rewritemap={};var seenset={};var collected={};var out="";var debugMode=false;var renderOptions=options;var decoratorQueue=[];var renderedbindings={};var that={};function getRewriteKey(template,parent,id){return template.resourceKey+parent.fullID+id}function resolveInScope(searchID,defprefix,scope,child){var deflump;var scopelook=scope?scope[searchID]:null;if(scopelook){for(var i=0;i<scopelook.length;++i){var scopelump=scopelook[i];if(!deflump&&scopelump.rsfID==defprefix){deflump=scopelump}if(scopelump.rsfID==searchID){return scopelump}}}return deflump}function resolveCall(sourcescope,child){var searchID=child.jointID?child.jointID:child.ID;var split=fluid.SplitID(searchID);var defprefix=split.prefix+":";var match=resolveInScope(searchID,defprefix,sourcescope.downmap,child);if(match){return match}if(child.children){match=resolveInScope(searchID,defprefix,globalmap,child);if(match){return match}}return null}function noteCollected(template){if(!seenset[template.href]){fluid.aggregateMMap(collected,template.collectmap);seenset[template.href]=true}}function resolveRecurse(basecontainer,parentlump){for(var i=0;i<basecontainer.children.length;++i){var branch=basecontainer.children[i];if(branch.children){var resolved=resolveCall(parentlump,branch);if(resolved){branchmap[branch.fullID]=resolved;var id=resolved.attributemap.id;if(id!==undefined){rewritemap[getRewriteKey(parentlump.parent,basecontainer,id)]=branch.fullID}noteCollected(resolved.parent);resolveRecurse(branch,resolved)}}}if(parentlump.downmap){for(var id in parentlump.downmap){var lumps=parentlump.downmap[id];for(var i=0;i<lumps.length;++i){var lump=lumps[i];var lumpid=lump.attributemap.id;if(lumpid!==undefined&&lump.rsfID!==undefined){var resolved=fetchComponent(basecontainer,lump.rsfID);if(resolved!==null){var resolveID=resolved.fullID;if(resolved.componentType==="UISelect"){resolveID=resolveID+"-selection"}rewritemap[getRewriteKey(parentlump.parent,basecontainer,lumpid)]=resolveID}}}}}}function resolveBranches(globalmapp,basecontainer,parentlump){branchmap={};rewritemap={};seenset={};collected={};globalmap=globalmapp;branchmap[basecontainer.fullID]=parentlump;resolveRecurse(basecontainer,parentlump)}function dumpBranchHead(branch,targetlump){if(targetlump.elide){return }var attrcopy={};$.extend(true,attrcopy,targetlump.attributemap);adjustForID(attrcopy,branch);outDecorators(branch,attrcopy);out+="<"+targetlump.tagname+" ";out+=fluid.dumpAttributes(attrcopy);out+=">"}function dumpTillLump(lumps,start,limit){for(;start<limit;++start){var text=lumps[start].text;if(text){out+=lumps[start].text}}}function dumpScan(lumps,renderindex,basedepth,closeparent,insideleaf){var start=renderindex;while(true){if(renderindex===lumps.length){break}var lump=lumps[renderindex];if(lump.nestingdepth<basedepth){break}if(lump.rsfID!==undefined){if(!insideleaf){break}if(insideleaf&&lump.nestingdepth>basedepth+(closeparent?0:1)){fluid.log("Error in component tree - leaf component found to contain further components - at "+lump.toString())}else{break}}++renderindex}if(!closeparent&&(renderindex==lumps.length||!lumps[renderindex].rsfID)){--renderindex}dumpTillLump(lumps,start,renderindex);return renderindex}var trc={};function openTag(){if(!trc.iselide){out+="<"+trc.uselump.tagname}}function closeTag(){if(!trc.iselide){out+="</"+trc.uselump.tagname+">"}}function renderUnchanged(){dumpTillLump(trc.uselump.parent.lumps,trc.uselump.lumpindex+1,trc.close.lumpindex+(trc.iselide?0:1))}function replaceAttributes(){if(!trc.iselide){out+=fluid.dumpAttributes(trc.attrcopy)}dumpTemplateBody()}function replaceAttributesOpen(){if(trc.iselide){replaceAttributes()}else{out+=fluid.dumpAttributes(trc.attrcopy);out+=">";trc.nextpos=trc.endopen.lumpindex}}function dumpTemplateBody(){if(trc.endopen.lumpindex===trc.close.lumpindex){if(!trc.iselide){out+="/>"}}else{if(!trc.iselide){out+=">"}dumpTillLump(trc.uselump.parent.lumps,trc.endopen.lumpindex,trc.close.lumpindex+(trc.iselide?0:1))}}function rewriteLeaf(value){if(isValue(value)){replaceBody(value)}else{replaceAttributes()}}function rewriteLeafOpen(value){if(trc.iselide){rewriteLeaf(trc.value)}else{if(isValue(value)){replaceBody(value)}else{replaceAttributesOpen()}}}function replaceBody(value){out+=fluid.dumpAttributes(trc.attrcopy);if(!trc.iselide){out+=">"}out+=fluid.XMLEncode(value.toString());closeTag()}function isValue(value){return value!==null&&value!==undefined&&!isPlaceholder(value)}function isPlaceholder(value){return false}function rewriteURL(template,URL){var togo=URL;return fluid.rewriteUrlPrefix(renderOptions,togo)}function dumpHiddenField(todump){out+='<input type="hidden" ';var isvirtual=todump.virtual;var outattrs={};outattrs[isvirtual?"id":"name"]=todump.name;outattrs.value=todump.value;out+=fluid.dumpAttributes(outattrs);out+=" />\n"}function applyAutoBind(torender,finalID){var tagname=trc.uselump.tagname;var applier=renderOptions.applier;function applyFunc(){fluid.applyChange(fluid.byId(finalID),undefined,applier)}if(renderOptions.autoBind&&/input|select|textarea/.test(tagname)&&!renderedbindings[finalID]){var decorators=[{jQuery:["change",applyFunc]}];if($.browser.msie&&tagname==="input"&&/radio|checkbox/.test(trc.attrcopy.type)){decorators.push({jQuery:["click",applyFunc]})}outDecoratorsImpl(torender,decorators,trc.attrcopy,finalID)}}function dumpBoundFields(torender,parent){if(torender){var holder=parent?parent:torender;if(directFossils&&holder.submittingname&&holder.valuebinding){directFossils[holder.submittingname]={name:holder.submittingname,EL:holder.valuebinding,oldvalue:holder.value};applyAutoBind(torender,torender.fullID)}if(torender.fossilizedbinding){dumpHiddenField(torender.fossilizedbinding)}if(torender.fossilizedshaper){dumpHiddenField(torender.fossilizedshaper)}}}function dumpSelectionBindings(uiselect){if(!renderedbindings[uiselect.selection.fullID]){renderedbindings[uiselect.selection.fullID]=true;dumpBoundFields(uiselect.selection);dumpBoundFields(uiselect.optionlist);dumpBoundFields(uiselect.optionnames)}}function isSelectedValue(torender,value){var selection=torender.selection;return selection.value&&typeof (selection.value)!=="string"&&typeof (selection.value.length)==="number"?$.inArray(value,selection.value,value)!==-1:selection.value===value}function getRelativeComponent(component,relativeID){component=component.parent;while(relativeID.indexOf("..::")===0){relativeID=relativeID.substring(4);component=component.parent}return component.childmap[relativeID]}function explodeDecorators(decorators){var togo=[];if(decorators.type){togo[0]=decorators}else{for(var key in decorators){if(key==="$"){key="jQuery"}var value=decorators[key];var decorator={type:key};if(key==="jQuery"){decorator.func=value[0];decorator.args=value.slice(1)}else{if(key==="addClass"||key==="removeClass"){decorator.classes=value}else{if(key==="attrs"){decorator.attributes=value}else{if(key==="identify"){decorator.key=value}}}}togo[togo.length]=decorator}}return togo}function outDecoratorsImpl(torender,decorators,attrcopy,finalID){renderOptions.idMap=renderOptions.idMap||{};for(var i=0;i<decorators.length;++i){var decorator=decorators[i];var type=decorator.type;if(!type){var explodedDecorators=explodeDecorators(decorator);outDecoratorsImpl(torender,explodedDecorators,attrcopy,finalID);continue}if(type==="$"){type=decorator.type="jQuery"}if(type==="jQuery"||type==="event"||type==="fluid"){var id=adjustForID(attrcopy,torender,true,finalID);decorator.id=id;decoratorQueue[decoratorQueue.length]=decorator}else{if(type==="attrs"){$.extend(true,attrcopy,decorator.attributes)}else{if(type==="addClass"||type==="removeClass"){var fakeNode={nodeType:1,className:attrcopy["class"]||""};$(fakeNode)[type](decorator.classes);attrcopy["class"]=fakeNode.className}else{if(type==="identify"){var id=adjustForID(attrcopy,torender,true,finalID);renderOptions.idMap[decorator.key]=id}}}}}}function outDecorators(torender,attrcopy){if(!torender.decorators){return }if(torender.decorators.length===undefined){torender.decorators=explodeDecorators(torender.decorators)}outDecoratorsImpl(torender,torender.decorators,attrcopy)}function renderComponent(torender){var attrcopy=trc.attrcopy;var lumps=trc.uselump.parent.lumps;var lumpindex=trc.uselump.lumpindex;var componentType=torender.componentType;var tagname=trc.uselump.tagname;outDecorators(torender,attrcopy);if(componentType==="UIMessage"){componentType="UIBound";if(!renderOptions.messageLocator){torender.value="[No messageLocator is configured in options - please consult documentation on options.messageSource]"}else{torender.value=renderOptions.messageLocator(torender.messagekey,torender.args)}}function makeFail(torender,end){fluid.fail("Error in component tree - UISelectChoice with id "+torender.fullID+end)}if(componentType==="UIBound"||componentType==="UISelectChoice"){var parent;if(torender.choiceindex!==undefined){if(torender.parentFullID){parent=getAbsoluteComponent(view,torender.parentFullID);if(!parent){makeFail(torender," has parentFullID of "+torender.parentFullID+" which cannot be resolved")}}else{if(torender.parentRelativeID!==undefined){parent=getRelativeComponent(torender,torender.parentRelativeID);if(!parent){makeFail(torender," has parentRelativeID of "+torender.parentRelativeID+" which cannot be resolved")}}else{makeFail(torender," does not have either parentFullID or parentRelativeID set")}}assignSubmittingName(parent.selection);dumpSelectionBindings(parent)}var submittingname=parent?parent.selection.submittingname:torender.submittingname;if(tagname==="input"||tagname==="textarea"){if(!parent){submittingname=assignSubmittingName(torender)}if(submittingname!==undefined){attrcopy.name=submittingname}}dumpBoundFields(torender,parent?parent.selection:null);if(typeof (torender.value)==="boolean"||attrcopy.type==="radio"||attrcopy.type==="checkbox"){var underlyingValue;var directValue=torender.value;if(torender.choiceindex!==undefined){if(!parent.optionlist.value){fluid.fail("Error in component tree - selection control with full ID "+parent.fullID+" has no values")}underlyingValue=parent.optionlist.value[torender.choiceindex];directValue=isSelectedValue(parent,underlyingValue)}if(isValue(directValue)){if(directValue){attrcopy.checked="checked"}else{delete attrcopy.checked}}attrcopy.value=underlyingValue?underlyingValue:"true";rewriteLeaf(null)}else{if(torender.value instanceof Array){renderUnchanged()}else{var value=parent?parent[tagname==="textarea"||tagname==="input"?"optionlist":"optionnames"].value[torender.choiceindex]:torender.value;if(tagname==="textarea"){if(isPlaceholder(value)&&torender.willinput){value=""}rewriteLeaf(value)}else{if(tagname==="input"){if(torender.willinput||isValue(value)){attrcopy.value=value}rewriteLeaf(null)}else{delete attrcopy.name;rewriteLeafOpen(value)}}}}}else{if(componentType==="UISelect"){applyAutoBind(torender,torender.selection.fullID);var ishtmlselect=tagname==="select";var ismultiple=false;if(torender.selection.value instanceof Array){ismultiple=true;if(ishtmlselect){attrcopy.multiple="multiple"}}assignSubmittingName(torender.selection,attrcopy.id);if(ishtmlselect){if(torender.selection.willinput!==false){attrcopy.name=torender.selection.submittingname}}out+=fluid.dumpAttributes(attrcopy);if(ishtmlselect){out+=">";var values=torender.optionlist.value;var names=torender.optionnames===null||torender.optionnames===undefined||!torender.optionnames.value?values:torender.optionnames.value;if(!names||!names.length){fluid.fail("Error in component tree - UISelect component with fullID "+torender.fullID+" does not have optionnames set")}for(var i=0;i<names.length;++i){out+='<option value="';var value=values[i];if(value===null){value=fluid.NULL_STRING}out+=fluid.XMLEncode(value);if(isSelectedValue(torender,value)){out+='" selected="selected'}out+='">';out+=fluid.XMLEncode(names[i]);out+="</option>\n"}closeTag()}else{dumpTemplateBody()}dumpSelectionBindings(torender)}else{if(componentType==="UILink"){var attrname=LINK_ATTRIBUTES[tagname];if(attrname){var target=torender.target.value;if(!isValue(target)){target=attrcopy[attname]}else{target=rewriteURL(trc.uselump.parent,target)}attrcopy[attrname]=target}var value=torender.linktext.value;if(!isValue(value)){replaceAttributesOpen()}else{rewriteLeaf(value)}}else{if(torender.markup!==undefined){var rendered=torender.markup;if(rendered===null){out+=fluid.dumpAttributes(attrcopy);out+=">";renderUnchanged()}else{if(!trc.iselide){out+=fluid.dumpAttributes(attrcopy);out+=">"}out+=rendered;closeTag()}}else{}}}}}function adjustForID(attrcopy,component,late,forceID){if(!late){delete attrcopy["rsf:id"]}if(forceID!==undefined){attrcopy.id=forceID}else{if(attrcopy.id||late){attrcopy.id=component.fullID}}var count=1;var baseid=attrcopy.id;while(renderOptions.document.getElementById(attrcopy.id)){attrcopy.id=baseid+"-"+(count++)}return attrcopy.id}function rewriteIDRelation(context){var attrname;var attrval=trc.attrcopy["for"];if(attrval!==undefined){attrname="for"}else{attrval=trc.attrcopy.headers;if(attrval!==undefined){attrname="headers"}}if(!attrname){return }var tagname=trc.uselump.tagname;if(attrname==="for"&&tagname!=="label"){return }if(attrname==="headers"&&tagname!=="td"&&tagname!=="th"){return }var rewritten=rewritemap[getRewriteKey(trc.uselump.parent,context,attrval)];if(rewritten!==undefined){trc.attrcopy[attrname]=rewritten}}function renderComment(message){out+=("<!-- "+fluid.XMLEncode(message)+"-->")}function renderDebugMessage(message){out+='<span style="background-color:#FF466B;color:white;padding:1px;">';out+=message;out+="</span><br/>"}function reportPath(branch){var path=branch.fullID;return !path?"component tree root":"full path "+path}function renderComponentSystem(context,torendero,lump){var lumpindex=lump.lumpindex;var lumps=lump.parent.lumps;var nextpos=-1;var outerendopen=lumps[lumpindex+1];var outerclose=lump.close_tag;nextpos=outerclose.lumpindex+1;var payloadlist=lump.downmap?lump.downmap["payload-component"]:null;var payload=payloadlist?payloadlist[0]:null;var iselide=lump.rsfID.charCodeAt(0)===126;var endopen=outerendopen;var close=outerclose;var uselump=lump;var attrcopy={};$.extend(true,attrcopy,(payload===null?lump:payload).attributemap);trc.attrcopy=attrcopy;trc.uselump=uselump;trc.endopen=endopen;trc.close=close;trc.nextpos=nextpos;trc.iselide=iselide;rewriteIDRelation(context);if(torendero===null){if(lump.rsfID.indexOf("scr=")===(iselide?1:0)){var scrname=lump.rsfID.substring(4+(iselide?1:0));if(scrname==="ignore"){nextpos=trc.close.lumpindex+1}else{openTag();replaceAttributesOpen();nextpos=trc.endopen.lumpindex}}}else{if(payload){trc.endopen=lumps[payload.lumpindex+1];trc.close=payload.close_tag;trc.uselump=payload;dumpTillLump(lumps,lumpindex,payload.lumpindex);lumpindex=payload.lumpindex}adjustForID(attrcopy,torendero);openTag();renderComponent(torendero);if(payload!==null){if(trc.nextpos===nextpos){dumpTillLump(lumps,trc.close.lumpindex+1,outerclose.lumpindex+1)}}nextpos=trc.nextpos}return nextpos}function renderContainer(child,targetlump){var t2=targetlump.parent;var firstchild=t2.lumps[targetlump.lumpindex+1];if(child.children!==undefined){dumpBranchHead(child,targetlump)}else{renderComponentSystem(child.parent,child,targetlump)}renderRecurse(child,targetlump,firstchild)}function fetchComponent(basecontainer,id,lump){if(id.indexOf("msg=")===0){var key=id.substring(4);return{componentType:"UIMessage",messagekey:key}}while(basecontainer){var togo=basecontainer.childmap[id];if(togo){return togo}basecontainer=basecontainer.parent}return null}function fetchComponents(basecontainer,id){var togo;while(basecontainer){togo=basecontainer.childmap[id];if(togo){break}basecontainer=basecontainer.parent}return togo}function findChild(sourcescope,child){var split=fluid.SplitID(child.ID);var headlumps=sourcescope.downmap[child.ID];if(headlumps===null){headlumps=sourcescope.downmap[split.prefix+":"]}return headlumps===null?null:headlumps[0]}function renderRecurse(basecontainer,parentlump,baselump){var renderindex=baselump.lumpindex;var basedepth=parentlump.nestingdepth;var t1=parentlump.parent;if(debugMode){var rendered={}}while(true){renderindex=dumpScan(t1.lumps,renderindex,basedepth,!parentlump.elide,false);if(renderindex===t1.lumps.length){break}var lump=t1.lumps[renderindex];var id=lump.rsfID;if(lump.nestingdepth<basedepth||id===undefined){break}if(id.charCodeAt(0)===126){id=id.substring(1)}if(id.indexOf(":")!==-1){var prefix=fluid.getPrefix(id);var children=fetchComponents(basecontainer,prefix);var finallump=lump.uplump.finallump[prefix];var closefinal=finallump.close_tag;if(children){for(var i=0;i<children.length;++i){var child=children[i];if(child.children){var targetlump=branchmap[child.fullID];if(targetlump){if(debugMode){renderComment("Branching for "+child.fullID+" from "+fluid.debugLump(lump)+" to "+fluid.debugLump(targetlump))}renderContainer(child,targetlump);if(debugMode){renderComment("Branch returned for "+child.fullID+fluid.debugLump(lump)+" to "+fluid.debugLump(targetlump))}}else{if(debugMode){renderDebugMessage("No matching template branch found for branch container with full ID "+child.fullID+" rendering from parent template branch "+fluid.debugLump(baselump))}}}else{var targetlump=findChild(parentlump,child);if(!targetlump){if(debugMode){renderDebugMessage("Repetitive leaf with full ID "+child.fullID+" could not be rendered from parent template branch "+fluid.debugLump(baselump))}continue}var renderend=renderComponentSystem(basecontainer,child,targetlump);var wasopentag=renderend<t1.lumps.lengtn&&t1.lumps[renderend].nestingdepth>=targetlump.nestingdepth;var newbase=child.children?child:basecontainer;if(wasopentag){renderRecurse(newbase,targetlump,t1.lumps[renderend]);renderend=targetlump.close_tag.lumpindex+1}if(i!==children.length-1){if(renderend<closefinal.lumpindex){dumpScan(t1.lumps,renderend,targetlump.nestingdepth-1,false,false)}}else{dumpScan(t1.lumps,renderend,targetlump.nestingdepth,true,false)}}}}else{if(debugMode){renderDebugMessage("No branch container with prefix "+prefix+": found in container "+reportPath(basecontainer)+" rendering at template position "+fluid.debugLump(baselump)+", skipping")}}renderindex=closefinal.lumpindex+1;if(debugMode){renderComment("Stack returned from branch for ID "+id+" to "+fluid.debugLump(baselump)+": skipping from "+fluid.debugLump(lump)+" to "+fluid.debugLump(closefinal))}}else{var component;if(id){if(debugMode){rendered[id]=true}component=fetchComponent(basecontainer,id,lump)}if(component&&component.children!==undefined){renderContainer(component);renderindex=lump.close_tag.lumpindex+1}else{renderindex=renderComponentSystem(basecontainer,component,lump)}}if(renderindex===t1.lumps.length){break}}if(debugMode){var children=basecontainer.children;for(var key=0;key<children.length;++key){var child=children[key];if(!(child.ID.indexOf(":")!==-1)&&!rendered[child.ID]){renderDebugMessage("Leaf child component "+child.componentType+" with full ID "+child.fullID+" could not be found within template "+fluid.debugLump(baselump))}}}}function renderCollect(collump){dumpTillLump(collump.parent.lumps,collump.lumpindex,collump.close_tag.lumpindex+1)}function renderCollects(){for(var key in collected){var collist=collected[key];for(var i=0;i<collist.length;++i){renderCollect(collist[i])}}}function processDecoratorQueue(){for(var i=0;i<decoratorQueue.length;++i){var decorator=decoratorQueue[i];var node=fluid.byId(decorator.id,renderOptions.document);if(!node){fluid.fail("Error during rendering - component with id "+decorator.id+" which has a queued decorator was not found in the output markup")}if(decorator.type==="jQuery"){var jnode=$(node);jnode[decorator.func].apply(jnode,$.makeArray(decorator.args))}else{if(decorator.type==="fluid"){var args=decorator.args;if(!args){if(!decorator.container){decorator.container=node}args=[decorator.container,decorator.options]}var that=fluid.invokeGlobalFunction(decorator.func,args,fluid);decorator.that=that}else{if(decorator.type==="event"){node[decorator.event]=decorator.handler}}}}}that.renderTemplates=function(){tree=fixupTree(tree,options.model);var template=templates[0];resolveBranches(templates.globalmap,tree,template.rootlump);renderedbindings={};renderCollects();renderRecurse(tree,template.rootlump,template.lumps[template.firstdocumentindex]);return out};that.processDecoratorQueue=function(){processDecoratorQueue()};return that};fluid.ComponentReference=function(reference){this.reference=reference};fluid.explode=function(hash,basepath){var togo=[];for(var key in hash){var binding=basepath===undefined?key:basepath+"."+key;togo[togo.length]={ID:key,value:hash[key],valuebinding:binding}}return togo};fluid.explodeSelectionToInputs=function(optionlist,opts){return fluid.transform(optionlist,function(option,index){return{ID:opts.rowID,children:[{ID:opts.inputID,parentRelativeID:"..::"+opts.selectID,choiceindex:index},{ID:opts.labelID,parentRelativeID:"..::"+opts.selectID,choiceindex:index}]}})};fluid.resolveMessageSource=function(messageSource){if(messageSource.type==="data"){if(messageSource.url===undefined){return fluid.messageLocator(messageSource.messages)}else{}}};fluid.makeBranches=function(){var firstBranch;var thisBranch;for(var i=0;i<arguments.length;++i){var thisarg=arguments[i];var nextBranch;if(typeof (thisarg)==="string"){nextBranch={ID:thisarg}}else{if(thisarg instanceof Array){nextBranch={ID:thisarg[0],jointID:thisarg[1]}}else{$.extend(true,thisBranch,thisarg);nextBranch=thisBranch}}if(thisBranch&&nextBranch!==thisBranch){if(!thisBranch.children){thisBranch.children=[]}thisBranch.children[thisBranch.children.length]=nextBranch}thisBranch=nextBranch;if(!firstBranch){firstBranch=nextBranch}}return firstBranch};fluid.renderTemplates=function(templates,tree,options,fossilsIn){var renderer=fluid.renderer(templates,tree,options,fossilsIn);var rendered=renderer.renderTemplates();return rendered};fluid.reRender=function(templates,node,tree,options){options=options||{};node=fluid.unwrap(node);var lastFocusedElement=fluid.getLastFocusedElement?fluid.getLastFocusedElement():null;var lastId;if(lastFocusedElement&&fluid.dom.isContainer(node,lastFocusedElement)){lastId=lastFocusedElement.id}if($.browser.msie){$(node).empty()}else{node.innerHTML=""}var fossils={};var renderer=fluid.renderer(templates,tree,options,fossils);var rendered=renderer.renderTemplates();if(options.renderRaw){rendered=fluid.XMLEncode(rendered);rendered=rendered.replace(/\n/g,"<br/>")}if(options.model){fluid.bindFossils(node,options.model,fossils)}if($.browser.msie){$(node).html(rendered)}else{node.innerHTML=rendered}renderer.processDecoratorQueue();if(lastId){var element=fluid.byId(lastId);if(element){$(element).focus()}}return templates};function findNodeValue(rootNode){var node=fluid.dom.iterateDom(rootNode,function(node){return node.nodeType===8||node.nodeType===4?"stop":null},true);var value=node.nodeValue;if(value.indexOf("[CDATA[")===0){return value.substring(6,value.length-2)}else{return value}}fluid.extractTemplate=function(node,armouring){if(!armouring){return node.innerHTML}else{return findNodeValue(node)}};fluid.selfRender=function(node,tree,options){options=options||{};node=fluid.unwrap(node);var resourceSpec={base:{resourceText:fluid.extractTemplate(node,options.armouring),href:".",resourceKey:".",cutpoints:options.cutpoints}};var templates=fluid.parseTemplates(resourceSpec,["base"],options);return fluid.reRender(templates,node,tree,options)}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var insertAnchor=function(el){var a=$("<a name='"+el.text()+"' />",el[0].ownerDocument);el.before(a)};var createNode=function(id){var node={ID:id,children:[]};return node};var createTree=function(headings,levels){var generateTree=function(nodes,items,level){if(items.length===0){return }var item=items[0];if(level===item.level){nodes[nodes.length-1].push(item.leaf);items.shift();return generateTree(nodes,items,level)}if(level<item.level){var prefix=level>-1?"level"+(level+1)+":":"";var postfix=level===-1?"s:":"s";var name=prefix+"level"+(level+2)+postfix;var myNode=createNode(name);nodes[nodes.length-1].push(myNode);nodes.push(myNode.children);return generateTree(nodes,items,level+1)}if(level>item.level){nodes.pop();return generateTree(nodes,items,level-1)}};var tree={children:[]};var items=fluid.transform(headings,function(heading){var level=$.inArray(heading.tagName,levels);var text=$(heading).text();return{level:level,leaf:{ID:"level"+(level+1)+":item",children:[{ID:"link",linktext:text,target:"#"+text}]}}});generateTree([tree.children],items,-1);return tree};var buildTOC=function(container,headings,levels,templateURL,afterRender){headings.each(function(i,el){insertAnchor($(el))});var resources={toc:{href:templateURL}};fluid.fetchResources(resources,function(){var templates=fluid.parseTemplates(resources,["toc"],{});var node=$("<div></div>",container[0].ownerDocument);fluid.reRender(templates,node,createTree(headings,levels),{});container.prepend(node);afterRender.fire(node)})};fluid.tableOfContents=function(container,options){var that=fluid.initView("fluid.tableOfContents",container,options);that.events.afterRender.addListener(function(node){that.tocNode=$(node)});buildTOC(that.container,that.locate("headings"),that.options.levels,that.options.templateUrl,that.events.afterRender);that.hide=function(){if(that.tocNode){that.tocNode.hide()}};that.show=function(){if(that.tocNode){that.tocNode.show()}};return that};fluid.defaults("fluid.tableOfContents",{selectors:{headings:":header"},events:{afterRender:null},templateUrl:"../html/TableOfContents.html",levels:["H1","H2","H3","H4","H5","H6"]})})(jQuery,fluid_1_1);(function($){var helper={},current,title,tID,IE=$.browser.msie&&/MSIE\s(5\.5|6\.)/.test(navigator.userAgent),track=false;$.tooltip={blocked:false,defaults:{delay:200,showURL:true,extraClass:"",top:15,left:15,id:"tooltip"},block:function(){$.tooltip.blocked=!$.tooltip.blocked}};$.fn.extend({tooltip:function(settings){settings=$.extend({},$.tooltip.defaults,settings);createHelper(settings);return this.each(function(){$.data(this,"tooltip-settings",settings);this.tooltipText=this.title;$(this).removeAttr("title");this.alt=""}).hover(save,hide).click(hide)},fixPNG:IE?function(){return this.each(function(){var image=$(this).css("backgroundImage");if(image.match(/^url\(["']?(.*\.png)["']?\)$/i)){image=RegExp.$1;$(this).css({backgroundImage:"none",filter:"progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop, src='"+image+"')"}).each(function(){var position=$(this).css("position");if(position!="absolute"&&position!="relative"){$(this).css("position","relative")}})}})}:function(){return this},unfixPNG:IE?function(){return this.each(function(){$(this).css({filter:"",backgroundImage:""})})}:function(){return this},hideWhenEmpty:function(){return this.each(function(){$(this)[$(this).html()?"show":"hide"]()})},url:function(){return this.attr("href")||this.attr("src")}});function createHelper(settings){if(helper.parent){return }helper.parent=$('<div id="'+settings.id+'"><h3></h3><div class="body"></div><div class="url"></div></div>').appendTo(document.body).hide();if($.fn.bgiframe){helper.parent.bgiframe()}helper.title=$("h3",helper.parent);helper.body=$("div.body",helper.parent);helper.url=$("div.url",helper.parent)}function settings(element){return $.data(element,"tooltip-settings")}function handle(event){if(settings(this).delay){tID=setTimeout(show,settings(this).delay)}else{show()}track=!!settings(this).track;$(document.body).bind("mousemove",update);update(event)}function save(){if($.tooltip.blocked||this==current||(!this.tooltipText&&!settings(this).bodyHandler)){return }current=this;title=this.tooltipText;if(settings(this).bodyHandler){helper.title.hide();var bodyContent=settings(this).bodyHandler.call(this);if(bodyContent.nodeType||bodyContent.jquery){helper.body.empty().append(bodyContent)}else{helper.body.html(bodyContent)}helper.body.show()}else{if(settings(this).showBody){var parts=title.split(settings(this).showBody);helper.title.html(parts.shift()).show();helper.body.empty();for(var i=0,part;part=parts[i];i++){if(i>0){helper.body.append("<br/>")}helper.body.append(part)}helper.body.hideWhenEmpty()}else{helper.title.html(title).show();helper.body.hide()}}if(settings(this).showURL&&$(this).url()){helper.url.html($(this).url().replace("http://","")).show()}else{helper.url.hide()}helper.parent.addClass(settings(this).extraClass);if(settings(this).fixPNG){helper.parent.fixPNG()}handle.apply(this,arguments)}function show(){tID=null;helper.parent.show();update()}function update(event){if($.tooltip.blocked){return }if(!track&&helper.parent.is(":visible")){$(document.body).unbind("mousemove",update)}if(current==null||!settings(current)){return }helper.parent.removeClass("viewport-right").removeClass("viewport-bottom");var left=helper.parent[0].offsetLeft;var top=helper.parent[0].offsetTop;if(event){left=event.pageX+settings(current).left;top=event.pageY+settings(current).top;helper.parent.css({left:left+"px",top:top+"px"})}var v=viewport(),h=helper.parent[0];if(v.x+v.cx<h.offsetLeft+h.offsetWidth){left-=h.offsetWidth+20+settings(current).left;helper.parent.css({left:left+"px"}).addClass("viewport-right")}if(v.y+v.cy<h.offsetTop+h.offsetHeight){top-=h.offsetHeight+20+settings(current).top;helper.parent.css({top:top+"px"}).addClass("viewport-bottom")}}function viewport(){return{x:$(window).scrollLeft(),y:$(window).scrollTop(),cx:$(window).width(),cy:$(window).height()}}function hide(event){if($.tooltip.blocked){return }if(tID){clearTimeout(tID)}current=null;helper.parent.hide().removeClass(settings(this).extraClass);if(settings(this).fixPNG){helper.parent.unfixPNG()}}$.fn.Tooltip=$.fn.tooltip})(jQuery);fluid_1_1=fluid_1_1||{};(function($,fluid){var STATE_INITIAL="state_initial",STATE_CHANGED="state_changed",STATE_REVERTED="state_reverted";function defaultRenderer(that,targetContainer){var markup="<span class='flc-undo' aria-live='polite' aria-relevant='all'><span class='flc-undo-undoContainer'>[<a href='#' class='flc-undo-undoControl'>undo</a>]</span><span class='flc-undo-redoContainer'>[<a href='#' class='flc-undo-redoControl'>redo</a>]</span></span>";var markupNode=$(markup);targetContainer.append(markupNode);return markupNode}function refreshView(that){if(that.state===STATE_INITIAL){that.locate("undoContainer").hide();that.locate("redoContainer").hide()}else{if(that.state===STATE_CHANGED){that.locate("undoContainer").show();that.locate("redoContainer").hide()}else{if(that.state===STATE_REVERTED){that.locate("undoContainer").hide();that.locate("redoContainer").show()}}}}var bindHandlers=function(that){that.locate("undoControl").click(function(){if(that.state!==STATE_REVERTED){fluid.model.copyModel(that.extremalModel,that.component.model);that.component.updateModel(that.initialModel,that);that.state=STATE_REVERTED;refreshView(that);that.locate("redoControl").focus()}return false});that.locate("redoControl").click(function(){if(that.state!==STATE_CHANGED){that.component.updateModel(that.extremalModel,that);that.state=STATE_CHANGED;refreshView(that);that.locate("undoControl").focus()}return false});return{modelChanged:function(newModel,oldModel,source){if(source!==that){that.state=STATE_CHANGED;fluid.model.copyModel(that.initialModel,oldModel);refreshView(that)}}}};fluid.undoDecorator=function(component,userOptions){var that=fluid.initView("undo",null,userOptions);that.container=that.options.renderer(that,component.container);fluid.initDomBinder(that);fluid.tabindex(that.locate("undoControl"),0);fluid.tabindex(that.locate("redoControl"),0);that.component=component;that.initialModel={};that.extremalModel={};fluid.model.copyModel(that.initialModel,component.model);fluid.model.copyModel(that.extremalModel,component.model);that.state=STATE_INITIAL;refreshView(that);var listeners=bindHandlers(that);that.returnedOptions={listeners:listeners};return that};fluid.defaults("undo",{selectors:{undoContainer:".flc-undo-undoContainer",undoControl:".flc-undo-undoControl",redoContainer:".flc-undo-redoContainer",redoControl:".flc-undo-redoControl"},renderer:defaultRenderer})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var replaceClass=function(container,selector,regExp,newVal){newVal=newVal||"";$(selector,container).andSelf().each(function(i){var attr=($.browser.msie===false)?"class":"className";if(this.getAttribute(attr)){this.setAttribute(attr,this.getAttribute(attr).replace(regExp,newVal))}})};var addClassForSetting=function(element,settingName,value,classnameMap){var settingValues=classnameMap[settingName]||{};var className=settingValues[value];if(className){element.addClass(className)}};var isTrue=function(val){return val&&(val===true||val==="true")};var setToc=function(that,tocSetting){if(isTrue(tocSetting)){if(that.tableOfContents){that.tableOfContents.show()}else{that.tableOfContents=fluid.initSubcomponent(that,"tableOfContents",[that.container,fluid.COMPONENT_OPTIONS])}}else{if(that.tableOfContents){that.tableOfContents.hide()}}};var setLineSpacing=function(container,spacing){spacing=spacing&&spacing>0?spacing:1;container.css("line-height",spacing+"em")};var setMinSize=function(container,size){if(size&&size>0){container.css("font-size",size+"pt");replaceClass(container,"[class*=fl-font-size-]",/\bfl-font-size-[0-9]{1,2}\s+/g,"fl-font-size-100")}else{container.css("font-size","")}};var addStyles=function(container,settings,classnameMap){addClassForSetting(container,"textFont",settings.textFont,classnameMap);addClassForSetting(container,"textSpacing",settings.textSpacing,classnameMap);addClassForSetting(container,"theme",settings.theme,classnameMap);addClassForSetting(container,"layout",settings.layout,classnameMap)};var styleElements=function(elements,setting,classname){if(setting){elements.addClass(classname)}else{elements.removeClass(classname)}};var styleLinks=function(container,settings,classnameMap){var links=$("a",container);styleElements(links,settings.linksUnderline,classnameMap.linksUnderline);styleElements(links,settings.linksBold,classnameMap.linksBold);styleElements(links,settings.linksLarger,classnameMap.linksLarger)};var styleInputs=function(container,settings,classnameMap){styleElements($("input",container),settings.inputsLarger,classnameMap.inputsLarger)};var initModel=function(that){if(that.options.savedSettings){that.model=that.options.savedSettings;return }that.model=that.settingsStore.fetch()||fluid.copy(that.defaultSiteSettings)};var clearClashingClasses=function(container,classnameMap){var settingsWhichMayClash=["textFont","textSpacing","theme","layout"];var classesToRemove="fl-noBackgroundImages";var selector=".fl-noBackgroundImages";for(var i=0;i<settingsWhichMayClash.length;i++){var settingValues=classnameMap[settingsWhichMayClash[i]];for(var val in settingValues){var classname=settingValues[val];if(classname){classesToRemove=classesToRemove+" "+classname;selector=selector+",."+classname}}}$(selector,container).removeClass(classesToRemove);return classesToRemove};var setupUIEnhancer=function(that){that.settingsStore=fluid.initSubcomponent(that,"settingsStore",[fluid.COMPONENT_OPTIONS]);initModel(that);that.refreshView()};fluid.uiEnhancer=function(doc,options){doc=doc||document;var that=fluid.initView("fluid.uiEnhancer",doc,options);$(doc).data("uiEnhancer",that);that.container=$("body",doc);that.defaultSiteSettings=that.options.defaultSiteSettings;var clashingClassnames;that.refreshView=function(){that.container.removeClass(clashingClassnames);addStyles(that.container,that.model,that.options.classnameMap);styleElements(that.container,!isTrue(that.model.backgroundImages),that.options.classnameMap.noBackgroundImages);setMinSize(that.container,that.model.textSize);setLineSpacing(that.container,that.model.lineSpacing);setToc(that,that.model.toc);styleLinks(that.container,that.model,that.options.classnameMap);styleInputs(that.container,that.model,that.options.classnameMap)};that.updateModel=function(newModel,source){that.events.modelChanged.fire(newModel,that.model,source);fluid.clear(that.model);fluid.model.copyModel(that.model,newModel);that.settingsStore.save(that.model);that.refreshView()};clashingClassnames=clearClashingClasses(that.container,that.options.classnameMap);setupUIEnhancer(that);return that};fluid.defaults("fluid.uiEnhancer",{tableOfContents:{type:"fluid.tableOfContents",options:{templateUrl:"../../tableOfContents/html/TableOfContents.html"}},settingsStore:{type:"fluid.uiEnhancer.cookieStore"},events:{modelChanged:null},classnameMap:{textFont:{serif:"fl-font-serif",sansSerif:"fl-font-sans",arial:"fl-font-arial",verdana:"fl-font-verdana",monospace:"fl-font-monospace",courier:"fl-font-courier",times:"fl-font-times"},textSpacing:{"default":"",wide0:"fl-font-spacing-0",wide1:"fl-font-spacing-1",wide2:"fl-font-spacing-2",wide3:"fl-font-spacing-3",wide4:"fl-font-spacing-4",wide5:"fl-font-spacing-5",wide6:"fl-font-spacing-6"},theme:{mist:"fl-theme-mist",rust:"fl-theme-rust",highContrast:"fl-theme-hc",highContrastInverted:"fl-theme-hci",lowContrast:"fl-theme-slate",mediumContrast:"fl-theme-coal","default":""},layout:{simple:"fl-layout-linear","default":""},noBackgroundImages:"fl-noBackgroundImages",linksUnderline:"fl-text-underline",linksBold:"fl-text-bold",linksLarger:"fl-text-larger",inputsLarger:"fl-text-larger"},defaultSiteSettings:{textFont:"",textSpacing:"",theme:"default",layout:"default",textSize:"",lineSpacing:"",backgroundImages:true,toc:false,linksUnderline:false,linksBold:false,linksLarger:false,inputsLarger:false}});fluid.uiEnhancer.cookieStore=function(options){var that={};fluid.mergeComponentOptions(that,"fluid.uiEnhancer.cookieStore",options);that.fetch=function(){var cookie=document.cookie;var cookiePrefix=that.options.cookieName+"=";var retObj,startIndex,endIndex;if(cookie.length>0){startIndex=cookie.indexOf(cookiePrefix);if(startIndex>-1){startIndex=startIndex+cookiePrefix.length;endIndex=cookie.indexOf(";",startIndex);if(endIndex<startIndex){endIndex=cookie.length}retObj=JSON.parse(decodeURIComponent(cookie.substring(startIndex,endIndex)))}}return retObj};that.save=function(settings){document.cookie=that.options.cookieName+"="+encodeURIComponent(JSON.stringify(settings))};return that};fluid.defaults("fluid.uiEnhancer.cookieStore",{cookieName:"fluid-ui-settings"});fluid.uiEnhancer.tempStore=function(options){var that={};that.model=null;that.fetch=function(){return that.model};that.save=function(settings){that.model=settings};return that}})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var initSliderAria=function(thumb,opts){var ariaDefaults={role:"slider","aria-valuenow":opts.value,"aria-valuemin":opts.min,"aria-valuemax":opts.max};thumb.attr(ariaDefaults)};var initSlider=function(that){var sliderOptions=that.options.sliderOptions;sliderOptions.value=that.model;sliderOptions.min=that.min;sliderOptions.max=that.max;var slider=that.locate("slider").slider(sliderOptions);initSliderAria(that.locate("thumb"),sliderOptions);return slider};var bindSliderHandlers=function(that,textfield,slider){slider.bind("slide",function(e,ui){textfield.val(ui.value);that.updateModel(ui.value,slider)})};var initTextfield=function(that,slider){var textfield=that.locate("textfield");textfield.val(that.model);return textfield};var bindTextfieldHandlers=function(that,textfield,slider){textfield.change(function(){if(that.isValid(this.value)){if(!that.isInRange(this.value)){this.value=(this.value<that.min)?that.min:that.max}slider.slider("value",this.value);that.updateModel(this.value,this)}else{this.value=that.model}});textfield.keypress(function(evt){if(evt.keyCode!==$.ui.keyCode.ENTER){return true}else{$(evt.target).change();$(fluid.findForm(evt.target)).submit();return false}})};var initTextfieldSlider=function(that){var slider=initSlider(that);var textfield=initTextfield(that,slider);bindSliderHandlers(that,textfield,slider);bindTextfieldHandlers(that,textfield,slider)};fluid.textfieldSlider=function(container,options){var that=fluid.initView("fluid.textfieldSlider",container,options);that.model=that.options.value||that.locate("textfield").val();that.min=that.options.min;that.max=that.options.max;that.isInRange=function(value){return(value>=that.min&&value<=that.max)};that.isValid=function(value){return !(isNaN(parseInt(value,10))||isNaN(value))};that.updateModel=function(model,source){if(that.isInRange(model)){that.events.modelChanged.fire(model,that.model,source);that.model=model;that.locate("thumb").attr("aria-valuenow",that.model)}};initTextfieldSlider(that);return that};fluid.defaults("fluid.textfieldSlider",{selectors:{textfield:".flc-textfieldSlider-field",slider:".flc-textfieldSlider-slider",thumb:".ui-slider-handle"},events:{modelChanged:null},sliderOptions:{orientation:"horizontal"},min:0,max:100,value:null})})(jQuery,fluid_1_1);(function($,fluid){var createSelectNode=function(id,selection,list,names){return{ID:id,selection:{valuebinding:selection},optionlist:{valuebinding:list},optionnames:{valuebinding:names}}};var createSimpleBindingNode=function(id,binding){return{ID:id,valuebinding:binding}};var generateTree=function(that,rendererModel){var children=[];children.push(createSelectNode("text-font","selections.textFont","labelMap.textFont.values","labelMap.textFont.names"));children.push(createSelectNode("text-spacing","selections.textSpacing","labelMap.textSpacing.values","labelMap.textSpacing.names"));children.push(createSelectNode("theme","selections.theme","labelMap.theme.values","labelMap.theme.names"));var bgiExplodeOpts={selectID:"background-images",rowID:"background-images-row:",inputID:"background-images-choice",labelID:"background-images-label"};children.push(createSelectNode("background-images","selections.backgroundImages","labelMap.backgroundImages.values","labelMap.backgroundImages.names"));children=children.concat(fluid.explodeSelectionToInputs(that.options.controlValues.backgroundImages,bgiExplodeOpts));var layoutExplodeOpts={selectID:"layout",rowID:"layout-row:",inputID:"layout-choice",labelID:"layout-label"};children.push(createSelectNode("layout","selections.layout","labelMap.layout.values","labelMap.layout.names"));children=children.concat(fluid.explodeSelectionToInputs(that.options.controlValues.layout,layoutExplodeOpts));var tocExplodeOpts={selectID:"toc",rowID:"toc-row:",inputID:"toc-choice",labelID:"toc-label"};children.push(createSelectNode("toc","selections.toc","labelMap.toc.values","labelMap.toc.names"));children=children.concat(fluid.explodeSelectionToInputs(that.options.controlValues.layout,tocExplodeOpts));children.push(createSimpleBindingNode("links-underline","selections.linksUnderline"));children.push(createSimpleBindingNode("links-bold","selections.linksBold"));children.push(createSimpleBindingNode("links-larger","selections.linksLarger"));children.push(createSimpleBindingNode("inputs-larger","selections.inputsLarger"));return{children:children}};var bindHandlers=function(that){var saveButton=that.locate("save");saveButton.click(that.save);that.locate("reset").click(that.reset);that.locate("cancel").click(that.cancel);var form=fluid.findForm(saveButton);$(form).submit(function(){that.save()})};var initPreview=function(that){var previewFrame=that.locate("previewFrame");var previewEnhancer;that.events.modelChanged.addListener(function(model){setTimeout(function(){if(previewEnhancer){previewEnhancer.updateModel(model)}},0)});previewFrame.load(function(){var previewFrameContents=previewFrame.contents();var options={savedSettings:that.model,tableOfContents:that.uiEnhancer.options.tableOfContents,settingsStore:{type:"fluid.uiEnhancer.tempStore"}};previewEnhancer=fluid.uiEnhancer(previewFrameContents,options)})};var createLabelMap=function(options){var labelMap={};for(var item in options.controlValues){labelMap[item]={names:options.strings[item],values:options.controlValues[item]}}return labelMap};var createRenderOptions=function(that){that.model.toc=String(that.model.toc);that.model.backgroundImages=String(that.model.backgroundImages);var aggregateModel=fluid.assembleModel({selections:{model:that.model,applier:that.applier},labelMap:{model:createLabelMap(that.options)}});return{model:aggregateModel.model,applier:aggregateModel.applier,autoBind:true}};var initSliders=function(that){var createOptions=function(settingName){return{listeners:{modelChanged:function(value){that.applier.requestChange(settingName,value)}},value:that.model[settingName]}};var options=createOptions("textSize");fluid.merge(null,options,that.options.textMinSize.options);fluid.initSubcomponents(that,"textMinSize",[that.options.selectors.textMinSizeCtrl,options]);options=createOptions("lineSpacing");fluid.merge(null,options,that.options.lineSpacing.options);fluid.initSubcomponents(that,"lineSpacing",[that.options.selectors.lineSpacingCtrl,options])};var mergeSiteDefaults=function(options,siteDefaults){for(var settingName in options.controlValues){var setting=String(siteDefaults[settingName]);var settingValues=options.controlValues[settingName];if(setting){var index=$.inArray(setting,settingValues);if(index===-1){var defaultIndex=$.inArray("default",settingValues);if(defaultIndex===-1){settingValues.push(setting)}else{settingValues[defaultIndex]=setting}}}}};var setupUIOptions=function(that){that.applier.modelChanged.addListener("*",function(newModel,oldModel,changeRequest){that.events.modelChanged.fire(newModel,oldModel,changeRequest.source)});mergeSiteDefaults(that.options,that.uiEnhancer.defaultSiteSettings);that.events.afterRender.addListener(function(){initSliders(that);bindHandlers(that);initPreview(that)});var rendererOptions=createRenderOptions(that);var template=fluid.selfRender(that.container,generateTree(that,rendererOptions.model),rendererOptions);that.events.afterRender.fire();return template};fluid.uiOptions=function(container,options){var that=fluid.initView("fluid.uiOptions",container,options);that.uiEnhancer=$(document).data("uiEnhancer");that.model=fluid.copy(that.uiEnhancer.model);that.applier=fluid.makeChangeApplier(that.model);var savedModel=that.uiEnhancer.model;var template;that.save=function(){that.events.onSave.fire(that.model);savedModel=fluid.copy(that.model);that.uiEnhancer.updateModel(savedModel)};that.reset=function(){that.events.onReset.fire();that.updateModel(fluid.copy(that.uiEnhancer.defaultSiteSettings),that);that.refreshView()};that.cancel=function(){that.events.onCancel.fire();that.updateModel(fluid.copy(savedModel),that);that.refreshView()};that.refreshView=function(){var rendererOptions=createRenderOptions(that);fluid.reRender(template,that.container,generateTree(that,rendererOptions.model),rendererOptions);that.events.afterRender.fire()};that.updateModel=function(newModel,source){that.events.modelChanged.fire(newModel,that.model,source);fluid.clear(that.model);fluid.model.copyModel(that.model,newModel)};template=setupUIOptions(that);return that};fluid.defaults("fluid.uiOptions",{textMinSize:{type:"fluid.textfieldSlider",options:{min:6,max:30}},lineSpacing:{type:"fluid.textfieldSlider",options:{min:1,max:10}},selectors:{controls:".flc-uiOptions-control",textMinSizeCtrl:".flc-uiOptions-min-text-size",lineSpacingCtrl:".flc-uiOptions-line-spacing",cancel:".flc-uiOptions-cancel",reset:".flc-uiOptions-reset",save:".flc-uiOptions-save",previewFrame:".flc-uiOptions-preview-frame"},events:{modelChanged:null,onSave:null,onCancel:null,onReset:null,afterRender:null},strings:{textFont:["Serif","Sans-Serif","Arial","Verdana","Courier","Times"],textSpacing:["Regular","Wide","Wider","Widest"],theme:["Low Contrast","Medium Contrast","Medium Contrast Grey Scale","High Contrast","High Contrast Inverted"],backgroundImages:["Yes","No"],layout:["Yes","No"],toc:["Yes","No"]},controlValues:{textFont:["serif","sansSerif","arial","verdana","courier","times"],textSpacing:["default","wide1","wide2","wide3"],theme:["lowContrast","default","mediumContrast","highContrast","highContrastInverted"],backgroundImages:["true","false"],layout:["simple","default"],toc:["true","false"]}})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){function updateStyles(pageListThat,newModel,oldModel){if(!pageListThat.pageLinks){return }if(oldModel.pageIndex!==undefined){var oldLink=pageListThat.pageLinks.eq(oldModel.pageIndex);oldLink.removeClass(pageListThat.options.styles.currentPage)}var pageLink=pageListThat.pageLinks.eq(newModel.pageIndex);pageLink.addClass(pageListThat.options.styles.currentPage)}function bindLinkClick(link,events,eventArg){link.unbind("click.fluid.pager");link.bind("click.fluid.pager",function(){events.initiatePageChange.fire(eventArg)})}function computePageCount(model){model.pageCount=Math.max(1,Math.floor((model.totalRange-1)/model.pageSize)+1)}function computePageLimit(model){return Math.min(model.totalRange,(model.pageIndex+1)*model.pageSize)}fluid.pager=function(){return fluid.pagerImpl.apply(null,arguments)};fluid.pager.directPageList=function(container,events,options){var that=fluid.initView("fluid.pager.directPageList",container,options);that.pageLinks=that.locate("pageLinks");for(var i=0;i<that.pageLinks.length;++i){var pageLink=that.pageLinks.eq(i);bindLinkClick(pageLink,events,{pageIndex:i})}events.onModelChange.addListener(function(newModel,oldModel){updateStyles(that,newModel,oldModel)});that.defaultModel={pageIndex:undefined,pageSize:1,totalRange:that.pageLinks.length};return that};fluid.iota=function(count,first){first=first||0;var togo=[];for(var i=0;i<count;++i){togo[togo.length]=first++}return togo};fluid.pager.everyPageStrategy=fluid.iota;fluid.pager.gappedPageStrategy=function(locality,midLocality){if(!locality){locality=3}if(!midLocality){midLocality=locality}return function(count,first,mid){var togo=[];var j=0;var lastSkip=false;for(var i=0;i<count;++i){if(i<locality||(count-i-1)<locality||(i>=mid-midLocality&&i<=mid+midLocality)){togo[j++]=i;lastSkip=false}else{if(!lastSkip){togo[j++]=-1;lastSkip=true}}}return togo}};fluid.pager.renderedPageList=function(container,events,pagerBarOptions,options,strings){options=$.extend(true,pagerBarOptions,options);var that=fluid.initView("fluid.pager.renderedPageList",container,options);options=that.options;var renderOptions={cutpoints:[{id:"page-link:link",selector:pagerBarOptions.selectors.pageLinks},{id:"page-link:skip",selector:pagerBarOptions.selectors.pageLinkSkip},{id:"page-link:disabled",selector:pagerBarOptions.selectors.pageLinkDisabled}]};if(options.linkBody){renderOptions.cutpoints[renderOptions.cutpoints.length]={id:"payload-component",selector:options.linkBody}}function pageToComponent(current){return function(page){return page===-1?{ID:"page-link:skip"}:{ID:page===current?"page-link:link":"page-link:link",localID:page+1,value:page+1,pageIndex:page,decorators:[{type:"jQuery",func:"click",args:function(){events.initiatePageChange.fire({pageIndex:page})}},{type:page===current?"addClass":"",classes:that.options.styles.currentPage}]}}}var root=that.locate("root");fluid.expectFilledSelector(root,"Error finding root template for fluid.pager.renderedPageList");var template=fluid.selfRender(root,{},renderOptions);events.onModelChange.addListener(function(newModel,oldModel){var pages=that.options.pageStrategy(newModel.pageCount,0,newModel.pageIndex);var pageTree=fluid.transform(pages,pageToComponent(newModel.pageIndex));pageTree[pageTree.length-1].value=pageTree[pageTree.length-1].value+strings.last;events.onRenderPageLinks.fire(pageTree,newModel);fluid.reRender(template,root,pageTree,renderOptions);updateStyles(that,newModel,oldModel)});return that};fluid.defaults("fluid.pager.renderedPageList",{selectors:{root:".flc-pager-links"},linkBody:"a",pageStrategy:fluid.pager.everyPageStrategy});var updatePreviousNext=function(that,options,newModel){if(newModel.pageIndex===0){that.previous.addClass(options.styles.disabled)}else{that.previous.removeClass(options.styles.disabled)}if(newModel.pageIndex===newModel.pageCount-1){that.next.addClass(options.styles.disabled)}else{that.next.removeClass(options.styles.disabled)}};fluid.pager.previousNext=function(container,events,options){var that=fluid.initView("fluid.pager.previousNext",container,options);that.previous=that.locate("previous");bindLinkClick(that.previous,events,{relativePage:-1});that.next=that.locate("next");bindLinkClick(that.next,events,{relativePage:+1});events.onModelChange.addListener(function(newModel,oldModel,overallThat){updatePreviousNext(that,options,newModel)});return that};fluid.pager.pagerBar=function(events,container,options,strings){var that=fluid.initView("fluid.pager.pagerBar",container,options);that.pageList=fluid.initSubcomponent(that,"pageList",[container,events,that.options,fluid.COMPONENT_OPTIONS,strings]);that.previousNext=fluid.initSubcomponent(that,"previousNext",[container,events,that.options,fluid.COMPONENT_OPTIONS,strings]);return that};fluid.defaults("fluid.pager.pagerBar",{previousNext:{type:"fluid.pager.previousNext"},pageList:{type:"fluid.pager.directPageList"},selectors:{pageLinks:".flc-pager-pageLink",pageLinkSkip:".flc-pager-pageLink-skip",pageLinkDisabled:".flc-pager-pageLink-disabled",previous:".flc-pager-previous",next:".flc-pager-next"},styles:{currentPage:"fl-pager-currentPage",disabled:"fl-pager-disabled"}});function getColumnDefs(that){return that.options.columnDefs}fluid.pager.findColumnDef=function(columnDefs,key){var columnDef=$.grep(columnDefs,function(def){return def.key===key})[0];return columnDef};function getRoots(target,overallThat,index){var cellRoot=(overallThat.options.dataOffset?overallThat.options.dataOffset+".":"");target.shortRoot=index;target.longRoot=cellRoot+target.shortRoot}function expandPath(EL,shortRoot,longRoot){if(EL.charAt(0)==="*"){return longRoot+EL.substring(1)}else{return EL.replace("*",shortRoot)}}fluid.pager.fetchValue=function(that,dataModel,index,valuebinding,roots){getRoots(roots,that,index);var path=expandPath(valuebinding,roots.shortRoot,roots.longRoot);return fluid.model.getBeanValue(dataModel,path)};fluid.pager.basicSorter=function(overallThat,model){var dataModel=overallThat.options.dataModel;var roots={};var columnDefs=getColumnDefs(overallThat);var columnDef=fluid.pager.findColumnDef(columnDefs,model.sortKey);var sortrecs=[];for(var i=0;i<model.totalRange;++i){sortrecs[i]={index:i,value:fluid.pager.fetchValue(overallThat,dataModel,i,columnDef.valuebinding,roots)}}var columnType=typeof sortrecs[0].value;function sortfunc(arec,brec){var a=arec.value;var b=brec.value;return a===b?0:(a>b?model.sortDir:-model.sortDir)}sortrecs.sort(sortfunc);return fluid.transform(sortrecs,function(row){return row.index})};fluid.pager.directModelFilter=function(model,pagerModel,perm){var togo=[];var limit=computePageLimit(pagerModel);for(var i=pagerModel.pageIndex*pagerModel.pageSize;i<limit;++i){var index=perm?perm[i]:i;togo[togo.length]={index:index,row:model[index]}}return togo};function expandVariables(value,opts){var togo="";var index=0;while(true){var nextindex=value.indexOf("${",index);if(nextindex===-1){togo+=value.substring(index);break}else{togo+=value.substring(index,nextindex);var endi=value.indexOf("}",nextindex+2);var EL=value.substring(nextindex+2,endi);if(EL==="VALUE"){EL=opts.EL}else{EL=expandPath(EL,opts.shortRoot,opts.longRoot)}var val=fluid.model.getBeanValue(opts.dataModel,EL);togo+=val;index=endi+1}}return togo}function expandPaths(target,tree,opts){for(var i in tree){var val=tree[i];if(val===fluid.VALUE){if(i==="valuebinding"){target[i]=opts.EL}else{target[i]={valuebinding:opts.EL}}}else{if(i==="valuebinding"){target[i]=expandPath(tree[i],opts)}else{if(typeof (val)==="object"){target[i]=val.length!==undefined?[]:{};expandPaths(target[i],val,opts)}else{if(typeof (val)==="string"){target[i]=expandVariables(val,opts)}else{target[i]=tree[i]}}}}}return target}function iDforColumn(columnDef,opts){var options=opts.options;var EL=columnDef.valuebinding;var key=columnDef.key;if(!EL){fluid.fail("Error in definition for column with key "+key+": valuebinding is not set")}opts.EL=expandPath(EL,opts.shortRoot,opts.longRoot);if(!key){var segs=fluid.model.parseEL(EL);key=segs[segs.length-1]}var ID=(options.keyPrefix?options.keyPrefix:"")+key;return ID}function expandColumnDefs(filteredRow,opts){var tree=fluid.transform(opts.columnDefs,function(columnDef){var ID=iDforColumn(columnDef,opts);var togo;if(!columnDef.components){return{ID:ID,valuebinding:opts.EL}}else{if(typeof columnDef.components==="function"){togo=columnDef.components(filteredRow.row,filteredRow.index)}else{togo=columnDef.components}}togo=expandPaths({},togo,opts);togo.ID=ID;return togo});return tree}function fetchModel(overallThat){return fluid.model.getBeanValue(overallThat.options.dataModel,overallThat.options.dataOffset)}function bigHeaderForKey(key,opts){var id=opts.options.renderOptions.idMap["header:"+key];var smallHeader=fluid.jById(id);if(smallHeader.length===0){return null}var headerSortStylisticOffset=opts.overallOptions.selectors.headerSortStylisticOffset;var bigHeader=fluid.findAncestor(smallHeader,function(element){return $(element).is(headerSortStylisticOffset)});return bigHeader}function setSortHeaderClass(styles,element,sort){element=$(element);element.removeClass(styles.ascendingHeader);element.removeClass(styles.descendingHeader);if(sort!==0){element.addClass(sort===1?styles.ascendingHeader:styles.descendingHeader)}}function isCurrentColumnSortable(columnDefs,model){var columnDef=model.sortKey?fluid.pager.findColumnDef(columnDefs,model.sortKey):null;return columnDef?columnDef.sortable:false}function setModelSortHeaderClass(newModel,opts){var styles=opts.overallOptions.styles;var sort=isCurrentColumnSortable(opts.columnDefs,newModel)?newModel.sortDir:0;setSortHeaderClass(styles,bigHeaderForKey(newModel.sortKey,opts),sort)}function fireModelChange(that,newModel,forceUpdate){computePageCount(newModel);if(newModel.pageIndex>=newModel.pageCount){newModel.pageIndex=newModel.pageCount-1}if(forceUpdate||newModel.pageIndex!==that.model.pageIndex||newModel.pageSize!==that.model.pageSize||newModel.sortKey!==that.model.sortKey||newModel.sortDir!==that.model.sortDir){var sorted=isCurrentColumnSortable(getColumnDefs(that),newModel)?that.options.sorter(that,newModel):null;that.permutation=sorted;that.events.onModelChange.fire(newModel,that.model,that);fluid.model.copyModel(that.model,newModel)}}function generateColumnClick(overallThat,columnDef,opts){return function(){if(columnDef.sortable===true){var model=overallThat.model;var newModel=fluid.copy(model);var styles=overallThat.options.styles;var oldKey=model.sortKey;if(columnDef.key!==model.sortKey){newModel.sortKey=columnDef.key;newModel.sortDir=1;var oldBig=bigHeaderForKey(oldKey,opts);if(oldBig){setSortHeaderClass(styles,oldBig,0)}}else{if(newModel.sortKey===columnDef.key){newModel.sortDir=-1*newModel.sortDir}else{return false}}newModel.pageIndex=0;fireModelChange(overallThat,newModel,true);setModelSortHeaderClass(newModel,opts)}return false}}function fetchHeaderDecorators(decorators,columnDef){return decorators[columnDef.sortable?"sortableHeader":"unsortableHeader"]}function generateHeader(overallThat,newModel,columnDefs,opts){return{children:fluid.transform(columnDefs,function(columnDef){return{ID:iDforColumn(columnDef,opts),value:columnDef.label,decorators:[{jQuery:["click",generateColumnClick(overallThat,columnDef,opts)]},{identify:"header:"+columnDef.key}].concat(fetchHeaderDecorators(opts.overallOptions.decorators,columnDef))}})}}fluid.pager.selfRender=function(overallThat,inOptions){var that=fluid.initView("fluid.pager.selfRender",overallThat.container,inOptions);var options=that.options;options.renderOptions.idMap=options.renderOptions.idMap||{};var idMap=options.renderOptions.idMap;var root=that.locate("root");var template=fluid.selfRender(root,{},options.renderOptions);root.addClass(options.styles.root);var columnDefs=getColumnDefs(overallThat);var expOpts={options:options,columnDefs:columnDefs,overallOptions:overallThat.options,dataModel:overallThat.options.dataModel,idMap:idMap};var directModel=fetchModel(overallThat);return{returnedOptions:{listeners:{onModelChange:function(newModel,oldModel){var filtered=overallThat.options.modelFilter(directModel,newModel,overallThat.permutation);var tree=fluid.transform(filtered,function(filteredRow){var roots=getRoots(expOpts,overallThat,filteredRow.index);if(columnDefs==="explode"){return fluid.explode(filteredRow.row,root)}else{if(columnDefs.length){return expandColumnDefs(filteredRow,expOpts)}}});var fullTree={};fullTree[options.row]=tree;if(typeof (columnDefs)==="object"){fullTree[options.header]=generateHeader(overallThat,newModel,columnDefs,expOpts)}options.renderOptions=options.renderOptions||{};options.renderOptions.model=expOpts.dataModel;fluid.reRender(template,root,fullTree,options.renderOptions);setModelSortHeaderClass(newModel,expOpts)}}}}};fluid.defaults("fluid.pager.selfRender",{selectors:{root:".flc-pager-body-template"},styles:{root:"fl-pager"},keyStrategy:"id",keyPrefix:"",row:"row:",header:"header:",renderOptions:{}});fluid.pager.summary=function(dom,options){var node=dom.locate("summary");return{returnedOptions:{listeners:{onModelChange:function(newModel,oldModel){var text=fluid.stringTemplate(options.message,{first:newModel.pageIndex*newModel.pageSize+1,last:computePageLimit(newModel),total:newModel.totalRange});if(node.length>0){node.text(text)}}}}}};fluid.pager.directPageSize=function(that){var node=that.locate("pageSize");if(node.length>0){that.events.onModelChange.addListener(function(newModel,oldModel){if(node.val()!==newModel.pageSize){node.val(newModel.pageSize)}});node.change(function(){that.events.initiatePageSizeChange.fire(node.val())})}return that};fluid.pager.rangeAnnotator=function(that,options){var roots={};that.events.onRenderPageLinks.addListener(function(tree,newModel){var column=that.options.annotateColumnRange;var dataModel=that.options.dataModel;var columnDefs=getColumnDefs(that);if(!column||!dataModel||!columnDefs){return }var columnDef=fluid.pager.findColumnDef(columnDefs,column);function fetchValue(index){index=that.permutation?that.permutation[index]:index;return fluid.pager.fetchValue(that,dataModel,index,columnDef.valuebinding,roots)}var tModel={};fluid.model.copyModel(tModel,newModel);fluid.transform(tree,function(cell){if(cell.ID==="page-link:link"){var page=cell.pageIndex;var start=page*tModel.pageSize;tModel.pageIndex=page;var limit=computePageLimit(tModel);var iValue=fetchValue(start);var lValue=fetchValue(limit-1);var text="<b>"+iValue+"</b><br/>&mdash;<br/><b>"+lValue+"</b>";var decorator={type:"jQuery",func:"tooltip",args:{delay:that.options.tooltipDelay,extraClass:that.options.styles.tooltip,bodyHandler:function(){return text},showURL:false,id:that.options.tooltipId}};cell.decorators.push(decorator)}})})};fluid.pagerImpl=function(container,options){var that=fluid.initView("fluid.pager",container,options);var pageIndexConformer=function(model,changeRequest){if(changeRequest.value<0){changeRequest.value=0}};that.events.initiatePageChange.addListener(function(arg){var newModel=fluid.copy(that.model);if(arg.relativePage!==undefined){newModel.pageIndex=that.model.pageIndex+arg.relativePage}else{newModel.pageIndex=arg.pageIndex}if(newModel.pageIndex===undefined||newModel.pageIndex<0){newModel.pageIndex=0}fireModelChange(that,newModel,arg.forceUpdate)});that.events.initiatePageSizeChange.addListener(function(arg){var newModel=fluid.copy(that.model);newModel.pageSize=arg;fireModelChange(that,newModel)});var pagerBarElement=that.locate("pagerBar");if(pagerBarElement.length>0){that.pagerBar=fluid.initSubcomponent(that,"pagerBar",[that.events,pagerBarElement,fluid.COMPONENT_OPTIONS,that.options.strings])}var pagerBarSecondaryElement=that.locate("pagerBarSecondary");if(pagerBarSecondaryElement.length>0){that.pagerBarSecondary=fluid.initSubcomponent(that,"pagerBar",[that.events,pagerBarSecondaryElement,fluid.COMPONENT_OPTIONS,that.options.strings])}that.bodyRenderer=fluid.initSubcomponent(that,"bodyRenderer",[that,fluid.COMPONENT_OPTIONS]);that.summary=fluid.initSubcomponent(that,"summary",[that.dom,fluid.COMPONENT_OPTIONS]);that.pageSize=fluid.initSubcomponent(that,"pageSize",[that]);that.rangeAnnotator=fluid.initSubcomponent(that,"rangeAnnotator",[that,fluid.COMPONENT_OPTIONS]);that.model=fluid.copy(that.options.model);var dataModel=fetchModel(that);if(dataModel){that.model.totalRange=dataModel.length}if(that.model.totalRange===undefined){if(!that.pagerBar){fluid.fail("Error in Pager configuration - cannot determine total range,  since not configured in model.totalRange and no PagerBar is configured")}that.model=that.pagerBar.pageList.defaultModel}that.applier=fluid.makeChangeApplier(that.model);that.events.initiatePageChange.fire({pageIndex:that.model.pageIndex?that.model.pageIndex:0,forceUpdate:true});return that};fluid.defaults("fluid.pager",{pagerBar:{type:"fluid.pager.pagerBar",options:null},summary:{type:"fluid.pager.summary",options:{message:"%first-%last of %total items"}},pageSize:{type:"fluid.pager.directPageSize"},modelFilter:fluid.pager.directModelFilter,sorter:fluid.pager.basicSorter,bodyRenderer:{type:"fluid.emptySubcomponent"},model:{pageIndex:undefined,pageSize:10,totalRange:undefined},dataModel:undefined,dataOffset:"",columnDefs:"explode",annotateColumnRange:undefined,tooltipDelay:300,tooltipId:"tooltip",rangeAnnotator:{type:"fluid.pager.rangeAnnotator"},selectors:{pagerBar:".flc-pager-top",pagerBarSecondary:".flc-pager-bottom",summary:".flc-pager-summary",pageSize:".flc-pager-page-size",headerSortStylisticOffset:".flc-pager-sort-header"},styles:{tooltip:"fl-pager-tooltip",ascendingHeader:"fl-pager-asc",descendingHeader:"fl-pager-desc"},decorators:{sortableHeader:[],unsortableHeader:[]},strings:{last:" (last)"},events:{initiatePageChange:null,initiatePageSizeChange:null,onModelChange:null,onRenderPageLinks:null}})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){function sendKey(control,event,virtualCode,charCode){var kE=document.createEvent("KeyEvents");kE.initKeyEvent(event,1,1,null,0,0,0,0,virtualCode,charCode);control.dispatchEvent(kE)}fluid.setCaretToEnd=function(control,value){var pos=value?value.length:0;try{control.focus();if(control.setSelectionRange){control.setSelectionRange(pos,pos);if($.browser.mozilla&&pos>0){sendKey(control,"keypress",92,92);sendKey(control,"keydown",8,0);sendKey(control,"keypress",8,0)}}else{if(control.createTextRange){var range=control.createTextRange();range.move("character",pos);range.select()}}}catch(e){}};fluid.deadMansBlur=function(control,exclusions,handler){var blurPending=false;$(control).blur(function(){blurPending=true;setTimeout(function(){if(blurPending){handler(control)}},150)});var canceller=function(){blurPending=false};exclusions.focus(canceller);exclusions.click(canceller)};var renderEditContainer=function(that,really){that.editContainer=that.locate("editContainer");that.editField=that.locate("edit");if(that.editContainer.length!==1){if(that.editField.length===1){that.editContainer=that.editField}else{if(that.editContainer.length>1){fluid.fail("InlineEdit did not find a unique container for selector "+that.options.selectors.editContainer+": "+fluid.dumpEl(that.editContainer))}}}if(that.editContainer.length===1&&!that.editField){that.editField=that.locate("edit",that.editContainer)}if(!really){return }var editElms=that.options.editModeRenderer(that);if(editElms){that.editContainer=editElms.container;that.editField=editElms.field}if(that.editField.length===0){fluid.fail("InlineEdit improperly initialised - editField could not be located (selector "+that.options.selectors.edit+")")}};var switchToViewMode=function(that){that.editContainer.hide();that.viewEl.show()};var cancel=function(that){if(that.isEditing()){setTimeout(function(){that.editView.value(that.model.value)},1);switchToViewMode(that);that.events.afterFinishEdit.fire(that.model.value,that.model.value,that.editField[0],that.viewEl[0])}};var finish=function(that){var newValue=that.editView.value();var oldValue=that.model.value;var viewNode=that.viewEl[0];var editNode=that.editField[0];var ret=that.events.onFinishEdit.fire(newValue,oldValue,editNode,viewNode);if(ret===false){return }that.updateModelValue(newValue);that.events.afterFinishEdit.fire(newValue,oldValue,editNode,viewNode);switchToViewMode(that)};var bindEditFinish=function(that){if(that.options.submitOnEnter===undefined){that.options.submitOnEnter="textarea"!==fluid.unwrap(that.editField).nodeName.toLowerCase()}function keyCode(evt){return evt.keyCode?evt.keyCode:(evt.which?evt.which:0)}var escHandler=function(evt){var code=keyCode(evt);if(code===$.ui.keyCode.ESCAPE){cancel(that);return false}};var finishHandler=function(evt){var code=keyCode(evt);if(code!==$.ui.keyCode.ENTER){return true}finish(that);that.viewEl.focus();return false};if(that.options.submitOnEnter){that.editContainer.keypress(finishHandler)}that.editContainer.keydown(escHandler)};var bindBlurHandler=function(that){if(that.options.blurHandlerBinder){that.options.blurHandlerBinder(that)}else{var blurHandler=function(evt){if(that.isEditing()){finish(that)}return false};that.editField.blur(blurHandler)}};var initializeEditView=function(that,initial){if(!that.editInitialized){renderEditContainer(that,!that.options.lazyEditView||!initial);if(!that.options.lazyEditView||!initial){that.editView=fluid.initSubcomponent(that,"editView",that.editField);$.extend(true,that.editView,fluid.initSubcomponent(that,"editAccessor",that.editField));bindEditFinish(that);bindBlurHandler(that);that.editView.refreshView(that);that.editInitialized=true}}};var edit=function(that){initializeEditView(that,false);var viewEl=that.viewEl;var displayText=that.displayView.value();that.updateModelValue(that.model.value===""?"":displayText);if(that.options.applyEditPadding){that.editField.width(Math.max(viewEl.width()+that.options.paddings.edit,that.options.paddings.minimumEdit))}viewEl.removeClass(that.options.styles.invitation);viewEl.removeClass(that.options.styles.focus);viewEl.hide();that.editContainer.show();if(that.tooltipEnabled()){$("#"+that.options.tooltipId).hide()}setTimeout(function(){that.editField.focus();fluid.setCaretToEnd(that.editField[0],that.editView.value());if(that.options.selectOnEdit){that.editField[0].select()}},0);that.events.afterBeginEdit.fire()};var clearEmptyViewStyles=function(textEl,defaultViewStyle,originalViewPadding){textEl.removeClass(defaultViewStyle);textEl.css("padding-right",originalViewPadding)};var showDefaultViewText=function(that){that.displayView.value(that.options.defaultViewText);that.viewEl.css("padding-right",that.existingPadding);that.viewEl.addClass(that.options.styles.defaultViewStyle)};var showNothing=function(that){that.displayView.value("");if($.browser.msie){if(that.viewEl.css("display")==="inline"){that.viewEl.css("display","inline-block")}}};var showEditedText=function(that){that.displayView.value(that.model.value);clearEmptyViewStyles(that.viewEl,that.options.styles.defaultViewStyle,that.existingPadding)};var refreshView=function(that,source){that.displayView.refreshView(that,source);if(that.editView){that.editView.refreshView(that,source)}};var initModel=function(that,value){that.model.value=value;that.refreshView()};var updateModelValue=function(that,newValue,source){var comparator=that.options.modelComparator;var unchanged=comparator?comparator(that.model.value,newValue):that.model.value===newValue;if(!unchanged){var oldModel=$.extend(true,{},that.model);that.model.value=newValue;that.events.modelChanged.fire(that.model,oldModel,source);that.refreshView(source)}};var bindHoverHandlers=function(viewEl,invitationStyle){var over=function(evt){viewEl.addClass(invitationStyle)};var out=function(evt){viewEl.removeClass(invitationStyle)};viewEl.hover(over,out)};var makeEditHandler=function(that){return function(){var prevent=that.events.onBeginEdit.fire();if(prevent===false){return false}edit(that);return true}};function makeEditTriggerGuard(that){var viewEl=fluid.unwrap(that.viewEl);return function(event){var outer=fluid.findAncestor(event.target,function(elem){if(/input|select|textarea|button|a/i.test(elem.nodeName)||elem===viewEl){return true}});if(outer===viewEl){that.edit();return false}}}var bindMouseHandlers=function(that){bindHoverHandlers(that.viewEl,that.options.styles.invitation);that.viewEl.click(makeEditTriggerGuard(that))};var bindHighlightHandler=function(viewEl,focusStyle,invitationStyle){var focusOn=function(){viewEl.addClass(focusStyle);viewEl.addClass(invitationStyle)};var focusOff=function(){viewEl.removeClass(focusStyle);viewEl.removeClass(invitationStyle)};viewEl.focus(focusOn);viewEl.blur(focusOff)};var bindKeyboardHandlers=function(that){fluid.tabbable(that.viewEl);var guard=makeEditTriggerGuard(that);fluid.activatable(that.viewEl,function(event){return guard(event)})};var aria=function(viewEl,editContainer){viewEl.attr("role","button")};var defaultEditModeRenderer=function(that){if(that.editContainer.length>0&&that.editField.length>0){return{container:that.editContainer,field:that.editField}}var editModeTemplate="<span><input type='text' class='flc-inlineEdit-edit fl-inlineEdit-edit'/></span>";var editContainer=$(editModeTemplate);var editField=$("input",editContainer);var componentContainerId=that.container.attr("id");if(componentContainerId){var editContainerId=componentContainerId+"-edit-container";var editFieldId=componentContainerId+"-edit";editContainer.attr("id",editContainerId);editField.attr("id",editFieldId)}that.viewEl.after(editContainer);return{container:editContainer,field:editField}};var makeIsEditing=function(that){var isEditing=false;that.events.onBeginEdit.addListener(function(){isEditing=true});that.events.afterFinishEdit.addListener(function(){isEditing=false});return function(){return isEditing}};var setupInlineEdit=function(componentContainer,that){var padding=that.viewEl.css("padding-right");that.existingPadding=padding?parseFloat(padding):0;initModel(that,that.displayView.value());bindMouseHandlers(that);bindKeyboardHandlers(that);bindHighlightHandler(that.viewEl,that.options.styles.focus,that.options.styles.invitation);aria(that.viewEl);if(that.editContainer){that.editContainer.hide()}var initTooltip=function(){if(that.tooltipEnabled()){that.viewEl.tooltip({delay:that.options.tooltipDelay,extraClass:that.options.styles.tooltip,bodyHandler:function(){return that.options.tooltipText},id:that.options.tooltipId})}};$(initTooltip);that.decorators=fluid.initSubcomponents(that,"componentDecorators",[that,fluid.COMPONENT_OPTIONS])};var setupInlineEdits=function(editables,options){var editors=[];editables.each(function(idx,editable){editors.push(fluid.inlineEdit($(editable),options))});return editors};fluid.inlineEdit=function(componentContainer,userOptions){var that=fluid.initView("inlineEdit",componentContainer,userOptions);that.viewEl=that.locate("text");that.displayView=fluid.initSubcomponent(that,"displayView",that.viewEl);$.extend(true,that.displayView,fluid.initSubcomponent(that,"displayAccessor",that.viewEl));that.model={value:""};that.edit=makeEditHandler(that);that.isEditing=makeIsEditing(that);that.finish=function(){finish(that)};that.cancel=function(){cancel(that)};that.tooltipEnabled=function(){return that.options.useTooltip&&$.fn.tooltip};that.refreshView=function(source){refreshView(that,source)};that.updateModelValue=function(newValue,source){updateModelValue(that,newValue,source)};that.updateModel=function(newModel,source){updateModelValue(that,newModel.value,source)};initializeEditView(that,true);setupInlineEdit(componentContainer,that);return that};fluid.inlineEdit.standardAccessor=function(element){var nodeName=element.nodeName.toLowerCase();var func="input"===nodeName||"textarea"===nodeName?"val":"text";return{value:function(newValue){return $(element)[func](newValue)}}};fluid.inlineEdit.richTextViewAccessor=function(element){return{value:function(newValue){return $(element).html(newValue)}}};fluid.inlineEdit.standardDisplayView=function(viewEl){var that={refreshView:function(componentThat,source){if(componentThat.model.value){showEditedText(componentThat)}else{if(componentThat.options.defaultViewText){showDefaultViewText(componentThat)}else{showNothing(componentThat)}}if(($.trim(componentThat.viewEl.text()).length===0)&&(componentThat.existingPadding<componentThat.options.paddings.minimumView)){componentThat.viewEl.css("padding-right",componentThat.options.paddings.minimumView)}}};return that};fluid.inlineEdit.standardEditView=function(editField){var that={refreshView:function(componentThat,source){if(componentThat.editField&&componentThat.editField.index(source)===-1){componentThat.editView.value(componentThat.model.value)}}};$.extend(true,that,fluid.inlineEdit.standardAccessor(editField));return that};fluid.inlineEdits=function(componentContainer,options){options=options||{};var selectors=$.extend({},fluid.defaults("inlineEdits").selectors,options.selectors);var container=fluid.container(componentContainer);var editables=$(selectors.editables,container);return setupInlineEdits(editables,options)};fluid.defaults("inlineEdit",{selectors:{text:".flc-inlineEdit-text",editContainer:".flc-inlineEdit-editContainer",edit:".flc-inlineEdit-edit"},styles:{text:"fl-inlineEdit-text",edit:"fl-inlineEdit-edit",invitation:"fl-inlineEdit-invitation",defaultViewStyle:"fl-inlineEdit-invitation-text",tooltip:"fl-inlineEdit-tooltip",focus:"fl-inlineEdit-focus"},events:{modelChanged:null,onBeginEdit:"preventable",afterBeginEdit:null,onFinishEdit:"preventable",afterFinishEdit:null,afterInitEdit:null},paddings:{edit:10,minimumEdit:80,minimumView:60},applyEditPadding:true,blurHandlerBinder:null,submitOnEnter:undefined,modelComparator:null,displayAccessor:{type:"fluid.inlineEdit.standardAccessor"},displayView:{type:"fluid.inlineEdit.standardDisplayView"},editAccessor:{type:"fluid.inlineEdit.standardAccessor"},editView:{type:"fluid.inlineEdit.standardEditView"},editModeRenderer:defaultEditModeRenderer,lazyEditView:false,defaultViewText:"Click here to edit",tooltipText:"Click item to edit",tooltipId:"tooltip",useTooltip:false,tooltipDelay:1000,selectOnEdit:false});fluid.defaults("inlineEdits",{selectors:{editables:".flc-inlineEditable"}})})(jQuery,fluid_1_1);fluid_1_1=fluid_1_1||{};(function($,fluid){var configureInlineEdit=function(configurationName,container,options){var defaults=fluid.defaults(configurationName);var assembleOptions=fluid.merge(defaults?defaults.mergePolicy:null,{},defaults,options);return fluid.inlineEdit(container,assembleOptions)};fluid.inlineEdit.normalizeHTML=function(value){var togo=$.trim(value.replace(/\s+/g," "));togo=togo.replace(/\s+<\//g,"</");togo=togo.replace(/\<(\S+)[^\>\s]*\>/g,function(match){return match.toLowerCase()});return togo};fluid.inlineEdit.htmlComparator=function(el1,el2){return fluid.inlineEdit.normalizeHTML(el1)===fluid.inlineEdit.normalizeHTML(el2)};fluid.inlineEdit.tinyMCE=function(container,options){var inlineEditor=configureInlineEdit("fluid.inlineEdit.tinyMCE",container,options);tinyMCE.init(inlineEditor.options.tinyMCE);return inlineEditor};fluid.inlineEdit.tinyMCE.viewAccessor=function(editField){return{value:function(newValue){var editor=tinyMCE.get(editField.id);if(!editor){return""}if(newValue){$(editField).val(newValue);editor.setContent(newValue,{format:"raw"})}else{return editor.getContent()}}}};fluid.inlineEdit.tinyMCE.blurHandlerBinder=function(that){function focusEditor(editor){setTimeout(function(){tinyMCE.execCommand("mceFocus",false,that.editField[0].id);if($.browser.mozilla&&$.browser.version.substring(0,3)==="1.8"){return }editor.selection.select(editor.getBody(),1);editor.selection.collapse(0)},10)}that.events.afterInitEdit.addListener(function(editor){focusEditor(editor);var editorBody=editor.getBody();fluid.deadMansBlur(that.editField,$(editorBody),function(){that.cancel()})});that.events.afterBeginEdit.addListener(function(){var editor=tinyMCE.get(that.editField[0].id);if(editor){focusEditor(editor)}})};fluid.inlineEdit.tinyMCE.editModeRenderer=function(that){var options=that.options.tinyMCE;options.elements=fluid.allocateSimpleId(that.editField);var oldinit=options.init_instance_callback;options.init_instance_callback=function(instance){that.events.afterInitEdit.fire(instance);if(oldinit){oldinit()}};tinyMCE.init(options)};fluid.defaults("fluid.inlineEdit.tinyMCE",{tinyMCE:{mode:"exact",theme:"simple"},useTooltip:true,selectors:{edit:"textarea"},styles:{invitation:"fl-inlineEdit-richText-invitation"},displayAccessor:{type:"fluid.inlineEdit.richTextViewAccessor"},editAccessor:{type:"fluid.inlineEdit.tinyMCE.viewAccessor"},lazyEditView:true,modelComparator:fluid.inlineEdit.htmlComparator,blurHandlerBinder:fluid.inlineEdit.tinyMCE.blurHandlerBinder,editModeRenderer:fluid.inlineEdit.tinyMCE.editModeRenderer});fluid.inlineEdit.FCKEditor=function(container,options){return configureInlineEdit("fluid.inlineEdit.FCKEditor",container,options)};fluid.inlineEdit.FCKEditor.complete=fluid.event.getEventFirer();fluid.inlineEdit.FCKEditor.complete.addListener(function(editor){var editField=editor.LinkedField;var that=$.data(editField,"fluid.inlineEdit.FCKEditor");that.events.afterInitEdit.fire(editor)});fluid.inlineEdit.FCKEditor.blurHandlerBinder=function(that){function focusEditor(editor){editor.Focus()}that.events.afterInitEdit.addListener(function(editor){focusEditor(editor);var editorBody=editor.EditingArea.TargetElement});that.events.afterBeginEdit.addListener(function(){var editor=fluid.inlineEdit.FCKEditor.byId(that.editField[0].id);if(editor){focusEditor(editor)}})};fluid.inlineEdit.FCKEditor.byId=function(id){var editor=typeof (FCKeditorAPI)==="undefined"?null:FCKeditorAPI.GetInstance(id);return editor};fluid.inlineEdit.FCKEditor.editModeRenderer=function(that){var id=fluid.allocateSimpleId(that.editField);$.data(fluid.unwrap(that.editField),"fluid.inlineEdit.FCKEditor",that);var oFCKeditor=new FCKeditor(id);var opcopy=fluid.copy(that.options.FCKEditor);opcopy.BasePath=opcopy.BasePath+"editor/";$.extend(true,oFCKeditor.Config,opcopy);$.extend(true,oFCKeditor,that.options.FCKEditor);oFCKeditor.Config.fluidInstance=that;oFCKeditor.ReplaceTextarea()};fluid.inlineEdit.FCKEditor.viewAccessor=function(editField){return{value:function(newValue){var editor=fluid.inlineEdit.FCKEditor.byId(editField.id);if(!editor){if(newValue){$(editField).val(newValue)}return""}if(newValue){editor.SetHTML(newValue)}else{return editor.GetHTML()}}}};fluid.defaults("fluid.inlineEdit.FCKEditor",{selectors:{edit:"textarea"},styles:{invitation:"fl-inlineEdit-richText-invitation"},displayAccessor:{type:"fluid.inlineEdit.richTextViewAccessor"},editAccessor:{type:"fluid.inlineEdit.FCKEditor.viewAccessor"},lazyEditView:true,modelComparator:fluid.inlineEdit.htmlComparator,blurHandlerBinder:fluid.inlineEdit.FCKEditor.blurHandlerBinder,editModeRenderer:fluid.inlineEdit.FCKEditor.editModeRenderer,FCKEditor:{BasePath:"fckeditor/"}});fluid.inlineEdit.dropdown=function(container,options){return configureInlineEdit("fluid.inlineEdit.dropdown",container,options)};fluid.inlineEdit.dropdown.editModeRenderer=function(that){var id=fluid.allocateSimpleId(that.editField);that.editField.selectbox({finishHandler:function(){that.finish()}});return{container:that.editContainer,field:$("input.selectbox",that.editContainer)}};fluid.inlineEdit.dropdown.blurHandlerBinder=function(that){fluid.deadMansBlur(that.editField,$("div.selectbox-wrapper li",that.editContainer),function(){that.cancel()})};fluid.defaults("fluid.inlineEdit.dropdown",{applyEditPadding:false,blurHandlerBinder:fluid.inlineEdit.dropdown.blurHandlerBinder,editModeRenderer:fluid.inlineEdit.dropdown.editModeRenderer})})(jQuery,fluid_1_1);function FCKeditor_OnComplete(editorInstance){fluid.inlineEdit.FCKEditor.complete.fire(editorInstance)};